/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.util.Objects;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderCustomReport;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderExecutionWs;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderRequirementWs;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderTestCaseWs;

public record RelationshipMapper(Long libraryId, SequenceGenerator contentOrderSequence, boolean atRoot, Long parentId, Integer order, RelationshipType type) {
    public RelationshipMapper(Long libraryId, SequenceGenerator contentOrderSequence, RelationshipType type) {
        this(libraryId, contentOrderSequence, true, null, null, type);
    }

    public TableRow mapRelationship(Long libraryNodeId) {
        if (this.atRoot) {
            return this.getRelationshipToLibrary(libraryNodeId);
        }
        Objects.requireNonNull(this.parentId);
        Objects.requireNonNull(this.order);
        return this.getRelationshipToNode(libraryNodeId);
    }

    private TableRow getRelationshipToLibrary(Long libraryNodeId) {
        Long contentOrder = this.contentOrderSequence.getIdAndIncrement();
        return switch (this.type) {
            case RelationshipType.CAMPAIGN_LIBRARY_NODE -> BuilderExecutionWs.getRelationshipToLibrary(this.libraryId, libraryNodeId, contentOrder);
            case RelationshipType.CUSTOM_REPORT_LIBRARY_NODE -> BuilderCustomReport.getRelationshipToCrlnNode(this.libraryId, libraryNodeId, contentOrder);
            case RelationshipType.REQUIREMENT_LIBRARY_NODE -> BuilderRequirementWs.getRelationshipToLibrary(this.libraryId, libraryNodeId, contentOrder);
            case RelationshipType.TESTCASE_LIBRARY_NODE -> BuilderTestCaseWs.getRelationshipToLibrary(this.libraryId, libraryNodeId, contentOrder);
            default -> throw new MatchException(null, null);
        };
    }

    private TableRow getRelationshipToNode(Long libraryNodeId) {
        return switch (this.type) {
            case RelationshipType.CAMPAIGN_LIBRARY_NODE -> BuilderExecutionWs.getRelationshipToClnNode(this.parentId, libraryNodeId, this.order);
            case RelationshipType.CUSTOM_REPORT_LIBRARY_NODE -> BuilderCustomReport.getRelationshipToCrlnNode(this.parentId, libraryNodeId, (long)this.order);
            case RelationshipType.REQUIREMENT_LIBRARY_NODE -> BuilderRequirementWs.getRelationshipToRlnNode(this.parentId, libraryNodeId, this.order);
            case RelationshipType.TESTCASE_LIBRARY_NODE -> BuilderTestCaseWs.getRelationshipToTclnNode(this.parentId, libraryNodeId, this.order);
            default -> throw new MatchException(null, null);
        };
    }

    public static enum RelationshipType {
        CAMPAIGN_LIBRARY_NODE,
        CUSTOM_REPORT_LIBRARY_NODE,
        REQUIREMENT_LIBRARY_NODE,
        TESTCASE_LIBRARY_NODE;

    }
}

