/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldModel;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldValueModel;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.InputType;

public record CustomFieldData(List<CustomFieldModel> customFieldModels, Map<Pair<Long, BindableEntity>, List<CustomFieldValueData>> bindingByProjectIdBindableEntity) {
    public List<CustomFieldValueData> getCustomFieldValueModel(Long projectId, BindableEntity bindableEntity, List<CustomFieldValueModel> customFieldValueModels) {
        ArrayList<CustomFieldValueModel> cufValueModels = new ArrayList<CustomFieldValueModel>(customFieldValueModels);
        List bindings = this.bindingByProjectIdBindableEntity.getOrDefault(Pair.of((Object)projectId, (Object)bindableEntity), List.of());
        List<CustomFieldValueData> customFieldValueData = bindings.stream().map(cfv -> {
            CustomFieldValueModel customFieldValueModel = cufValueModels.stream().filter(cfm -> cfm.getCufId().equals(cfv.cfId())).findFirst().orElse(null);
            if (customFieldValueModel != null) {
                cufValueModels.remove(customFieldValueModel);
                return new CustomFieldValueData(cfv.cfId(), cfv.cfbId(), cfv.inputType(), cfv.code, cfv.label, customFieldValueModel.getValue());
            }
            return cfv;
        }).toList();
        if (!cufValueModels.isEmpty()) {
            String cufValueModelsStr = cufValueModels.stream().map(cfm -> String.format("[cufId=%d; value=%s]", cfm.getCufId(), cfm.getValue())).reduce((a, b) -> String.format("%s, %s", a, b)).orElse("");
            String bindingStr = bindings.stream().map(cfv -> String.format("[cfId=%d; type=%s]", cfv.cfId(), cfv.inputType())).reduce((a, b) -> String.format("%s, %s", a, b)).orElse(String.format("No bindings for projectId=%d and bindableEntity=%s", projectId, bindableEntity));
            throw new IllegalArgumentException(String.format("Some custom field values were not found: %s%nCurrent bindings: %s", cufValueModelsStr, bindingStr));
        }
        return customFieldValueData;
    }

    public void putBinding(Long cufId, Long projectId, BindableEntity bindableEntity, Long cfbId) {
        CustomFieldModel customFieldModel = this.customFieldModels.stream().filter(cf -> cf.getCufId().equals(cufId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Custom field not found: " + String.valueOf(cufId)));
        CustomFieldValueData customFieldValueData = new CustomFieldValueData(cufId, cfbId, customFieldModel.getInputType(), customFieldModel.getCode(), customFieldModel.getLabel(), customFieldModel.getDefaultValue());
        this.bindingByProjectIdBindableEntity.computeIfAbsent((Pair<Long, BindableEntity>)Pair.of((Object)projectId, (Object)bindableEntity), k -> new ArrayList()).add(customFieldValueData);
    }

    public record CustomFieldValueData(Long cfId, Long cfbId, InputType inputType, String code, String label, Object value) {
    }
}

