/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder;

import java.util.Map;
import java.util.stream.Stream;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.TableRow;

public final class DatasetBuilder {
    private static final String PATH_TO_DTD = "classpath:org/squashtest/it/datasetbuilder/dbunit/dbunit.dtd";

    private DatasetBuilder() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static String build(TableRow ... rows) {
        StringBuilder xml = new StringBuilder();
        xml.append("<!DOCTYPE dataset SYSTEM \"%s\">%n".formatted(PATH_TO_DTD));
        xml.append("<dataset>\n");
        TableRow[] tableRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            TableRow row = tableRowArray[n2];
            xml.append("  <").append(row.name);
            for (Map.Entry attr : row.attributes.entrySet()) {
                if (attr.getValue() == null) continue;
                xml.append(" ").append((String)attr.getKey()).append("=\"").append(DatasetBuilder.escapeDoubleQuotes((String)attr.getValue())).append("\"");
            }
            xml.append("/>\n");
            ++n2;
        }
        xml.append("</dataset>");
        return xml.toString();
    }

    public static String escapeDoubleQuotes(String value) {
        return value.replace("\"", "&quot;").replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String[] build(DatasetData datasetData) {
        return (String[])Stream.of(datasetData.tableRowInsert(), datasetData.tableRowUpdate()).map(tableRows -> DatasetBuilder.build(tableRows.toArray(new TableRow[0]))).toArray(String[]::new);
    }

    public static String[] build(DatasetData ... datasetData) {
        return (String[])Stream.of(datasetData).flatMap(data -> Stream.of(data.tableRowInsert(), data.tableRowUpdate())).map(tableRows -> DatasetBuilder.build(tableRows.toArray(new TableRow[0]))).toArray(String[]::new);
    }
}

