/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.api.model.CustomChartModel;
import org.squashtest.it.datasetbuilder.api.model.CustomDashboardModel;
import org.squashtest.it.datasetbuilder.api.model.CustomExportModel;
import org.squashtest.it.datasetbuilder.api.model.CustomReportFolderModel;
import org.squashtest.it.datasetbuilder.api.model.CustomReportLibraryNodeModel;
import org.squashtest.it.datasetbuilder.api.model.CustomReportModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderCustomReport;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.mappers.RelationshipMapper;
import org.squashtest.it.datasetbuilder.rowbuilders.CustomReportLibraryNodeRow;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;

public final class CustomReportMapper {
    private CustomReportMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(List<CustomReportLibraryNodeModel> models, ProjectMapper.ProjectData projectData, Long crlnLibraryId) {
        SequenceGenerator contentOrderSequence = new SequenceGenerator();
        DatasetData datasetData = new DatasetData();
        models.forEach(model -> {
            RelationshipMapper relationship = new RelationshipMapper(crlnLibraryId, contentOrderSequence, RelationshipMapper.RelationshipType.CUSTOM_REPORT_LIBRARY_NODE);
            CustomReportMapper.mapNode(model, projectData, relationship, datasetData);
        });
        return datasetData;
    }

    private static void mapNode(CustomReportLibraryNodeModel model, ProjectMapper.ProjectData projectData, RelationshipMapper relationship, DatasetData datasetData) {
        CustomReportLibraryNodeModel customReportLibraryNodeModel = model;
        Objects.requireNonNull(customReportLibraryNodeModel);
        CustomReportLibraryNodeModel customReportLibraryNodeModel2 = customReportLibraryNodeModel;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CustomReportFolderModel.class, CustomExportModel.class, CustomReportModel.class, CustomChartModel.class, CustomDashboardModel.class}, (Object)customReportLibraryNodeModel2, n)) {
            case 0: {
                CustomReportFolderModel folderModel = (CustomReportFolderModel)customReportLibraryNodeModel2;
                CustomReportMapper.mapCustomReportFolder(folderModel, projectData, relationship, datasetData);
                break;
            }
            case 1: {
                CustomExportModel exportModel = (CustomExportModel)customReportLibraryNodeModel2;
                CustomReportMapper.mapCustomExport(exportModel, projectData, relationship, datasetData);
                break;
            }
            case 2: {
                CustomReportModel reportModel = (CustomReportModel)customReportLibraryNodeModel2;
                CustomReportMapper.mapCustomReport(reportModel, projectData, relationship, datasetData);
                break;
            }
            case 3: {
                CustomChartModel chartModel = (CustomChartModel)customReportLibraryNodeModel2;
                CustomReportMapper.mapCustomChart(chartModel, projectData, relationship, datasetData);
                break;
            }
            case 4: {
                CustomDashboardModel dashboardModel = (CustomDashboardModel)customReportLibraryNodeModel2;
                CustomReportMapper.mapCustomDashboard(dashboardModel, projectData, relationship, datasetData);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CustomReportLibraryNodeModel type: " + String.valueOf(model.getClass()));
            }
        }
    }

    private static void mapCustomReportFolder(CustomReportFolderModel model, ProjectMapper.ProjectData projectData, RelationshipMapper relationship, DatasetData datasetData) {
        Long crlnId = CustomReportLibraryNodeRow.sequence.nextId();
        datasetData.addTableRowInsert(BuilderCustomReport.getCustomReportLibraryNodeTableRow(crlnId, projectData.getLibraryNodeId(), model.getName(), model.getCrfId(), CustomReportTreeDefinition.FOLDER), relationship.mapRelationship(crlnId), BuilderCustomReport.getCustomReportFolderTableRow(model, projectData.projectId()));
        int i = 0;
        while (i < model.getNodes().size()) {
            CustomReportLibraryNodeModel child = (CustomReportLibraryNodeModel)model.getNodes().get(i);
            RelationshipMapper childRelationship = new RelationshipMapper(relationship.libraryId(), relationship.contentOrderSequence(), false, crlnId, i, RelationshipMapper.RelationshipType.CUSTOM_REPORT_LIBRARY_NODE);
            CustomReportMapper.mapNode(child, projectData, childRelationship, datasetData);
            ++i;
        }
    }

    private static void mapCustomExport(CustomExportModel model, ProjectMapper.ProjectData projectData, RelationshipMapper relationship, DatasetData datasetData) {
        Long crlnId = CustomReportLibraryNodeRow.sequence.nextId();
        datasetData.addTableRowInsert(BuilderCustomReport.getCustomReportLibraryNodeTableRow(crlnId, projectData.getLibraryNodeId(), model.getName(), model.getCrceId(), CustomReportTreeDefinition.CUSTOM_EXPORT), relationship.mapRelationship(crlnId), BuilderCustomReport.getCustomExportTableRow(model, projectData.projectId()));
        model.getColumns().forEach(columnModel -> datasetData.addTableRowInsert(BuilderCustomReport.getCustomExportColumnTableRow(columnModel, model.getCrceId())));
        model.getScope().forEach(scopeModel -> datasetData.addTableRowInsert(BuilderCustomReport.getCustomExportScope(scopeModel, model.getCrceId())));
    }

    private static void mapCustomReport(CustomReportModel model, ProjectMapper.ProjectData projectData, RelationshipMapper relationship, DatasetData datasetData) {
        Long crlnId = CustomReportLibraryNodeRow.sequence.nextId();
        datasetData.addTableRowInsert(BuilderCustomReport.getCustomReportLibraryNodeTableRow(crlnId, projectData.getLibraryNodeId(), model.getName(), model.getReportId(), CustomReportTreeDefinition.REPORT), relationship.mapRelationship(crlnId), BuilderCustomReport.getReportDefinitionTableRow(model, projectData.projectId()));
    }

    private static void mapCustomDashboard(CustomDashboardModel model, ProjectMapper.ProjectData projectData, RelationshipMapper relationship, DatasetData datasetData) {
        Long crlnId = CustomReportLibraryNodeRow.sequence.nextId();
        datasetData.addTableRowInsert(BuilderCustomReport.getCustomReportLibraryNodeTableRow(crlnId, projectData.getLibraryNodeId(), model.getName(), model.getCrdId(), CustomReportTreeDefinition.DASHBOARD), relationship.mapRelationship(crlnId), BuilderCustomReport.getDashBoardTableRow(model, projectData.projectId()));
    }

    private static void mapCustomChart(CustomChartModel model, ProjectMapper.ProjectData projectData, RelationshipMapper relationship, DatasetData datasetData) {
        Long crlnId = CustomReportLibraryNodeRow.sequence.nextId();
        datasetData.addTableRowInsert(BuilderCustomReport.getCustomReportLibraryNodeTableRow(crlnId, projectData.getLibraryNodeId(), model.getName(), model.getChartId(), CustomReportTreeDefinition.CHART), relationship.mapRelationship(crlnId), BuilderCustomReport.getChartDefinition(model, projectData.projectId()));
        model.getScope().forEach(scopeModel -> datasetData.addTableRowInsert(BuilderCustomReport.getChartScopeTableRow(scopeModel, model.getChartId())));
    }
}

