/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.entitybuilder;

import java.util.Optional;
import org.squashtest.it.datasetbuilder.CustomFieldData;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.AiServerModel;
import org.squashtest.it.datasetbuilder.api.model.BugTrackerModel;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldModel;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldOptionModel;
import org.squashtest.it.datasetbuilder.api.model.InfoListItemModel;
import org.squashtest.it.datasetbuilder.api.model.InfoListModel;
import org.squashtest.it.datasetbuilder.api.model.MilestoneModel;
import org.squashtest.it.datasetbuilder.api.model.PromptModel;
import org.squashtest.it.datasetbuilder.api.model.PromptSetModel;
import org.squashtest.it.datasetbuilder.api.model.RequirementVersionLinkTypeModel;
import org.squashtest.it.datasetbuilder.api.model.ScmRepositoryModel;
import org.squashtest.it.datasetbuilder.api.model.ScmServerModel;
import org.squashtest.it.datasetbuilder.api.model.TestAutomationServerModel;
import org.squashtest.it.datasetbuilder.api.model.ThirdPartyServerModel;
import org.squashtest.it.datasetbuilder.mappers.ExecutionMapper;
import org.squashtest.it.datasetbuilder.rowbuilders.AiServerRow;
import org.squashtest.it.datasetbuilder.rowbuilders.BugtrackerRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CustomFieldBindingRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CustomFieldOptionRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CustomFieldRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CustomFieldValueOptionRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CustomFieldValueRow;
import org.squashtest.it.datasetbuilder.rowbuilders.DenormalizedFieldValueRow;
import org.squashtest.it.datasetbuilder.rowbuilders.InfoListItemRow;
import org.squashtest.it.datasetbuilder.rowbuilders.InfoListRow;
import org.squashtest.it.datasetbuilder.rowbuilders.MilestoneRow;
import org.squashtest.it.datasetbuilder.rowbuilders.PromptRow;
import org.squashtest.it.datasetbuilder.rowbuilders.PromptSetRow;
import org.squashtest.it.datasetbuilder.rowbuilders.RequirementVersionLinkTypeRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ScmRepositoryRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ScmServerRow;
import org.squashtest.it.datasetbuilder.rowbuilders.TestAutomationServerRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ThirdPartyServerRow;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValueType;
import org.squashtest.tm.domain.customfield.InputType;

public final class BuilderAdminWsEntities {
    private static final String ITEM_TYPE = "USR";

    private BuilderAdminWsEntities() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static TableRow getCustomFieldTableRow(CustomFieldModel model) {
        InputType inputType = model.getInputType();
        CustomFieldRow.Builder customFieldBuilder = CustomFieldRow.builder().withCfId((Object)model.getCufId()).withName((Object)model.getName()).withLabel((Object)model.getLabel()).withCode((Object)model.getCode()).withInputType((Object)model.getInputType().name()).withOptional((Object)model.getOptional()).withFieldType((Object)Discriminator.fromInputType(inputType).getCufFieldType());
        Object defaultValue = model.getDefaultValue();
        if (model.getDefaultValue() == null) {
            defaultValue = "";
        }
        switch (inputType) {
            case RICH_TEXT: {
                customFieldBuilder.withLargeDefaultValue(defaultValue);
                break;
            }
            case NUMERIC: {
                customFieldBuilder.withNumericDefaultValue(model.getDefaultValue()).withDefaultValue(defaultValue);
                break;
            }
            default: {
                customFieldBuilder.withDefaultValue(defaultValue);
            }
        }
        return customFieldBuilder.build().toTableRow();
    }

    public static TableRow getCustomFieldOptionTableRow(Long cufId, String label, String code, String colour, Integer position) {
        return CustomFieldOptionRow.builder().withCfId((Object)cufId).withLabel((Object)label).withCode((Object)code).withColour((Object)colour).withPosition((Object)position).build().toTableRow();
    }

    public static TableRow getCustomFieldOptionTableRow(Long cufId, CustomFieldOptionModel model, int position) {
        return BuilderAdminWsEntities.getCustomFieldOptionTableRow(cufId, model.getLabel(), model.getCode(), model.getColour(), position);
    }

    public static TableRow getCustomFieldBindingTableRow(Long cufId, Long cfbId, BindableEntity bindableEntity, Long projectId, Long position) {
        return CustomFieldBindingRow.builder().withCfbId((Object)cfbId).withCfId((Object)cufId).withBoundEntity((Object)bindableEntity).withBoundProjectId((Object)projectId).withPosition((Object)position).build().toTableRow();
    }

    public static TableRow getCustomFieldValueTableRow(CustomFieldData.CustomFieldValueData cufValueData, Long cfvId, Long boundEntityId, BindableEntity boundEntityType) {
        InputType inputType = cufValueData.inputType();
        CustomFieldValueRow.Builder customFieldValueBuilder = CustomFieldValueRow.builder().withCfvId((Object)cfvId).withCfId((Object)cufValueData.cfId()).withCfbId((Object)cufValueData.cfbId()).withBoundEntityId((Object)boundEntityId).withBoundEntityType((Object)boundEntityType.name()).withFieldType((Object)Discriminator.fromInputType(inputType).getCufValueFieldType());
        switch (inputType) {
            case RICH_TEXT: {
                customFieldValueBuilder.withLargeValue(cufValueData.value());
                break;
            }
            case NUMERIC: {
                customFieldValueBuilder.withNumericValue(cufValueData.value()).withValue(cufValueData.value());
                break;
            }
            default: {
                customFieldValueBuilder.withValue(cufValueData.value());
            }
        }
        return customFieldValueBuilder.build().toTableRow();
    }

    public static TableRow getCustomFieldValueOptionTableRow(Long cfvId, String tag, Long position) {
        return CustomFieldValueOptionRow.builder().withCfvId((Object)cfvId).withLabel((Object)tag).withPosition((Object)position).build().toTableRow();
    }

    public static TableRow getInfoListTableRow(InfoListModel model, Long infoListId) {
        return InfoListRow.builder().withInfoListId((Object)infoListId).withLabel((Object)model.getLabel()).withDescription((Object)model.getDescription()).withCode((Object)model.getCode()).withCreatedBy((Object)model.getCreatedBy()).withCreatedOn((Object)model.getCreatedOn()).withLastModifiedBy((Object)model.getLastModifiedBy()).withLastModifiedOn((Object)model.getLastModifiedOn()).build().toTableRow();
    }

    public static TableRow getInfoListItemTableRow(InfoListItemModel model, Long infoListId, Long index) {
        return InfoListItemRow.builder().withItemType((Object)ITEM_TYPE).withItemId((Object)model.getIliId()).withListId((Object)infoListId).withLabel((Object)model.getLabel()).withCode((Object)model.getCode()).withColour((Object)model.getColour()).withIconName((Object)model.getIconName()).withIsDefault((Object)model.getIsDefault()).withItemIndex((Object)index).build().toTableRow();
    }

    public static TableRow getDenormalizedFieldValueTableRow(Long dfvId, ExecutionMapper.DenormalizedValueData denormalizedValueData, Long position) {
        DenormalizedFieldValueRow.Builder denormalizedFieldValueBuilder = DenormalizedFieldValueRow.builder().withDfvId((Object)dfvId).withCfvId((Object)denormalizedValueData.cfvId()).withDenormalizedFieldHolderId((Object)denormalizedValueData.holderId()).withDenormalizedFieldHolderType((Object)denormalizedValueData.holderType()).withInputType((Object)denormalizedValueData.inputType()).withCode((Object)denormalizedValueData.code()).withLabel((Object)denormalizedValueData.label()).withPosition((Object)position).withFieldType((Object)Discriminator.fromInputType(denormalizedValueData.inputType()).getDenormalizedType());
        switch (denormalizedValueData.inputType()) {
            case RICH_TEXT: {
                denormalizedFieldValueBuilder.withLargeValue(Optional.ofNullable(denormalizedValueData.value()).orElse(""));
                break;
            }
            case NUMERIC: {
                Object value = Optional.ofNullable(denormalizedValueData.value()).orElse(0);
                denormalizedFieldValueBuilder.withNumericValue(value).withValue(value);
                break;
            }
            default: {
                denormalizedFieldValueBuilder.withValue(Optional.ofNullable(denormalizedValueData.value()).orElse(""));
            }
        }
        return denormalizedFieldValueBuilder.build().toTableRow();
    }

    public static TableRow getPrompSetTableRow(PromptSetModel model, Long promptSetId) {
        return PromptSetRow.builder().withPromptSetId((Object)promptSetId).withName((Object)model.getName()).withDescription((Object)model.getDescription()).withAiUsageId((Object)model.getAiUsageId()).withCreatedBy((Object)model.getCreatedBy()).withCreatedOn((Object)model.getCreatedOn()).withLastModifiedBy((Object)model.getLastModifiedBy()).withLastModifiedOn((Object)model.getLastModifiedOn()).build().toTableRow();
    }

    public static TableRow getPromptTableRow(PromptModel model, Long promptSetId, Long promptId) {
        return PromptRow.builder().withPromptId((Object)promptId).withName((Object)model.getName()).withPromptSetId((Object)promptSetId).withSystemPromptTemplate((Object)model.getSystemPromptTemplate()).withUserPromptTemplate((Object)model.getUserPromptTemplate()).build().toTableRow();
    }

    public static TableRow getMilestoneTableRow(MilestoneModel model) {
        return MilestoneRow.builder().withMilestoneId((Object)model.getId()).withLabel((Object)Optional.ofNullable(model.getLabel()).orElse("label%s".formatted(model.getId()))).withStatus((Object)model.getStatus()).withEndDate((Object)model.getEndDate()).withDescription((Object)model.getDescription()).withMRange((Object)model.getRange()).withCreatedBy((Object)model.getCreatedBy()).withCreatedOn((Object)model.getCreatedOn()).withLastModifiedBy((Object)model.getLastModifiedBy()).withLastModifiedOn((Object)model.getLastModifiedOn()).withUserId((Object)model.getUserId()).build().toTableRow();
    }

    public static TableRow getThirdPartyServerTableRow(ThirdPartyServerModel model) {
        return ThirdPartyServerRow.builder().withServerId((Object)model.getId()).withName((Object)model.getName()).withUrl((Object)model.getUrl()).withAuthPolicy((Object)model.getAuthPolicy()).withAuthProtocol((Object)model.getAuthProtocol()).withCreatedBy((Object)model.getCreatedBy()).withCreatedOn((Object)model.getCreatedOn()).withLastModifiedBy((Object)model.getLastModifiedBy()).withLastModifiedOn((Object)model.getLastModifiedOn()).withDescription((Object)model.getDescription()).build().toTableRow();
    }

    public static TableRow getTestAutomationServerTableRow(TestAutomationServerModel model) {
        return TestAutomationServerRow.builder().withServerId((Object)model.getId()).withKind((Object)model.getServerKind()).withManualSlaveSelection((Object)model.getManualSlaveSelection()).withObserverUrl((Object)model.getObserverUrl()).withEventBusUrl((Object)model.getEventBusUrl()).withKillswitchUrl((Object)model.getKillSwitchUrl()).withAdditionalConfiguration((Object)model.getAdditionalConfig()).build().toTableRow();
    }

    public static TableRow getAiServerTableRow(AiServerModel model) {
        return AiServerRow.builder().withServerId((Object)model.getId()).withJsonPath((Object)model.getJsonPath()).withPayloadTemplate((Object)model.getPayloadTemplate()).withModelName((Object)model.getPayloadTemplate()).withProvider((Object)model.getProvider()).withOptions((Object)model.getOptions()).build().toTableRow();
    }

    public static TableRow getScmServerTableRow(ScmServerModel model) {
        return ScmServerRow.builder().withServerId((Object)model.getId()).withKind((Object)model.getServerKind()).withCommitterMail((Object)model.getCommitterMail()).withCredentialsNotShared((Object)model.getCredentialsNotShared()).build().toTableRow();
    }

    public static TableRow getScmRepositoryTableRow(ScmRepositoryModel model, Long serverId) {
        return ScmRepositoryRow.builder().withScmRepositoryId((Object)model.getId()).withServerId((Object)serverId).withName((Object)model.getName()).withWorkingBranch((Object)model.getWorkingBranch()).withRepositoryPath((Object)model.getRepositoryPath()).withWorkingFolderPath((Object)model.getWorkingFolderPath()).build().toTableRow();
    }

    public static TableRow getRequirementVersionLinkTypeTableRow(RequirementVersionLinkTypeModel model) {
        return RequirementVersionLinkTypeRow.builder().withTypeId((Object)model.getId()).withRole1((Object)model.getRole1()).withRole2((Object)model.getRole2()).withRole1Code((Object)model.getCodeRole1()).withRole2Code((Object)model.getCodeRole2()).withIsDefault((Object)model.getIsDefault()).build().toTableRow();
    }

    public static TableRow getBugtrackerTableRow(BugTrackerModel model) {
        return BugtrackerRow.builder().withBugtrackerId((Object)model.getId()).withKind((Object)model.getKind()).withIframeFriendly((Object)model.getIframeFriendly()).build().toTableRow();
    }

    private static enum Discriminator {
        RICH_TEXT("RTF", CustomFieldValueType.RTF, CustomFieldValueType.RTF),
        NUMERIC("NUM", CustomFieldValueType.NUM, CustomFieldValueType.NUM),
        DROPDOWN_LIST("SSF", CustomFieldValueType.CF, CustomFieldValueType.CF),
        TAG("MSF", CustomFieldValueType.TAG, CustomFieldValueType.CF),
        DEFAULT("CF", CustomFieldValueType.CF, CustomFieldValueType.CF);

        private final String cufFieldType;
        private final CustomFieldValueType cufValueFieldType;
        private final CustomFieldValueType denormalizedType;

        private Discriminator(String cufFieldType, CustomFieldValueType cufValueFieldType, CustomFieldValueType denormalizedType) {
            this.cufFieldType = cufFieldType;
            this.cufValueFieldType = cufValueFieldType;
            this.denormalizedType = denormalizedType;
        }

        public String getCufFieldType() {
            return this.cufFieldType;
        }

        public String getCufValueFieldType() {
            return this.cufValueFieldType.getDiscriminatorValue();
        }

        public String getDenormalizedType() {
            return this.denormalizedType.getDiscriminatorValue();
        }

        public static Discriminator fromInputType(InputType inputType) {
            return switch (inputType) {
                case InputType.RICH_TEXT -> RICH_TEXT;
                case InputType.NUMERIC -> NUMERIC;
                case InputType.DROPDOWN_LIST -> DROPDOWN_LIST;
                case InputType.TAG -> TAG;
                default -> DEFAULT;
            };
        }
    }
}

