/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.DigestUtils;
import org.squashtest.it.datasetbuilder.CustomFieldData;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldBindingModel;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldModel;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldOptionModel;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldValueModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderAdminWsEntities;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.rowbuilders.CustomFieldBindingRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CustomFieldValueRow;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.InputType;

public final class CustomFieldMapper {
    private CustomFieldMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(CustomFieldModel ... models) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        CustomFieldModel[] customFieldModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            CustomFieldModel model = customFieldModelArray[n2];
            datasetData.addDatasetData(CustomFieldMapper.toDatasetData(model));
            ++n2;
        }
        return datasetData;
    }

    public static DatasetData toDatasetData(CustomFieldModel model) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderAdminWsEntities.getCustomFieldTableRow(model));
        if (model.getInputType().equals((Object)InputType.TAG) && model.getDefaultValue() != null) {
            Arrays.stream(((String)model.getDefaultValue()).split("\\|")).forEach(tag -> datasetData.addTableRowInsert(BuilderAdminWsEntities.getCustomFieldOptionTableRow(model.getCufId(), tag, DigestUtils.md5DigestAsHex((byte[])tag.getBytes()).substring(0, 30), null, null)));
        }
        int i = 0;
        while (i < model.getOptions().size()) {
            datasetData.addTableRowInsert(BuilderAdminWsEntities.getCustomFieldOptionTableRow(model.getCufId(), (CustomFieldOptionModel)model.getOptions().get(i), i));
            ++i;
        }
        return datasetData;
    }

    public static DatasetData toDatasetData(CustomFieldBindingModel model, CustomFieldData customFieldData, Long projectId, SequenceGenerator positionGenerator) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        model.getCufBindingIds().forEach(cufId -> {
            Long position = positionGenerator.getIdAndIncrement();
            model.getBoundEntities().forEach(boundEntity -> {
                Long cfbId = CustomFieldBindingRow.sequence.nextId();
                datasetData.addTableRowInsert(BuilderAdminWsEntities.getCustomFieldBindingTableRow(cufId, cfbId, boundEntity, projectId, position));
                customFieldData.putBinding((Long)cufId, projectId, (BindableEntity)boundEntity, cfbId);
            });
        });
        return datasetData;
    }

    public static DatasetData toDatasetData(ProjectMapper.ProjectData projectData, Long bindableEntityId, BindableEntity bindableEntity, List<CustomFieldValueModel> customFieldValueModels) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        projectData.customFieldData().getCustomFieldValueModel(projectData.projectId(), bindableEntity, customFieldValueModels).forEach(cufValueData -> datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, cufValueData, bindableEntityId, bindableEntity)));
        return datasetData;
    }

    public static DatasetData toDatasetData(ProjectMapper.ProjectData projectData, CustomFieldData.CustomFieldValueData cufValueData, Long bindableEntityId, BindableEntity bindableEntity) {
        Long cfvId = CustomFieldValueRow.sequence.nextId();
        if (BindableEntity.TEST_CASE.equals((Object)bindableEntity) || BindableEntity.TEST_STEP.equals((Object)bindableEntity)) {
            Map denormalizedByEntitiyId = projectData.denormalizedDataByBindableEntity().computeIfAbsent(bindableEntity, k -> new HashMap());
            List denormalizedDatas = denormalizedByEntitiyId.computeIfAbsent(bindableEntityId, k -> new ArrayList());
            denormalizedDatas.add(new ProjectMapper.DenormalizedData(cufValueData, cfvId));
        }
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderAdminWsEntities.getCustomFieldValueTableRow(cufValueData, cfvId, bindableEntityId, bindableEntity));
        if (cufValueData.inputType().equals((Object)InputType.TAG) && cufValueData.value() != null) {
            SequenceGenerator positionGenerator = new SequenceGenerator();
            Arrays.stream(((String)cufValueData.value()).split("\\|")).forEach(tag -> datasetData.addTableRowInsert(BuilderAdminWsEntities.getCustomFieldValueOptionTableRow(cfvId, tag, positionGenerator.getIdAndIncrement())));
        }
        return datasetData;
    }
}

