/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.CampaignFolderModel;
import org.squashtest.it.datasetbuilder.api.model.CampaignLibraryNodeModel;
import org.squashtest.it.datasetbuilder.api.model.CampaignModel;
import org.squashtest.it.datasetbuilder.api.model.ExploratoryTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.IterationModel;
import org.squashtest.it.datasetbuilder.api.model.SessionOverviewModel;
import org.squashtest.it.datasetbuilder.api.model.SprintGroupModel;
import org.squashtest.it.datasetbuilder.api.model.SprintModel;
import org.squashtest.it.datasetbuilder.api.model.SprintReqVersionModel;
import org.squashtest.it.datasetbuilder.api.model.TestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.TestPlanItemModel;
import org.squashtest.it.datasetbuilder.api.model.TestSuiteModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderExecutionWs;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderGlobalEntities;
import org.squashtest.it.datasetbuilder.mappers.CustomFieldMapper;
import org.squashtest.it.datasetbuilder.mappers.ExecutionMapper;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.rowbuilders.AttachmentListRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CampaignTestPlanItemRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ExploratorySessionOverviewRow;
import org.squashtest.it.datasetbuilder.rowbuilders.SprintReqVersionRow;
import org.squashtest.it.datasetbuilder.rowbuilders.TestPlanRow;
import org.squashtest.tm.domain.customfield.BindableEntity;

public final class CampaignLibraryNodeMapper {
    private CampaignLibraryNodeMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(CampaignLibraryNodeModel node, SequenceGenerator clContentOrderSequence, ProjectMapper.ProjectData projectData) {
        Relationship relationship = new Relationship(projectData.clid(), clContentOrderSequence, true, null, null);
        return CampaignLibraryNodeMapper.mapNode(node, projectData, relationship);
    }

    private static DatasetData mapNode(CampaignLibraryNodeModel node, ProjectMapper.ProjectData projectData, Relationship relationship) {
        CampaignLibraryNodeModel campaignLibraryNodeModel = node;
        Objects.requireNonNull(campaignLibraryNodeModel);
        CampaignLibraryNodeModel campaignLibraryNodeModel2 = campaignLibraryNodeModel;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CampaignFolderModel.class, CampaignModel.class, SprintModel.class}, (Object)campaignLibraryNodeModel2, n)) {
            case 0 -> {
                CampaignFolderModel folder = (CampaignFolderModel)campaignLibraryNodeModel2;
                yield CampaignLibraryNodeMapper.mapFolderNode(folder, projectData, relationship);
            }
            case 1 -> {
                CampaignModel campaign = (CampaignModel)campaignLibraryNodeModel2;
                yield CampaignLibraryNodeMapper.mapCampaignNode(campaign, projectData, relationship);
            }
            case 2 -> {
                SprintModel sprint = (SprintModel)campaignLibraryNodeModel2;
                yield CampaignLibraryNodeMapper.mapSprintNode(sprint, projectData, relationship);
            }
            default -> throw new IllegalArgumentException("Unsupported CampaignLibraryNode type: " + node.getClass().getName());
        };
    }

    private static List<TableRow> mapCampaignLibraryNode(CampaignLibraryNodeModel model, Long clnId, Long projectId, Relationship relationship) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        rows.add(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId));
        rows.add(BuilderExecutionWs.getCampaignLibraryNodeTableRow(model, clnId, attachmentListId, projectId));
        rows.add(CampaignLibraryNodeMapper.mapRelationship(clnId, relationship));
        return rows;
    }

    private static DatasetData mapFolderNode(CampaignFolderModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        Long clnId = model.getClnId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(CampaignLibraryNodeMapper.mapCampaignLibraryNode((CampaignLibraryNodeModel)model, clnId, projectData.projectId(), relationship));
        CampaignFolderModel campaignFolderModel = model;
        Objects.requireNonNull(campaignFolderModel);
        CampaignFolderModel campaignFolderModel2 = campaignFolderModel;
        int n = 0;
        BindableEntity bindableEntity = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SprintGroupModel.class, CampaignFolderModel.class}, (Object)campaignFolderModel2, n)) {
            case 0 -> {
                SprintGroupModel ignored = (SprintGroupModel)campaignFolderModel2;
                datasetData.addTableRowInsert(BuilderExecutionWs.getSprintGroupTableRow(model.getClnId()));
                yield BindableEntity.SPRINT_GROUP;
            }
            default -> {
                CampaignFolderModel ignored = campaignFolderModel2;
                datasetData.addTableRowInsert(BuilderExecutionWs.getCampaignFolderTableRow(model.getClnId()));
                yield BindableEntity.CAMPAIGN_FOLDER;
            }
        };
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, model.getClnId(), bindableEntity, model.getCustomFieldValues()));
        int i = 0;
        while (i < model.getNodes().size()) {
            CampaignLibraryNodeModel child = (CampaignLibraryNodeModel)model.getNodes().get(i);
            Relationship childRelationship = new Relationship(relationship.campaignLibraryId, relationship.clContentOrderSequence, false, clnId, i);
            datasetData.addDatasetData(CampaignLibraryNodeMapper.mapNode(child, projectData, childRelationship));
            ++i;
        }
        return datasetData;
    }

    private static DatasetData mapCampaignNode(CampaignModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        Long clnId = model.getClnId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(CampaignLibraryNodeMapper.mapCampaignLibraryNode((CampaignLibraryNodeModel)model, clnId, projectData.projectId(), relationship));
        datasetData.addTableRowInsert(BuilderExecutionWs.getCampaignTableRow(model, clnId));
        SequenceGenerator ctpiOrderSequence = new SequenceGenerator();
        model.getTestPlanItems().forEach(tpiModel -> {
            Long tpiId = CampaignTestPlanItemRow.sequence.nextId();
            datasetData.addTableRowInsert(BuilderExecutionWs.getCampaignTestPlanItemTableRow(tpiModel, tpiId, clnId, ctpiOrderSequence.getIdAndIncrement()));
        });
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, model.getClnId(), BindableEntity.CAMPAIGN, model.getCustomFieldValues()));
        SequenceGenerator iterationOrderSequence = new SequenceGenerator();
        model.getIterations().forEach(iteration -> {
            datasetData.addDatasetData(CampaignLibraryNodeMapper.mapIterationNode(iteration, projectData));
            datasetData.addTableRowInsert(BuilderExecutionWs.getCampaignIterationTableRow(clnId, iteration.getItId(), iterationOrderSequence.getIdAndIncrement()));
        });
        return datasetData;
    }

    private static DatasetData mapIterationNode(IterationModel model, ProjectMapper.ProjectData projectData) {
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        Long testPlanId = TestPlanRow.sequence.nextId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderExecutionWs.getTestPlanTableRow(testPlanId, projectData.clid()));
        SequenceGenerator tpiOrderSequence = new SequenceGenerator();
        model.getTestPlanItems().forEach(tpiModel -> CampaignLibraryNodeMapper.mapTestPlanItem(datasetData, tpiModel, testPlanId, tpiOrderSequence.getIdAndIncrement(), projectData));
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderExecutionWs.getIterationTableRow(model, attachmentListId, testPlanId));
        SequenceGenerator testSuiteOrderSequence = new SequenceGenerator();
        model.getTestSuites().forEach(testSuite -> {
            datasetData.addDatasetData(CampaignLibraryNodeMapper.mapTestSuiteNode(testSuite, projectData));
            datasetData.addTableRowInsert(BuilderExecutionWs.getIterationTestSuiteTableRow(model.getItId(), testSuite.getTsId(), testSuiteOrderSequence.getIdAndIncrement()));
        });
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, model.getItId(), BindableEntity.ITERATION, model.getCustomFieldValues()));
        return datasetData;
    }

    private static void mapTestPlanItem(DatasetData datasetData, TestPlanItemModel tpiModel, Long testPlanId, Long tpiOrder, ProjectMapper.ProjectData projectData) {
        Map<Long, TestCaseModel> testCaseModelByTclnId = projectData.testCaseModelByTclnId();
        if (!testCaseModelByTclnId.containsKey(tpiModel.getTclnId())) {
            datasetData.addTableRowInsert(BuilderExecutionWs.getTestPlanItemTableRow(tpiModel, testPlanId, null, tpiOrder, null));
            throw new IllegalArgumentException(String.format("TPI with id %s has unknown tclnId %s", tpiModel.getTpiId(), tpiModel.getTclnId()));
        }
        TestCaseModel testCaseModel = testCaseModelByTclnId.get(tpiModel.getTclnId());
        Long tclnId = null;
        if (!tpiModel.getDeleted()) {
            tclnId = testCaseModel.getTclnId();
        }
        datasetData.addTableRowInsert(BuilderExecutionWs.getTestPlanItemTableRow(tpiModel, testPlanId, tclnId, tpiOrder, null));
        if (testCaseModel instanceof ExploratoryTestCaseModel) {
            ExploratoryTestCaseModel exploratoryTestCaseModel = (ExploratoryTestCaseModel)testCaseModel;
            SessionOverviewModel sessionOverviewModel = Optional.ofNullable(tpiModel.getSessionOverview()).orElse(new SessionOverviewModel());
            Long sessionOverviewId = ExploratorySessionOverviewRow.sequence.nextId();
            Long attachmentListId = AttachmentListRow.sequence.nextId();
            datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderExecutionWs.getExploratorySessionOverviewTableRow(sessionOverviewModel, exploratoryTestCaseModel, sessionOverviewId, attachmentListId));
            datasetData.addTableRowUpdate(BuilderExecutionWs.getTestPlanItemTableRow(tpiModel, testPlanId, tclnId, tpiOrder, sessionOverviewId));
        }
        datasetData.addDatasetData(CampaignLibraryNodeMapper.mapExecution(tpiModel, projectData));
    }

    private static DatasetData mapTestSuiteNode(TestSuiteModel model, ProjectMapper.ProjectData projectData) {
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderExecutionWs.getTestSuiteTableRow(model, attachmentListId));
        SequenceGenerator tstpiOrderSequence = new SequenceGenerator();
        model.getTestPlanItemBindings().forEach(tpiId -> datasetData.addTableRowInsert(BuilderExecutionWs.getTestSuiteTestPlanItemTableRow(model.getTsId(), tpiId, tstpiOrderSequence.getIdAndIncrement())));
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, model.getTsId(), BindableEntity.TEST_SUITE, model.getCustomFieldValues()));
        return datasetData;
    }

    private static DatasetData mapExecution(TestPlanItemModel tpiModel, ProjectMapper.ProjectData projectData) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        SequenceGenerator executionOrderSequence = new SequenceGenerator();
        tpiModel.getExecutions().forEach(model -> datasetData.addDatasetData(ExecutionMapper.toDatasetData(model, tpiModel, executionOrderSequence.getIdAndIncrement(), projectData)));
        return datasetData;
    }

    private static DatasetData mapSprintNode(SprintModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        Long clnId = model.getClnId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(CampaignLibraryNodeMapper.mapCampaignLibraryNode((CampaignLibraryNodeModel)model, clnId, projectData.projectId(), relationship));
        datasetData.addTableRowInsert(BuilderExecutionWs.getSprintTableRow(model, clnId));
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, model.getClnId(), BindableEntity.SPRINT, model.getCustomFieldValues()));
        model.getSprintReqVersions().forEach(sprintReqVersionModel -> datasetData.addDatasetData(CampaignLibraryNodeMapper.mapSprintReqVersion(sprintReqVersionModel, model, projectData)));
        return datasetData;
    }

    private static DatasetData mapSprintReqVersion(SprintReqVersionModel model, SprintModel sprintModel, ProjectMapper.ProjectData projectData) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        Long sprintReqVersionId = SprintReqVersionRow.sequence.nextId();
        Long testPlanId = TestPlanRow.sequence.nextId();
        datasetData.addTableRowInsert(BuilderExecutionWs.getTestPlanTableRow(testPlanId, projectData.clid()));
        datasetData.addTableRowInsert(BuilderExecutionWs.getSprintReqVersionTableRow(model, sprintReqVersionId, sprintModel.getClnId(), testPlanId));
        SequenceGenerator tpiOrderSequence = new SequenceGenerator();
        model.getTestPlanItems().forEach(tpiModel -> CampaignLibraryNodeMapper.mapTestPlanItem(datasetData, tpiModel, testPlanId, tpiOrderSequence.getIdAndIncrement(), projectData));
        return datasetData;
    }

    private static TableRow mapRelationship(Long tclnId, Relationship relationship) {
        if (relationship.atRoot) {
            return BuilderExecutionWs.getRelationshipToLibrary(relationship.campaignLibraryId, tclnId, relationship.clContentOrderSequence.getIdAndIncrement());
        }
        Objects.requireNonNull(relationship.parentId);
        Objects.requireNonNull(relationship.order);
        return BuilderExecutionWs.getRelationshipToClnNode(relationship.parentId, tclnId, relationship.order);
    }

    private record Relationship(Long campaignLibraryId, SequenceGenerator clContentOrderSequence, boolean atRoot, Long parentId, Integer order) {
    }
}

