--
--     This file is part of the Squashtest platform.
--     Copyright (C) Henix, henix.fr
--
--     See the NOTICE file distributed with this work for additional
--     information regarding copyright ownership.
--
--     This is free software: you can redistribute it and/or modify
--     it under the terms of the GNU Lesser General Public License as published by
--     the Free Software Foundation, either version 3 of the License, or
--     (at your option) any later version.
--
--     this software is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU Lesser General Public License for more details.
--
--     You should have received a copy of the GNU Lesser General Public License
--     along with this software.  If not, see <http://www.gnu.org/licenses/>.
--

--
-- PostgreSQL database dump
--

-- Dumped from database version 16.1
-- Dumped by pg_dump version 16.1

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: uuid-ossp; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA public;


--
-- Name: EXTENSION "uuid-ossp"; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION "uuid-ossp" IS 'generate universally unique identifiers (UUIDs)';


--
-- Name: attach_awln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.attach_awln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
      insert into AWLN_RELATIONSHIP_CLOSURE
      select c1.ancestor_id, c2.descendant_id, c1.depth + c2.depth + 1
      from AWLN_RELATIONSHIP_CLOSURE c1
      cross join AWLN_RELATIONSHIP_CLOSURE c2
      where c1.descendant_id = new.ancestor_id
      and c2.ancestor_id = new.descendant_id;
      return new;
      end;
      $$;


ALTER FUNCTION public.attach_awln_after() OWNER TO postgres;

--
-- Name: attach_cln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.attach_cln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        insert into CLN_RELATIONSHIP_CLOSURE
        select c1.ancestor_id, c2.descendant_id, c1.depth + c2.depth + 1
        from CLN_RELATIONSHIP_CLOSURE c1
        cross join CLN_RELATIONSHIP_CLOSURE c2
        where c1.descendant_id = new.ancestor_id
        and c2.ancestor_id = new.descendant_id;
        return new;
      end;
      $$;


ALTER FUNCTION public.attach_cln_after() OWNER TO postgres;

--
-- Name: attach_crln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.attach_crln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		begin
			insert into CRLN_RELATIONSHIP_CLOSURE
			select c1.ancestor_id, c2.descendant_id, c1.depth + c2.depth + 1
			from CRLN_RELATIONSHIP_CLOSURE c1
			cross join CRLN_RELATIONSHIP_CLOSURE c2
			where c1.descendant_id = new.ancestor_id
			and c2.ancestor_id = new.descendant_id;
			return new;
		end;
		$$;


ALTER FUNCTION public.attach_crln_after() OWNER TO postgres;

--
-- Name: attach_rln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.attach_rln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        insert into RLN_RELATIONSHIP_CLOSURE
        select c1.ancestor_id, c2.descendant_id, c1.depth + c2.depth + 1
        from RLN_RELATIONSHIP_CLOSURE c1
        cross join RLN_RELATIONSHIP_CLOSURE c2
        where c1.descendant_id = new.ancestor_id
        and c2.ancestor_id = new.descendant_id;
        return new;
      end;
      $$;


ALTER FUNCTION public.attach_rln_after() OWNER TO postgres;

--
-- Name: attach_tcln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.attach_tcln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        insert into TCLN_RELATIONSHIP_CLOSURE
        select c1.ancestor_id, c2.descendant_id, c1.depth + c2.depth + 1
        from TCLN_RELATIONSHIP_CLOSURE c1
        cross join TCLN_RELATIONSHIP_CLOSURE c2
        where c1.descendant_id = new.ancestor_id
        and c2.ancestor_id = new.descendant_id;
        return new;
      end;
      $$;


ALTER FUNCTION public.attach_tcln_after() OWNER TO postgres;

--
-- Name: del_awln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.del_awln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
      delete from AWLN_RELATIONSHIP_CLOSURE
      where ancestor_id = old.awln_id
      and descendant_id = old.awln_id;
      return old;
      end;
      $$;


ALTER FUNCTION public.del_awln_before() OWNER TO postgres;

--
-- Name: del_cln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.del_cln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        delete from CLN_RELATIONSHIP_CLOSURE
        where ancestor_id = old.cln_id
        and descendant_id = old.cln_id;
        return old;
      end;
      $$;


ALTER FUNCTION public.del_cln_before() OWNER TO postgres;

--
-- Name: del_crln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.del_crln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		begin
			delete from CRLN_RELATIONSHIP_CLOSURE
			where ancestor_id = old.crln_id
			and descendant_id = old.crln_id;
			return old;
		end;
		$$;


ALTER FUNCTION public.del_crln_before() OWNER TO postgres;

--
-- Name: del_rln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.del_rln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        delete from RLN_RELATIONSHIP_CLOSURE
        where ancestor_id = old.rln_id
        and descendant_id = old.rln_id;
        return old;
      end;
      $$;


ALTER FUNCTION public.del_rln_before() OWNER TO postgres;

--
-- Name: del_tcln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.del_tcln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        delete from TCLN_RELATIONSHIP_CLOSURE
        where ancestor_id=old.tcln_id
        and descendant_id=old.tcln_id;
        return old;
      end;
      $$;


ALTER FUNCTION public.del_tcln_before() OWNER TO postgres;

--
-- Name: detach_awln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.detach_awln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
      delete from AWLN_RELATIONSHIP_CLOSURE
      where descendant_id in ( select descendant_id from AWLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
      and ancestor_id not in ( select descendant_id from AWLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
      ;
      return old;
      end;
      $$;


ALTER FUNCTION public.detach_awln_before() OWNER TO postgres;

--
-- Name: detach_cln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.detach_cln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        delete from CLN_RELATIONSHIP_CLOSURE
        where descendant_id in ( select descendant_id from CLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
        and ancestor_id not in ( select descendant_id from CLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
        ;
        return old;
      end;
      $$;


ALTER FUNCTION public.detach_cln_before() OWNER TO postgres;

--
-- Name: detach_crln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.detach_crln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		begin
			delete from CRLN_RELATIONSHIP_CLOSURE
			where descendant_id in ( select descendant_id from CRLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
			and ancestor_id not in ( select descendant_id from CRLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
			;
			return old;
		end;
		$$;


ALTER FUNCTION public.detach_crln_before() OWNER TO postgres;

--
-- Name: detach_rln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.detach_rln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
      delete from RLN_RELATIONSHIP_CLOSURE
        where descendant_id in ( select descendant_id from RLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
        and ancestor_id not in ( select descendant_id from RLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
        ;
        return old;
      end;
      $$;


ALTER FUNCTION public.detach_rln_before() OWNER TO postgres;

--
-- Name: detach_tcln_before(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.detach_tcln_before() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        delete from TCLN_RELATIONSHIP_CLOSURE
        where descendant_id in ( select descendant_id from TCLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
        and ancestor_id not in ( select descendant_id from TCLN_RELATIONSHIP_CLOSURE where ancestor_id = old.descendant_id )
        ;
        return old;

      end;
      $$;


ALTER FUNCTION public.detach_tcln_before() OWNER TO postgres;

--
-- Name: group_concat_func(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.group_concat_func(field1 text, field2 text) RETURNS text
    LANGUAGE plpgsql
    AS $$
      BEGIN
      RETURN
      COALESCE(field1||','||field2, field2, field1);
      END;
      $$;


ALTER FUNCTION public.group_concat_func(field1 text, field2 text) OWNER TO postgres;

--
-- Name: ins_awln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_awln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
      insert into AWLN_RELATIONSHIP_CLOSURE
      values (new.awln_id, new.awln_id, 0);
      return new;
      end;
      $$;


ALTER FUNCTION public.ins_awln_after() OWNER TO postgres;

--
-- Name: ins_cln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_cln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        insert into CLN_RELATIONSHIP_CLOSURE
        values (new.cln_id, new.cln_id, 0);
        return new;
      end;
      $$;


ALTER FUNCTION public.ins_cln_after() OWNER TO postgres;

--
-- Name: ins_crln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_crln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		begin
			insert into CRLN_RELATIONSHIP_CLOSURE
			values (new.crln_id, new.crln_id, 0);
			return new;
		end;
		$$;


ALTER FUNCTION public.ins_crln_after() OWNER TO postgres;

--
-- Name: ins_rln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_rln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        insert into RLN_RELATIONSHIP_CLOSURE
        values (new.rln_id, new.rln_id, 0);
        return new;
      end;
      $$;


ALTER FUNCTION public.ins_rln_after() OWNER TO postgres;

--
-- Name: ins_tcln_after(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_tcln_after() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      begin
        insert into TCLN_RELATIONSHIP_CLOSURE
        values (new.tcln_id, new.tcln_id, 0);
        return new;
      end;
      $$;


ALTER FUNCTION public.ins_tcln_after() OWNER TO postgres;

--
-- Name: group_concat(text); Type: AGGREGATE; Schema: public; Owner: postgres
--

CREATE AGGREGATE public.group_concat(text) (
    SFUNC = public.group_concat_func,
    STYPE = text
);


ALTER AGGREGATE public.group_concat(text) OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: acl_class; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.acl_class (
    id bigint NOT NULL,
    classname character varying(255) NOT NULL
);


ALTER TABLE public.acl_class OWNER TO postgres;

--
-- Name: COLUMN acl_class.classname; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.acl_class.classname IS 'Fully qualified classname';


--
-- Name: acl_class_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.acl_class ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.acl_class_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: acl_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.acl_group (
    id bigint NOT NULL,
    qualified_name character varying(50) NOT NULL,
    active boolean DEFAULT true NOT NULL,
    description text DEFAULT ''::text NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone
);


ALTER TABLE public.acl_group OWNER TO postgres;

--
-- Name: COLUMN acl_group.qualified_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.acl_group.qualified_name IS 'Group''s qualified name, both used as a functional key and a localization key. Should be something like ''squashtest.acl.group._app module_._GroupName_''';


--
-- Name: acl_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.acl_group ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.acl_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: acl_group_permission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.acl_group_permission (
    acl_group_id bigint NOT NULL,
    permission_mask integer DEFAULT 0 NOT NULL,
    class_id bigint NOT NULL,
    permission_order integer DEFAULT 0 NOT NULL,
    granting boolean DEFAULT true NOT NULL
);


ALTER TABLE public.acl_group_permission OWNER TO postgres;

--
-- Name: COLUMN acl_group_permission.permission_mask; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.acl_group_permission.permission_mask IS 'Mask of permissions as defined by spring security';


--
-- Name: COLUMN acl_group_permission.class_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.acl_group_permission.class_id IS 'The class to which the permissions apply';


--
-- Name: acl_object_identity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.acl_object_identity (
    id bigint NOT NULL,
    identity bigint NOT NULL,
    class_id bigint NOT NULL
);


ALTER TABLE public.acl_object_identity OWNER TO postgres;

--
-- Name: COLUMN acl_object_identity.identity; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.acl_object_identity.identity IS 'The id of the target entity';


--
-- Name: acl_object_identity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.acl_object_identity ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.acl_object_identity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: acl_responsibility_scope_entry; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.acl_responsibility_scope_entry (
    id bigint NOT NULL,
    party_id bigint NOT NULL,
    acl_group_id bigint NOT NULL,
    object_identity_id bigint NOT NULL
);


ALTER TABLE public.acl_responsibility_scope_entry OWNER TO postgres;

--
-- Name: acl_responsibility_scope_entry_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.acl_responsibility_scope_entry ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.acl_responsibility_scope_entry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: action_test_step; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_test_step (
    test_step_id bigint NOT NULL,
    action text DEFAULT ''::text NOT NULL,
    expected_result text DEFAULT ''::text NOT NULL,
    attachment_list_id bigint
);


ALTER TABLE public.action_test_step OWNER TO postgres;

--
-- Name: COLUMN action_test_step.test_step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_test_step.test_step_id IS 'Shared key with TEST_STEP table';


--
-- Name: COLUMN action_test_step.action; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_test_step.action IS 'The step''s action';


--
-- Name: COLUMN action_test_step.expected_result; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_test_step.expected_result IS 'The step''s expected result';


--
-- Name: COLUMN action_test_step.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_test_step.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: action_word; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_word (
    action_word_id bigint NOT NULL,
    description text,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    token character varying(766) NOT NULL,
    project_id bigint NOT NULL,
    last_implementation_technology character varying(30),
    last_implementation_date timestamp without time zone
);


ALTER TABLE public.action_word OWNER TO postgres;

--
-- Name: COLUMN action_word.last_implementation_technology; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word.last_implementation_technology IS 'Technology used for last implementation';


--
-- Name: COLUMN action_word.last_implementation_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word.last_implementation_date IS 'Date of last implementation';


--
-- Name: action_word_action_word_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.action_word ALTER COLUMN action_word_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.action_word_action_word_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: action_word_fragment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_word_fragment (
    action_word_fragment_id bigint NOT NULL,
    action_word_id bigint,
    fragment_order integer
);


ALTER TABLE public.action_word_fragment OWNER TO postgres;

--
-- Name: TABLE action_word_fragment; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.action_word_fragment IS 'base table for Action word fragments';


--
-- Name: COLUMN action_word_fragment.action_word_fragment_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_fragment.action_word_fragment_id IS 'primary key, auto-generated';


--
-- Name: COLUMN action_word_fragment.action_word_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_fragment.action_word_id IS 'Foreign key to the action word';


--
-- Name: COLUMN action_word_fragment.fragment_order; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_fragment.fragment_order IS 'the fragment order in action word fragment list';


--
-- Name: action_word_fragment_action_word_fragment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.action_word_fragment ALTER COLUMN action_word_fragment_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.action_word_fragment_action_word_fragment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: action_word_library; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_word_library (
    awl_id bigint NOT NULL,
    attachment_list_id bigint
);


ALTER TABLE public.action_word_library OWNER TO postgres;

--
-- Name: COLUMN action_word_library.awl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_library.awl_id IS 'The auto-generated id';


--
-- Name: COLUMN action_word_library.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_library.attachment_list_id IS 'Foreign key to ATTACHMENT_LIST';


--
-- Name: action_word_library_awl_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.action_word_library ALTER COLUMN awl_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.action_word_library_awl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: action_word_library_node; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_word_library_node (
    awln_id bigint NOT NULL,
    name character varying(255),
    entity_type character varying(50),
    entity_id bigint,
    awl_id bigint
);


ALTER TABLE public.action_word_library_node OWNER TO postgres;

--
-- Name: COLUMN action_word_library_node.awln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_library_node.awln_id IS 'The auto-generated id';


--
-- Name: COLUMN action_word_library_node.awl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_library_node.awl_id IS 'Foreign key to the ACTION_WORD_LIBRARY';


--
-- Name: action_word_library_node_awln_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.action_word_library_node ALTER COLUMN awln_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.action_word_library_node_awln_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: action_word_parameter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_word_parameter (
    action_word_fragment_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    default_value character varying(255) NOT NULL
);


ALTER TABLE public.action_word_parameter OWNER TO postgres;

--
-- Name: COLUMN action_word_parameter.action_word_fragment_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_parameter.action_word_fragment_id IS 'Shared key with ACTION_WORD_FRAGMENT table';


--
-- Name: COLUMN action_word_parameter.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_parameter.name IS 'the name of the action word parameter';


--
-- Name: COLUMN action_word_parameter.default_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_parameter.default_value IS 'the default value of the action word parameter';


--
-- Name: action_word_parameter_value; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_word_parameter_value (
    action_word_parameter_value_id bigint NOT NULL,
    value character varying(255) NOT NULL,
    action_word_fragment_id bigint NOT NULL,
    keyword_test_step_id bigint NOT NULL
);


ALTER TABLE public.action_word_parameter_value OWNER TO postgres;

--
-- Name: COLUMN action_word_parameter_value.action_word_parameter_value_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_parameter_value.action_word_parameter_value_id IS 'primary key, auto-generated';


--
-- Name: COLUMN action_word_parameter_value.value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_parameter_value.value IS 'the value of the action word parameter value';


--
-- Name: COLUMN action_word_parameter_value.action_word_fragment_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_parameter_value.action_word_fragment_id IS 'the action word parameter by which this value replaces';


--
-- Name: COLUMN action_word_parameter_value.keyword_test_step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_parameter_value.keyword_test_step_id IS 'the keyword test step in which this value is used';


--
-- Name: action_word_parameter_value_action_word_parameter_value_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.action_word_parameter_value ALTER COLUMN action_word_parameter_value_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.action_word_parameter_value_action_word_parameter_value_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: action_word_text; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_word_text (
    action_word_fragment_id bigint NOT NULL,
    text character varying(255) NOT NULL
);


ALTER TABLE public.action_word_text OWNER TO postgres;

--
-- Name: COLUMN action_word_text.action_word_fragment_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_text.action_word_fragment_id IS 'Shared key with ACTION_WORD_FRAGMENT table';


--
-- Name: COLUMN action_word_text.text; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.action_word_text.text IS 'the content of the action word text';


--
-- Name: ai_server; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ai_server (
    server_id bigint NOT NULL,
    payload_template text,
    json_path character varying(255) DEFAULT NULL::character varying
);


ALTER TABLE public.ai_server OWNER TO postgres;

--
-- Name: COLUMN ai_server.server_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.ai_server.server_id IS 'The id of the ai server, foreign key to third_party_server.';


--
-- Name: COLUMN ai_server.payload_template; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.ai_server.payload_template IS 'The body of the json sent';


--
-- Name: COLUMN ai_server.json_path; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.ai_server.json_path IS 'Specifies the JSON path used to locate the node containing the response in AI-generated test cases.';


--
-- Name: api_token; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.api_token (
    token_id bigint NOT NULL,
    user_id bigint NOT NULL,
    uuid character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    permissions character varying(50) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    expiry_date character varying(10) NOT NULL,
    last_usage timestamp without time zone,
    created_by character varying(100) NOT NULL
);


ALTER TABLE public.api_token OWNER TO postgres;

--
-- Name: COLUMN api_token.token_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.api_token.token_id IS 'primary key for API_TOKEN';


--
-- Name: COLUMN api_token.user_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.api_token.user_id IS 'foreign key to CORE_USER.PARTY_ID';


--
-- Name: COLUMN api_token.uuid; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.api_token.uuid IS 'Unique UUID to identify a token in database';


--
-- Name: COLUMN api_token.permissions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.api_token.permissions IS 'READ for GET and READ_WRITE for all methods';


--
-- Name: api_token_token_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.api_token ALTER COLUMN token_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.api_token_token_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: attachment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attachment (
    attachment_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    type character varying(10) NOT NULL,
    size bigint NOT NULL,
    added_on timestamp without time zone NOT NULL,
    content_id bigint,
    attachment_list_id bigint NOT NULL,
    last_modified_on timestamp without time zone
);


ALTER TABLE public.attachment OWNER TO postgres;

--
-- Name: COLUMN attachment.attachment_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment.attachment_id IS 'clé primaire de la piece jointe. Devrait être autogénérée.';


--
-- Name: COLUMN attachment.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment.name IS 'nom de la piece jointe';


--
-- Name: COLUMN attachment.type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment.type IS 'type de la piece jointe. Cette information pourrait etre trivialement deduite du nom de fichier';


--
-- Name: COLUMN attachment.size; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment.size IS 'taille de la piece jointe en octet. Cette information est déterminée au moment de l''upload et doit etre fournie a la base     dès sa création';


--
-- Name: COLUMN attachment.added_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment.added_on IS 'Date de l''ajout de la piece jointe.';


--
-- Name: COLUMN attachment.content_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment.content_id IS 'cle etrangere vers la table ATTACHMENT_CONTENT';


--
-- Name: COLUMN attachment.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment.last_modified_on IS 'the date when the attachment was last modified';


--
-- Name: attachment_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.attachment ALTER COLUMN attachment_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.attachment_attachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: attachment_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attachment_content (
    attachment_content_id bigint NOT NULL,
    stream_content oid
);


ALTER TABLE public.attachment_content OWNER TO postgres;

--
-- Name: COLUMN attachment_content.attachment_content_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment_content.attachment_content_id IS 'clé primaire du contenu de la piece jointe. Devrait être autogénérée.';


--
-- Name: COLUMN attachment_content.stream_content; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment_content.stream_content IS 'Le contenu de la piece jointe.';


--
-- Name: attachment_content_attachment_content_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.attachment_content ALTER COLUMN attachment_content_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.attachment_content_attachment_content_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: attachment_list; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attachment_list (
    attachment_list_id bigint NOT NULL
);


ALTER TABLE public.attachment_list OWNER TO postgres;

--
-- Name: COLUMN attachment_list.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.attachment_list.attachment_list_id IS 'clé primaire, devrait être autogénérée.';


--
-- Name: attachment_list_attachment_list_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.attachment_list ALTER COLUMN attachment_list_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.attachment_list_attachment_list_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.auth_user (
    login character varying(100) NOT NULL,
    password character varying(255) NOT NULL,
    active boolean DEFAULT true NOT NULL
);


ALTER TABLE public.auth_user OWNER TO postgres;

--
-- Name: TABLE auth_user; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.auth_user IS 'Stores users credentials';


--
-- Name: COLUMN auth_user.login; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.auth_user.login IS 'The user''s unique identifier';


--
-- Name: COLUMN auth_user.password; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.auth_user.password IS 'SHA-1 hash of the user''s password';


--
-- Name: automated_execution_extender; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automated_execution_extender (
    extender_id bigint NOT NULL,
    master_execution_id bigint NOT NULL,
    test_id bigint,
    result_url character varying(300),
    result_summary text,
    node_name character varying(50) DEFAULT ''::character varying,
    execution_extender_order bigint,
    test_technology character varying(36),
    duration integer,
    flag character varying(50),
    suite_id bigint NOT NULL
);


ALTER TABLE public.automated_execution_extender OWNER TO postgres;

--
-- Name: COLUMN automated_execution_extender.master_execution_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_execution_extender.master_execution_id IS 'foreign key to the Execution it attaches to.';


--
-- Name: COLUMN automated_execution_extender.test_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_execution_extender.test_id IS 'we save that information as soon as the auto execution is created,             because it may change in the future (even if the test case that this execution             is linked to stays otherwhise the same)';


--
-- Name: COLUMN automated_execution_extender.result_url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_execution_extender.result_url IS 'urls longer than 300 chars should go to hell';


--
-- Name: COLUMN automated_execution_extender.result_summary; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_execution_extender.result_summary IS 'a short debriefing of a test once it has been       executed, for instance an error message';


--
-- Name: COLUMN automated_execution_extender.node_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_execution_extender.node_name IS 'Name of the node which ran the test';


--
-- Name: COLUMN automated_execution_extender.execution_extender_order; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_execution_extender.execution_extender_order IS 'order of automated executions extenders within an automated suite';


--
-- Name: COLUMN automated_execution_extender.duration; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_execution_extender.duration IS 'the execution time of a automation test';


--
-- Name: COLUMN automated_execution_extender.flag; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_execution_extender.flag IS 'Indicates the status of the automated test (e.g., To be analysed, Flaky, Fixed)';


--
-- Name: automated_execution_extender_extender_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.automated_execution_extender ALTER COLUMN extender_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.automated_execution_extender_extender_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: automated_execution_failure_detail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automated_execution_failure_detail (
    failure_detail_id bigint NOT NULL,
    execution_extender_id bigint NOT NULL
);


ALTER TABLE public.automated_execution_failure_detail OWNER TO postgres;

--
-- Name: automated_suite; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automated_suite (
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    execution_status character varying(255) DEFAULT 'READY'::character varying,
    iteration_id bigint,
    test_suite_id bigint,
    attachment_list_id bigint,
    uuid character varying(50),
    suite_id bigint NOT NULL
);


ALTER TABLE public.automated_suite OWNER TO postgres;

--
-- Name: COLUMN automated_suite.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_suite.attachment_list_id IS 'foreign key to ATTACHMENT_LIST, entity dealing with attachment.';


--
-- Name: automated_suite_suite_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.automated_suite ALTER COLUMN suite_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.automated_suite_suite_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: automated_suite_workflows; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automated_suite_workflows (
    workflow_id character varying(100) NOT NULL,
    project_id bigint NOT NULL,
    suite_id bigint NOT NULL
);


ALTER TABLE public.automated_suite_workflows OWNER TO postgres;

--
-- Name: COLUMN automated_suite_workflows.workflow_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_suite_workflows.workflow_id IS 'id of the workflow launched from the suite';


--
-- Name: COLUMN automated_suite_workflows.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automated_suite_workflows.project_id IS 'original project id';


--
-- Name: automated_test; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automated_test (
    test_id bigint NOT NULL,
    name character varying(255),
    project_id bigint
);


ALTER TABLE public.automated_test OWNER TO postgres;

--
-- Name: automated_test_technology; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automated_test_technology (
    at_technology_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    action_provider_key character varying(50) NOT NULL,
    premium boolean DEFAULT false NOT NULL
);


ALTER TABLE public.automated_test_technology OWNER TO postgres;

--
-- Name: automated_test_technology_at_technology_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.automated_test_technology ALTER COLUMN at_technology_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.automated_test_technology_at_technology_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: automated_test_test_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.automated_test ALTER COLUMN test_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.automated_test_test_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: automation_environment_tag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automation_environment_tag (
    value character varying(255),
    entity_type character varying(50) NOT NULL,
    entity_id bigint NOT NULL
);


ALTER TABLE public.automation_environment_tag OWNER TO postgres;

--
-- Name: automation_request; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automation_request (
    automation_request_id bigint NOT NULL,
    request_status character varying(25) DEFAULT 'WORK_IN_PROGRESS'::character varying NOT NULL,
    transmitted_on timestamp without time zone,
    assigned_to bigint,
    automation_priority integer,
    assigned_on timestamp without time zone,
    created_by bigint,
    transmitted_by bigint,
    project_id bigint NOT NULL,
    conflict_association text,
    is_manual boolean DEFAULT false NOT NULL
);


ALTER TABLE public.automation_request OWNER TO postgres;

--
-- Name: COLUMN automation_request.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automation_request.project_id IS 'fk to the host project';


--
-- Name: automation_request_automation_request_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.automation_request ALTER COLUMN automation_request_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.automation_request_automation_request_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: automation_request_library; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automation_request_library (
    arl_id bigint NOT NULL,
    attachment_list_id bigint
);


ALTER TABLE public.automation_request_library OWNER TO postgres;

--
-- Name: COLUMN automation_request_library.arl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automation_request_library.arl_id IS 'autoincremented primary key';


--
-- Name: COLUMN automation_request_library.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automation_request_library.attachment_list_id IS 'fk to the attachment list';


--
-- Name: automation_request_library_arl_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.automation_request_library ALTER COLUMN arl_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.automation_request_library_arl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: automation_request_library_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.automation_request_library_content (
    library_id bigint NOT NULL,
    content_id bigint NOT NULL
);


ALTER TABLE public.automation_request_library_content OWNER TO postgres;

--
-- Name: COLUMN automation_request_library_content.library_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automation_request_library_content.library_id IS 'Foreign key to the library';


--
-- Name: COLUMN automation_request_library_content.content_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.automation_request_library_content.content_id IS 'Foreign key to the content';


--
-- Name: awln_relationship; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.awln_relationship (
    ancestor_id bigint,
    descendant_id bigint NOT NULL,
    content_order bigint
);


ALTER TABLE public.awln_relationship OWNER TO postgres;

--
-- Name: COLUMN awln_relationship.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.awln_relationship.ancestor_id IS 'Foreign key to parent node';


--
-- Name: COLUMN awln_relationship.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.awln_relationship.descendant_id IS 'Foreign key to child node';


--
-- Name: COLUMN awln_relationship.content_order; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.awln_relationship.content_order IS 'Order in its parent node';


--
-- Name: awln_relationship_closure; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.awln_relationship_closure (
    ancestor_id bigint NOT NULL,
    descendant_id bigint NOT NULL,
    depth smallint NOT NULL
);


ALTER TABLE public.awln_relationship_closure OWNER TO postgres;

--
-- Name: COLUMN awln_relationship_closure.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.awln_relationship_closure.ancestor_id IS 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN awln_relationship_closure.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.awln_relationship_closure.descendant_id IS 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN awln_relationship_closure.depth; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.awln_relationship_closure.depth IS 'stores how deep is the descendant element nested in the subtree of the ancestor element';


--
-- Name: bugtracker; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bugtracker (
    bugtracker_id bigint NOT NULL,
    kind character varying(50) DEFAULT 'mantis'::character varying NOT NULL,
    iframe_friendly boolean DEFAULT false NOT NULL
);


ALTER TABLE public.bugtracker OWNER TO postgres;

--
-- Name: TABLE bugtracker; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.bugtracker IS 'stores bugtrackers informations';


--
-- Name: COLUMN bugtracker.bugtracker_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.bugtracker.bugtracker_id IS 'primary key, should be auto-generated.';


--
-- Name: COLUMN bugtracker.kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.bugtracker.kind IS 'tells what kind of connector should be used';


--
-- Name: COLUMN bugtracker.iframe_friendly; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.bugtracker.iframe_friendly IS 'tells if the bugtracker page can be accessed through an iframe';


--
-- Name: bugtracker_project; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bugtracker_project (
    bugtracker_project_id bigint NOT NULL,
    bugtracker_project_name character varying(255),
    bugtracker_project_order integer NOT NULL,
    project_id bigint NOT NULL
);


ALTER TABLE public.bugtracker_project OWNER TO postgres;

--
-- Name: bugtracker_project_bugtracker_project_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.bugtracker_project ALTER COLUMN bugtracker_project_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.bugtracker_project_bugtracker_project_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: call_test_step; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.call_test_step (
    test_step_id bigint NOT NULL,
    called_test_case_id bigint NOT NULL,
    called_dataset bigint,
    delegate_parameter_values boolean DEFAULT false NOT NULL
);


ALTER TABLE public.call_test_step OWNER TO postgres;

--
-- Name: COLUMN call_test_step.test_step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.call_test_step.test_step_id IS 'Shared key with TEST_STEP table';


--
-- Name: COLUMN call_test_step.called_test_case_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.call_test_step.called_test_case_id IS 'ID of called test case';


--
-- Name: COLUMN call_test_step.called_dataset; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.call_test_step.called_dataset IS 'A reference to the called dataset (if any). The fk constraint must set null when the dataset is deleted.';


--
-- Name: COLUMN call_test_step.delegate_parameter_values; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.call_test_step.delegate_parameter_values IS 'Says whether the parameters of the called test case must be set by the caller test case or not';


--
-- Name: campaign; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.campaign (
    cln_id bigint NOT NULL,
    actual_end_auto boolean NOT NULL,
    actual_end_date timestamp without time zone,
    actual_start_auto boolean NOT NULL,
    actual_start_date timestamp without time zone,
    scheduled_end_date timestamp without time zone,
    scheduled_start_date timestamp without time zone,
    reference character varying(50) DEFAULT ''::character varying,
    campaign_status character varying(30) DEFAULT 'UNDEFINED'::character varying NOT NULL
);


ALTER TABLE public.campaign OWNER TO postgres;

--
-- Name: COLUMN campaign.actual_end_auto; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign.actual_end_auto IS 'Drapeau indiquant si l''utilisateur a choisit une determination automatique de la date de depart effective ou non.';


--
-- Name: COLUMN campaign.actual_end_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign.actual_end_date IS 'Date de fin effective (reelle) de la campagne.';


--
-- Name: COLUMN campaign.actual_start_auto; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign.actual_start_auto IS 'Drapeau indiquant si l''utilisateur a choisit une determination automatique de la date de fin effective ou non.';


--
-- Name: COLUMN campaign.actual_start_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign.actual_start_date IS 'Date de depar effective (reelle) de la campagne.';


--
-- Name: COLUMN campaign.scheduled_end_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign.scheduled_end_date IS 'Date planifiee de fin de la campagne.';


--
-- Name: COLUMN campaign.scheduled_start_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign.scheduled_start_date IS 'Date planifiee de debut de la campagne.';


--
-- Name: COLUMN campaign.reference; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign.reference IS 'a reference lavel for a campaign';


--
-- Name: campaign_folder; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.campaign_folder (
    cln_id bigint NOT NULL
);


ALTER TABLE public.campaign_folder OWNER TO postgres;

--
-- Name: COLUMN campaign_folder.cln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_folder.cln_id IS 'cle primaire, qui est une cle etrangere vers la table CAMPAIGN_LIBRARY_NODE. Ne doit donc pas etre autogeneree.';


--
-- Name: campaign_iteration; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.campaign_iteration (
    campaign_id bigint NOT NULL,
    iteration_id bigint NOT NULL,
    iteration_order integer NOT NULL
);


ALTER TABLE public.campaign_iteration OWNER TO postgres;

--
-- Name: campaign_library; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.campaign_library (
    cl_id bigint NOT NULL,
    attachment_list_id bigint NOT NULL
);


ALTER TABLE public.campaign_library OWNER TO postgres;

--
-- Name: COLUMN campaign_library.cl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library.cl_id IS 'cle primaire autogeneree';


--
-- Name: COLUMN campaign_library.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: campaign_library_cl_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.campaign_library ALTER COLUMN cl_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.campaign_library_cl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: campaign_library_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.campaign_library_content (
    library_id bigint NOT NULL,
    content_id bigint NOT NULL,
    content_order integer NOT NULL
);


ALTER TABLE public.campaign_library_content OWNER TO postgres;

--
-- Name: COLUMN campaign_library_content.library_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_content.library_id IS 'cle etrangere vers une bibliotheque de campagnes.';


--
-- Name: COLUMN campaign_library_content.content_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_content.content_id IS 'cle etrangere vers un noeud de la bibliotheque de campagnes.';


--
-- Name: campaign_library_node; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.campaign_library_node (
    cln_id bigint NOT NULL,
    description text,
    name character varying(255) NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_on timestamp without time zone,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    project_id bigint,
    attachment_list_id bigint NOT NULL
);


ALTER TABLE public.campaign_library_node OWNER TO postgres;

--
-- Name: COLUMN campaign_library_node.cln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_node.cln_id IS 'cle primaire autogeneree';


--
-- Name: COLUMN campaign_library_node.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_node.description IS 'Une description associee a cet element. Devrait etre un champ texte long ou un clob.';


--
-- Name: COLUMN campaign_library_node.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_node.name IS 'Le nom/label de l''element en question.';


--
-- Name: COLUMN campaign_library_node.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_node.created_by IS 'nom du createur de cette campagne.';


--
-- Name: COLUMN campaign_library_node.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_node.created_on IS 'Date de creation de cette campagne. Il s''agit de la date de creation de l''entree dans    la base, non d''une date metier.';


--
-- Name: COLUMN campaign_library_node.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_node.last_modified_on IS 'Date de derniere mise a jour de cette instance.';


--
-- Name: COLUMN campaign_library_node.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_node.last_modified_by IS 'Nom du dernier utilisateur ayant mis a jour cet instance.';


--
-- Name: COLUMN campaign_library_node.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_node.project_id IS 'FK to the Project to which belongs this resource';


--
-- Name: COLUMN campaign_library_node.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_library_node.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: campaign_library_node_cln_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.campaign_library_node ALTER COLUMN cln_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.campaign_library_node_cln_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: campaign_test_plan_item; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.campaign_test_plan_item (
    ctpi_id bigint NOT NULL,
    campaign_id bigint,
    test_case_id bigint NOT NULL,
    user_id bigint,
    test_plan_order integer,
    dataset_id bigint
);


ALTER TABLE public.campaign_test_plan_item OWNER TO postgres;

--
-- Name: COLUMN campaign_test_plan_item.ctpi_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_test_plan_item.ctpi_id IS 'clé primaire du test plan. Devrait être autogénérée.';


--
-- Name: COLUMN campaign_test_plan_item.campaign_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_test_plan_item.campaign_id IS 'cle etrangere vers CAMPAIGN';


--
-- Name: COLUMN campaign_test_plan_item.test_case_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_test_plan_item.test_case_id IS 'cle etrangere vers TEST_CASE';


--
-- Name: COLUMN campaign_test_plan_item.user_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_test_plan_item.user_id IS 'Id de l''utilisateur assigné a ce cas de test reférenncé';


--
-- Name: COLUMN campaign_test_plan_item.test_plan_order; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_test_plan_item.test_plan_order IS 'numéro d''ordre d''une execution dans la liste des test plans d''une itération.';


--
-- Name: COLUMN campaign_test_plan_item.dataset_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.campaign_test_plan_item.dataset_id IS 'the dataset the test plan item should use so that new iterations will now use those datasets';


--
-- Name: campaign_test_plan_item_ctpi_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.campaign_test_plan_item ALTER COLUMN ctpi_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.campaign_test_plan_item_ctpi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: chart_axis_column; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.chart_axis_column (
    chart_column_id bigint NOT NULL,
    label character varying(100),
    axis_operation character varying(20),
    axis_rank integer,
    cuf_id bigint,
    chart_definition_id bigint
);


ALTER TABLE public.chart_axis_column OWNER TO postgres;

--
-- Name: COLUMN chart_axis_column.chart_column_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_axis_column.chart_column_id IS 'foreign key to CHART_COLUMN_PROTOTYPE';


--
-- Name: COLUMN chart_axis_column.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_axis_column.label IS 'a label for this axis. If non null, will override the default label in the CHART_COLUMN_PROTOTYPE';


--
-- Name: COLUMN chart_axis_column.axis_operation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_axis_column.axis_operation IS 'may define an additional operation about how data are grouped on this axis, most of the time ''NONE'' is fine, however     for Timestamp columns an adequate aggregation (day, month etc) may be useful';


--
-- Name: COLUMN chart_axis_column.axis_rank; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_axis_column.axis_rank IS 'in which order the axis are processed (if relevant)';


--
-- Name: COLUMN chart_axis_column.cuf_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_axis_column.cuf_id IS 'a column to persist cuf id relative to this axis';


--
-- Name: COLUMN chart_axis_column.chart_definition_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_axis_column.chart_definition_id IS 'foreign key to the chart_definition';


--
-- Name: chart_column_role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.chart_column_role (
    chart_column_id bigint NOT NULL,
    role character varying(255)
);


ALTER TABLE public.chart_column_role OWNER TO postgres;

--
-- Name: COLUMN chart_column_role.chart_column_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_column_role.chart_column_id IS 'foreign key to CHART_COLUMN_PROTOTYPE';


--
-- Name: COLUMN chart_column_role.role; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_column_role.role IS 'name of a role for the referenced column';


--
-- Name: chart_definition; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.chart_definition (
    chart_id bigint NOT NULL,
    name character varying(50),
    visibility character varying(20),
    chart_type character varying(20),
    description text,
    project_id bigint NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    scope_type character varying(20)
);


ALTER TABLE public.chart_definition OWNER TO postgres;

--
-- Name: COLUMN chart_definition.chart_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_definition.chart_id IS 'autogenerated ID';


--
-- Name: COLUMN chart_definition.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_definition.name IS 'The name of this chart';


--
-- Name: COLUMN chart_definition.visibility; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_definition.visibility IS 'whether this chart is ''PRIVATE'' or ''PUBLIC''';


--
-- Name: COLUMN chart_definition.chart_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_definition.chart_type IS 'whether this chart is a ''PIE'', ''BAR'' etc';


--
-- Name: COLUMN chart_definition.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_definition.description IS 'additional informations about this chart';


--
-- Name: COLUMN chart_definition.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_definition.project_id IS 'cle etrangere vers le projet.';


--
-- Name: COLUMN chart_definition.scope_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_definition.scope_type IS 'a column to persist the scope type';


--
-- Name: chart_definition_chart_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.chart_definition ALTER COLUMN chart_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.chart_definition_chart_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: chart_filter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.chart_filter (
    filter_id bigint NOT NULL,
    chart_column_id bigint NOT NULL,
    filter_operation character varying(20),
    cuf_id bigint,
    chart_definition_id bigint
);


ALTER TABLE public.chart_filter OWNER TO postgres;

--
-- Name: COLUMN chart_filter.filter_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_filter.filter_id IS 'autogenerated ID';


--
-- Name: COLUMN chart_filter.chart_column_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_filter.chart_column_id IS 'foreign key to a CHART_COLUMN_PROTOTYPE';


--
-- Name: COLUMN chart_filter.filter_operation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_filter.filter_operation IS 'a comparison operator';


--
-- Name: COLUMN chart_filter.cuf_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_filter.cuf_id IS 'a column to persist cuf id relative to this filter';


--
-- Name: COLUMN chart_filter.chart_definition_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_filter.chart_definition_id IS 'foreign key to the chart_definition';


--
-- Name: chart_filter_filter_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.chart_filter ALTER COLUMN filter_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.chart_filter_filter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: chart_filter_values; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.chart_filter_values (
    filter_id bigint NOT NULL,
    filter_value character varying(255)
);


ALTER TABLE public.chart_filter_values OWNER TO postgres;

--
-- Name: COLUMN chart_filter_values.filter_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_filter_values.filter_id IS 'foreign key to CHART_FILTER';


--
-- Name: COLUMN chart_filter_values.filter_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_filter_values.filter_value IS 'a value for this filter';


--
-- Name: chart_measure_column; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.chart_measure_column (
    chart_column_id bigint NOT NULL,
    label character varying(30),
    measure_operation character varying(20),
    measure_rank integer,
    cuf_id bigint,
    chart_definition_id bigint
);


ALTER TABLE public.chart_measure_column OWNER TO postgres;

--
-- Name: COLUMN chart_measure_column.chart_column_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_measure_column.chart_column_id IS 'foreign key to the CHART_COLUMN_PROTOTYPE this measure applies to';


--
-- Name: COLUMN chart_measure_column.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_measure_column.label IS 'a label for this measure. Will override the default label of the column prototype if non null.';


--
-- Name: COLUMN chart_measure_column.measure_operation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_measure_column.measure_operation IS 'the measure applied to the column';


--
-- Name: COLUMN chart_measure_column.measure_rank; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_measure_column.measure_rank IS 'the order in which the measure will be displayed when the chart is rendered.';


--
-- Name: COLUMN chart_measure_column.cuf_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_measure_column.cuf_id IS 'a column to persist cuf id relative to this measure';


--
-- Name: COLUMN chart_measure_column.chart_definition_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_measure_column.chart_definition_id IS 'foreign key to the chart_definition';


--
-- Name: chart_project_scope; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.chart_project_scope (
    chart_project_scope_id bigint NOT NULL,
    chart_id bigint NOT NULL,
    project_scope character varying(15)
);


ALTER TABLE public.chart_project_scope OWNER TO postgres;

--
-- Name: chart_project_scope_chart_project_scope_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.chart_project_scope ALTER COLUMN chart_project_scope_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.chart_project_scope_chart_project_scope_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: chart_scope; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.chart_scope (
    chart_id bigint NOT NULL,
    entity_reference_type character varying(50),
    entity_reference_id bigint
);


ALTER TABLE public.chart_scope OWNER TO postgres;

--
-- Name: COLUMN chart_scope.chart_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_scope.chart_id IS 'foreign key to a CHART_DEFINITION';


--
-- Name: COLUMN chart_scope.entity_reference_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_scope.entity_reference_type IS 'the type of the referenced entity';


--
-- Name: COLUMN chart_scope.entity_reference_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.chart_scope.entity_reference_id IS 'the id of the referenced entity';


--
-- Name: cln_relationship; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cln_relationship (
    ancestor_id bigint NOT NULL,
    descendant_id bigint NOT NULL,
    content_order integer NOT NULL
);


ALTER TABLE public.cln_relationship OWNER TO postgres;

--
-- Name: COLUMN cln_relationship.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.cln_relationship.ancestor_id IS 'cle etrangere vers le repertoire parent (il s''agit necessairement d''un repertoire).';


--
-- Name: COLUMN cln_relationship.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.cln_relationship.descendant_id IS 'cle etrangere vers l''element fils.';


--
-- Name: cln_relationship_closure; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cln_relationship_closure (
    ancestor_id bigint NOT NULL,
    descendant_id bigint NOT NULL,
    depth smallint NOT NULL
);


ALTER TABLE public.cln_relationship_closure OWNER TO postgres;

--
-- Name: COLUMN cln_relationship_closure.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.cln_relationship_closure.ancestor_id IS 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN cln_relationship_closure.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.cln_relationship_closure.descendant_id IS 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN cln_relationship_closure.depth; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.cln_relationship_closure.depth IS 'stores how deep is the descendant element nested in the subtree of the ancestor element';


--
-- Name: connection_attempt_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.connection_attempt_log (
    attempt_id bigint NOT NULL,
    login character varying(100),
    connection_date timestamp without time zone NOT NULL,
    success boolean NOT NULL
);


ALTER TABLE public.connection_attempt_log OWNER TO postgres;

--
-- Name: COLUMN connection_attempt_log.attempt_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.connection_attempt_log.attempt_id IS 'autogenerated ID';


--
-- Name: COLUMN connection_attempt_log.login; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.connection_attempt_log.login IS 'login used to connect';


--
-- Name: COLUMN connection_attempt_log.connection_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.connection_attempt_log.connection_date IS 'Date of connection';


--
-- Name: COLUMN connection_attempt_log.success; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.connection_attempt_log.success IS 'if connection succeeded or not';


--
-- Name: connection_attempt_log_attempt_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.connection_attempt_log ALTER COLUMN attempt_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.connection_attempt_log_attempt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: core_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.core_config (
    str_key character varying(255) NOT NULL,
    value text
);


ALTER TABLE public.core_config OWNER TO postgres;

--
-- Name: COLUMN core_config.str_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_config.str_key IS 'Configuration Key';


--
-- Name: COLUMN core_config.value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_config.value IS 'Configuration value';


--
-- Name: core_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.core_group (
    id bigint NOT NULL,
    qualified_name character varying(255) NOT NULL
);


ALTER TABLE public.core_group OWNER TO postgres;

--
-- Name: COLUMN core_group.qualified_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_group.qualified_name IS 'Qualified name of the group, both used as a functional key and a localization key. Should be something like ''squashtest.authz.group._app module_._GroupName_''';


--
-- Name: core_group_authority; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.core_group_authority (
    group_id bigint NOT NULL,
    authority character varying(50) NOT NULL
);


ALTER TABLE public.core_group_authority OWNER TO postgres;

--
-- Name: COLUMN core_group_authority.group_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_group_authority.group_id IS 'Shared key with CORE_GROUP table';


--
-- Name: COLUMN core_group_authority.authority; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_group_authority.authority IS 'The authority';


--
-- Name: core_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.core_group ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: core_group_member; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.core_group_member (
    party_id bigint NOT NULL,
    group_id bigint NOT NULL
);


ALTER TABLE public.core_group_member OWNER TO postgres;

--
-- Name: core_party; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.core_party (
    party_id bigint NOT NULL
);


ALTER TABLE public.core_party OWNER TO postgres;

--
-- Name: core_party_authority; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.core_party_authority (
    party_id bigint NOT NULL,
    authority character varying(50) NOT NULL
);


ALTER TABLE public.core_party_authority OWNER TO postgres;

--
-- Name: COLUMN core_party_authority.party_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_party_authority.party_id IS 'The CORE_PARTY';


--
-- Name: COLUMN core_party_authority.authority; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_party_authority.authority IS 'The authority';


--
-- Name: core_party_party_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.core_party ALTER COLUMN party_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_party_party_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: core_team; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.core_team (
    party_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_on timestamp without time zone,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    description text
);


ALTER TABLE public.core_team OWNER TO postgres;

--
-- Name: COLUMN core_team.party_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_team.party_id IS 'cle primaire, qui est aussi une cle etrangere vers la table PARTY_ID Ne doit donc pas etre autogeneree.';


--
-- Name: COLUMN core_team.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_team.created_on IS 'Date de creation. Il s''agit de la date de creation de l''entree dans      la base, non d''une date metier.';


--
-- Name: COLUMN core_team.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_team.last_modified_on IS 'Date de derniere mise a jour de cette instance.';


--
-- Name: COLUMN core_team.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_team.last_modified_by IS 'Nom du dernier utilisateur ayant mis a jour cet instance.';


--
-- Name: core_team_member; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.core_team_member (
    team_id bigint NOT NULL,
    user_id bigint NOT NULL
);


ALTER TABLE public.core_team_member OWNER TO postgres;

--
-- Name: core_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.core_user (
    party_id bigint NOT NULL,
    login character varying(100) NOT NULL,
    first_name character varying(50) DEFAULT ''::character varying NOT NULL,
    last_name character varying(50) DEFAULT ''::character varying NOT NULL,
    email character varying(255) DEFAULT ''::character varying NOT NULL,
    active boolean DEFAULT false NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_on timestamp without time zone,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_connected_on timestamp without time zone,
    can_delete_from_front boolean DEFAULT true NOT NULL
);


ALTER TABLE public.core_user OWNER TO postgres;

--
-- Name: COLUMN core_user.login; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.login IS 'The user''s login as provided by the authentication system';


--
-- Name: COLUMN core_user.first_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.first_name IS 'The user''s first name';


--
-- Name: COLUMN core_user.last_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.last_name IS 'The user''s last name';


--
-- Name: COLUMN core_user.email; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.email IS 'The user''s e-mail';


--
-- Name: COLUMN core_user.active; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.active IS 'User is active or not';


--
-- Name: COLUMN core_user.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.created_by IS 'nom du createur de cet utilisateur.';


--
-- Name: COLUMN core_user.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.created_on IS 'Date de creation de cet utilisateur. Il s''agit de la date de creation de l''entree dans       la base, non d''une date metier.';


--
-- Name: COLUMN core_user.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.last_modified_on IS 'Date de derniere mise a jour de cette instance.';


--
-- Name: COLUMN core_user.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.last_modified_by IS 'Nom du dernier utilisateur ayant mis a jour cet instance.';


--
-- Name: COLUMN core_user.last_connected_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.core_user.last_connected_on IS 'a column to persist the last connection date';


--
-- Name: core_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.core_user ALTER COLUMN party_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: crln_relationship; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.crln_relationship (
    ancestor_id bigint,
    descendant_id bigint NOT NULL,
    content_order bigint
);


ALTER TABLE public.crln_relationship OWNER TO postgres;

--
-- Name: COLUMN crln_relationship.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.crln_relationship.ancestor_id IS 'cle etrangere vers le noeud parent';


--
-- Name: COLUMN crln_relationship.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.crln_relationship.descendant_id IS 'cle etrangere vers l''element fils.';


--
-- Name: COLUMN crln_relationship.content_order; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.crln_relationship.content_order IS 'numéro d''ordre du noeud dans son parent';


--
-- Name: crln_relationship_closure; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.crln_relationship_closure (
    ancestor_id bigint NOT NULL,
    descendant_id bigint NOT NULL,
    depth smallint NOT NULL
);


ALTER TABLE public.crln_relationship_closure OWNER TO postgres;

--
-- Name: COLUMN crln_relationship_closure.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.crln_relationship_closure.ancestor_id IS 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN crln_relationship_closure.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.crln_relationship_closure.descendant_id IS 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN crln_relationship_closure.depth; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.crln_relationship_closure.depth IS 'stores how deep is the descendant element nested in the subtree of the ancestor element';


--
-- Name: custom_export_column; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_export_column (
    custom_export_id bigint NOT NULL,
    label character varying(255),
    cuf_id bigint
);


ALTER TABLE public.custom_export_column OWNER TO postgres;

--
-- Name: COLUMN custom_export_column.custom_export_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_export_column.custom_export_id IS 'Foreign key to the Custom Export';


--
-- Name: custom_export_scope; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_export_scope (
    custom_export_id bigint NOT NULL,
    entity_reference_type character varying(50),
    entity_reference_id bigint
);


ALTER TABLE public.custom_export_scope OWNER TO postgres;

--
-- Name: COLUMN custom_export_scope.custom_export_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_export_scope.custom_export_id IS 'Foreign key to the Custom Export';


--
-- Name: custom_field; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_field (
    cf_id bigint NOT NULL,
    field_type character varying(3) NOT NULL,
    name character varying(255) NOT NULL,
    label character varying(255) DEFAULT ''::character varying NOT NULL,
    optional boolean DEFAULT true NOT NULL,
    default_value character varying(255),
    input_type character varying(30) NOT NULL,
    code character varying(30) DEFAULT ''::character varying NOT NULL,
    large_default_value text,
    numeric_default_value numeric(20,5)
);


ALTER TABLE public.custom_field OWNER TO postgres;

--
-- Name: COLUMN custom_field.field_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field.field_type IS 'CF : simple, SSF : multiple-choice';


--
-- Name: COLUMN custom_field.large_default_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field.large_default_value IS 'this column is used by rich text cufs. It contains HTML data.';


--
-- Name: COLUMN custom_field.numeric_default_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field.numeric_default_value IS 'a column to persist numeric cuf';


--
-- Name: custom_field_binding; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_field_binding (
    cfb_id bigint NOT NULL,
    cf_id bigint NOT NULL,
    bound_entity character varying(30) NOT NULL,
    bound_project_id bigint NOT NULL,
    "position" integer
);


ALTER TABLE public.custom_field_binding OWNER TO postgres;

--
-- Name: custom_field_binding_cfb_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_field_binding ALTER COLUMN cfb_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_field_binding_cfb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: custom_field_cf_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_field ALTER COLUMN cf_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_field_cf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: custom_field_option; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_field_option (
    cf_id bigint NOT NULL,
    label character varying(255) NOT NULL,
    "position" integer,
    code character varying(30) DEFAULT ''::character varying NOT NULL,
    colour character varying(7)
);


ALTER TABLE public.custom_field_option OWNER TO postgres;

--
-- Name: custom_field_rendering_location; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_field_rendering_location (
    cfb_id bigint NOT NULL,
    rendering_location character varying(30) NOT NULL
);


ALTER TABLE public.custom_field_rendering_location OWNER TO postgres;

--
-- Name: custom_field_value; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_field_value (
    cfv_id bigint NOT NULL,
    bound_entity_id bigint NOT NULL,
    bound_entity_type character varying(30) NOT NULL,
    cfb_id bigint NOT NULL,
    value character varying(255),
    large_value text,
    field_type character varying(3) DEFAULT 'CF'::character varying NOT NULL,
    numeric_value numeric(20,5),
    cf_id bigint
);


ALTER TABLE public.custom_field_value OWNER TO postgres;

--
-- Name: COLUMN custom_field_value.cfv_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field_value.cfv_id IS 'technical id';


--
-- Name: COLUMN custom_field_value.bound_entity_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field_value.bound_entity_id IS 'the id of the bound entity';


--
-- Name: COLUMN custom_field_value.bound_entity_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field_value.bound_entity_type IS 'the kind of entity. Note that this information is also contained by the                  custom field binding.';


--
-- Name: COLUMN custom_field_value.cfb_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field_value.cfb_id IS 'the custom field binding that holds all the data';


--
-- Name: COLUMN custom_field_value.value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field_value.value IS 'the value of that particular custom field value';


--
-- Name: COLUMN custom_field_value.large_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field_value.large_value IS 'this column is used by rich text cufs. It contains HTML data.';


--
-- Name: COLUMN custom_field_value.field_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field_value.field_type IS 'CF : simple, RTF : rich text field';


--
-- Name: COLUMN custom_field_value.numeric_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field_value.numeric_value IS 'a column to persist numeric cuf';


--
-- Name: COLUMN custom_field_value.cf_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_field_value.cf_id IS 'dernomalize the custom field id for custom report queries';


--
-- Name: custom_field_value_cfv_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_field_value ALTER COLUMN cfv_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_field_value_cfv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: custom_field_value_option; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_field_value_option (
    cfv_id bigint NOT NULL,
    label character varying(255) NOT NULL,
    "position" integer NOT NULL
);


ALTER TABLE public.custom_field_value_option OWNER TO postgres;

--
-- Name: TABLE custom_field_value_option; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.custom_field_value_option IS 'The table.';


--
-- Name: custom_report_chart_binding; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_report_chart_binding (
    crcb_id bigint NOT NULL,
    crd_id bigint NOT NULL,
    chart_id bigint NOT NULL,
    "row" integer,
    col integer,
    size_x integer,
    size_y integer
);


ALTER TABLE public.custom_report_chart_binding OWNER TO postgres;

--
-- Name: COLUMN custom_report_chart_binding.crcb_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_chart_binding.crcb_id IS 'pk genere';


--
-- Name: COLUMN custom_report_chart_binding.crd_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_chart_binding.crd_id IS 'cle etrangere vers le dashboard.';


--
-- Name: COLUMN custom_report_chart_binding.chart_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_chart_binding.chart_id IS 'cle etrangere vers le chart.';


--
-- Name: custom_report_chart_binding_crcb_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_report_chart_binding ALTER COLUMN crcb_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_report_chart_binding_crcb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: custom_report_custom_export; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_report_custom_export (
    crce_id bigint NOT NULL,
    name character varying(255),
    project_id bigint NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone
);


ALTER TABLE public.custom_report_custom_export OWNER TO postgres;

--
-- Name: COLUMN custom_report_custom_export.crce_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_custom_export.crce_id IS 'The auto-generated id';


--
-- Name: COLUMN custom_report_custom_export.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_custom_export.name IS 'The name of the Custom Export';


--
-- Name: COLUMN custom_report_custom_export.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_custom_export.project_id IS 'Foreign key to the Project';


--
-- Name: custom_report_custom_export_crce_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_report_custom_export ALTER COLUMN crce_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_report_custom_export_crce_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: custom_report_dashboard; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_report_dashboard (
    crd_id bigint NOT NULL,
    name character varying(255),
    project_id bigint NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone
);


ALTER TABLE public.custom_report_dashboard OWNER TO postgres;

--
-- Name: COLUMN custom_report_dashboard.crd_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_dashboard.crd_id IS 'pk genere';


--
-- Name: COLUMN custom_report_dashboard.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_dashboard.project_id IS 'cle etrangere vers le projet.';


--
-- Name: custom_report_dashboard_crd_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_report_dashboard ALTER COLUMN crd_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_report_dashboard_crd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: custom_report_folder; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_report_folder (
    crf_id bigint NOT NULL,
    name character varying(255),
    description text,
    project_id bigint NOT NULL
);


ALTER TABLE public.custom_report_folder OWNER TO postgres;

--
-- Name: COLUMN custom_report_folder.crf_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_folder.crf_id IS 'pk genere';


--
-- Name: COLUMN custom_report_folder.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_folder.project_id IS 'cle etrangere vers le projet.';


--
-- Name: custom_report_folder_crf_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_report_folder ALTER COLUMN crf_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_report_folder_crf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: custom_report_library; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_report_library (
    crl_id bigint NOT NULL,
    attachment_list_id bigint
);


ALTER TABLE public.custom_report_library OWNER TO postgres;

--
-- Name: COLUMN custom_report_library.crl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_library.crl_id IS 'pk genere';


--
-- Name: COLUMN custom_report_library.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_library.attachment_list_id IS 'FK to ATTACHMENT_LIST';


--
-- Name: custom_report_library_crl_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_report_library ALTER COLUMN crl_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_report_library_crl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: custom_report_library_node; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_report_library_node (
    crln_id bigint NOT NULL,
    name character varying(255),
    entity_type character varying(50),
    entity_id bigint,
    crl_id bigint
);


ALTER TABLE public.custom_report_library_node OWNER TO postgres;

--
-- Name: COLUMN custom_report_library_node.crln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_library_node.crln_id IS 'pk genere';


--
-- Name: COLUMN custom_report_library_node.crl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_library_node.crl_id IS 'fk to the containing CUSTOM_REPORT_LIBRARY';


--
-- Name: custom_report_library_node_crln_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_report_library_node ALTER COLUMN crln_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_report_library_node_crln_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: custom_report_report_binding; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_report_report_binding (
    crrb_id bigint NOT NULL,
    crd_id bigint NOT NULL,
    report_id bigint NOT NULL,
    "row" integer,
    col integer,
    size_x integer,
    size_y integer
);


ALTER TABLE public.custom_report_report_binding OWNER TO postgres;

--
-- Name: COLUMN custom_report_report_binding.crrb_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_report_binding.crrb_id IS 'pk genere';


--
-- Name: COLUMN custom_report_report_binding.crd_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_report_binding.crd_id IS 'cle etrangere vers le dashboard.';


--
-- Name: COLUMN custom_report_report_binding.report_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.custom_report_report_binding.report_id IS 'cle etrangere vers le report.';


--
-- Name: custom_report_report_binding_crrb_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.custom_report_report_binding ALTER COLUMN crrb_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.custom_report_report_binding_crrb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: databasechangelog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.databasechangelog (
    id character varying(255) NOT NULL,
    author character varying(255) NOT NULL,
    filename character varying(255) NOT NULL,
    dateexecuted timestamp without time zone NOT NULL,
    orderexecuted integer NOT NULL,
    exectype character varying(10) NOT NULL,
    md5sum character varying(35),
    description character varying(255),
    comments character varying(255),
    tag character varying(255),
    liquibase character varying(20),
    contexts character varying(255),
    labels character varying(255),
    deployment_id character varying(10)
);


ALTER TABLE public.databasechangelog OWNER TO postgres;

--
-- Name: databasechangeloglock; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.databasechangeloglock (
    id integer NOT NULL,
    locked boolean NOT NULL,
    lockgranted timestamp without time zone,
    lockedby character varying(255)
);


ALTER TABLE public.databasechangeloglock OWNER TO postgres;

--
-- Name: dataset; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dataset (
    dataset_id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    test_case_id bigint NOT NULL
);


ALTER TABLE public.dataset OWNER TO postgres;

--
-- Name: COLUMN dataset.dataset_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dataset.dataset_id IS 'the DATASET primary key';


--
-- Name: COLUMN dataset.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dataset.name IS 'the dataset name, should be unique among parameters of the same test case';


--
-- Name: COLUMN dataset.test_case_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dataset.test_case_id IS 'the test case where the parameter is declared';


--
-- Name: dataset_dataset_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.dataset ALTER COLUMN dataset_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.dataset_dataset_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: dataset_param_value; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dataset_param_value (
    dataset_param_value_id bigint NOT NULL,
    dataset_id bigint NOT NULL,
    param_id bigint NOT NULL,
    param_value character varying(1024) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.dataset_param_value OWNER TO postgres;

--
-- Name: COLUMN dataset_param_value.dataset_param_value_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dataset_param_value.dataset_param_value_id IS 'the DATASET_PARAM_VALUE primary key';


--
-- Name: COLUMN dataset_param_value.dataset_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dataset_param_value.dataset_id IS 'the dataset holding the value for the parameter';


--
-- Name: COLUMN dataset_param_value.param_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dataset_param_value.param_id IS 'the parameter to set the value of';


--
-- Name: COLUMN dataset_param_value.param_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dataset_param_value.param_value IS 'the value for the parameter in the dataset';


--
-- Name: dataset_param_value_dataset_param_value_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.dataset_param_value ALTER COLUMN dataset_param_value_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.dataset_param_value_dataset_param_value_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: denormalized_environment_tag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.denormalized_environment_tag (
    det_id bigint NOT NULL,
    holder_id bigint NOT NULL,
    holder_type character varying(30) NOT NULL,
    value character varying(255)
);


ALTER TABLE public.denormalized_environment_tag OWNER TO postgres;

--
-- Name: COLUMN denormalized_environment_tag.det_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_environment_tag.det_id IS 'technical id';


--
-- Name: COLUMN denormalized_environment_tag.value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_environment_tag.value IS 'the value of that particular environment tag value';


--
-- Name: denormalized_environment_tag_det_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.denormalized_environment_tag ALTER COLUMN det_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.denormalized_environment_tag_det_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: denormalized_environment_variable; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.denormalized_environment_variable (
    dev_id bigint NOT NULL,
    ev_id bigint,
    holder_id bigint NOT NULL,
    holder_type character varying(30) NOT NULL,
    name character varying(255) NOT NULL,
    value character varying(255),
    type character varying(30)
);


ALTER TABLE public.denormalized_environment_variable OWNER TO postgres;

--
-- Name: COLUMN denormalized_environment_variable.dev_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_environment_variable.dev_id IS 'technical id';


--
-- Name: COLUMN denormalized_environment_variable.value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_environment_variable.value IS 'the value of that particular environment variable value';


--
-- Name: denormalized_environment_variable_dev_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.denormalized_environment_variable ALTER COLUMN dev_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.denormalized_environment_variable_dev_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: denormalized_field_rendering_location; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.denormalized_field_rendering_location (
    dfv_id bigint NOT NULL,
    rendering_location character varying(30) NOT NULL
);


ALTER TABLE public.denormalized_field_rendering_location OWNER TO postgres;

--
-- Name: denormalized_field_value; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.denormalized_field_value (
    dfv_id bigint NOT NULL,
    cfv_id bigint,
    code character varying(30) DEFAULT ''::character varying NOT NULL,
    denormalized_field_holder_id bigint NOT NULL,
    denormalized_field_holder_type character varying(30) NOT NULL,
    input_type character varying(30) NOT NULL,
    label character varying(255) DEFAULT ''::character varying NOT NULL,
    "position" integer,
    value character varying(255),
    field_type character varying(3) DEFAULT 'CF'::bpchar NOT NULL,
    large_value text,
    numeric_value numeric(20,5)
);


ALTER TABLE public.denormalized_field_value OWNER TO postgres;

--
-- Name: COLUMN denormalized_field_value.cfv_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_field_value.cfv_id IS 'the custom field value where the denormalized field is copied from';


--
-- Name: COLUMN denormalized_field_value.denormalized_field_holder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_field_value.denormalized_field_holder_id IS 'the id of the denormalized field holder.';


--
-- Name: COLUMN denormalized_field_value.denormalized_field_holder_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_field_value.denormalized_field_holder_type IS 'the kind of entity.';


--
-- Name: COLUMN denormalized_field_value.value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_field_value.value IS 'the value of that particular custom field value';


--
-- Name: COLUMN denormalized_field_value.field_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_field_value.field_type IS 'CF : simple, SSF : multiple-choice';


--
-- Name: COLUMN denormalized_field_value.large_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_field_value.large_value IS 'this column is used by rich text cufs. It contains HTML data.';


--
-- Name: COLUMN denormalized_field_value.numeric_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.denormalized_field_value.numeric_value IS 'a column to persist denormalized numeric cuf';


--
-- Name: denormalized_field_value_dfv_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.denormalized_field_value ALTER COLUMN dfv_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.denormalized_field_value_dfv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: denormalized_field_value_option; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.denormalized_field_value_option (
    dfv_id bigint NOT NULL,
    label character varying(255) NOT NULL,
    "position" integer NOT NULL
);


ALTER TABLE public.denormalized_field_value_option OWNER TO postgres;

--
-- Name: disabled_execution_status; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.disabled_execution_status (
    cl_id bigint NOT NULL,
    execution_status character varying(255) NOT NULL
);


ALTER TABLE public.disabled_execution_status OWNER TO postgres;

--
-- Name: environment_variable; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.environment_variable (
    ev_id bigint NOT NULL,
    field_type character varying(5) NOT NULL,
    name character varying(255) NOT NULL,
    input_type character varying(30) NOT NULL
);


ALTER TABLE public.environment_variable OWNER TO postgres;

--
-- Name: environment_variable_binding; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.environment_variable_binding (
    evb_id bigint NOT NULL,
    ev_id bigint NOT NULL,
    entity_id bigint,
    entity_type character varying(30),
    value character varying(255)
);


ALTER TABLE public.environment_variable_binding OWNER TO postgres;

--
-- Name: environment_variable_binding_evb_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.environment_variable_binding ALTER COLUMN evb_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.environment_variable_binding_evb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: environment_variable_ev_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.environment_variable ALTER COLUMN ev_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.environment_variable_ev_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: environment_variable_option; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.environment_variable_option (
    ev_id bigint NOT NULL,
    label character varying(255) NOT NULL,
    "position" integer NOT NULL
);


ALTER TABLE public.environment_variable_option OWNER TO postgres;

--
-- Name: execution; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.execution (
    execution_id bigint NOT NULL,
    tcln_id bigint,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    description text,
    name character varying(308) NOT NULL,
    execution_mode character varying(255) DEFAULT NULL::character varying,
    execution_status character varying(255) DEFAULT NULL::character varying,
    last_executed_by character varying(255) DEFAULT NULL::character varying,
    last_executed_on timestamp without time zone,
    attachment_list_id bigint,
    issue_list_id bigint,
    prerequisite text NOT NULL,
    tc_status character varying(30) DEFAULT 'WORK_IN_PROGRESS'::character varying NOT NULL,
    importance character varying(20) DEFAULT 'LOW'::character varying NOT NULL,
    reference character varying(50) DEFAULT ''::character varying NOT NULL,
    tc_description text,
    dataset_label character varying(255),
    tc_nat_label character varying(100),
    tc_nat_code character varying(30),
    tc_nat_icon_name character varying(100),
    tc_typ_label character varying(100),
    tc_typ_code character varying(30),
    tc_typ_icon_name character varying(100),
    test_plan_item_id bigint NOT NULL,
    execution_order integer NOT NULL
);


ALTER TABLE public.execution OWNER TO postgres;

--
-- Name: COLUMN execution.execution_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.execution_id IS 'clé primaire de l''execution. Devrait être autogénérée.';


--
-- Name: COLUMN execution.tcln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.tcln_id IS 'Clé étrangère vers le cas de test référencé. Cette information est redondante puisque     il s''agit toujours du même que celui du test plan, cependant cette information ne devant     jamais évoluer il n''y a pas de risque à dénormaliser';


--
-- Name: COLUMN execution.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.created_by IS 'nom du créateur de l''execution.';


--
-- Name: COLUMN execution.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.created_on IS 'Date de création de cette execution. Il s''agit de la date de création de l''entrée dans la base, non d''une date métier.';


--
-- Name: COLUMN execution.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.last_modified_by IS 'Nom du dernier utilisateur ayant mis à jour cet instance.';


--
-- Name: COLUMN execution.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.last_modified_on IS 'Date de dernière mise à jour de cette instance.';


--
-- Name: COLUMN execution.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.description IS 'Une description associée à cet élément. Devrait être un champ texte long ou un clob.';


--
-- Name: COLUMN execution.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.name IS 'Le nom/label de l''élément en question.';


--
-- Name: COLUMN execution.execution_mode; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.execution_mode IS 'Mode d''execution de cette execution. Bien que ce champs soit caractère variable, les données réelles    seront la représentation texte d''un type énuméré. C''est une copie du mode d''execution du cas de test référencé.';


--
-- Name: COLUMN execution.execution_status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.execution_status IS 'Status d''execution de ce plan de test. Bien que ce champs soit caractère variable, les données réelles    seront la représentation texte d''un type énuméré. Sera recalculé en fonction du status de    sa derniere execution';


--
-- Name: COLUMN execution.last_executed_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.last_executed_by IS 'Nom du dernier utilisateur ayant execute cet instance.';


--
-- Name: COLUMN execution.last_executed_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.last_executed_on IS 'Date de derniere execution de cette instance.';


--
-- Name: COLUMN execution.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: COLUMN execution.issue_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.issue_list_id IS 'clé étrangère vers un ISSUE_LIST, l''entité qui gère les listes d''issues.';


--
-- Name: COLUMN execution.prerequisite; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.prerequisite IS 'the prerequisite for a test_case execution';


--
-- Name: COLUMN execution.dataset_label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.dataset_label IS 'the name of the dataset used';


--
-- Name: COLUMN execution.tc_nat_label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.tc_nat_label IS 'a label to be displayed. If the item is builtin this label will be a i18n key, else the label will        be displayed verbatim';


--
-- Name: COLUMN execution.tc_nat_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.tc_nat_code IS 'a code that helps identifying that item. Note that unlike the original version the values for       that column will not be unique.';


--
-- Name: COLUMN execution.tc_nat_icon_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.tc_nat_icon_name IS 'the identifier of the icon to be displayed';


--
-- Name: COLUMN execution.tc_typ_label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.tc_typ_label IS 'a label to be displayed. If the item is builtin this label will be a i18n key, else the label will  be displayed verbatim';


--
-- Name: COLUMN execution.tc_typ_code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.tc_typ_code IS 'a code that helps identifying that item. Note that unlike the original version the values for       that column will not be unique.';


--
-- Name: COLUMN execution.tc_typ_icon_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution.tc_typ_icon_name IS 'the identifier of the icon to be displayed';


--
-- Name: execution_execution_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.execution ALTER COLUMN execution_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.execution_execution_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: execution_execution_steps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.execution_execution_steps (
    execution_id bigint NOT NULL,
    execution_step_id bigint NOT NULL,
    execution_step_order integer NOT NULL
);


ALTER TABLE public.execution_execution_steps OWNER TO postgres;

--
-- Name: COLUMN execution_execution_steps.execution_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_execution_steps.execution_id IS 'clé étrangère vers la table EXECUTION.';


--
-- Name: COLUMN execution_execution_steps.execution_step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_execution_steps.execution_step_id IS 'clé étrangère vers EXECUTION_STEP';


--
-- Name: COLUMN execution_execution_steps.execution_step_order; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_execution_steps.execution_step_order IS 'numéro d''ordre d''un pas d''execution dans la liste des pas d''executions d''une execution.';


--
-- Name: execution_step; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.execution_step (
    execution_step_id bigint NOT NULL,
    expected_result text DEFAULT ''::text NOT NULL,
    action text DEFAULT ''::text NOT NULL,
    execution_status character varying(255) DEFAULT NULL::character varying,
    last_executed_by character varying(255) DEFAULT NULL::character varying,
    last_executed_on timestamp without time zone,
    comment text,
    test_step_id bigint,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    attachment_list_id bigint,
    issue_list_id bigint
);


ALTER TABLE public.execution_step OWNER TO postgres;

--
-- Name: COLUMN execution_step.execution_step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.execution_step_id IS 'clé primaire autogénérée.';


--
-- Name: COLUMN execution_step.expected_result; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.expected_result IS 'le résultat attendu de l''action effectuée.';


--
-- Name: COLUMN execution_step.action; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.action IS 'action à réaliser dans ce pas d''execution.';


--
-- Name: COLUMN execution_step.execution_status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.execution_status IS 'Status de l''execution de ce pas d''execution. Bien que ce champs soit caractère variable, les données réelles    seront la représentation texte d''un type énuméré.';


--
-- Name: COLUMN execution_step.last_executed_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.last_executed_by IS 'Nom du dernier utilisateur ayant execute cet instance.';


--
-- Name: COLUMN execution_step.last_executed_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.last_executed_on IS 'Date de derniere execution de cette instance.';


--
-- Name: COLUMN execution_step.comment; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.comment IS 'commentaire libre du recetteur.';


--
-- Name: COLUMN execution_step.test_step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.test_step_id IS 'Clé étrangère vers le pas de test référencé';


--
-- Name: COLUMN execution_step.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.created_by IS 'nom du créateur du pas d''execution.';


--
-- Name: COLUMN execution_step.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.created_on IS 'Date de création de ce pas d''execution. Il s''agit de la date de création de l''entrée dans la base, non d''une date métier.';


--
-- Name: COLUMN execution_step.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.last_modified_by IS 'Nom du dernier utilisateur ayant mis à jour cet instance.';


--
-- Name: COLUMN execution_step.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.last_modified_on IS 'Date de dernière mise à jour de cette instance.';


--
-- Name: COLUMN execution_step.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: COLUMN execution_step.issue_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.execution_step.issue_list_id IS 'clé étrangère vers un ISSUE_LIST, l''entité qui gère les listes d''issues.';


--
-- Name: issue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.issue (
    issue_id bigint NOT NULL,
    remote_issue_id character varying(255) NOT NULL,
    issue_list_id bigint NOT NULL,
    bugtracker_id bigint NOT NULL,
    additional_data text
);


ALTER TABLE public.issue OWNER TO postgres;

--
-- Name: COLUMN issue.remote_issue_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.issue.remote_issue_id IS 'considering the different types    a bugtracker may use for its own primary keys, we use here a varchar type as it is generic enough';


--
-- Name: COLUMN issue.issue_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.issue.issue_list_id IS 'References the list of issue to which an issue belongs';


--
-- Name: COLUMN issue.bugtracker_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.issue.bugtracker_id IS 'Issue''s bugtracker';


--
-- Name: COLUMN issue.additional_data; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.issue.additional_data IS 'Column for json info. Use it only when remote_key is not enough to fetch issue';


--
-- Name: session_note; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.session_note (
    note_id bigint NOT NULL,
    execution_id bigint NOT NULL,
    kind character varying(30) DEFAULT 'COMMENT'::character varying NOT NULL,
    content text DEFAULT ''::text NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    attachment_list_id bigint,
    issue_list_id bigint,
    note_order integer
);


ALTER TABLE public.session_note OWNER TO postgres;

--
-- Name: COLUMN session_note.note_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.session_note.note_id IS 'primary key for SESSION_NOTE';


--
-- Name: COLUMN session_note.execution_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.session_note.execution_id IS 'foreign key to EXECUTION';


--
-- Name: COLUMN session_note.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.session_note.attachment_list_id IS 'Foreign key to attachment list';


--
-- Name: COLUMN session_note.issue_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.session_note.issue_list_id IS 'Foreign key to issue list';


--
-- Name: COLUMN session_note.note_order; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.session_note.note_order IS 'Order in the note list';


--
-- Name: execution_issues_closure; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.execution_issues_closure AS
 SELECT exec.execution_id,
    issue.issue_id
   FROM (public.execution exec
     JOIN public.issue issue ON ((exec.issue_list_id = issue.issue_list_id)))
UNION
 SELECT eesteps.execution_id,
    issue.issue_id
   FROM ((public.execution_execution_steps eesteps
     JOIN public.execution_step estep ON ((eesteps.execution_step_id = estep.execution_step_id)))
     JOIN public.issue issue ON ((estep.issue_list_id = issue.issue_list_id)))
UNION
 SELECT sn.execution_id,
    issue.issue_id
   FROM (public.session_note sn
     JOIN public.issue ON ((issue.issue_list_id = sn.issue_list_id)));


ALTER VIEW public.execution_issues_closure OWNER TO postgres;

--
-- Name: execution_step_execution_step_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.execution_step ALTER COLUMN execution_step_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.execution_step_execution_step_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: exploratory_execution; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.exploratory_execution (
    execution_id bigint NOT NULL,
    assignee_id bigint,
    task_division character varying(255) DEFAULT NULL::character varying,
    reviewed boolean DEFAULT false NOT NULL
);


ALTER TABLE public.exploratory_execution OWNER TO postgres;

--
-- Name: COLUMN exploratory_execution.execution_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.exploratory_execution.execution_id IS 'primary key shared with EXECUTION';


--
-- Name: exploratory_execution_event; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.exploratory_execution_event (
    event_id bigint NOT NULL,
    execution_id bigint NOT NULL,
    event_date timestamp(3) without time zone NOT NULL,
    author character varying(100) NOT NULL,
    event_type character varying(30) NOT NULL
);


ALTER TABLE public.exploratory_execution_event OWNER TO postgres;

--
-- Name: COLUMN exploratory_execution_event.event_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.exploratory_execution_event.event_id IS 'primary key for EXPLORATORY_EXECUTION_EVENT';


--
-- Name: COLUMN exploratory_execution_event.execution_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.exploratory_execution_event.execution_id IS 'foreign key to EXECUTION';


--
-- Name: exploratory_execution_event_event_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.exploratory_execution_event ALTER COLUMN event_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.exploratory_execution_event_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: exploratory_session_overview; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.exploratory_session_overview (
    overview_id bigint NOT NULL,
    charter text,
    session_duration integer,
    name character varying(255) NOT NULL,
    reference character varying(50) DEFAULT ''::character varying NOT NULL,
    due_date timestamp without time zone,
    session_status character varying(50) DEFAULT 'TO_DO'::character varying NOT NULL,
    comments text,
    attachment_list_id bigint
);


ALTER TABLE public.exploratory_session_overview OWNER TO postgres;

--
-- Name: COLUMN exploratory_session_overview.charter; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.exploratory_session_overview.charter IS 'the charter for an exploratory session overview';


--
-- Name: COLUMN exploratory_session_overview.session_duration; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.exploratory_session_overview.session_duration IS 'the test session planned duration in minutes';


--
-- Name: COLUMN exploratory_session_overview.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.exploratory_session_overview.attachment_list_id IS 'Foreign key to attachment list';


--
-- Name: exploratory_session_overview_overview_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.exploratory_session_overview ALTER COLUMN overview_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.exploratory_session_overview_overview_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: exploratory_test_case; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.exploratory_test_case (
    tcln_id bigint NOT NULL,
    charter text,
    session_duration integer
);


ALTER TABLE public.exploratory_test_case OWNER TO postgres;

--
-- Name: COLUMN exploratory_test_case.tcln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.exploratory_test_case.tcln_id IS 'primary key shared with TEST_CASE';


--
-- Name: COLUMN exploratory_test_case.charter; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.exploratory_test_case.charter IS 'the charter for an exploratory test_case';


--
-- Name: COLUMN exploratory_test_case.session_duration; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.exploratory_test_case.session_duration IS 'the test session planned duration in minutes';


--
-- Name: failure_detail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.failure_detail (
    failure_detail_id bigint NOT NULL,
    message text,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    test_plan_item_id bigint NOT NULL,
    issue_list_id bigint
);


ALTER TABLE public.failure_detail OWNER TO postgres;

--
-- Name: COLUMN failure_detail.failure_detail_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.failure_detail.failure_detail_id IS 'primary key for FAILURE_DETAIL';


--
-- Name: COLUMN failure_detail.test_plan_item_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.failure_detail.test_plan_item_id IS 'foreign key to ITPI';


--
-- Name: COLUMN failure_detail.issue_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.failure_detail.issue_list_id IS 'Foreign key to issue list';


--
-- Name: failure_detail_failure_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.failure_detail ALTER COLUMN failure_detail_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.failure_detail_failure_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: grid_column_display_configuration; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grid_column_display_configuration (
    gcdc_id bigint NOT NULL,
    gcdr_id bigint NOT NULL,
    active_column_id character varying(100) NOT NULL
);


ALTER TABLE public.grid_column_display_configuration OWNER TO postgres;

--
-- Name: COLUMN grid_column_display_configuration.gcdc_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.grid_column_display_configuration.gcdc_id IS 'primary key for GRID_COLUMN_DISPLAY_CONFIGURATION';


--
-- Name: COLUMN grid_column_display_configuration.gcdr_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.grid_column_display_configuration.gcdr_id IS 'foreign key to GRID_COLUMN_DISPLAY_REFERENCE';


--
-- Name: grid_column_display_configuration_gcdc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.grid_column_display_configuration ALTER COLUMN gcdc_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.grid_column_display_configuration_gcdc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: grid_column_display_reference; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.grid_column_display_reference (
    gcdr_id bigint NOT NULL,
    party_id bigint NOT NULL,
    grid_id character varying(100) NOT NULL,
    project_id bigint
);


ALTER TABLE public.grid_column_display_reference OWNER TO postgres;

--
-- Name: COLUMN grid_column_display_reference.gcdr_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.grid_column_display_reference.gcdr_id IS 'primary key for GRID_COLUMN_DISPLAY_REFERENCE';


--
-- Name: COLUMN grid_column_display_reference.party_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.grid_column_display_reference.party_id IS 'foreign key to CORE_USER';


--
-- Name: COLUMN grid_column_display_reference.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.grid_column_display_reference.project_id IS 'foreign key to PROJECT';


--
-- Name: grid_column_display_reference_gcdr_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.grid_column_display_reference ALTER COLUMN gcdr_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.grid_column_display_reference_gcdr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: high_level_requirement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.high_level_requirement (
    rln_id bigint NOT NULL
);


ALTER TABLE public.high_level_requirement OWNER TO postgres;

--
-- Name: info_list; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.info_list (
    info_list_id bigint NOT NULL,
    label character varying(100),
    description text,
    code character varying(30) NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone
);


ALTER TABLE public.info_list OWNER TO postgres;

--
-- Name: COLUMN info_list.info_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list.info_list_id IS 'the ID';


--
-- Name: COLUMN info_list.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list.label IS 'the label for this list. Would noly be displayed in the administration page as the name  actually displayed to regular uses would depend on the role of that list on a given projet (criticality, nature etc)';


--
-- Name: COLUMN info_list.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list.description IS 'a description for that list';


--
-- Name: COLUMN info_list.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list.code IS 'a code that helps identifying that list';


--
-- Name: COLUMN info_list.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list.created_by IS 'username of the user who created that list';


--
-- Name: COLUMN info_list.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list.created_on IS 'the time at when that list was created';


--
-- Name: COLUMN info_list.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list.last_modified_by IS 'username of the last user who modified one of the list attributes';


--
-- Name: COLUMN info_list.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list.last_modified_on IS 'Time when the list was touched last';


--
-- Name: info_list_info_list_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.info_list ALTER COLUMN info_list_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.info_list_info_list_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: info_list_item; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.info_list_item (
    item_id bigint NOT NULL,
    item_type character varying(3) NOT NULL,
    list_id bigint,
    item_index integer,
    label character varying(100) NOT NULL,
    code character varying(30) NOT NULL,
    is_default boolean DEFAULT false NOT NULL,
    icon_name character varying(100),
    colour character varying(7)
);


ALTER TABLE public.info_list_item OWNER TO postgres;

--
-- Name: COLUMN info_list_item.item_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list_item.item_id IS 'an ID, what did you expect ?';


--
-- Name: COLUMN info_list_item.item_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list_item.item_type IS 'discriminator telling whether this item is user-made or builtin in the app. Pick one of ''USR'' or ''SYS''';


--
-- Name: COLUMN info_list_item.list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list_item.list_id IS 'foreign key to the list this item belongs to. Allows ''NULL'' for Hibernate to work.';


--
-- Name: COLUMN info_list_item.item_index; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list_item.item_index IS 'the position of that item in the list. Allows ''NULL'' for Hibernate to work.';


--
-- Name: COLUMN info_list_item.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list_item.label IS 'a label to be displayed. If the item is builtin this label will be a i18n key, else the label will be displayed verbatim';


--
-- Name: COLUMN info_list_item.code; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list_item.code IS 'a code that helps identifying that item';


--
-- Name: COLUMN info_list_item.is_default; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list_item.is_default IS 'whether this item is the default item for         its list. Only one item per list should have it true';


--
-- Name: COLUMN info_list_item.icon_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.info_list_item.icon_name IS 'the identifier of the icon to be displayed';


--
-- Name: info_list_item_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.info_list_item ALTER COLUMN item_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.info_list_item_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: issue_issue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.issue ALTER COLUMN issue_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.issue_issue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: issue_list; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.issue_list (
    issue_list_id bigint NOT NULL
);


ALTER TABLE public.issue_list OWNER TO postgres;

--
-- Name: issue_list_issue_list_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.issue_list ALTER COLUMN issue_list_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.issue_list_issue_list_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: iteration; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.iteration (
    iteration_id bigint NOT NULL,
    description text,
    name character varying(255) NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    actual_end_auto boolean NOT NULL,
    actual_end_date timestamp without time zone,
    actual_start_auto boolean NOT NULL,
    actual_start_date timestamp without time zone,
    scheduled_end_date timestamp without time zone,
    scheduled_start_date timestamp without time zone,
    attachment_list_id bigint,
    reference character varying(50) DEFAULT ''::character varying,
    iteration_status character varying(30) DEFAULT 'UNDEFINED'::character varying NOT NULL,
    uuid character varying(36) NOT NULL,
    test_plan_id bigint NOT NULL
);


ALTER TABLE public.iteration OWNER TO postgres;

--
-- Name: COLUMN iteration.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.iteration.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: COLUMN iteration.reference; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.iteration.reference IS 'a reference lavel for an iteration';


--
-- Name: iteration_iteration_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.iteration ALTER COLUMN iteration_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.iteration_iteration_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: iteration_test_suite; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.iteration_test_suite (
    iteration_id bigint NOT NULL,
    test_suite_id bigint NOT NULL,
    iteration_test_suite_order integer NOT NULL
);


ALTER TABLE public.iteration_test_suite OWNER TO postgres;

--
-- Name: keyword_execution; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.keyword_execution (
    execution_id bigint NOT NULL
);


ALTER TABLE public.keyword_execution OWNER TO postgres;

--
-- Name: keyword_test_case; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.keyword_test_case (
    tcln_id bigint NOT NULL
);


ALTER TABLE public.keyword_test_case OWNER TO postgres;

--
-- Name: keyword_test_step; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.keyword_test_step (
    test_step_id bigint NOT NULL,
    action_word_id bigint NOT NULL,
    keyword character varying(20) NOT NULL,
    datatable text,
    docstring text,
    comment text
);


ALTER TABLE public.keyword_test_step OWNER TO postgres;

--
-- Name: COLUMN keyword_test_step.test_step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.keyword_test_step.test_step_id IS 'Shared key with TEST_STEP table';


--
-- Name: COLUMN keyword_test_step.action_word_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.keyword_test_step.action_word_id IS 'The action word which this test step uses';


--
-- Name: COLUMN keyword_test_step.keyword; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.keyword_test_step.keyword IS 'A keyword test step keyword';


--
-- Name: COLUMN keyword_test_step.datatable; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.keyword_test_step.datatable IS 'A keyword test step datatable';


--
-- Name: COLUMN keyword_test_step.docstring; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.keyword_test_step.docstring IS 'A keyword test step docstring';


--
-- Name: COLUMN keyword_test_step.comment; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.keyword_test_step.comment IS 'A keyword test step comment';


--
-- Name: library_plugin_binding; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.library_plugin_binding (
    plugin_binding_id bigint NOT NULL,
    library_id bigint,
    library_type character(1) NOT NULL,
    plugin_id character varying(50) NOT NULL,
    plugin_type character varying(25),
    active boolean DEFAULT true
);


ALTER TABLE public.library_plugin_binding OWNER TO postgres;

--
-- Name: COLUMN library_plugin_binding.plugin_binding_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.library_plugin_binding.plugin_binding_id IS 'primary key (autogenerated)';


--
-- Name: COLUMN library_plugin_binding.library_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.library_plugin_binding.library_id IS 'ID of the library. It is explicitely nullable because hibernate will first create the row then update this column.';


--
-- Name: COLUMN library_plugin_binding.library_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.library_plugin_binding.library_type IS 'discriminator of the library. T: test case library, R : requirement library, C : campaign library';


--
-- Name: COLUMN library_plugin_binding.plugin_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.library_plugin_binding.plugin_id IS 'id of the plugin. Note that those plugins aren''t stored in the database and the plugin registry is purely software                (it is basically based on the presence/absence of an OSGI services published by each plugin) so we cannot really enforce referential               integrity. Still, although technically that column cannot be a foreign key, the application uses it as if.';


--
-- Name: COLUMN library_plugin_binding.plugin_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.library_plugin_binding.plugin_type IS 'This column specifies which type of plugin is used. for now only one type used: Automation.';


--
-- Name: COLUMN library_plugin_binding.active; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.library_plugin_binding.active IS 'This column specifies if plugin is enable or disable for a project .';


--
-- Name: library_plugin_binding_plugin_binding_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.library_plugin_binding ALTER COLUMN plugin_binding_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.library_plugin_binding_plugin_binding_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: library_plugin_binding_property; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.library_plugin_binding_property (
    plugin_binding_id bigint NOT NULL,
    plugin_binding_key character varying(30) NOT NULL,
    plugin_binding_value text NOT NULL
);


ALTER TABLE public.library_plugin_binding_property OWNER TO postgres;

--
-- Name: COLUMN library_plugin_binding_property.plugin_binding_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.library_plugin_binding_property.plugin_binding_id IS 'foreign key to LIBRARY_PLUGIN_BINDING';


--
-- Name: COLUMN library_plugin_binding_property.plugin_binding_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.library_plugin_binding_property.plugin_binding_key IS 'key of this property';


--
-- Name: COLUMN library_plugin_binding_property.plugin_binding_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.library_plugin_binding_property.plugin_binding_value IS 'value of this property';


--
-- Name: milestone; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.milestone (
    milestone_id bigint NOT NULL,
    label character varying(30) NOT NULL,
    status character varying(30),
    end_date timestamp without time zone NOT NULL,
    description text,
    m_range character varying(30) NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    user_id bigint NOT NULL
);


ALTER TABLE public.milestone OWNER TO postgres;

--
-- Name: COLUMN milestone.milestone_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.milestone_id IS 'Primary key';


--
-- Name: COLUMN milestone.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.label IS 'Milestone label';


--
-- Name: COLUMN milestone.status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.status IS 'Milestone status';


--
-- Name: COLUMN milestone.end_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.end_date IS 'Term date';


--
-- Name: COLUMN milestone.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.description IS 'Milestone description';


--
-- Name: COLUMN milestone.m_range; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.m_range IS 'Milestone range';


--
-- Name: COLUMN milestone.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.created_by IS 'Name of the milestone creator';


--
-- Name: COLUMN milestone.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.created_on IS 'Date of creation.';


--
-- Name: COLUMN milestone.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.last_modified_by IS 'last modified by';


--
-- Name: COLUMN milestone.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.last_modified_on IS 'Date of last update';


--
-- Name: COLUMN milestone.user_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone.user_id IS 'the user that own the milestone';


--
-- Name: milestone_binding; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.milestone_binding (
    milestone_binding_id bigint NOT NULL,
    milestone_id bigint NOT NULL,
    project_id bigint NOT NULL
);


ALTER TABLE public.milestone_binding OWNER TO postgres;

--
-- Name: milestone_binding_milestone_binding_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.milestone_binding ALTER COLUMN milestone_binding_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.milestone_binding_milestone_binding_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: milestone_binding_perimeter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.milestone_binding_perimeter (
    milestone_binding_perimeter_id bigint NOT NULL,
    milestone_id bigint NOT NULL,
    project_id bigint NOT NULL
);


ALTER TABLE public.milestone_binding_perimeter OWNER TO postgres;

--
-- Name: milestone_binding_perimeter_milestone_binding_perimeter_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.milestone_binding_perimeter ALTER COLUMN milestone_binding_perimeter_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.milestone_binding_perimeter_milestone_binding_perimeter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: milestone_campaign; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.milestone_campaign (
    milestone_id bigint NOT NULL,
    campaign_id bigint NOT NULL
);


ALTER TABLE public.milestone_campaign OWNER TO postgres;

--
-- Name: COLUMN milestone_campaign.milestone_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone_campaign.milestone_id IS 'foreign key to table MILESTONE';


--
-- Name: COLUMN milestone_campaign.campaign_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone_campaign.campaign_id IS 'foreign key to table CAMPAIGN';


--
-- Name: milestone_milestone_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.milestone ALTER COLUMN milestone_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.milestone_milestone_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: milestone_req_version; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.milestone_req_version (
    milestone_id bigint NOT NULL,
    req_version_id bigint NOT NULL
);


ALTER TABLE public.milestone_req_version OWNER TO postgres;

--
-- Name: COLUMN milestone_req_version.milestone_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone_req_version.milestone_id IS 'foreign key to table MILESTONE';


--
-- Name: COLUMN milestone_req_version.req_version_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone_req_version.req_version_id IS 'foreign key to table REQUIREMENT_VERSION';


--
-- Name: milestone_test_case; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.milestone_test_case (
    milestone_id bigint NOT NULL,
    test_case_id bigint NOT NULL
);


ALTER TABLE public.milestone_test_case OWNER TO postgres;

--
-- Name: COLUMN milestone_test_case.milestone_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone_test_case.milestone_id IS 'foreign key to table MILESTONE';


--
-- Name: COLUMN milestone_test_case.test_case_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.milestone_test_case.test_case_id IS 'foreign key to table TEST_CASE';


--
-- Name: oauth_access_token; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.oauth_access_token (
    token_id character varying(255) NOT NULL,
    token bytea,
    authentication_id character varying(255),
    user_name character varying(255),
    client_id character varying(255),
    authentication bytea,
    refresh_token character varying(255)
);


ALTER TABLE public.oauth_access_token OWNER TO postgres;

--
-- Name: oauth_approvals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.oauth_approvals (
    userid character varying(255) NOT NULL,
    clientid character varying(255) NOT NULL,
    scope character varying(255),
    status character varying(10),
    expiresat timestamp without time zone,
    lastmodifiedat timestamp without time zone
);


ALTER TABLE public.oauth_approvals OWNER TO postgres;

--
-- Name: oauth_client_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.oauth_client_details (
    client_id character varying(255) NOT NULL,
    client_secret character varying(255),
    resource_ids character varying(255) DEFAULT NULL::character varying,
    scope character varying(255) DEFAULT 'location,locationhistory'::character varying,
    authorized_grant_types character varying(255) DEFAULT 'password,authorization_code,refresh_token,implicit'::character varying,
    web_server_redirect_uri character varying(255) DEFAULT NULL::character varying,
    authorities character varying(255) DEFAULT 'ROLE_CLIENT, ROLE_TRUSTED_CLIENT'::character varying,
    access_token_validity bigint DEFAULT 60,
    refresh_token_validity bigint,
    additional_information text,
    autoapprove character varying(255)
);


ALTER TABLE public.oauth_client_details OWNER TO postgres;

--
-- Name: oauth_client_token; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.oauth_client_token (
    token_id character varying(255) NOT NULL,
    token bytea,
    authentication_id character varying(255),
    user_name character varying(255),
    client_id character varying(255)
);


ALTER TABLE public.oauth_client_token OWNER TO postgres;

--
-- Name: oauth_code; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.oauth_code (
    code character varying(255) NOT NULL,
    authentication bytea
);


ALTER TABLE public.oauth_code OWNER TO postgres;

--
-- Name: oauth_refresh_token; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.oauth_refresh_token (
    token_id character varying(255) NOT NULL,
    token bytea,
    authentication bytea
);


ALTER TABLE public.oauth_refresh_token OWNER TO postgres;

--
-- Name: parameter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.parameter (
    param_id bigint NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    test_case_id bigint NOT NULL,
    description text NOT NULL,
    param_order integer NOT NULL
);


ALTER TABLE public.parameter OWNER TO postgres;

--
-- Name: COLUMN parameter.param_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.parameter.param_id IS 'the PARAMETER primary key';


--
-- Name: COLUMN parameter.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.parameter.name IS 'the parameter name, should be unique among parameters of the same test case';


--
-- Name: COLUMN parameter.test_case_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.parameter.test_case_id IS 'the test case where the parameter is declared';


--
-- Name: COLUMN parameter.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.parameter.description IS 'the description of the parameter';


--
-- Name: parameter_param_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.parameter ALTER COLUMN param_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.parameter_param_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: party_preference; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.party_preference (
    preference_id bigint NOT NULL,
    party_id bigint NOT NULL,
    preference_key character varying(50),
    preference_value character varying(5000)
);


ALTER TABLE public.party_preference OWNER TO postgres;

--
-- Name: COLUMN party_preference.party_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.party_preference.party_id IS 'foreign key to the core_party table';


--
-- Name: party_preference_preference_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.party_preference ALTER COLUMN preference_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.party_preference_preference_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: pivot_format_import; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pivot_format_import (
    pfi_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    created_by bigint,
    created_on timestamp without time zone NOT NULL,
    file_path character varying(255) NOT NULL,
    status character varying(50) NOT NULL,
    project_id bigint,
    import_type character varying(50) NOT NULL,
    successfully_imported_on timestamp without time zone
);


ALTER TABLE public.pivot_format_import OWNER TO postgres;

--
-- Name: COLUMN pivot_format_import.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.pivot_format_import.created_by IS 'Foreign key to the user that requested the pivot format import';


--
-- Name: pivot_format_import_pfi_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.pivot_format_import ALTER COLUMN pfi_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.pivot_format_import_pfi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: project; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.project (
    project_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    description text,
    label character varying(255),
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    cl_id bigint,
    tcl_id bigint,
    rl_id bigint,
    attachment_list_id bigint NOT NULL,
    project_type character(1) DEFAULT 'P'::bpchar NOT NULL,
    ta_server_id bigint,
    req_categories_list bigint DEFAULT 1 NOT NULL,
    tc_natures_list bigint DEFAULT 2 NOT NULL,
    tc_types_list bigint DEFAULT 3 NOT NULL,
    allow_tc_modif_during_exec boolean DEFAULT false NOT NULL,
    crl_id bigint,
    template_id bigint,
    arl_id bigint,
    allow_automation_workflow boolean DEFAULT false NOT NULL,
    scm_repository_id bigint,
    use_tree_structure_in_scm_repo boolean DEFAULT true NOT NULL,
    automation_workflow_type character varying(25) DEFAULT 'NONE'::character varying NOT NULL,
    awl_id bigint,
    bdd_implementation_technology character varying(30) DEFAULT 'CUCUMBER_5_PLUS'::character varying NOT NULL,
    bdd_script_language character varying(30) DEFAULT 'ENGLISH'::character varying NOT NULL,
    automated_suites_lifetime integer,
    inherits_environment_tags boolean DEFAULT true NOT NULL,
    ai_server_id bigint,
    bugtracker_id bigint
);


ALTER TABLE public.project OWNER TO postgres;

--
-- Name: COLUMN project.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.project_id IS 'cle primaire de la table';


--
-- Name: COLUMN project.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.name IS 'nom du projet';


--
-- Name: COLUMN project.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.description IS 'description du projet';


--
-- Name: COLUMN project.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.label IS 'Label du projet';


--
-- Name: COLUMN project.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.created_by IS 'nom du createur du projet.';


--
-- Name: COLUMN project.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.created_on IS 'Date de creation de ce projet. Il s''agit de la date de creation de l''entree dans la base, non d''une date metier.';


--
-- Name: COLUMN project.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.last_modified_by IS 'Nom du dernier utilisateur ayant mis a jour cet instance.';


--
-- Name: COLUMN project.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.last_modified_on IS 'Date de derniere mise a jour de cette instance.';


--
-- Name: COLUMN project.cl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.cl_id IS 'cle etrangere de la table campaign-Library';


--
-- Name: COLUMN project.tcl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.tcl_id IS 'cle etrangere de la table TESTCASE-Library';


--
-- Name: COLUMN project.rl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.rl_id IS 'cle etrangere de la table REQUIREMENT-Library';


--
-- Name: COLUMN project.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: COLUMN project.project_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.project_type IS 'P: project, T: project template';


--
-- Name: COLUMN project.ta_server_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.ta_server_id IS 'the reference to the test automation server';


--
-- Name: COLUMN project.req_categories_list; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.req_categories_list IS 'foreign key to the requirement categories used in that project';


--
-- Name: COLUMN project.tc_natures_list; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.tc_natures_list IS 'foreign key to the test case natures used in that project';


--
-- Name: COLUMN project.tc_types_list; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.tc_types_list IS 'foreign key to the test case types used in that project';


--
-- Name: COLUMN project.crl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.crl_id IS 'FK FOR CUSTOM_REPORT_LIBRARY.CRL_ID';


--
-- Name: COLUMN project.arl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.arl_id IS 'fk to the automation request library';


--
-- Name: COLUMN project.automation_workflow_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.automation_workflow_type IS 'This column precises which workflow type is used.';


--
-- Name: COLUMN project.ai_server_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project.ai_server_id IS 'the reference to the artificial intelligence server';


--
-- Name: project_filter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.project_filter (
    project_filter_id bigint NOT NULL,
    activated boolean DEFAULT false NOT NULL,
    user_login character varying(255) NOT NULL
);


ALTER TABLE public.project_filter OWNER TO postgres;

--
-- Name: COLUMN project_filter.activated; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project_filter.activated IS 'filter activated yes or no';


--
-- Name: COLUMN project_filter.user_login; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project_filter.user_login IS 'unique user login';


--
-- Name: project_filter_entry; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.project_filter_entry (
    project_id bigint NOT NULL,
    filter_id bigint NOT NULL
);


ALTER TABLE public.project_filter_entry OWNER TO postgres;

--
-- Name: COLUMN project_filter_entry.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project_filter_entry.project_id IS 'foreign key to project';


--
-- Name: COLUMN project_filter_entry.filter_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.project_filter_entry.filter_id IS 'foreign key to filter';


--
-- Name: project_filter_project_filter_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.project_filter ALTER COLUMN project_filter_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.project_filter_project_filter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: project_project_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.project ALTER COLUMN project_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.project_project_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: test_automation_project; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_automation_project (
    ta_project_id bigint NOT NULL,
    tm_project_id bigint NOT NULL,
    label character varying(50) NOT NULL,
    remote_name character varying(50) NOT NULL,
    server_id bigint NOT NULL,
    execution_environments character varying(255) DEFAULT ''::character varying NOT NULL,
    can_run_gherkin boolean DEFAULT false NOT NULL
);


ALTER TABLE public.test_automation_project OWNER TO postgres;

--
-- Name: COLUMN test_automation_project.ta_project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_automation_project.ta_project_id IS 'the primary key';


--
-- Name: COLUMN test_automation_project.tm_project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_automation_project.tm_project_id IS 'the reference to the TM project';


--
-- Name: COLUMN test_automation_project.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_automation_project.label IS 'the (friendly) alias for that TA project';


--
-- Name: COLUMN test_automation_project.remote_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_automation_project.remote_name IS 'the (real) name of the remote test automation project';


--
-- Name: COLUMN test_automation_project.server_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_automation_project.server_id IS 'foreign key to the automated test server';


--
-- Name: COLUMN test_automation_project.execution_environments; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_automation_project.execution_environments IS 'the list of approved slaves servers';


--
-- Name: proto_test_automation_project_ta_project_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.test_automation_project ALTER COLUMN ta_project_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.proto_test_automation_project_ta_project_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: query_aggregation_column; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.query_aggregation_column (
    query_model_id bigint NOT NULL,
    query_column_id bigint NOT NULL,
    label character varying(30),
    aggregation_operation character varying(20),
    aggregation_rank integer,
    cuf_id bigint
);


ALTER TABLE public.query_aggregation_column OWNER TO postgres;

--
-- Name: COLUMN query_aggregation_column.query_model_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_aggregation_column.query_model_id IS 'foreign key to a QUERY_MODEL.';


--
-- Name: COLUMN query_aggregation_column.query_column_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_aggregation_column.query_column_id IS 'foreign key to the QUERY_COLUMN_PROTOTYPE which must be aggregated on';


--
-- Name: COLUMN query_aggregation_column.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_aggregation_column.label IS 'A label for this projected column. Will override the default label of the column prototype if non null.';


--
-- Name: COLUMN query_aggregation_column.aggregation_operation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_aggregation_column.aggregation_operation IS 'the operation applied to the column, if any.';


--
-- Name: COLUMN query_aggregation_column.aggregation_rank; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_aggregation_column.aggregation_rank IS 'the order in which this projected column in the returned tuple.';


--
-- Name: COLUMN query_aggregation_column.cuf_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_aggregation_column.cuf_id IS 'the custom field id for this projection column, if the referenced column is a custom field.';


--
-- Name: query_column_prototype; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.query_column_prototype (
    query_column_id bigint NOT NULL,
    column_type character varying(15),
    subquery_id bigint,
    label character varying(255) NOT NULL,
    entity_type character varying(30),
    entity_role character varying(40),
    attribute_name character varying(255),
    data_type character varying(50),
    business boolean DEFAULT true,
    attribute_type character varying(15)
);


ALTER TABLE public.query_column_prototype OWNER TO postgres;

--
-- Name: COLUMN query_column_prototype.query_column_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.query_column_id IS 'the column ID';


--
-- Name: COLUMN query_column_prototype.column_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.column_type IS 'complementary information about the nature of this column : native attribute (''ATTRIBUTE''),     computed field (''CALCULATED'') - often as a subquery -, or custom field (''CUF'')';


--
-- Name: COLUMN query_column_prototype.subquery_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.subquery_id IS 'optional foreign key to a (sub) CHART_QUERY';


--
-- Name: COLUMN query_column_prototype.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.label IS 'The default label for this column.';


--
-- Name: COLUMN query_column_prototype.entity_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.entity_type IS 'The kind of entities this column belongs to';


--
-- Name: COLUMN query_column_prototype.entity_role; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.entity_role IS 'a complementary qualifier for ENTITY_TYPE,           used when an entity has an auxialiary role regarding another entity.           For instance an InfoListItem may have a role of nature for a TestCase,           or category for a RequirementVersion. May be null if nothing special about it.';


--
-- Name: COLUMN query_column_prototype.attribute_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.attribute_name IS 'The name of the attribute of the entity';


--
-- Name: COLUMN query_column_prototype.data_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.data_type IS 'Data type of the attribute';


--
-- Name: COLUMN query_column_prototype.business; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.business IS 'tells whether this column is public or internal.';


--
-- Name: COLUMN query_column_prototype.attribute_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_column_prototype.attribute_type IS 'complementary information about the nature of this column : native attribute (''ATTRIBUTE''),     computed field (''CALCULATED'') - often as a subquery -, or custom field (''CUF'')';


--
-- Name: query_column_prototype_query_column_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.query_column_prototype ALTER COLUMN query_column_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.query_column_prototype_query_column_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: query_filter_column; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.query_filter_column (
    query_filter_id bigint NOT NULL,
    query_column_id bigint NOT NULL,
    query_model_id bigint NOT NULL,
    filter_operation character varying(20),
    cuf_id bigint
);


ALTER TABLE public.query_filter_column OWNER TO postgres;

--
-- Name: COLUMN query_filter_column.query_filter_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_filter_column.query_filter_id IS 'autogenerated ID';


--
-- Name: COLUMN query_filter_column.query_column_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_filter_column.query_column_id IS 'foreign key to a QUERY_COLUMN_PROTOTYPE';


--
-- Name: COLUMN query_filter_column.query_model_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_filter_column.query_model_id IS 'foreign key to a QUERY_MODEL';


--
-- Name: COLUMN query_filter_column.filter_operation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_filter_column.filter_operation IS 'a comparison operator';


--
-- Name: COLUMN query_filter_column.cuf_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_filter_column.cuf_id IS 'the custom field id for this filter column, if the referenced column is a custom field.';


--
-- Name: query_filter_column_query_filter_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.query_filter_column ALTER COLUMN query_filter_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.query_filter_column_query_filter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: query_filter_values; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.query_filter_values (
    query_filter_id bigint NOT NULL,
    filter_value character varying(255)
);


ALTER TABLE public.query_filter_values OWNER TO postgres;

--
-- Name: COLUMN query_filter_values.query_filter_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_filter_values.query_filter_id IS 'foreign key to QUERY_FILTER_COLUMN';


--
-- Name: COLUMN query_filter_values.filter_value; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_filter_values.filter_value IS 'a value for this filter';


--
-- Name: query_model; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.query_model (
    query_model_id bigint NOT NULL,
    name character varying(100),
    strategy character varying(20),
    join_style character varying(10)
);


ALTER TABLE public.query_model OWNER TO postgres;

--
-- Name: COLUMN query_model.query_model_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_model.query_model_id IS 'autogenerated ID';


--
-- Name: COLUMN query_model.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_model.name IS 'internal usage, when this CHART_QUERY is a    CHART_COLUMN_PROTOTYPE subquery the name helps identify which one';


--
-- Name: COLUMN query_model.strategy; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_model.strategy IS 'says how the query builder should integrate this query    to a main query. Accepts values : MAIN, SUBQUERY or INLINED';


--
-- Name: COLUMN query_model.join_style; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_model.join_style IS 'generally indicate whether should use inner join or left join when a    natural join is possible. Possible values : INNER_JOIN or LEFT_JOIN';


--
-- Name: query_model_query_model_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.query_model ALTER COLUMN query_model_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.query_model_query_model_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: query_ordering_column; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.query_ordering_column (
    query_model_id bigint NOT NULL,
    query_column_id bigint NOT NULL,
    order_operation character varying(20),
    order_rank integer,
    order_dir character(3) DEFAULT 'ASC'::bpchar,
    cuf_id bigint
);


ALTER TABLE public.query_ordering_column OWNER TO postgres;

--
-- Name: COLUMN query_ordering_column.query_model_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_ordering_column.query_model_id IS 'foreign key to a QUERY_MODEL. Note that this is a denormalization : that value could be retrieved via the referenced projection column';


--
-- Name: COLUMN query_ordering_column.query_column_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_ordering_column.query_column_id IS 'foreign key to the QUERY_COLUMN_PROTOTYPE which must be ordered';


--
-- Name: COLUMN query_ordering_column.order_operation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_ordering_column.order_operation IS 'the operation applied to the column, if any. It must mirror the operation applied to the column they reference in the projection/aggregation clause.';


--
-- Name: COLUMN query_ordering_column.order_rank; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_ordering_column.order_rank IS 'the order in which this ordering instruction must be treated.';


--
-- Name: COLUMN query_ordering_column.order_dir; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_ordering_column.order_dir IS 'either ASC or DESC';


--
-- Name: COLUMN query_ordering_column.cuf_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_ordering_column.cuf_id IS 'the custom field id for this filter column, if the referenced column is a custom field.';


--
-- Name: query_projection_column; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.query_projection_column (
    query_column_id bigint NOT NULL,
    query_model_id bigint NOT NULL,
    label character varying(30),
    projection_operation character varying(20),
    projection_rank integer,
    cuf_id bigint
);


ALTER TABLE public.query_projection_column OWNER TO postgres;

--
-- Name: COLUMN query_projection_column.query_column_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_projection_column.query_column_id IS 'foreign key to the QUERY_COLUMN_PROTOTYPE this projection applies to';


--
-- Name: COLUMN query_projection_column.query_model_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_projection_column.query_model_id IS 'foreign key to a QUERY_MODEL';


--
-- Name: COLUMN query_projection_column.label; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_projection_column.label IS 'A label for this projected column. Will override the default label of the column prototype if non null.';


--
-- Name: COLUMN query_projection_column.projection_operation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_projection_column.projection_operation IS 'the operation applied to the column, if any.';


--
-- Name: COLUMN query_projection_column.projection_rank; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_projection_column.projection_rank IS 'the order in which this projected column in the returned tuple.';


--
-- Name: COLUMN query_projection_column.cuf_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.query_projection_column.cuf_id IS 'the custom field id for this projection column, if the referenced column is a custom field.';


--
-- Name: remote_automation_request_extender; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.remote_automation_request_extender (
    remote_automation_request_extender_id bigint NOT NULL,
    automation_request_id bigint NOT NULL,
    server_id bigint,
    remote_status character varying(255),
    remote_issue_key character varying(255) NOT NULL,
    remote_request_url character varying(300),
    remote_assigned_to character varying(300) NOT NULL,
    last_sync_date timestamp without time zone,
    sent_value_for_sync text,
    synchronizable_issue_status character varying(25),
    last_sync_date_squash timestamp without time zone
);


ALTER TABLE public.remote_automation_request_extender OWNER TO postgres;

--
-- Name: COLUMN remote_automation_request_extender.remote_automation_request_extender_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.remote_automation_request_extender_id IS 'The auto-generated id';


--
-- Name: COLUMN remote_automation_request_extender.automation_request_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.automation_request_id IS 'The automation request this extender extends';


--
-- Name: COLUMN remote_automation_request_extender.server_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.server_id IS 'The bugtracker to which the automation request is linked';


--
-- Name: COLUMN remote_automation_request_extender.remote_status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.remote_status IS 'The remote status as defined in the bugtracker';


--
-- Name: COLUMN remote_automation_request_extender.remote_issue_key; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.remote_issue_key IS 'The remote issue key as generated by Jira';


--
-- Name: COLUMN remote_automation_request_extender.remote_request_url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.remote_request_url IS 'The Url to the remote request';


--
-- Name: COLUMN remote_automation_request_extender.remote_assigned_to; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.remote_assigned_to IS 'email of the assigned';


--
-- Name: COLUMN remote_automation_request_extender.last_sync_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.last_sync_date IS 'Date of the last synchronisation.';


--
-- Name: COLUMN remote_automation_request_extender.sent_value_for_sync; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.sent_value_for_sync IS 'The values ​​of the test case fields sent during synchronization.';


--
-- Name: COLUMN remote_automation_request_extender.synchronizable_issue_status; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.synchronizable_issue_status IS 'this column can be set to: TO SYNCHRONIZE, DELETED, MOVED_PROJECT and MOVED_ISSUE_TYPE ; and it is updated after each synchronization.';


--
-- Name: COLUMN remote_automation_request_extender.last_sync_date_squash; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_automation_request_extender.last_sync_date_squash IS 'Date of the last synchronisation squash to remote server.';


--
-- Name: remote_automation_request_ext_remote_automation_request_ext_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.remote_automation_request_extender ALTER COLUMN remote_automation_request_extender_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.remote_automation_request_ext_remote_automation_request_ext_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: remote_synchronisation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.remote_synchronisation (
    remote_synchronisation_id bigint NOT NULL,
    project_id bigint NOT NULL,
    server_id bigint NOT NULL,
    remote_synchronisation_name character varying(255) NOT NULL,
    kind character varying(50) NOT NULL,
    remote_select_type character varying(50),
    remote_select_value character varying(1000),
    last_successful_sync_date timestamp without time zone,
    last_sync_date timestamp without time zone,
    last_sync_status character varying(20),
    sync_status character varying(20),
    remote_synchronisation_options text,
    sync_enable boolean DEFAULT true NOT NULL,
    owner_id bigint
);


ALTER TABLE public.remote_synchronisation OWNER TO postgres;

--
-- Name: COLUMN remote_synchronisation.sync_enable; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.remote_synchronisation.sync_enable IS 'This column specifies if synchronisation is enable or disable for a project';


--
-- Name: remote_synchronisation_remote_synchronisation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.remote_synchronisation ALTER COLUMN remote_synchronisation_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.remote_synchronisation_remote_synchronisation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: report_definition; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.report_definition (
    report_id bigint NOT NULL,
    name character varying(255),
    description text,
    plugin_namespace character varying(255),
    parameters text,
    project_id bigint NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    summary character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.report_definition OWNER TO postgres;

--
-- Name: COLUMN report_definition.report_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.report_definition.report_id IS 'autogenerated ID';


--
-- Name: COLUMN report_definition.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.report_definition.name IS 'The name of this chart';


--
-- Name: COLUMN report_definition.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.report_definition.description IS 'additional informations about this report';


--
-- Name: COLUMN report_definition.plugin_namespace; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.report_definition.plugin_namespace IS 'The namespace of the report plugin';


--
-- Name: COLUMN report_definition.parameters; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.report_definition.parameters IS 'parameters to generate the report';


--
-- Name: COLUMN report_definition.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.report_definition.project_id IS 'foreign key to the projet';


--
-- Name: report_definition_report_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.report_definition ALTER COLUMN report_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.report_definition_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: requirement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement (
    rln_id bigint NOT NULL,
    current_version_id bigint,
    mode character varying(15) DEFAULT 'NATIVE'::character varying,
    high_level_requirement_id bigint
);


ALTER TABLE public.requirement OWNER TO postgres;

--
-- Name: COLUMN requirement.rln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement.rln_id IS 'cle primaire, qui est aussi une cle etrangere vers la table REQUIREMENT_LIBRARY_NODE. Ne doit donc pas etre autogeneree.';


--
-- Name: COLUMN requirement.current_version_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement.current_version_id IS 'FK to REQUIREMENT_VERSION linking to the requirement''s latest version. Should not be null but the column is nullable because of cyclic relationship between the tables.';


--
-- Name: COLUMN requirement.mode; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement.mode IS 'Says whether a requirement is NATIVE or SYNCHRONIZED';


--
-- Name: requirement_audit_event; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_audit_event (
    event_id bigint NOT NULL,
    req_version_id bigint NOT NULL,
    event_date timestamp without time zone NOT NULL,
    author character varying(255) NOT NULL
);


ALTER TABLE public.requirement_audit_event OWNER TO postgres;

--
-- Name: COLUMN requirement_audit_event.req_version_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_audit_event.req_version_id IS 'the ID of the target entity. As for 1.1.0 and until further notice, the target is always a requirement version.';


--
-- Name: COLUMN requirement_audit_event.event_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_audit_event.event_date IS 'the timestamp of the log entry';


--
-- Name: COLUMN requirement_audit_event.author; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_audit_event.author IS 'the login of the user who generated the event';


--
-- Name: requirement_audit_event_event_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.requirement_audit_event ALTER COLUMN event_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.requirement_audit_event_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: requirement_creation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_creation (
    event_id bigint NOT NULL
);


ALTER TABLE public.requirement_creation OWNER TO postgres;

--
-- Name: COLUMN requirement_creation.event_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_creation.event_id IS 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).';


--
-- Name: requirement_folder; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_folder (
    rln_id bigint NOT NULL,
    res_id bigint
);


ALTER TABLE public.requirement_folder OWNER TO postgres;

--
-- Name: COLUMN requirement_folder.rln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_folder.rln_id IS 'cle primaire, qui est une cle etrangere vers la table REQUIREMENT_LIBRARY_NODE. Ne doit donc pas etre autogeneree.';


--
-- Name: COLUMN requirement_folder.res_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_folder.res_id IS 'FK to SIMPLE_RESOURCE table';


--
-- Name: requirement_folder_sync_extender; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_folder_sync_extender (
    rf_sync_extender_id bigint NOT NULL,
    remote_synchronisation_id bigint NOT NULL,
    remote_folder_id character varying(255),
    remote_folder_status character varying(50),
    requirement_folder_id bigint NOT NULL,
    type character varying(30) NOT NULL
);


ALTER TABLE public.requirement_folder_sync_extender OWNER TO postgres;

--
-- Name: COLUMN requirement_folder_sync_extender.remote_synchronisation_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_folder_sync_extender.remote_synchronisation_id IS 'Only one master folder should be targeted by a given synchronisation';


--
-- Name: COLUMN requirement_folder_sync_extender.requirement_folder_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_folder_sync_extender.requirement_folder_id IS 'Only one extender for any folder in Squash TM';


--
-- Name: requirement_folder_sync_extender_rf_sync_extender_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.requirement_folder_sync_extender ALTER COLUMN rf_sync_extender_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.requirement_folder_sync_extender_rf_sync_extender_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: requirement_large_property_change; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_large_property_change (
    event_id bigint NOT NULL,
    old_value text,
    new_value text,
    property_name character varying(100) NOT NULL
);


ALTER TABLE public.requirement_large_property_change OWNER TO postgres;

--
-- Name: COLUMN requirement_large_property_change.event_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_large_property_change.event_id IS 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).';


--
-- Name: requirement_library; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_library (
    rl_id bigint NOT NULL,
    attachment_list_id bigint NOT NULL
);


ALTER TABLE public.requirement_library OWNER TO postgres;

--
-- Name: COLUMN requirement_library.rl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library.rl_id IS 'cle primaire autogeneree';


--
-- Name: COLUMN requirement_library.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: requirement_library_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_library_content (
    library_id bigint NOT NULL,
    content_id bigint NOT NULL,
    content_order integer NOT NULL
);


ALTER TABLE public.requirement_library_content OWNER TO postgres;

--
-- Name: COLUMN requirement_library_content.library_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library_content.library_id IS 'cle etrangere vers une bibliotheque d''exigence.';


--
-- Name: COLUMN requirement_library_content.content_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library_content.content_id IS 'cle etrangere vers un noeud de la bibliotheque d''exigences.';


--
-- Name: requirement_library_node; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_library_node (
    rln_id bigint NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    project_id bigint
);


ALTER TABLE public.requirement_library_node OWNER TO postgres;

--
-- Name: COLUMN requirement_library_node.rln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library_node.rln_id IS 'cle primaire autogeneree';


--
-- Name: COLUMN requirement_library_node.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library_node.created_by IS 'nom du createur de ce cas de test.';


--
-- Name: COLUMN requirement_library_node.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library_node.created_on IS 'Date de creation de cette exigence. Il s''agit de la date de creation de l''entree dans la base, non d''une date metier.';


--
-- Name: COLUMN requirement_library_node.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library_node.last_modified_by IS 'Nom du dernier utilisateur ayant mis a jour cet instance.';


--
-- Name: COLUMN requirement_library_node.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library_node.last_modified_on IS 'Date de derniere mise a jour de cette instance.';


--
-- Name: COLUMN requirement_library_node.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_library_node.project_id IS 'FK to the Project to which belongs this resource';


--
-- Name: requirement_library_node_rln_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.requirement_library_node ALTER COLUMN rln_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.requirement_library_node_rln_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: requirement_library_rl_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.requirement_library ALTER COLUMN rl_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.requirement_library_rl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: requirement_property_change; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_property_change (
    event_id bigint NOT NULL,
    old_value character varying(255),
    new_value character varying(255),
    property_name character varying(100) NOT NULL
);


ALTER TABLE public.requirement_property_change OWNER TO postgres;

--
-- Name: COLUMN requirement_property_change.event_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_property_change.event_id IS 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).';


--
-- Name: requirement_sync_extender; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_sync_extender (
    req_sync_id bigint NOT NULL,
    requirement_id bigint NOT NULL,
    server_id bigint NOT NULL,
    remote_req_id character varying(50),
    remote_project_id character varying(100),
    remote_req_url character varying(300),
    last_synchronized_by character varying(100) DEFAULT NULL::character varying,
    remote_filter_name character varying(150),
    remote_synchronisation_id bigint,
    remote_last_updated timestamp without time zone,
    remote_parent_id character varying(30),
    remote_req_perimeter_status character varying(30) DEFAULT 'UNKNOWN'::character varying NOT NULL
);


ALTER TABLE public.requirement_sync_extender OWNER TO postgres;

--
-- Name: COLUMN requirement_sync_extender.req_sync_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_sync_extender.req_sync_id IS 'autogenerated key';


--
-- Name: COLUMN requirement_sync_extender.requirement_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_sync_extender.requirement_id IS 'foreign key to the (now synchronized) requirement';


--
-- Name: COLUMN requirement_sync_extender.server_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_sync_extender.server_id IS 'foreign key to the source bugtracker';


--
-- Name: COLUMN requirement_sync_extender.remote_req_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_sync_extender.remote_req_id IS 'ID of the remote requirement';


--
-- Name: COLUMN requirement_sync_extender.remote_project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_sync_extender.remote_project_id IS 'ID of the remote project that hosts the remote requirement';


--
-- Name: COLUMN requirement_sync_extender.remote_req_url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_sync_extender.remote_req_url IS 'the url of the remote requirement';


--
-- Name: COLUMN requirement_sync_extender.last_synchronized_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_sync_extender.last_synchronized_by IS 'the last used that synchronized that requirement with the remote manager';


--
-- Name: COLUMN requirement_sync_extender.remote_filter_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_sync_extender.remote_filter_name IS 'name of a filter (not its ID)';


--
-- Name: requirement_sync_extender_req_sync_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.requirement_sync_extender ALTER COLUMN req_sync_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.requirement_sync_extender_req_sync_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: requirement_version; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_version (
    res_id bigint NOT NULL,
    requirement_id bigint,
    reference character varying(50) DEFAULT ''::character varying NOT NULL,
    version_number integer DEFAULT 1,
    criticality character varying(50) DEFAULT 'UNDEFINED'::character varying NOT NULL,
    requirement_status character varying(50) DEFAULT 'WORK_IN_PROGRESS'::character varying NOT NULL,
    category bigint DEFAULT 1 NOT NULL
);


ALTER TABLE public.requirement_version OWNER TO postgres;

--
-- Name: COLUMN requirement_version.res_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version.res_id IS 'shared key with RESOURCE table';


--
-- Name: COLUMN requirement_version.requirement_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version.requirement_id IS 'FK to the requirement. Should not be null but is nullable because of cyclic association REQ - REQ_VER';


--
-- Name: COLUMN requirement_version.reference; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version.reference IS 'The requirement''s reference';


--
-- Name: COLUMN requirement_version.version_number; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version.version_number IS 'This requirement''s version number';


--
-- Name: COLUMN requirement_version.criticality; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version.criticality IS 'Requirement criticality. Althought this field is a variable character, the data will be the text representation of an enumeration';


--
-- Name: COLUMN requirement_version.category; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version.category IS 'foreign key to the info list item';


--
-- Name: requirement_version_coverage; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_version_coverage (
    requirement_version_coverage_id bigint NOT NULL,
    verified_req_version_id bigint,
    verifying_test_case_id bigint NOT NULL
);


ALTER TABLE public.requirement_version_coverage OWNER TO postgres;

--
-- Name: COLUMN requirement_version_coverage.requirement_version_coverage_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version_coverage.requirement_version_coverage_id IS 'generated surrogate key';


--
-- Name: COLUMN requirement_version_coverage.verified_req_version_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version_coverage.verified_req_version_id IS 'FK to the verified requirement version';


--
-- Name: COLUMN requirement_version_coverage.verifying_test_case_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version_coverage.verifying_test_case_id IS 'FK to the verifying test case';


--
-- Name: requirement_version_coverage_requirement_version_coverage_i_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.requirement_version_coverage ALTER COLUMN requirement_version_coverage_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.requirement_version_coverage_requirement_version_coverage_i_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: requirement_version_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_version_link (
    link_id bigint NOT NULL,
    link_type_id bigint NOT NULL,
    link_direction boolean DEFAULT false NOT NULL,
    requirement_version_id bigint NOT NULL,
    related_requirement_version_id bigint NOT NULL
);


ALTER TABLE public.requirement_version_link OWNER TO postgres;

--
-- Name: COLUMN requirement_version_link.link_type_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version_link.link_type_id IS 'foreign key to the requirement_version_link_type table';


--
-- Name: COLUMN requirement_version_link.requirement_version_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version_link.requirement_version_id IS 'foreign key for requirement version to requirement_version table';


--
-- Name: COLUMN requirement_version_link.related_requirement_version_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version_link.related_requirement_version_id IS 'foreign key for related requirement version to requirement_version table';


--
-- Name: requirement_version_link_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.requirement_version_link ALTER COLUMN link_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.requirement_version_link_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: requirement_version_link_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.requirement_version_link_type (
    type_id bigint NOT NULL,
    role_1 character varying(50),
    role_1_code character varying(30),
    role_2 character varying(50),
    role_2_code character varying(30),
    is_default boolean DEFAULT false NOT NULL
);


ALTER TABLE public.requirement_version_link_type OWNER TO postgres;

--
-- Name: COLUMN requirement_version_link_type.is_default; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.requirement_version_link_type.is_default IS 'Only one item per list should have it true';


--
-- Name: requirement_version_link_type_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.requirement_version_link_type ALTER COLUMN type_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.requirement_version_link_type_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: resource; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resource (
    res_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    description text,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    attachment_list_id bigint NOT NULL
);


ALTER TABLE public.resource OWNER TO postgres;

--
-- Name: COLUMN resource.res_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.resource.res_id IS 'generated surrogate key';


--
-- Name: COLUMN resource.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.resource.name IS 'Resource''s name';


--
-- Name: COLUMN resource.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.resource.description IS 'Resource''s description';


--
-- Name: COLUMN resource.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.resource.created_by IS 'Who created this requirement''s version';


--
-- Name: COLUMN resource.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.resource.created_on IS 'When this requirement''s version was created';


--
-- Name: COLUMN resource.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.resource.last_modified_by IS 'Who modified this requirement''s version last';


--
-- Name: COLUMN resource.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.resource.last_modified_on IS 'When this requirement''s version was last modified';


--
-- Name: COLUMN resource.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.resource.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: resource_res_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.resource ALTER COLUMN res_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.resource_res_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: rln_relationship; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rln_relationship (
    ancestor_id bigint NOT NULL,
    descendant_id bigint NOT NULL,
    content_order integer NOT NULL
);


ALTER TABLE public.rln_relationship OWNER TO postgres;

--
-- Name: COLUMN rln_relationship.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.rln_relationship.ancestor_id IS 'cle etrangere vers le repertoire parent (il s''agit necessairement d''un repertoire).';


--
-- Name: COLUMN rln_relationship.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.rln_relationship.descendant_id IS 'cle etrangere vers l''element fils.';


--
-- Name: rln_relationship_closure; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rln_relationship_closure (
    ancestor_id bigint NOT NULL,
    descendant_id bigint NOT NULL,
    depth smallint NOT NULL
);


ALTER TABLE public.rln_relationship_closure OWNER TO postgres;

--
-- Name: COLUMN rln_relationship_closure.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.rln_relationship_closure.ancestor_id IS 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN rln_relationship_closure.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.rln_relationship_closure.descendant_id IS 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN rln_relationship_closure.depth; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.rln_relationship_closure.depth IS 'stores how deep is the descendant element nested in the subtree of the ancestor element';


--
-- Name: rln_resource; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.rln_resource AS
 SELECT fold.rln_id,
    fold.res_id
   FROM public.requirement_folder fold
UNION
 SELECT req.rln_id,
    req.current_version_id AS res_id
   FROM public.requirement req;


ALTER VIEW public.rln_resource OWNER TO postgres;

--
-- Name: scm_repository; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.scm_repository (
    scm_repository_id bigint NOT NULL,
    server_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    working_branch character varying(255) NOT NULL,
    repository_path character varying(255) NOT NULL,
    working_folder_path character varying(255)
);


ALTER TABLE public.scm_repository OWNER TO postgres;

--
-- Name: COLUMN scm_repository.scm_repository_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scm_repository.scm_repository_id IS 'The auto-generated id of the scm repository.';


--
-- Name: COLUMN scm_repository.server_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scm_repository.server_id IS 'The foreign key to the related SCM_SEVER';


--
-- Name: COLUMN scm_repository.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scm_repository.name IS 'The name of the repository.';


--
-- Name: COLUMN scm_repository.working_branch; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scm_repository.working_branch IS 'The name of the working branch on which SquashTM will push.';


--
-- Name: COLUMN scm_repository.repository_path; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scm_repository.repository_path IS 'The absolute path to the local repository on the local server.';


--
-- Name: COLUMN scm_repository.working_folder_path; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scm_repository.working_folder_path IS 'The relative path of the working folder in which SquashTM will push.';


--
-- Name: scm_repository_scm_repository_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.scm_repository ALTER COLUMN scm_repository_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.scm_repository_scm_repository_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: scm_server; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.scm_server (
    server_id bigint NOT NULL,
    kind character varying(30) NOT NULL,
    committer_mail character varying(255) DEFAULT ''::character varying NOT NULL,
    credentials_not_shared boolean DEFAULT false NOT NULL
);


ALTER TABLE public.scm_server OWNER TO postgres;

--
-- Name: COLUMN scm_server.server_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scm_server.server_id IS 'The id of the scm server.';


--
-- Name: COLUMN scm_server.kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scm_server.kind IS 'The kind of scm server.';


--
-- Name: COLUMN scm_server.credentials_not_shared; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scm_server.credentials_not_shared IS 'the credentials_not_shared prevent git credentials propagation';


--
-- Name: scripted_execution; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.scripted_execution (
    script_name character varying(255),
    execution_id bigint NOT NULL
);


ALTER TABLE public.scripted_execution OWNER TO postgres;

--
-- Name: COLUMN scripted_execution.script_name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scripted_execution.script_name IS 'script name,by example feature name for Gherkin';


--
-- Name: COLUMN scripted_execution.execution_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scripted_execution.execution_id IS 'foreign key to EXECUTION';


--
-- Name: scripted_test_case; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.scripted_test_case (
    script text,
    tcln_id bigint NOT NULL
);


ALTER TABLE public.scripted_test_case OWNER TO postgres;

--
-- Name: COLUMN scripted_test_case.script; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scripted_test_case.script IS 'the test case script';


--
-- Name: COLUMN scripted_test_case.tcln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.scripted_test_case.tcln_id IS 'foreign key to TEST_CASE';


--
-- Name: session_note_note_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.session_note ALTER COLUMN note_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.session_note_note_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: simple_resource; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.simple_resource (
    res_id bigint NOT NULL
);


ALTER TABLE public.simple_resource OWNER TO postgres;

--
-- Name: COLUMN simple_resource.res_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.simple_resource.res_id IS 'shared key with RESOURCE table';


--
-- Name: sprint; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sprint (
    cln_id bigint NOT NULL,
    status character varying(50) DEFAULT 'UPCOMING'::character varying NOT NULL,
    remote_synchronisation_id bigint,
    remote_sprint_id bigint,
    remote_name character varying(255),
    remote_state character varying(50),
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    reference character varying(255)
);


ALTER TABLE public.sprint OWNER TO postgres;

--
-- Name: COLUMN sprint.cln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sprint.cln_id IS 'Shared key with CAMPAIGN_LIBRARY_NODE table';


--
-- Name: sprint_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sprint_group (
    cln_id bigint NOT NULL,
    remote_synchronisation_id bigint
);


ALTER TABLE public.sprint_group OWNER TO postgres;

--
-- Name: COLUMN sprint_group.cln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sprint_group.cln_id IS 'Shared key with CAMPAIGN_LIBRARY_NODE table';


--
-- Name: sprint_req_version; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sprint_req_version (
    sprint_req_version_id bigint NOT NULL,
    req_version_id bigint,
    sprint_id bigint NOT NULL,
    reference character varying(50),
    name character varying(255),
    status character varying(50),
    criticality character varying(50),
    category character varying(50),
    description text,
    mode character varying(15) DEFAULT 'NATIVE'::character varying,
    test_plan_id bigint NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    validation_status character varying(50) DEFAULT 'TO_BE_TESTED'::character varying NOT NULL
);


ALTER TABLE public.sprint_req_version OWNER TO postgres;

--
-- Name: COLUMN sprint_req_version.sprint_req_version_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sprint_req_version.sprint_req_version_id IS 'primary key for SPRINT_REQ_VERSION';


--
-- Name: COLUMN sprint_req_version.mode; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sprint_req_version.mode IS 'Says whether a sprint req version is NATIVE or SYNCHRONIZED';


--
-- Name: sprint_req_version_sprint_req_version_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.sprint_req_version ALTER COLUMN sprint_req_version_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.sprint_req_version_sprint_req_version_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: sprint_requirement_sync_extender; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sprint_requirement_sync_extender (
    sprint_req_sync_id bigint NOT NULL,
    sprint_req_version_id bigint NOT NULL,
    remote_req_id character varying(50),
    remote_req_url character varying(300),
    remote_project_id character varying(100),
    remote_last_updated timestamp without time zone,
    remote_synchronisation_id bigint,
    remote_perimeter_status character varying(30) DEFAULT 'UNKNOWN'::character varying NOT NULL,
    remote_req_state character varying(20)
);


ALTER TABLE public.sprint_requirement_sync_extender OWNER TO postgres;

--
-- Name: COLUMN sprint_requirement_sync_extender.sprint_req_sync_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sprint_requirement_sync_extender.sprint_req_sync_id IS 'primary key for SPRINT_REQUIREMENT_SYNC_EXTENDER';


--
-- Name: sprint_requirement_sync_extender_sprint_req_sync_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.sprint_requirement_sync_extender ALTER COLUMN sprint_req_sync_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.sprint_requirement_sync_extender_sprint_req_sync_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: stored_credentials; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stored_credentials (
    credential_id bigint NOT NULL,
    enc_version smallint,
    enc_credentials text,
    authenticated_server bigint,
    content_type character varying(4) DEFAULT 'CRED'::character varying,
    authenticated_user bigint,
    project_id bigint,
    reporting_cache_credentials boolean DEFAULT false
);


ALTER TABLE public.stored_credentials OWNER TO postgres;

--
-- Name: COLUMN stored_credentials.credential_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.stored_credentials.credential_id IS 'primary key';


--
-- Name: COLUMN stored_credentials.enc_version; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.stored_credentials.enc_version IS 'the version of encryption service used. Possibly the value will remain to 1 forever.';


--
-- Name: COLUMN stored_credentials.enc_credentials; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.stored_credentials.enc_credentials IS 'the credentials as an encrypted string';


--
-- Name: COLUMN stored_credentials.authenticated_server; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.stored_credentials.authenticated_server IS 'foreign key to the server to authenticate';


--
-- Name: COLUMN stored_credentials.content_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.stored_credentials.content_type IS 'the role of the content, either CRED or CONF';


--
-- Name: COLUMN stored_credentials.authenticated_user; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.stored_credentials.authenticated_user IS 'Foreign key to the user account that owns the credentials. A NULL value means that Squash-TM               owns the credentials (app-level credentials).';


--
-- Name: COLUMN stored_credentials.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.stored_credentials.project_id IS 'Foreign key to the project bound to these credentials. NULL for app-level and user-level credentials.';


--
-- Name: stored_credentials_credential_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.stored_credentials ALTER COLUMN credential_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.stored_credentials_credential_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: sync_requirement_creation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sync_requirement_creation (
    event_id bigint NOT NULL,
    source character varying(255) NOT NULL
);


ALTER TABLE public.sync_requirement_creation OWNER TO postgres;

--
-- Name: COLUMN sync_requirement_creation.event_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sync_requirement_creation.event_id IS 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).';


--
-- Name: COLUMN sync_requirement_creation.source; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sync_requirement_creation.source IS 'the url of the synchronized requirement at the time of creation';


--
-- Name: sync_requirement_update; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sync_requirement_update (
    event_id bigint NOT NULL,
    source character varying(255) NOT NULL
);


ALTER TABLE public.sync_requirement_update OWNER TO postgres;

--
-- Name: COLUMN sync_requirement_update.event_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sync_requirement_update.event_id IS 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).';


--
-- Name: COLUMN sync_requirement_update.source; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sync_requirement_update.source IS 'the url of the synchronized requirement at the time of update';


--
-- Name: tcln_relationship; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tcln_relationship (
    ancestor_id bigint NOT NULL,
    descendant_id bigint NOT NULL,
    content_order integer NOT NULL
);


ALTER TABLE public.tcln_relationship OWNER TO postgres;

--
-- Name: COLUMN tcln_relationship.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.tcln_relationship.ancestor_id IS 'cle etrangere vers le repertoire parent (il s''agit necessairement d''un repertoire).';


--
-- Name: COLUMN tcln_relationship.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.tcln_relationship.descendant_id IS 'cle etrangere vers l''element fils.';


--
-- Name: tcln_relationship_closure; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tcln_relationship_closure (
    ancestor_id bigint NOT NULL,
    descendant_id bigint NOT NULL,
    depth smallint NOT NULL
);


ALTER TABLE public.tcln_relationship_closure OWNER TO postgres;

--
-- Name: COLUMN tcln_relationship_closure.ancestor_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.tcln_relationship_closure.ancestor_id IS 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN tcln_relationship_closure.descendant_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.tcln_relationship_closure.descendant_id IS 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.';


--
-- Name: COLUMN tcln_relationship_closure.depth; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.tcln_relationship_closure.depth IS 'stores how deep is the descendant element nested in the subtree of the ancestor element';


--
-- Name: template_configurable_plugin_binding; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.template_configurable_plugin_binding (
    binding_id bigint NOT NULL,
    project_template_id bigint NOT NULL,
    project_id bigint NOT NULL,
    plugin_id character varying(50) NOT NULL
);


ALTER TABLE public.template_configurable_plugin_binding OWNER TO postgres;

--
-- Name: template_configurable_plugin_binding_binding_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.template_configurable_plugin_binding ALTER COLUMN binding_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.template_configurable_plugin_binding_binding_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: test_automation_server; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_automation_server (
    server_id bigint NOT NULL,
    kind character varying(30) DEFAULT 'jenkins'::character varying NOT NULL,
    manual_slave_selection boolean DEFAULT false NOT NULL,
    observer_url character varying(255) DEFAULT NULL::character varying,
    event_bus_url character varying(255) DEFAULT NULL::character varying,
    additional_configuration text,
    killswitch_url character varying(255)
);


ALTER TABLE public.test_automation_server OWNER TO postgres;

--
-- Name: COLUMN test_automation_server.kind; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_automation_server.kind IS 'the kind of automated test server TM will deal with.';


--
-- Name: COLUMN test_automation_server.manual_slave_selection; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_automation_server.manual_slave_selection IS 'Should the user select which slave will run the tests (if there are some) ?';


--
-- Name: test_case; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_case (
    tcln_id bigint NOT NULL,
    execution_mode character varying(255) DEFAULT NULL::character varying,
    importance character varying(20) DEFAULT 'LOW'::character varying NOT NULL,
    importance_auto boolean DEFAULT false NOT NULL,
    prerequisite text NOT NULL,
    reference character varying(50) DEFAULT ''::character varying NOT NULL,
    ta_test bigint,
    tc_status character varying(30) DEFAULT 'WORK_IN_PROGRESS'::character varying NOT NULL,
    tc_nature bigint DEFAULT 12 NOT NULL,
    tc_type bigint DEFAULT 20 NOT NULL,
    automatable character(1) DEFAULT 'M'::bpchar,
    uuid character varying(36) NOT NULL,
    automated_test_reference character varying(512),
    automated_test_technology bigint,
    scm_repository_id bigint,
    drafted_by_ai boolean DEFAULT false,
    automation_request_id bigint
);


ALTER TABLE public.test_case OWNER TO postgres;

--
-- Name: COLUMN test_case.tcln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.tcln_id IS 'cle primaire, qui est aussi une cle etrangere vers la table TEST_CASE_LIBRARY_NODE. Ne doit donc pas etre autogeneree.';


--
-- Name: COLUMN test_case.execution_mode; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.execution_mode IS 'Mode d''execution du test case. Bien que ce champs soit caractere variable, les donnees reelles seront la representation texte d''un type enumere.';


--
-- Name: COLUMN test_case.importance; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.importance IS 'The importance of the test case';


--
-- Name: COLUMN test_case.importance_auto; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.importance_auto IS 'Should the importance be automatically computed';


--
-- Name: COLUMN test_case.prerequisite; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.prerequisite IS 'the prerequisite for a test_case';


--
-- Name: COLUMN test_case.tc_nature; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.tc_nature IS 'foreign key to the info list item';


--
-- Name: COLUMN test_case.tc_type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.tc_type IS 'foreign key to the info list item';


--
-- Name: COLUMN test_case.automatable; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.automatable IS 'Y: Yes, N: No, M: Maybe';


--
-- Name: COLUMN test_case.automated_test_reference; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.automated_test_reference IS 'The path to the test';


--
-- Name: COLUMN test_case.automated_test_technology; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.automated_test_technology IS 'foreign key to AUTOMATED_TEST_TECHNOLOGY';


--
-- Name: COLUMN test_case.scm_repository_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.scm_repository_id IS 'foreign key to SCM_REPOSITORY, link to associated scm repository.';


--
-- Name: COLUMN test_case.drafted_by_ai; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case.drafted_by_ai IS 'is the test case drafted by artificial intelligence';


--
-- Name: test_case_folder; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_case_folder (
    tcln_id bigint NOT NULL
);


ALTER TABLE public.test_case_folder OWNER TO postgres;

--
-- Name: COLUMN test_case_folder.tcln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_folder.tcln_id IS 'cle primaire, qui est une cle etrangere vers la table CAMPAIGN_LIBRARY_NODE. Ne doit donc pas etre autogeneree.';


--
-- Name: test_case_library; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_case_library (
    tcl_id bigint NOT NULL,
    attachment_list_id bigint NOT NULL
);


ALTER TABLE public.test_case_library OWNER TO postgres;

--
-- Name: COLUMN test_case_library.tcl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library.tcl_id IS 'cle primaire autogeneree';


--
-- Name: COLUMN test_case_library.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: test_case_library_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_case_library_content (
    library_id bigint NOT NULL,
    content_id bigint NOT NULL,
    content_order integer NOT NULL
);


ALTER TABLE public.test_case_library_content OWNER TO postgres;

--
-- Name: COLUMN test_case_library_content.library_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_content.library_id IS 'cle etrangere vers une bibliotheque de cas de test.';


--
-- Name: COLUMN test_case_library_content.content_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_content.content_id IS 'cle etrangere vers un noeud de la bibliotheque de cas de test.';


--
-- Name: test_case_library_node; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_case_library_node (
    tcln_id bigint NOT NULL,
    description text,
    name character varying(255) NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    project_id bigint,
    attachment_list_id bigint NOT NULL
);


ALTER TABLE public.test_case_library_node OWNER TO postgres;

--
-- Name: COLUMN test_case_library_node.tcln_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_node.tcln_id IS 'cle primaire autogeneree.';


--
-- Name: COLUMN test_case_library_node.description; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_node.description IS 'Une description associee a cet element. Devrait etre un champ texte long ou un clob.';


--
-- Name: COLUMN test_case_library_node.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_node.name IS 'Le nom/label de l''element en question.';


--
-- Name: COLUMN test_case_library_node.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_node.created_by IS 'nom du createur de ce cas de test.';


--
-- Name: COLUMN test_case_library_node.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_node.created_on IS 'Date de creation de ce cas de test. Il s''agit de la date de creation de l''entree dans la base, non d''une date metier.';


--
-- Name: COLUMN test_case_library_node.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_node.last_modified_by IS 'Nom du dernier utilisateur ayant mis a jour cet instance.';


--
-- Name: COLUMN test_case_library_node.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_node.last_modified_on IS 'Date de derniere mise a jour de cette instance.';


--
-- Name: COLUMN test_case_library_node.project_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_node.project_id IS 'FK to the Project to which belongs this resource';


--
-- Name: COLUMN test_case_library_node.attachment_list_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_library_node.attachment_list_id IS 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';


--
-- Name: test_case_library_node_tcln_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.test_case_library_node ALTER COLUMN tcln_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.test_case_library_node_tcln_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: test_case_library_tcl_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.test_case_library ALTER COLUMN tcl_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.test_case_library_tcl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: test_case_steps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_case_steps (
    test_case_id bigint NOT NULL,
    step_id bigint NOT NULL,
    step_order integer NOT NULL
);


ALTER TABLE public.test_case_steps OWNER TO postgres;

--
-- Name: COLUMN test_case_steps.test_case_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_steps.test_case_id IS 'cle etrangere vers TEST_CASE.';


--
-- Name: COLUMN test_case_steps.step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_steps.step_id IS 'cle etrangere vers la table TEST_STEP.';


--
-- Name: COLUMN test_case_steps.step_order; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_case_steps.step_order IS 'numero d''ordre d''un pas de test dans la liste des pas de test d''un cas de test.';


--
-- Name: test_plan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_plan (
    test_plan_id bigint NOT NULL,
    cl_id bigint NOT NULL
);


ALTER TABLE public.test_plan OWNER TO postgres;

--
-- Name: COLUMN test_plan.test_plan_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_plan.test_plan_id IS 'primary key';


--
-- Name: COLUMN test_plan.cl_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_plan.cl_id IS 'foreign key to parent CampaignLibrary';


--
-- Name: test_plan_item; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_plan_item (
    test_plan_item_id bigint NOT NULL,
    test_plan_id bigint NOT NULL,
    item_order integer NOT NULL,
    execution_status character varying(255) DEFAULT 'READY'::character varying NOT NULL,
    last_executed_by character varying(255) DEFAULT NULL::character varying,
    last_executed_on timestamp without time zone,
    tcln_id bigint,
    dataset_id bigint,
    label character varying(255) NOT NULL,
    assignee_id bigint,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    overview_id bigint
);


ALTER TABLE public.test_plan_item OWNER TO postgres;

--
-- Name: COLUMN test_plan_item.test_plan_item_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_plan_item.test_plan_item_id IS 'primary key';


--
-- Name: COLUMN test_plan_item.test_plan_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_plan_item.test_plan_id IS 'fk to the parent test plan';


--
-- Name: test_plan_item_test_plan_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.test_plan_item ALTER COLUMN test_plan_item_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.test_plan_item_test_plan_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: test_plan_test_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.test_plan ALTER COLUMN test_plan_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.test_plan_test_plan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: test_step; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_step (
    test_step_id bigint NOT NULL
);


ALTER TABLE public.test_step OWNER TO postgres;

--
-- Name: COLUMN test_step.test_step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_step.test_step_id IS 'cle primaire autogeneree.';


--
-- Name: test_step_test_step_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.test_step ALTER COLUMN test_step_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.test_step_test_step_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: test_suite; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_suite (
    id bigint NOT NULL,
    name character varying(255),
    description text,
    attachment_list_id bigint NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100) DEFAULT NULL::character varying,
    last_modified_on timestamp without time zone,
    execution_status character varying(255) DEFAULT 'READY'::character varying,
    uuid character varying(36) NOT NULL
);


ALTER TABLE public.test_suite OWNER TO postgres;

--
-- Name: COLUMN test_suite.created_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_suite.created_by IS 'Who created this test suite';


--
-- Name: COLUMN test_suite.created_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_suite.created_on IS 'When this test suite was created';


--
-- Name: COLUMN test_suite.last_modified_by; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_suite.last_modified_by IS 'Who modified this test suite last';


--
-- Name: COLUMN test_suite.last_modified_on; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.test_suite.last_modified_on IS 'When this test suite was last modified';


--
-- Name: test_suite_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.test_suite ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.test_suite_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: test_suite_test_plan_item; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_suite_test_plan_item (
    tpi_id bigint NOT NULL,
    suite_id bigint NOT NULL,
    test_plan_order integer NOT NULL
);


ALTER TABLE public.test_suite_test_plan_item OWNER TO postgres;

--
-- Name: third_party_server; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.third_party_server (
    server_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    url character varying(400) NOT NULL,
    auth_policy character varying(30) DEFAULT 'USER'::character varying,
    auth_protocol character varying(30) DEFAULT 'BASIC_AUTH'::character varying NOT NULL,
    created_by character varying(100) NOT NULL,
    created_on timestamp without time zone NOT NULL,
    last_modified_by character varying(100),
    last_modified_on timestamp without time zone,
    description text DEFAULT ''::text
);


ALTER TABLE public.third_party_server OWNER TO postgres;

--
-- Name: TABLE third_party_server; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.third_party_server IS 'base table for third party servers';


--
-- Name: COLUMN third_party_server.server_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.third_party_server.server_id IS 'primary key, autogenerated';


--
-- Name: COLUMN third_party_server.name; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.third_party_server.name IS 'name of the server';


--
-- Name: COLUMN third_party_server.url; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.third_party_server.url IS 'the base url';


--
-- Name: COLUMN third_party_server.auth_policy; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.third_party_server.auth_policy IS 'the policy that decides who needs to authenticate';


--
-- Name: COLUMN third_party_server.auth_protocol; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.third_party_server.auth_protocol IS 'the protocol that should be used for that server';


--
-- Name: third_party_server_server_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.third_party_server ALTER COLUMN server_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.third_party_server_server_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: verifying_steps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.verifying_steps (
    requirement_version_coverage_id bigint NOT NULL,
    test_step_id bigint NOT NULL
);


ALTER TABLE public.verifying_steps OWNER TO postgres;

--
-- Name: COLUMN verifying_steps.requirement_version_coverage_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.verifying_steps.requirement_version_coverage_id IS 'FK to the concerned requirement-version-coverage';


--
-- Name: COLUMN verifying_steps.test_step_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.verifying_steps.test_step_id IS 'FK to the concerned action test step';


--
-- Name: work_delete_entities; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_delete_entities (
    entity_id bigint NOT NULL,
    entity_type character varying(100) NOT NULL,
    operation_id character varying(50) NOT NULL
);


ALTER TABLE public.work_delete_entities OWNER TO postgres;

--
-- Data for Name: acl_class; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.acl_class (id, classname) VALUES (1, 'org.squashtest.tm.domain.project.Project');
INSERT INTO public.acl_class (id, classname) VALUES (2, 'org.squashtest.tm.domain.requirement.RequirementLibrary');
INSERT INTO public.acl_class (id, classname) VALUES (3, 'org.squashtest.tm.domain.testcase.TestCaseLibrary');
INSERT INTO public.acl_class (id, classname) VALUES (4, 'org.squashtest.tm.domain.campaign.CampaignLibrary');
INSERT INTO public.acl_class (id, classname) VALUES (5, 'org.squashtest.tm.domain.project.ProjectTemplate');
INSERT INTO public.acl_class (id, classname) VALUES (6, 'org.squashtest.tm.domain.customreport.CustomReportLibrary');
INSERT INTO public.acl_class (id, classname) VALUES (7, 'org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary');
INSERT INTO public.acl_class (id, classname) VALUES (8, 'org.squashtest.tm.domain.actionword.ActionWordLibrary');


--
-- Data for Name: acl_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.acl_group (id, qualified_name, active, description, created_by, created_on, last_modified_by, last_modified_on) VALUES (2, 'squashtest.acl.group.tm.TestEditor', true, '', 'Upgrade Squash 8.0', '2025-04-03 16:51:16.591624', NULL, NULL);
INSERT INTO public.acl_group (id, qualified_name, active, description, created_by, created_on, last_modified_by, last_modified_on) VALUES (4, 'squashtest.acl.group.tm.ProjectViewer', true, '', 'Upgrade Squash 8.0', '2025-04-03 16:51:16.591624', NULL, NULL);
INSERT INTO public.acl_group (id, qualified_name, active, description, created_by, created_on, last_modified_by, last_modified_on) VALUES (5, 'squashtest.acl.group.tm.ProjectManager', true, '', 'Upgrade Squash 8.0', '2025-04-03 16:51:16.591624', NULL, NULL);
INSERT INTO public.acl_group (id, qualified_name, active, description, created_by, created_on, last_modified_by, last_modified_on) VALUES (6, 'squashtest.acl.group.tm.TestRunner', true, '', 'Upgrade Squash 8.0', '2025-04-03 16:51:16.591624', NULL, NULL);
INSERT INTO public.acl_group (id, qualified_name, active, description, created_by, created_on, last_modified_by, last_modified_on) VALUES (7, 'squashtest.acl.group.tm.TestDesigner', true, '', 'Upgrade Squash 8.0', '2025-04-03 16:51:16.591624', NULL, NULL);
INSERT INTO public.acl_group (id, qualified_name, active, description, created_by, created_on, last_modified_by, last_modified_on) VALUES (8, 'squashtest.acl.group.tm.AdvanceTester', true, '', 'Upgrade Squash 8.0', '2025-04-03 16:51:16.591624', NULL, NULL);
INSERT INTO public.acl_group (id, qualified_name, active, description, created_by, created_on, last_modified_by, last_modified_on) VALUES (9, 'squashtest.acl.group.tm.Validator', true, '', 'Upgrade Squash 8.0', '2025-04-03 16:51:16.591624', NULL, NULL);
INSERT INTO public.acl_group (id, qualified_name, active, description, created_by, created_on, last_modified_by, last_modified_on) VALUES (10, 'squashtest.acl.group.tm.AutomatedTestWriter', true, '', 'Upgrade Squash 8.0', '2025-04-03 16:51:16.591624', NULL, NULL);


--
-- Data for Name: acl_group_permission; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 32, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 2, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 4, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 8, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 64, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 256, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 512, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1024, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 2, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 4, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 8, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 64, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 256, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 512, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1024, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 2, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 4, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 8, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 64, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 128, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 256, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1024, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 2, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 4, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 8, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 64, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 256, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1024, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 2, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 4, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 8, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 64, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 256, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1024, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 2, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 4, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 8, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 64, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 128, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 256, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1024, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (4, 1, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (4, 1, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (4, 1, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (4, 1, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 1, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 1, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 1, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 128, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 1024, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 1, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 1, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 2, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 4, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 8, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 64, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 256, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 1024, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 1, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 2, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 4, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 8, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 64, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 256, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 1024, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 1, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 1, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 1, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 1, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 2, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 64, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 1, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 64, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 128, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 1024, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 1, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 1, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 64, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 1, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 64, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 1, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 1, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 2048, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 64, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 64, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 64, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 256, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 256, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 2, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 1024, 2, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 2, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 1024, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 4096, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (4, 4096, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 4096, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 4096, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 4096, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 4096, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 2, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 4, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 8, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1024, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 2, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 4, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 8, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1024, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (4, 1, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 1, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 1, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 1, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 1, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 8192, 7, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 8192, 7, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 16384, 7, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 8192, 7, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 8192, 7, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 8192, 7, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (10, 1, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (10, 16384, 7, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 2, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 4, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 8, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 64, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 512, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 1024, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 2, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 4, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 8, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 64, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 1024, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (4, 1, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 1, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 1, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 2, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 4, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 8, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 64, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 1024, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 1, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 2, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 64, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 1, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 64, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 64, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 2, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 1024, 8, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (10, 16384, 3, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (10, 1, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 32768, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 65536, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 512, 1, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 64, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 64, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (6, 64, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (7, 64, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (8, 64, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (9, 64, 6, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (5, 131072, 4, 0, true);
INSERT INTO public.acl_group_permission (acl_group_id, permission_mask, class_id, permission_order, granting) VALUES (2, 131072, 4, 0, true);


--
-- Data for Name: acl_object_identity; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: acl_responsibility_scope_entry; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: action_test_step; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: action_word; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: action_word_fragment; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: action_word_library; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: action_word_library_node; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: action_word_parameter; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: action_word_parameter_value; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: action_word_text; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: ai_server; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: api_token; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: attachment; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: attachment_content; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: attachment_list; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: auth_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.auth_user (login, password, active) VALUES ('admin', 'd033e22ae348aeb5660fc2140aec35850c4da997', true);


--
-- Data for Name: automated_execution_extender; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: automated_execution_failure_detail; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: automated_suite; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: automated_suite_workflows; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: automated_test; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: automated_test_technology; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (1, 'Robot Framework', 'robotframework/execute@v1', false);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (2, 'Cypress', 'cypress/execute@v1', false);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (3, 'JUnit', 'junit/execute@v1', false);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (5, 'SoapUI', 'soapui/execute@v1', false);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (9, 'SKF', 'skf/execute@v1', false);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (10, 'Postman', 'postman/execute@v1', false);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (11, 'Cucumber 5+', 'cucumber5/execute@v1', false);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (4, 'Cucumber 4', 'cucumber/execute@v1', false);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (6, 'Agilitest', 'agilitest/execute@v1', true);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (12, 'Katalon', 'katalon/execute@v1', true);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (8, 'Ranorex', 'ranorex/execute@v1', true);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (7, 'UFT', 'uft/execute@v1', true);
INSERT INTO public.automated_test_technology (at_technology_id, name, action_provider_key, premium) VALUES (13, 'Playwright', 'playwright/execute@v1', false);


--
-- Data for Name: automation_environment_tag; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: automation_request; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: automation_request_library; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: automation_request_library_content; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: awln_relationship; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: awln_relationship_closure; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: bugtracker; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: bugtracker_project; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: call_test_step; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: campaign; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: campaign_folder; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: campaign_iteration; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: campaign_library; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: campaign_library_content; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: campaign_library_node; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: campaign_test_plan_item; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: chart_axis_column; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: chart_column_role; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (1, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (1, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (1, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (4, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (4, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (4, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (5, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (5, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (5, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (6, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (6, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (6, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (7, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (7, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (7, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (8, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (8, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (9, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (9, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (9, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (10, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (10, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (10, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (11, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (11, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (11, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (12, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (12, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (13, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (13, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (14, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (14, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (15, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (15, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (16, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (16, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (19, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (19, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (19, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (20, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (20, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (21, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (21, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (21, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (22, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (22, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (22, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (23, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (23, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (23, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (24, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (24, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (24, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (25, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (25, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (26, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (26, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (27, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (27, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (28, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (28, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (37, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (37, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (37, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (39, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (39, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (40, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (40, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (41, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (41, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (42, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (42, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (43, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (43, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (46, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (46, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (46, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (47, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (47, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (48, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (48, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (49, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (49, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (50, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (50, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (51, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (51, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (54, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (54, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (54, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (55, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (55, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (55, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (56, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (56, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (56, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (57, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (57, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (57, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (58, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (58, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (58, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (59, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (59, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (59, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (60, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (60, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (60, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (66, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (66, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (66, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (67, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (67, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (68, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (68, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (69, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (69, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (70, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (70, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (71, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (71, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (71, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (2, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (2, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (2, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (17, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (17, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (17, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (18, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (18, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (18, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (30, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (30, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (30, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (31, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (31, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (31, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (32, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (32, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (32, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (33, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (33, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (33, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (34, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (34, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (34, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (35, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (35, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (35, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (36, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (36, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (36, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (44, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (44, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (44, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (45, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (45, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (45, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (52, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (52, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (52, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (53, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (53, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (53, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (61, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (61, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (61, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (62, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (62, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (62, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (63, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (63, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (63, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (64, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (64, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (64, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (65, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (65, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (65, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (72, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (73, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (73, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (73, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (95, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (95, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (95, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (96, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (96, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (96, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (97, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (97, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (97, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (98, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (98, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (98, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (99, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (99, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (99, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (100, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (100, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (100, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (101, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (101, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (101, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (102, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (102, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (102, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (103, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (103, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (103, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (104, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (104, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (104, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (105, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (105, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (105, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (106, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (106, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (106, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (107, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (107, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (107, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (108, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (108, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (108, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (109, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (109, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (109, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (110, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (110, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (110, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (111, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (111, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (111, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (112, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (112, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (112, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (113, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (113, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (113, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (114, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (114, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (114, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (115, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (115, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (115, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (116, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (116, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (116, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (117, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (117, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (117, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (118, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (118, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (118, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (119, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (119, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (119, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (120, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (120, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (120, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (121, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (121, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (121, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (122, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (122, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (122, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (123, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (123, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (123, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (124, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (124, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (124, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (72, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (72, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (179, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (179, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (179, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (186, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (186, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (186, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (203, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (203, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (203, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (204, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (204, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (204, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (205, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (205, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (205, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (206, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (206, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (206, 'FILTER');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (207, 'MEASURE');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (207, 'AXIS');
INSERT INTO public.chart_column_role (chart_column_id, role) VALUES (207, 'FILTER');


--
-- Data for Name: chart_definition; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: chart_filter; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: chart_filter_values; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: chart_measure_column; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: chart_project_scope; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: chart_scope; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: cln_relationship; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: cln_relationship_closure; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: connection_attempt_log; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: core_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.core_config (str_key, value) VALUES ('uploadfilter.fileExtensions.whitelist', 'txt, doc, xls, ppt, docx, xlsx, pptx, odt, ods, odp, pdf');
INSERT INTO public.core_config (str_key, value) VALUES ('uploadfilter.upload.sizeLimitInBytes', '4000000');
INSERT INTO public.core_config (str_key, value) VALUES ('uploadfilter.upload.import.sizeLimitInBytes', '2000000');
INSERT INTO public.core_config (str_key, value) VALUES ('autoconnect.on.connection.enabled', 'false');
INSERT INTO public.core_config (str_key, value) VALUES ('WELCOME_MESSAGE', '<p><span style="color:#ff0000;">The administrator default login is <strong>admin/admin</strong> (you can change this password in the &quot;<em>My account (admin)</em>&quot; menu).</span></p><p>Go to the &quot;<em>Administration&quot;</em> menu (in the bottom left corner) to create new users and projects, or change this default home message.</p><p>&nbsp;</p>');
INSERT INTO public.core_config (str_key, value) VALUES ('LOGIN_MESSAGE', '<p><span style="color:#ff0000;">The administrator default login is <strong>admin/admin</strong> (you can change this password in the &quot;<em>My account (admin)</em>&quot; menu).</span></p><p>Go to the &quot;<em>Administration&quot;</em> menu (in the bottom left corner) to create new users and projects, or change this default home message.</p><p>&nbsp;</p>');
INSERT INTO public.core_config (str_key, value) VALUES ('squashtest.tm.database.version', '10.0.0');


--
-- Data for Name: core_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.core_group (id, qualified_name) VALUES (1, 'squashtest.authz.group.core.Admin');
INSERT INTO public.core_group (id, qualified_name) VALUES (4, 'squashtest.authz.group.tm.TestAutomationServer');
INSERT INTO public.core_group (id, qualified_name) VALUES (2, 'squashtest.authz.group.tm.User');
INSERT INTO public.core_group (id, qualified_name) VALUES (5, 'squashtest.authz.group.tm.InfrastructureAdmin');


--
-- Data for Name: core_group_authority; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.core_group_authority (group_id, authority) VALUES (1, 'ROLE_ADMIN');
INSERT INTO public.core_group_authority (group_id, authority) VALUES (2, 'ROLE_TM_USER');
INSERT INTO public.core_group_authority (group_id, authority) VALUES (4, 'ROLE_TA_API_CLIENT');
INSERT INTO public.core_group_authority (group_id, authority) VALUES (5, 'ROLE_INFRASTRUCTURE_ADMIN');


--
-- Data for Name: core_group_member; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.core_group_member (party_id, group_id) VALUES (1, 1);


--
-- Data for Name: core_party; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.core_party (party_id) VALUES (1);


--
-- Data for Name: core_party_authority; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: core_team; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: core_team_member; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: core_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.core_user (party_id, login, first_name, last_name, email, active, created_by, created_on, last_modified_on, last_modified_by, last_connected_on, can_delete_from_front) VALUES (1, 'admin', '', 'Squash Administrator', 'admin@squashtest.org', true, 'liquibase', '2025-04-03 16:51:09.524256', NULL, NULL, NULL, true);


--
-- Data for Name: crln_relationship; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: crln_relationship_closure; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_export_column; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_export_scope; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_field; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_field_binding; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_field_option; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_field_rendering_location; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_field_value; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_field_value_option; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_report_chart_binding; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_report_custom_export; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_report_dashboard; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_report_folder; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_report_library; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_report_library_node; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_report_report_binding; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: databasechangelog; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('1', 'gfouquet', 'auth/auth.changelog-1.0.xml', '2025-04-03 16:51:09.466748', 1, 'EXECUTED', '9:82cf9cd0dac64c03d3863216b6475d07', 'createTable tableName=AUTH_USER; createIndex indexName=IDX_AUTHENTICATION, tableName=AUTH_USER; insert tableName=AUTH_USER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('1', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.492538', 2, 'EXECUTED', '9:6bbae42ae1b73d6851d9781d3fa3d189', 'createTable tableName=CORE_USER; createIndex indexName=DX_USER_LOGIN, tableName=CORE_USER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('2', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.5024', 3, 'EXECUTED', '9:51435087b78e21843956c95ec1f2f302', 'createTable tableName=CORE_GROUP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('3', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.513835', 4, 'EXECUTED', '9:f4b24c29ff729d24bb9adf33d798baf4', 'createTable tableName=CORE_GROUP_AUTHORITY; createIndex indexName=DX_GRP_ID, tableName=CORE_GROUP_AUTHORITY', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('4', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.522045', 5, 'EXECUTED', '9:4d8ec96219fd7ab4049ecf1e43c82cb0', 'createTable tableName=CORE_GROUP_MEMBER; createIndex indexName=DX_GRP_MEMBER, tableName=CORE_GROUP_MEMBER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('5', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.536214', 6, 'EXECUTED', '9:cf5a31507b05f9c77ca97f130d86429f', 'insert tableName=CORE_GROUP; insert tableName=CORE_GROUP_AUTHORITY; insert tableName=CORE_GROUP_AUTHORITY; insert tableName=CORE_USER; insert tableName=CORE_GROUP_MEMBER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('7', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.548488', 7, 'EXECUTED', '9:f70df6e664bf57946cc08bf829543610', 'createTable tableName=ACL_CLASS; createIndex indexName=DX_CLASS_NAME, tableName=ACL_CLASS', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('8', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.563633', 8, 'EXECUTED', '9:f93a61c10c24232a1a3416921a5d3ef6', 'createTable tableName=ACL_OBJECT_IDENTITY; addUniqueConstraint tableName=ACL_OBJECT_IDENTITY; createIndex indexName=DX_OBJ_ID_IDENTITY, tableName=ACL_OBJECT_IDENTITY', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('9', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.572869', 9, 'EXECUTED', '9:8e877f3cc3cbfe189e3349e55a3c6ca2', 'createTable tableName=ACL_GROUP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('10', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.583878', 10, 'EXECUTED', '9:a1d5ecb44110f2f97596beb906746b4c', 'createTable tableName=ACL_GROUP_PERMISSION; addPrimaryKey constraintName=PK_ACL_GRP_PERMISSION, tableName=ACL_GROUP_PERMISSION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('11', 'gfouquet', 'core/core.changelog-0.15.0.xml', '2025-04-03 16:51:09.592301', 11, 'EXECUTED', '9:20af6784da5c3b353b8732b949db7b7a', 'createTable tableName=ACL_RESPONSIBILITY_SCOPE_ENTRY', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('core-0.20.0.01', 'ramoussou', 'core/core.changelog-0.20.0.xml', '2025-04-03 16:51:09.601961', 12, 'EXECUTED', '9:f3fe15d64ead5f1c4eb85f050586f051', 'createTable tableName=CORE_CONFIG', 'Creation of a new table CORE_CONFIG containing Application configuration', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('core-0.20.0.02', 'gfouquet', 'core/core.changelog-0.20.0.xml', '2025-04-03 16:51:09.617127', 13, 'EXECUTED', '9:75e89c9e757ce73cbbc1ccb12e400c1c', 'sql', 'Default welcome message', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('core-1.1.1.RELEASE.01', 'mpagnon', 'core/core.changelog-1.1.1.xml', '2025-04-03 16:51:09.622349', 14, 'EXECUTED', '9:624dee2846748d72ec3b68397b3bab32', 'sql', 'Add new line in CORE_CONFIG for LOGIN_MESSAGE', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('core-feat-327', 'mpagnon', 'core/core.changelog-1.4.0.xml', '2025-04-03 16:51:09.628678', 15, 'EXECUTED', '9:c30ff04a52e9654281f126e49d6616f0', 'sql', 'Because admin was not active , need to make sure that all user active in auth_user are active in core_user', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.01', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.63819', 16, 'EXECUTED', '9:d3922ce2683c3eb4b6777b0e2687cd7f', 'createTable tableName=ISSUE; createIndex indexName=idx_issue, tableName=ISSUE', 'This table maintains the mapping between an issue in Squash and an
			issue in the remote bugtracker', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.02', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.646933', 17, 'EXECUTED', '9:21814f4fca07604873b3cd46bc9fcdbe', 'createTable tableName=ISSUE_LIST; createIndex indexName=idx_issue_list, tableName=ISSUE_LIST', 'each Squash entity that may be attached to one or several bugs will be given an issue list. This table will maintain that list, an entry means that some entity refering to it have several.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.03', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.65335', 18, 'EXECUTED', '9:f403e162e7d0acdab3d4b2202bc27c19', 'createTable tableName=ISSUE_LIST_CONTENT', 'This table will map one issue_list to (0,several) issues', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.04-pg', 'gfouquet', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.665727', 19, 'EXECUTED', '9:3dfd78ed75cc6bba44e7c0e8755ffd75', 'createTable tableName=ATTACHMENT_CONTENT', 'Cette table contient le contenu d''une pièce jointe, dont les meta infos sont stockees dans la
      table ATTACHMENT. La relation entre les deux tables est 1-1', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.05', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.68196', 20, 'EXECUTED', '9:fbbf0b55bc40e8fc7133f2da4f3b6089', 'createTable tableName=ATTACHMENT; createIndex indexName=idx_attachment, tableName=ATTACHMENT', 'Cette table stockera les pieces jointes. La piece elle même est un blob stocke a part dans
					la table ATTACHMENT_CONTENT. La relation entre les deux tables est 1-1', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.06', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.692639', 21, 'EXECUTED', '9:1b916e986e0b6fda9d364bf1655828ab', 'createTable tableName=ATTACHMENT_LIST', 'Cette table matérialise une liste d''ATTACHMENT. Bien qu''elle ne contienne que sa clé primaire, sa raison d''exister est, au niveau de l''application, de fournir une entité indépendante des entités métier auquel on rajoute les pièces jointes.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.07', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.702374', 22, 'EXECUTED', '9:5ced576e9f8162223d528992abb0d1fd', 'createTable tableName=ATTACHMENT_LIST_CONTENT', 'Table d''association entre un cas de test et ses pieces jointes', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.08', 'ramoussou', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.723114', 23, 'EXECUTED', '9:ac9a44c0d9a3ef7b17d47415bc79ba38', 'createTable tableName=PROJECT; createIndex indexName=idx_project, tableName=PROJECT', 'Table representant les projets englobants les libraries d''entite que nous utilisons.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.09', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.735271', 24, 'EXECUTED', '9:d6ae4b5e64516e3e97dcf0900a1ebc5f', 'createTable tableName=TEST_CASE_LIBRARY; createIndex indexName=idx_test_case_library, tableName=TEST_CASE_LIBRARY', 'Cette table gere les bibliotheques de cas de test. Une bibliotheque de cas de test peut contenir plusieurs
		repertoires et/ou cas de test, ces deux entites etant regroupees sous l''appellation generique d''element de bibliotheque
		de cas de test (...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.10', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.747479', 25, 'EXECUTED', '9:53eef6761a08a6e939813cadcdc30a72', 'createTable tableName=REQUIREMENT_LIBRARY; createIndex indexName=idx_requirement_library, tableName=REQUIREMENT_LIBRARY', 'Cette table gere les bibliotheques d''exigences. Une bibliotheque d''exigences peut contenir plusieurs repertoires
				et/ou exigences, ces deux entites etant regroupees sous l''appellation generique d''element de bibliotheque d''exigences (requirement...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.11', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.761594', 26, 'EXECUTED', '9:bacc823d0c25aa548451db2bb9c8e194', 'createTable tableName=CAMPAIGN_LIBRARY; createIndex indexName=idx_campaign_library, tableName=CAMPAIGN_LIBRARY', 'Cette table gere les bibliotheques de campagnes. Une bibliotheque
		de campagnes peut contenir plusieurs repertoires et/ou campagnes, ces deux
		entites etant regroupees sous l''appellation generique d''element de bibliotheque
		de campagnes (campai...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.12', 'ramoussou', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.773069', 27, 'EXECUTED', '9:311535f1424f28462f2fddd5491ab62d', 'addForeignKeyConstraint baseTableName=PROJECT, constraintName=fk_project_cl, referencedTableName=CAMPAIGN_LIBRARY; addForeignKeyConstraint baseTableName=PROJECT, constraintName=fk_project_tcl, referencedTableName=TEST_CASE_LIBRARY; addForeignKeyCo...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.13', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.788821', 28, 'EXECUTED', '9:ea6a4fa0fbf7b4a51c7fae78128ee80b', 'createTable tableName=TEST_CASE_LIBRARY_NODE', 'Cette table represente un element (generique) faisant partie d''une bibliotheque de cas de test. Cet element
		generique peut representer soit un repertoire, soit un cas de test. Pour cette raison, que l''utilisateur cree l''un ou
		l''autre cette tab...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.14', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.803984', 29, 'EXECUTED', '9:20828534ee321ace4a2f5fa4f07fcd05', 'createTable tableName=REQUIREMENT_LIBRARY_NODE', 'Cette table represente un element (generique) faisant partie d''une bibliotheque d''exigences. Cet element
				generique peut representer soit un repertoire, soit une exigence. Pour cette raison, que l''utilisateur cree l''un ou l''autre
				cette tabl...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.15', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.819792', 30, 'EXECUTED', '9:43141b561fe06fb1f22c531e6a3c469b', 'createTable tableName=CAMPAIGN_LIBRARY_NODE', 'Cette table represente un element (generique) faisant partie
				d''une bibliotheque de campagne. Cet element generique peut representer soit
				un repertoire, soit une campagne. Pour cette raison, que l''utilisateur cree
				l''un ou l''autre cette ...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.16', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.830379', 31, 'EXECUTED', '9:74e88ba85a96292836b89f47628c45a4', 'createTable tableName=TEST_CASE; createIndex indexName=idx_test_case, tableName=TEST_CASE', 'Cette table gere les cas de test proprement dits. Une entree dans cette table indique que l''element reference dans la table TEST_CASE_LIBRARY_NODE par la cle primaire (egalement cle etrangere) est de type cas de test.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.17', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.840753', 32, 'EXECUTED', '9:3aa1d6771de8e31576ea70d6c17b5fb1', 'createTable tableName=TEST_CASE_FOLDER; createIndex indexName=idx_tc_folder, tableName=TEST_CASE_FOLDER', 'Cette table est rudimentaire. La cle primaire est simplement une cle etrangere vers la table TEST_CASE_LIBRARY_NODE (relation qualifiante).
		Une entree dans cette table indique que l''element indexe par cette cle est de type repertoire.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.18', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.852222', 33, 'EXECUTED', '9:2ecad2c1259a421f14ac6d9ced859850', 'createTable tableName=TEST_CASE_LIBRARY_CONTENT; createIndex indexName=idx_test_case_lib_content_content, tableName=TEST_CASE_LIBRARY_CONTENT; createIndex indexName=idx_test_case_lib_content_lib, tableName=TEST_CASE_LIBRARY_CONTENT', 'Cette table associe les bibliotheques de cas de test a leur contenu (elements de bibliotheques de cas de test).
		Le contenu d''une bibliotheque de cas de test est arborescent et est represente suivant un patron composite
		(voire TEST_CASE_LIBRARY...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.19', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.864826', 34, 'EXECUTED', '9:325283c92679f0f0057b4ff6bf97b2e3', 'createTable tableName=TCLN_RELATIONSHIP; createIndex indexName=idx_tcln_relationship_descendant, tableName=TCLN_RELATIONSHIP; createIndex indexName=idx_tcln_relationship_ancestor, tableName=TCLN_RELATIONSHIP', 'Cette table gere la hierarchie entre elements d''une bibliotheque de cas de test, associant un element fils a
		un repertoire parent (si non NULL) ou eventuellement aucun (NULL, dans le cas ou l''element est a la racine de la bibliotheque
		de cas d...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.20', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.880303', 35, 'EXECUTED', '9:1cee127f8b7cd8c666744fde27ee5c49', 'createTable tableName=CAMPAIGN', 'Cette table gere les campagnes proprement dites. Une entree
				dans cette table indique que l''element reference dans la table CAMPAIGN_LIBRARY_NODE
				par la cle primaire (egalement cle etrangere) est de type campagne.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.21', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.88797', 36, 'EXECUTED', '9:911cd6fe956b8a95dd9e9fb1c68d5987', 'createTable tableName=CAMPAIGN_FOLDER', 'Cette table est rudimentaire. La cle primaire est simplement
				une cle etrangere vers la table CAMPAIGN_LIBRARY_NODE (relation qualifiante).
				Une entree dans cette table indique que l''element indexe par cette cle est
				de type repertoire.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.22', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.903044', 37, 'EXECUTED', '9:4d64db8e833f0bdd6973ffbf4c3125c2', 'createTable tableName=CAMPAIGN_LIBRARY_CONTENT; createIndex indexName=dx_cl_content_cl_node, tableName=CAMPAIGN_LIBRARY_CONTENT; createIndex indexName=dx_cl_content_campaign_lib, tableName=CAMPAIGN_LIBRARY_CONTENT', 'Cette table gere les bibliotheques de campagnes. Une bibliotheque
				de campagnes peut contenir plusieurs repertoires et/ou campagnes, ces deux
				entites etant regroupees sous l''appellation generique d''element de bibliotheque
				de campagnes (...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.23', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.91506', 38, 'EXECUTED', '9:b7e7ddddfc6990b50924f80643090182', 'createTable tableName=CLN_RELATIONSHIP; createIndex indexName=dx_cln_relationship_descendant, tableName=CLN_RELATIONSHIP; createIndex indexName=dx_cln_relationship_ancestor, tableName=CLN_RELATIONSHIP', 'Cette table gere la hierarchie entre elements d''une bibliotheque
				de campagne, associant un element fils a un repertoire parent (si non NULL)
				ou eventuellement aucun (NULL, dans le cas ou l''element est a la racine de
				la bibliotheque de ...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.24', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.926958', 39, 'EXECUTED', '9:c4a5cf640306687e26ef30fa142b4c39', 'createTable tableName=ITERATION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.25', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.932875', 40, 'EXECUTED', '9:b88a5f128477b559b83e61e51937547b', 'createTable tableName=CAMPAIGN_ITERATION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.26', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.9455', 41, 'EXECUTED', '9:7518ac9b9d8289555560a40a6565a3c8', 'createTable tableName=TEST_STEP', 'Cette table gere les pas de test d''un cas de test.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.27', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.956936', 42, 'EXECUTED', '9:724990dd6a35fba6094ff4ed9486b3a0', 'createTable tableName=TEST_CASE_STEPS; createIndex indexName=idx_tc_steps_step, tableName=TEST_CASE_STEPS; createIndex indexName=idx_tc_steps_tc, tableName=TEST_CASE_STEPS', 'Cette table associe un cas de test a ses pas de test. Cette table d''association existe pour ajouter un attribut d''ordre (la liste des pas de test est ordonnee). La cle primaire est ici composite, et ne doit pas etre autogeneree.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.28', 'xpr', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.966622', 43, 'EXECUTED', '9:842c0001f4bfc5863af5a11e2db2e65e', 'createTable tableName=PROJECT_FILTER; createIndex indexName=DX_UN_PROJECT_FILTER_USER, tableName=PROJECT_FILTER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.29', 'xpr', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.980461', 44, 'EXECUTED', '9:69a35ca06f90540a515d72ba4be366f6', 'createTable tableName=PROJECT_FILTER_ENTRY; addPrimaryKey constraintName=PK_PROJ_FILTER_ENTRY, tableName=PROJECT_FILTER_ENTRY; createIndex indexName=dx_pfp_project, tableName=PROJECT_FILTER_ENTRY; createIndex indexName=dx_pfp_filter, tableName=PRO...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.30', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:09.992117', 45, 'EXECUTED', '9:e4a5388832cf2fa619d376d1cd28d97e', 'createTable tableName=REQUIREMENT; createIndex indexName=idx_requirement, tableName=REQUIREMENT', 'Cette table gere les exigences proprement dites. Une entree dans cette table indique que l''element reference
				dans la table REQUIREMENT_LIBRARY_NODE par la cle primaire (egalement cle etrangere) est de type exigence.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.31', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.000693', 46, 'EXECUTED', '9:4bc9c8a4160f7774362f9cd99212ffa3', 'createTable tableName=REQUIREMENT_FOLDER; createIndex indexName=idx_req_folder, tableName=REQUIREMENT_FOLDER', 'Cette table est rudimentaire. La cle primaire est simplement une cle etrangere vers la table REQUIREMENT_LIBRARY_NODE
				(relation qualifiante). Une entree dans cette table indique que l''element indexe par cette cle est de type repertoire.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.32', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.012199', 47, 'EXECUTED', '9:d9a676bb575444d03835e12c35e560bc', 'createTable tableName=REQUIREMENT_LIBRARY_CONTENT; createIndex indexName=idx_requirement_lib_content_content, tableName=REQUIREMENT_LIBRARY_CONTENT; createIndex indexName=idx_requirement_lib_content_lib, tableName=REQUIREMENT_LIBRARY_CONTENT', 'Cette table associe les bibliotheques d''exigences a leur contenu (elements de bibliotheques d''exigence).
		Le contenu d''une bibliotheque d''exigence est arborescent et est represente suivant un patron composite (voire REQUIREMENT_LIBRARY_NODE,
		RE...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.33', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.023262', 48, 'EXECUTED', '9:7a6bef3d2ce8de002c7d42838c32c44b', 'createTable tableName=RLN_RELATIONSHIP; createIndex indexName=idx_rln_relationship_descendant, tableName=RLN_RELATIONSHIP; createIndex indexName=idx_rln_relationship_ancestor, tableName=RLN_RELATIONSHIP', 'Cette table gere la hierarchie entre elements d''une bibliotheque d''exigences, associant un element fils
				a un repertoire parent.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.34', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.039918', 49, 'EXECUTED', '9:ecd628dea6d2e2d39d4ecc8138b9ebe0', 'createTable tableName=ITEM_TEST_PLAN; createIndex indexName=idx_itertestplan, tableName=ITEM_TEST_PLAN', 'Cette table associe un cas de test avec une liste d''execution. Elle conserve également
		en mémoire le status d''execution, qui devra sera mis à jour au fur et à mesure qu''une execution
		est ajoutée ou exécutée.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.35', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.050084', 50, 'EXECUTED', '9:206d77f30502d5b3065bf5f78097be62', 'createTable tableName=ITEM_TEST_PLAN_LIST; createIndex indexName=idx_ITEM_TESTplan_iteration, tableName=ITEM_TEST_PLAN_LIST; createIndex indexName=idx_ITEM_TESTplan_testplan, tableName=ITEM_TEST_PLAN_LIST', 'Cette table associe une iteration a ses test plans. Cette table d''association existe pour ajouter un attribut d''ordre (la liste des test plans est ordonnée). La clé primaire est ici composite, et ne doit pas être autogénérée.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.36', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.070316', 51, 'EXECUTED', '9:5b8aebe7e33c6d6370c1bfeb61ad57c7', 'createTable tableName=EXECUTION; createIndex indexName=idx_execution, tableName=EXECUTION', 'Table des executions. Une execution correspond à un cas de test, et ses pas d''execution correspondent à des pas de test. Pour assurer un contrôle sur les modifications de l''entité source une référence est gardée vers le cas de test source.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.37', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.083809', 52, 'EXECUTED', '9:a263d14efb3fc2703e6ee720600b7820', 'createTable tableName=ITEM_TEST_PLAN_EXECUTION; createIndex indexName=idx_testplan_exec_testplan, tableName=ITEM_TEST_PLAN_EXECUTION; createIndex indexName=idx_testplan_exec_exec, tableName=ITEM_TEST_PLAN_EXECUTION', 'Associe les executions aux test plans', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.38', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.105555', 53, 'EXECUTED', '9:40179f3c5e3dedcaeea7e9ea01be1ed2', 'createTable tableName=EXECUTION_STEP; createIndex indexName=idx_executionstep, tableName=EXECUTION_STEP', 'Cette table gère les pas d''execution d''une execution. Voir la table EXECUTION pour plus de détails.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.39', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.11744', 54, 'EXECUTED', '9:4359a14ffbc5e4e26e2d513cd10c5f30', 'createTable tableName=EXECUTION_EXECUTION_STEPS; createIndex indexName=idx_exec_exec_step_exec, tableName=EXECUTION_EXECUTION_STEPS; createIndex indexName=idx_exec_exec_step_exec_step, tableName=EXECUTION_EXECUTION_STEPS', 'Cette table associe une executions à ses pas d''execution. Cette table d''association existe pour ajouter un attribut d''ordre (la liste des pas executions est ordonnée). La clé primaire est ici composite, et ne doit pas être autogénérée.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.40', 'bsiri', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.135128', 55, 'EXECUTED', '9:15e3ef72f76a105e4d66495110bd5501', 'createTable tableName=TEST_CASE_REQUIREMENT_LINK; addPrimaryKey constraintName=pk_tc_req_link, tableName=TEST_CASE_REQUIREMENT_LINK; createIndex indexName=idx_tc_req_tc, tableName=TEST_CASE_REQUIREMENT_LINK; createIndex indexName=idx_tc_req_req, t...', 'Cette table gere les associations entre cas de test et exigences.
				La cle primaire est composite et ne doit pas etre autogeneree.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.41', 'adurand', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.148006', 56, 'EXECUTED', '9:3e1c0e2963b79f869472100092ee7751', 'createTable tableName=CAMPAIGN_TEST_PLAN; addPrimaryKey constraintName=pk_camp_tp, tableName=CAMPAIGN_TEST_PLAN; createIndex indexName=idx_camp_tp_camp, tableName=CAMPAIGN_TEST_PLAN', 'Cette table gere les associations entre les campagnes et les cas de test (= les plans de test des campagnes).La cle primaire est composite et ne doit pas etre autogeneree.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.44', 'gfouquet', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.180891', 57, 'EXECUTED', '9:f5de69ea3ee140bf3e32bfee97e02a2e', 'insert tableName=CORE_GROUP_AUTHORITY; insert tableName=CORE_GROUP; insert tableName=CORE_GROUP_AUTHORITY; insert tableName=CORE_GROUP; insert tableName=CORE_GROUP_AUTHORITY; insert tableName=ACL_CLASS; insert tableName=ACL_GROUP; insert tableName...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.14.0.45', 'gfouquet', 'tm/tm.changelog-0.15.0.xml', '2025-04-03 16:51:10.185486', 58, 'EXECUTED', '9:fc7d364838d76197b47cb8122cf8c138', 'insert tableName=ACL_GROUP; insert tableName=ACL_GROUP_PERMISSION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.17.0.01', 'gfouquet', 'tm/tm.changelog-0.17.0.xml', '2025-04-03 16:51:10.196488', 59, 'EXECUTED', '9:e908fb2cbd57d3d61a4b5f43379e4c6c', 'createTable tableName=ACTION_TEST_STEP', 'This table stores "action" tests steps, i.e. steps with an action and expected result, which were formerly stored in TEST_STEP', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.17.0.02', 'gfouquet', 'tm/tm.changelog-0.17.0.xml', '2025-04-03 16:51:10.201732', 60, 'EXECUTED', '9:64b8a6f61ec2a2acf6093568eee161d1', 'sql', 'Data migration from TEST_STEP to ACTION_TEST_STEP', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.17.0.03', 'gfouquet', 'tm/tm.changelog-0.17.0.xml', '2025-04-03 16:51:10.207918', 61, 'EXECUTED', '9:c7621e8a265e6eb3ce611c6802496e7a', 'dropForeignKeyConstraint baseTableName=TEST_STEP, constraintName=fk_test_step__attachment_list; dropColumn columnName=ACTION, tableName=TEST_STEP; dropColumn columnName=EXPECTED_RESULT, tableName=TEST_STEP; dropColumn columnName=ATTACHMENT_LIST_ID...', 'Removes useless comlumns from TEST_STEP', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.17.0.04', 'gfouquet', 'tm/tm.changelog-0.17.0.xml', '2025-04-03 16:51:10.215013', 62, 'EXECUTED', '9:61a56f689600b5fc84b23a3f190c377b', 'createTable tableName=CALL_TEST_STEP', 'This table stores "call" tests steps, i.e. steps which call an entire test case', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.19.0.01', 'ramoussou', 'tm/tm.changelog-0.19.0.xml', '2025-04-03 16:51:10.228592', 63, 'EXECUTED', '9:3a5a22cb94188431998b3805e6827581', 'createTable tableName=CAMPAIGN_TEST_PLAN_ITEM; createIndex indexName=idx_camptestplan, tableName=CAMPAIGN_TEST_PLAN_ITEM', 'We have to set campaign_ID and Test_plan_order to "true" to let hibernate persist new items', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.19.0.02', 'ramoussou', 'tm/tm.changelog-0.19.0.xml', '2025-04-03 16:51:10.234813', 64, 'EXECUTED', '9:5a158f69a1fa794e1d2352e2f5d7d4ea', 'sql', 'Migrates data from unordered campaign test plan table to ordered test plan table.
	 		Items which references (soft) deleted test cases and which should not be in the table are not migrated', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.19.0.04-postgres', 'mpagnon', 'tm/tm.changelog-0.19.0.xml', '2025-04-03 16:51:10.25458', 65, 'EXECUTED', '9:0ecae746ac681b5a1f932e8b2385fb27', 'sql; createProcedure; sql', 'Calculate and insert and add Not null constraint on order for Campaign Test Plan for postgresql', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.19.0.06', 'ramoussou', 'tm/tm.changelog-0.19.0.xml', '2025-04-03 16:51:10.259494', 66, 'EXECUTED', '9:409ee305a69a79045df4bc5e27d5f4a6', 'dropTable tableName=CAMPAIGN_TEST_PLAN', 'Drop table CAMPAIGN_TEST_PLAN', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.19.0.07', 'ramoussou', 'tm/tm.changelog-0.19.0.xml', '2025-04-03 16:51:10.265328', 67, 'EXECUTED', '9:5741d27f1a2f644ae68c31bbdb3175b5', 'addColumn tableName=ITEM_TEST_PLAN', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.20.0.01', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', '2025-04-03 16:51:10.268887', 68, 'EXECUTED', '9:771c3504b2bcdbf2bdf959bbc352cd28', 'dropForeignKeyConstraint baseTableName=TEST_CASE_LIBRARY, constraintName=fk_tcl_project; dropColumn columnName=PROJECT_ID, tableName=TEST_CASE_LIBRARY', 'The PROJECT_ID foreign key in TEST_CASE_LIBRARY is useless, the useful one is in the PROJECT table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.20.0.02', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', '2025-04-03 16:51:10.2723', 69, 'EXECUTED', '9:954b1eb3c451405ac0582efae5d05fd1', 'dropForeignKeyConstraint baseTableName=REQUIREMENT_LIBRARY, constraintName=fk_rl_project; dropColumn columnName=PROJECT_ID, tableName=REQUIREMENT_LIBRARY', 'The PROJECT_ID foreign key in REQUIREMENT_LIBRARY is useless, the useful one is in the PROJECT table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.20.0.03', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', '2025-04-03 16:51:10.275895', 70, 'EXECUTED', '9:8aa9bd553581346172882366c43400d1', 'dropForeignKeyConstraint baseTableName=CAMPAIGN_LIBRARY, constraintName=fk_cl_project; dropColumn columnName=PROJECT_ID, tableName=CAMPAIGN_LIBRARY', 'The PROJECT_ID foreign key in CAMPAIGN_LIBRARY is useless, the useful one is in the PROJECT table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.20.0.05', 'bsiri', 'tm/tm.changelog-0.20.0.xml', '2025-04-03 16:51:10.279961', 71, 'EXECUTED', '9:a5d64573395beff6637860f5d9c63523', 'dropNotNullConstraint columnName=ISSUE_LIST_ID, tableName=EXECUTION; dropNotNullConstraint columnName=ISSUE_LIST_ID, tableName=EXECUTION_STEP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.20.0.07', 'bsiri', 'tm/tm.changelog-0.20.0.xml', '2025-04-03 16:51:10.284881', 72, 'EXECUTED', '9:beece0b9ccad499603ebd3dbe9fd15db', 'dropForeignKeyConstraint baseTableName=CAMPAIGN_TEST_PLAN_ITEM, constraintName=fk_camp_tp_user; addForeignKeyConstraint baseTableName=CAMPAIGN_TEST_PLAN_ITEM, constraintName=fk_camp_tp_user, referencedTableName=CORE_USER', 'add an ondelete set null to the fk campaign test plan item  -> core user', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.20.0.40', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', '2025-04-03 16:51:10.294022', 73, 'EXECUTED', '9:5dc7f75b1437e6686896ad2d26b6ba1c', 'addColumn tableName=ATTACHMENT; sql; dropTable tableName=ATTACHMENT_LIST_CONTENT; addForeignKeyConstraint baseTableName=ATTACHMENT, constraintName=fk_attachment_att_list, referencedTableName=ATTACHMENT_LIST; addNotNullConstraint columnName=ATTACHM...', 'Replace the ATTACHMENT_LIST_CONTENT table by a FK in ATTACHMENT', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.20.0.41', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', '2025-04-03 16:51:10.305099', 74, 'EXECUTED', '9:ff0b374094d672b2d04bd3fe2ff13397', 'addColumn tableName=ISSUE; sql; dropTable tableName=ISSUE_LIST_CONTENT; addForeignKeyConstraint baseTableName=ISSUE, constraintName=fk_issue_issue_list, referencedTableName=ISSUE_LIST; addNotNullConstraint columnName=ISSUE_LIST_ID, tableName=ISSUE', 'Replace the ISSUE_LIST_CONTENT table by a FK in ISSUE', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.20.0.42', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', '2025-04-03 16:51:10.309895', 75, 'EXECUTED', '9:72bd856a7c31ac615273bbb61cf7e759', 'renameTable newTableName=ITERATION_TEST_PLAN_ITEM, oldTableName=ITEM_TEST_PLAN', 'Rename ITEM_TEST_PLAN into ITERATION_TEST_PLAN_ITEM', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.23.0.01', 'bsiri', 'tm/tm.changelog-0.23.0.xml', '2025-04-03 16:51:10.313844', 76, 'EXECUTED', '9:4a791ccf6e03c9bb29314a4584fef2e5', 'sql', 'remove ProjectManager and TestRunner from the ACL permission table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.23.0.02', 'bsiri', 'tm/tm.changelog-0.23.0.xml', '2025-04-03 16:51:10.318026', 77, 'EXECUTED', '9:96a343a1d5266a435ee832c304288afb', 'sql', 'all users that were ProjectManager or TestRunner on anything are now TestEditor', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-0.23.0.03', 'bsiri', 'tm/tm.changelog-0.23.0.xml', '2025-04-03 16:51:10.321306', 78, 'EXECUTED', '9:0efabbb8dd01e84d61f8fecf88b2952e', 'sql', 'remove ProjectManager and TestRunner from the existing acl groups', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.01', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.325119', 79, 'EXECUTED', '9:66ab580c5247e3c97f9cecddd0c47374', 'update tableName=EXECUTION', 'Corrects status to BLOCKED in EXECUTION table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.02', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.329569', 80, 'EXECUTED', '9:4710a5fe7868290075c4b6e9e4c09829', 'update tableName=EXECUTION_STEP', 'Corrects status to BLOCKED in EXECUTION_STEP table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.03', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.333076', 81, 'EXECUTED', '9:ff3edea37c64589d415dad5b4a06eb56', 'update tableName=ITERATION_TEST_PLAN_ITEM', 'Corrects status to BLOCKED in EXECUTION_STEP table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.04', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.336923', 82, 'EXECUTED', '9:f0f51254c74ab328cc3ba739bf7eb49d', 'addColumn tableName=TEST_CASE', 'Adds an importance to test cases', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.05', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.340317', 83, 'EXECUTED', '9:61214804ee9d7c8442f1f0f647792487', 'addColumn tableName=TEST_CASE', 'Adds a auto compute importance property to test cases', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.06', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.343985', 84, 'EXECUTED', '9:f679d322a6a58f0a58f9367d517b8f17', 'insert tableName=CORE_CONFIG', 'Adds a TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.07', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.356739', 85, 'EXECUTED', '9:f846b06e0c2b6fe1625c53227227313b', 'createTable tableName=RESOURCE', 'A tree node organizes resources. These are stored in the RESOURCE table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.08', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.367098', 86, 'EXECUTED', '9:3b33ba452ffde9bef60eb3c2fa0e0f0d', 'createTable tableName=SIMPLE_RESOURCE; addColumn tableName=REQUIREMENT_FOLDER', 'SIMPLE_RESOURCE stores "concrete" resources with a name and a description', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.09', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.374798', 87, 'EXECUTED', '9:be2dea1f96980362052f786b23a9491d', 'sql; sql; sql', 'Moves requirement folder data into SIMPLE_RESOURCE table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.10', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.388119', 88, 'EXECUTED', '9:f52260a30ce5c5da2fa9cc0a3aafc304', 'createTable tableName=REQUIREMENT_VERSION; addUniqueConstraint constraintName=cu_version_of_requirement, tableName=REQUIREMENT_VERSION', 'Creates REQUIREMENT_VERSION table in which we store the versions of requirements', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.11', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.395512', 89, 'EXECUTED', '9:6c68fc0359ea21eb4517074461f3a7d7', 'sql; sql', 'Migrates requirement data into REQUIREMENT_VERSION table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.12', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.402867', 90, 'EXECUTED', '9:8a8142364244d3699622896b4429f267', 'addColumn tableName=REQUIREMENT; sql', 'Adds the ''latest version'' relationship between REQUIREMENT and REQUIREMENT_VERSION tables', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.13', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.416821', 91, 'EXECUTED', '9:44941783933cb1f049ce9e79778770fc', 'createTable tableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION; sql; addNotNullConstraint columnName=VERIFIED_REQ_VERSION_ID, tableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION; addNotNullConstraint columnName=VERIFYING_TEST_CASE_ID, tableName=TEST_CA...', 'Test Cases now cover Requirements versions. We create a new association table and populate it from TEST_CASE_REQUIREMENT_LINK', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.14', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.423755', 92, 'EXECUTED', '9:3e83dfa74c540e73a7444610a1c393e0', 'dropForeignKeyConstraint baseTableName=TEST_CASE_REQUIREMENT_LINK, constraintName=fk_tc_req_tc; dropForeignKeyConstraint baseTableName=TEST_CASE_REQUIREMENT_LINK, constraintName=fk_tc_req_req; dropTable tableName=TEST_CASE_REQUIREMENT_LINK', 'Trashes the now useless TEST_CASE_REQUIREMENT_LINK table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.15', 'bsiri', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.43257', 93, 'EXECUTED', '9:92c91e587a14ddafa7ee77bf23d0804a', 'createTable tableName=REQUIREMENT_AUDIT_EVENT', 'This table is the main table of the event logging system, in other words the history of a business entity. As for Squash TM
		version 1.1.0 and until further notice, we log here requirement modifications only. It may grows to log other entities in...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.16', 'bsiri', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.439046', 94, 'EXECUTED', '9:f2df54e597762c92b77621f59f7f8620', 'createTable tableName=REQUIREMENT_CREATION', 'It is a child table of REQUIREMENT_AUDIT_EVENT. This table exists for the sole purpose of qualifying a given event in a creation event, as such its content is empty (the sheer presence
		of an entry in this table is sufficient)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.17', 'bsiri', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.445298', 95, 'EXECUTED', '9:a0824283f44049c11bfd0c6e189e8591', 'createTable tableName=REQUIREMENT_PROPERTY_CHANGE', 'This is a child table of REQUIREMENT_AUDIT_EVENT. This table will log updates on the target entity. Not every operations will be logged. 
			Note 1 : As for version 1.1.0 and until further notice for the sake of simplicity we log both the former a...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.18', 'bsiri', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.453983', 96, 'EXECUTED', '9:b3b4e0fcd73b623d1232e52da0a6e55d', 'createTable tableName=REQUIREMENT_LARGE_PROPERTY_CHANGE', 'This is a child table of REQUIREMENT_AUDIT_EVENT. This table will log updates on the target entity. Not every operations will be logged. 
			Note 1 : As for version 1.1.0 and until further notice for the sake of simplicity we log both the former a...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.19', 'bsiri', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.459859', 97, 'EXECUTED', '9:7f0e668b22f6a6ab2e943764669bc973', 'sql; sql', 'Will immediately update the tables with the create_events of existing requirements.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.20', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.466773', 98, 'EXECUTED', '9:c6132e59dbf0b4055bf2e33b5b184e52', 'dropColumn columnName=REFERENCE, tableName=REQUIREMENT; dropColumn columnName=CRITICALITY, tableName=REQUIREMENT; dropForeignKeyConstraint baseTableName=REQUIREMENT, constraintName=fk_requirement_attachment_list; dropColumn columnName=ATTACHMENT_L...', 'Remove obsolete columns from REQUIREMENT and REQUIREMENT_LIBRARY_NODE table. 
			Data is now in REQUIREMENT_VERSION and REQUIREMENT_FOLDER tables.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.21', 'fogaillard', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.473679', 99, 'EXECUTED', '9:0188c3747556a6c219a10ede1046f561', 'addColumn tableName=TEST_CASE', 'Add Prerequisite collumn to the test_case table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.22', 'bsiri', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.485633', 100, 'EXECUTED', '9:027c405194ca1e224b567dda0c49fc4b', 'createTable tableName=TEST_SUITE', 'Add the table TEST_SUITE. A TEST_SUITE is basically a view on a subset of ITERATION_TEST_PLAN_ITEMs.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.23', 'bsiri', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.496202', 101, 'EXECUTED', '9:66a5ba440d5b4027542ef503436cbd37', 'createTable tableName=ITERATION_TEST_SUITE; createIndex indexName=dx_iteration_test_suite_iteration, tableName=ITERATION_TEST_SUITE; createIndex indexName=dx_iteration_test_suite_suite, tableName=ITERATION_TEST_SUITE', 'Association table between ITERATION and TEST_SUITE. Like in many other places here, the purpose of this association table is not to model a n-n cardinality between ITERATION and 
			TEST_SUITE, but 1-n. We thus gain performance at the expense of t...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.24', 'bsiri', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.501619', 102, 'EXECUTED', '9:1487bf2084c4b1f6a2ac3070b0b2f929', 'addColumn tableName=ITERATION_TEST_PLAN_ITEM', 'Hereby an ITERATION_TEST_PLAN_ITEM shalt reference 0 or 1 TEST_SUITE', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.1.0.25', 'fogaillard', 'tm/tm.changelog-1.1.0.xml', '2025-04-03 16:51:10.505672', 103, 'EXECUTED', '9:aee304b17aaa5dcbdded39fa07563f4b', 'addColumn tableName=EXECUTION', 'Add Prerequisite collumn to the execution table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.32', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.514859', 104, 'EXECUTED', '9:9391e3b9fa4edf079d5c9464ab9e2345', 'insert tableName=ACL_GROUP; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-1', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.521858', 105, 'EXECUTED', '9:337316d8d130663a49b679a02a89ea08', 'insert tableName=ACL_CLASS; insert tableName=ACL_CLASS; insert tableName=ACL_CLASS; insert tableName=ACL_GROUP; insert tableName=ACL_GROUP; insert tableName=ACL_GROUP; insert tableName=ACL_GROUP', 'add acl-class and acl-groups', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-2', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.529357', 106, 'EXECUTED', '9:a65fa76980c1bdadce3e058eb4173347', 'sql', 'remove existing permissions and redefine them', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-3', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.561057', 107, 'EXECUTED', '9:fcd78dbef53d760c5bd0b4545dc4285c', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableN...', 'ProjectManager / Project
ProjectManager / RequirementLibrary
ProjectManager / TestCaseLibrary
ProjectManager / CampaignLibrary', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-4', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.586956', 108, 'EXECUTED', '9:d264a8564acccd04343de3d4783ee8e2', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableN...', 'TestEditor / Project
TestEditor / RequirementLibrary
TestEditor / TestCaseLibrary
TestEditor / CampaignLibrary', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-5', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.593732', 109, 'EXECUTED', '9:efa47fa1a8a2bfd0814386208a44d004', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION', 'ProjectViewer / Project
ProjectViewer / RequirementLibrary
ProjectViewer / TestCaseLibrary
ProjectViewer / CampaignLibrary', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-6', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.600879', 110, 'EXECUTED', '9:a03bb2adac412728e405c79c23d98da1', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION', 'TestRunner / RequirementLibrary
TestRunner / TestCaseLibrary
TestRunner / CampaignLibrary', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-7', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.61892', 111, 'EXECUTED', '9:157997a0baf87b238317c90c090d56f8', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableN...', 'TestDesigner / Project
TestDesigner / RequirementLibrary
TestDesigner / TestCaseLibrary
TestDesigner / CampaignLibrary', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-8', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.634657', 112, 'EXECUTED', '9:47740122a526cc47b71453f5e82377fa', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableN...', 'AdvanceTester / Project
AdvanceTester / RequirementLibrary
AdvanceTester / TestCaseLibrary
AdvanceTester / CampaignLibrary', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-9', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.653492', 113, 'EXECUTED', '9:3af3d2a1002f4e2b18c7a7c5c5568f8f', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION', 'Validator / Project
Validator / RequirementLibrary
Validator / TestCaseLibrary
Validator / CampaignLibrary', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-10', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.666215', 114, 'EXECUTED', '9:5e6f3c8c7d735f0beb90df20389a57a3', 'sql; sql', 'Existing Data Update: Delete acls for deleted projects in 1.1.1', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-11', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.670934', 115, 'EXECUTED', '9:0f7afd12a2386c8d5e5e5e5842a51187', 'sql', 'Existing Data Update for ACL_OBJECT_IDENTITY / REQUIREMENT_LIBRARY', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-12', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.686099', 116, 'EXECUTED', '9:bd3e4514ef19ab7d2ae9eb6f3702a1f6', 'sql', 'Existing Data Update for ACL_OBJECT_IDENTITY / TEST_CASE_LIBRARY', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-13', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.692389', 117, 'EXECUTED', '9:a0cc8ad339ae1e36b8e746aaa56bcb09', 'sql', 'Existing Data Update for ACL_OBJECT_IDENTITY / CAMPAIGN_LIBRARY', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-14', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.701817', 118, 'EXECUTED', '9:7bcc177465693c830e80a4a9a7741e70', 'sql', 'Existing Data Update for ACL_RESPONSIBILITY_SCOPE_ENTRY / REQUIREMENT_LIBRARY', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-15', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.706724', 119, 'EXECUTED', '9:7076d2144d2a1803d4518ecb7bb53419', 'sql', 'Existing Data Update for ACL_RESPONSIBILITY_SCOPE_ENTRY / TEST_CASE_LIBRARY', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.34-16', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.711061', 120, 'EXECUTED', '9:601d8788b3ef5472fb85cfe99e259981', 'sql', 'Existing Data Update for ACL_RESPONSIBILITY_SCOPE_ENTRY / CAMPAIGN_LIBRARY', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.35-01', 'bsiri', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.721496', 121, 'EXECUTED', '9:3699deda18bfa83cc13cc31ea03616f7', 'addColumn tableName=ISSUE; createIndex indexName=idx_bt_name, tableName=ISSUE', 'table ISSUE nows holds the bugtracker name where the remote issues are hosted', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.36-01', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.725322', 122, 'EXECUTED', '9:de6531c55f709efaa5074dccd64fc018', 'addColumn tableName=REQUIREMENT_VERSION', 'table RequirementVersion nows holds a Category attribute', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.2.0.36-02', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', '2025-04-03 16:51:10.729247', 123, 'EXECUTED', '9:acace5b21987523571b6a9102ec4cfc3', 'addColumn tableName=TEST_CASE', 'table Test-Case nows holds a Reference attribute', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0.01', 'gfouquet', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.734575', 124, 'EXECUTED', '9:246cc469814e496674ec3f4c51e1937c', 'update tableName=CORE_CONFIG', 'Adds a TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0.2', 'gfouquet', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.740909', 125, 'EXECUTED', '9:9ba5612e07c4d493003346c64f18a50f', 'sql', 'Add a default group to users who do not have one (should be users from alpha versions)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.0', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.742884', 126, 'EXECUTED', '9:d41d8cd98f00b204e9800998ecf8427e', 'empty', 'The following serie of changeset labelled tm-1.3-feat-1112.x implements the closure table
			modelization for tree-like data	at
			http://www.mysqlperformanceblog.com/2011/02/14/moving-subtrees-in-closure-table/,
			with a focus on the mysql-speci...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.01', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.75588', 127, 'EXECUTED', '9:f802acbc36054ed630f36074dfc460a8', 'createTable tableName=TCLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_tcln_relationship_clos_desc, tableName=TCLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_tcln_relationship_clos_anc, tableName=TCLN_RELATIONSHIP_CLOSURE', 'closure table for test case library nodes. Its content is set and modified by four triggers, see
			changeset ''tm-1.3-feat-1112.05-mysql'' or ''tm-1.3-feat-1112.05-h2''.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.1.0', 'jmarque', 'tm/tm.changelog-8.1.0.xml', '2025-04-03 16:51:16.659132', 677, 'EXECUTED', '9:a673dfa0a51d51f46064973594f89297', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.02', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.767302', 128, 'EXECUTED', '9:7ce5083e1b131c538015fff1eba41996', 'createTable tableName=RLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_rln_relationship_clos_desc, tableName=RLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_rln_relationship_clos_anc, tableName=RLN_RELATIONSHIP_CLOSURE', 'closure table for requirement library nodes. Its content is set and modified by four triggers, see
			changeset ''tm-1.3-feat-1112.06-mysql'' or ''tm-1.3-feat-1112.06-h2''.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.03', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.778724', 129, 'EXECUTED', '9:210ea9a0af300afcce60b3116ee1af1f', 'createTable tableName=CLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_cln_relationship_clos_desc, tableName=CLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_cln_relationship_clos_anc, tableName=CLN_RELATIONSHIP_CLOSURE', 'closure table for campaign library nodes. Its content is set and modified by four triggers, see
			changeset ''tm-1.3-feat-1112.07-mysql'' or ''tm-1.3-feat-1112.07-h2''.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.04', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.795609', 130, 'EXECUTED', '9:ee874ec703cc89fb13a1c892953faef4', 'createTable tableName=TCLN_RELATIONSHIP_TMP; createTable tableName=RLN_RELATIONSHIP_TMP; createTable tableName=CLN_RELATIONSHIP_TMP; sql; sql; sql; sql; sql; sql', 'first step of the migration : creation of temporary tables in which we will dump
			the X_RELATIONSHIP tables, then truncate the later. We will reinsert the data once
			the triggers are all set.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.05-postgresql', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.804586', 131, 'EXECUTED', '9:b8a95628e71da665b0719ac04d54c95b', 'createProcedure; createProcedure; createProcedure; createProcedure', 'postgresql-triggers for TCLN_RELATIONSHIP_CLOSURE table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.06-postgresql', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.812215', 132, 'EXECUTED', '9:47fa353f5bcc6ed2ccfb950548c5d7f0', 'createProcedure; createProcedure; createProcedure; createProcedure', 'postgresql-triggers for RLN_RELATIONSHIP_CLOSURE table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.07-postgresql', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.820728', 133, 'EXECUTED', '9:81addebaf637ce3b5b2cc5e534305290', 'createProcedure; createProcedure; createProcedure; createProcedure', 'postgresql-triggers for CLN_RELATIONSHIP_CLOSURE table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.08', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.826953', 134, 'EXECUTED', '9:058cd32f96159fc52b8817bf51b6e63d', 'sql; sql; sql', 'this step is mandatory if we want the next one to work (triggers need the nodes to have self-reference in the closure tables)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.09', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.832033', 135, 'EXECUTED', '9:3b3bbbf4c1412b9e22d8cb8c5ca820d0', 'sql; sql; sql', 'we can now reinsert our data from the tmp tables and let the triggers do the job', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1112.10', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.836576', 136, 'EXECUTED', '9:133923f25b6c5d99b227f1512a141ef2', 'dropTable tableName=TCLN_RELATIONSHIP_TMP; dropTable tableName=RLN_RELATIONSHIP_TMP; dropTable tableName=CLN_RELATIONSHIP_TMP', 'If success, we can now drop our temp tables and complete the migration', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1209.01', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.845718', 137, 'EXECUTED', '9:1e1f8c64be774ae6bd7e4ab170d3e469', 'createTable tableName=BUGTRACKER', 'To connect Squash TM to a bugtracker, you must provide the name and the url of the bugtracker. The mantis plugin is shipped with the application
	 IFRAME_FRIENDLY :tells if the bugtracker page can be accessed through an iframe : if the response he...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1181.01', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.860789', 138, 'EXECUTED', '9:7c50180416ed9f3e2b9491610eecf173', 'createTable tableName=TEST_AUTOMATION_SERVER; createIndex indexName=idx_autotest_server, tableName=TEST_AUTOMATION_SERVER; addUniqueConstraint constraintName=uni_autotest_server, tableName=TEST_AUTOMATION_SERVER', 'creating table TEST_AUTOMATION_SERVER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1181.02', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.872468', 139, 'EXECUTED', '9:b939ad5c1974b7119bf498810d43a72b', 'createTable tableName=TEST_AUTOMATION_PROJECT; createIndex indexName=idx_auto_test_project, tableName=TEST_AUTOMATION_PROJECT; addUniqueConstraint constraintName=uni_autotest_project, tableName=TEST_AUTOMATION_PROJECT', 'creating table TEST_AUTOMATION_PROJECT', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1181.03', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.875477', 140, 'EXECUTED', '9:bd4af04452040c912fa5bec568f686b0', 'addColumn tableName=PROJECT', 'now a PROJECT may or may not have test automation enabled', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1181.04', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.882006', 141, 'EXECUTED', '9:3027d71e11f71ce880c87921b7354169', 'createTable tableName=TM_TA_PROJECTS; addPrimaryKey constraintName=pk_tm_ta_projects, tableName=TM_TA_PROJECTS', 'table where TM projects and TA projects are bound to each others', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1194.01', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.889986', 142, 'EXECUTED', '9:04b08c8eda8cb216f53e6c66b843b308', 'createTable tableName=BUGTRACKER_BINDING', 'Bugtracker project represent the project''s name in a configured bugtracker', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1194.04', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.894089', 143, 'EXECUTED', '9:c555097d8f8434afc7119157ebee6c12', 'sql', 'Data migration: add all bugtrackers that had an issue', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1194.05', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.899396', 144, 'EXECUTED', '9:c87320c7f7896ffb367660f22db7dcdc', 'addColumn tableName=ISSUE', 'New foreign key in ISSUE table that points to a BUGTRACKER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1194.06', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.905248', 145, 'EXECUTED', '9:d6d397d7e1439d39dd4bbd59d57da09d', 'sql', 'Data migration : update issue''s bugtracker FK with migrated BTs', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1194.07', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.908945', 146, 'EXECUTED', '9:e067f4befd6f511debc902b5c21ab13c', 'dropColumn columnName=BT_NAME, tableName=ISSUE', 'Drop of column "BT_NAME" on table issue because it is not used anymore => use of FK to table BUGTRACKER instead', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1194.08', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.911273', 147, 'EXECUTED', '9:479ebc194d65637cdf164dd4fa477537', 'addNotNullConstraint columnName=BUGTRACKER_ID, tableName=ISSUE', 'After Data migration : issue''s bugtracker must not be null', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1210.01', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.920451', 148, 'EXECUTED', '9:9c7311918ca3c08e4761e17b78a47827', 'createTable tableName=AUTOMATED_TEST; addUniqueConstraint constraintName=uni_auto_test, tableName=AUTOMATED_TEST', 'Creation of the table AUTOMATED_TEST', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1210.02', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.925993', 149, 'EXECUTED', '9:f480efa53dd0b454d2bf5d7cfdb9b813', 'addColumn tableName=TEST_CASE', 'a TEST_CASE can now refer to 0 or 1 AUTOMATED_TEST', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1210.03', 'gfouquet', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.929323', 150, 'EXECUTED', '9:6e12535be6d1cee145c9df137aea1188', 'insert tableName=CORE_GROUP; insert tableName=CORE_GROUP_AUTHORITY', 'Added a role / group for test automation clients', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1211.01', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.934647', 151, 'EXECUTED', '9:ed9292e1566504c1ef28a140c022212a', 'createTable tableName=AUTOMATED_SUITE', 'Creation of the automated suites table. Note that althought its ID is
			still the primary key, it won''t be autogenerated : the system will supply it
			along the rest instead.

			A automated suite groups together a bunch of test automation execu...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.3.0-feat-1211.02', 'bsiri', 'tm/tm.changelog-1.3.0.xml', '2025-04-03 16:51:10.94624', 152, 'EXECUTED', '9:0beba9c8bbed28e292dd686ce7f36445', 'createTable tableName=AUTOMATED_EXECUTION_EXTENDER', 'Table for the automated executions extender. An automated execution is
			an extension to Executions that handles things related to test automation.

			The correct business model would have been that an automated execution is a specialization of
...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.00', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:10.94943', 153, 'EXECUTED', '9:13ade6a1c334482c90dc2c5e9b5ff1c7', 'update tableName=CORE_CONFIG', 'Adds a TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0-feat-1109.01', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:10.959047', 154, 'EXECUTED', '9:bc130a7a362cd0ba1232efc1fbb1012b', 'createTable tableName=CUSTOM_FIELD', 'Creates a table for Custom Fields', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0-feat-1109.02', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:10.963253', 155, 'EXECUTED', '9:59993f73534cc237eaddd2f0104f8a32', 'createTable tableName=CUSTOM_FIELD_OPTION', 'Creates a table for Custom Fields Options', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0-feat-1390.01', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:10.972499', 156, 'EXECUTED', '9:28a22ae509e21ba85d64ab34bb026997', 'createTable tableName=CUSTOM_FIELD_BINDING; addUniqueConstraint constraintName=uc_cf_entity_proj_bnd, tableName=CUSTOM_FIELD_BINDING', 'Creates a table for Custom Fields Binding', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0-feat-1390.02', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:10.97634', 157, 'EXECUTED', '9:24ba2fb03ec526923220357b2b4bc3d7', 'createTable tableName=CUSTOM_FIELD_RENDERING_LOCATION', 'Creates a table for rendering locations of a bound custom field', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.01', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:10.993366', 158, 'EXECUTED', '9:37ad3a083cbc3612c3e8f29796d9613c', 'addColumn tableName=TEST_CASE_LIBRARY_NODE; addColumn tableName=CAMPAIGN_LIBRARY_NODE; addColumn tableName=RESOURCE; addColumn tableName=PROJECT; addColumn tableName=REQUIREMENT_LIBRARY; addColumn tableName=TEST_CASE_LIBRARY; addColumn tableName=C...', 'Add property attachment list in library nodes, projects and libraries', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.02', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:10.99989', 159, 'EXECUTED', '9:60eab68b876fbf3c372e717f9fa5e034', 'sql; sql; sql', 'Migrate existing attachment lists', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.03', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.008744', 160, 'EXECUTED', '9:b0ad810a67d0dba7510afc208b05323f', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_tcln; dropColumn columnName=TCLN_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to test_case_folders', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.04', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.017205', 161, 'EXECUTED', '9:4ce23ccec4ffc8d093f07bceaed831c6', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_cln; dropColumn columnName=CLN_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to campaign_folders', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.05', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.025084', 162, 'EXECUTED', '9:f0701191510058701096b63b0f8bd152', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_sr; dropColumn columnName=RES_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to requirement folders', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.06', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.032316', 163, 'EXECUTED', '9:e45dcb7c0dc05ae0dfce7e961d9dcb78', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_project; dropColumn columnName=PROJECT_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to projects', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.07', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.040463', 164, 'EXECUTED', '9:2ca87899988c892536cb05e6accb670b', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_rLib; dropColumn columnName=RL_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to reqLib', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.08', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.047292', 165, 'EXECUTED', '9:cfc2d92b21c779f8df150669849c801c', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_tcLib; dropColumn columnName=TCL_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to test_case_library', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.09', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.055549', 166, 'EXECUTED', '9:fea9ea602b0d901b9b8f3b18412cde4d', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_cLib; dropColumn columnName=CL_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to campaign libraries', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.010', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.061509', 167, 'EXECUTED', '9:46b5580d9f766d275becd2efd850ec60', 'addNotNullConstraint columnName=ATTACHMENT_LIST_ID, tableName=TEST_CASE_LIBRARY_NODE; addNotNullConstraint columnName=ATTACHMENT_LIST_ID, tableName=CAMPAIGN_LIBRARY_NODE; addNotNullConstraint columnName=ATTACHMENT_LIST_ID, tableName=RESOURCE; addN...', 'Make attachment_list_ids new fks not nullable', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1513.11', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.067445', 168, 'EXECUTED', '9:dd51fc484999f713f564563ea162da01', 'dropForeignKeyConstraint baseTableName=TEST_CASE, constraintName=fk_test_case_attachment_list; dropForeignKeyConstraint baseTableName=CAMPAIGN, constraintName=fk_campaign_attachment_list; dropForeignKeyConstraint baseTableName=REQUIREMENT_VERSION,...', 'Drop previous attachment list ids', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1392.01', 'bsiri', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.075902', 169, 'EXECUTED', '9:41d55fc7bc07ab93cfe0efcaa8361e4d', 'createTable tableName=CUSTOM_FIELD_VALUE', 'The table CUSTOM_FIELD_VALUE holds instances of a CUSTOM_FIELD that are bound to instances of :
			test cases, requirement version, campagnes, iterations and test suites. A custom field value is created
			when a custom field binding is created or...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1553.00', 'flaurens', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.078994', 170, 'EXECUTED', '9:ce177055f39fc43037d8159712053bc0', 'addColumn tableName=TEST_CASE', 'Adds a nature field to test cases', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1554.00', 'flaurens', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.081797', 171, 'EXECUTED', '9:6d188c2c4373192dbef3d165ad96f5f1', 'addColumn tableName=TEST_CASE', 'Adds a type field to test cases', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1609.00', 'flaurens', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.084856', 172, 'EXECUTED', '9:5a96830f6b1cb2f571d3e6d9036f740e', 'addColumn tableName=TEST_CASE', 'Adds a status field to test cases', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1596.00', 'flaurens', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.090996', 173, 'EXECUTED', '9:86223d2ecbe752d2f6f16d5291d18de7', 'addColumn tableName=EXECUTION', 'Adds test case related fields to executions for denormalization', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1596.01', 'flaurens', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.098689', 174, 'EXECUTED', '9:d8927f6b5e7290b1cb646dcfdb68681e', 'sql', 'adds test case information to executions created prior to the changeset tm-1.4.0.feat-1596.00', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1110.01', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.103405', 175, 'EXECUTED', '9:9bb4cf7429371cc9b6c72593ad4d5dc7', 'addColumn tableName=PROJECT', 'Adds a type discriminator column on PROJECT', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1393.01', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.105824', 176, 'EXECUTED', '9:98b14f0a98688ae95a2be5948d165bf9', 'insert tableName=ACL_CLASS', 'Adds a className for the ProjectTemplate, this is needed so that a project template can hold user''s permissions', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1628.01', 'flaurens', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.115197', 177, 'EXECUTED', '9:60fbf93914b8dd0fe59bf079530d8733', 'addDefaultValue columnName=REFERENCE, tableName=REQUIREMENT_VERSION; addDefaultValue columnName=REFERENCE, tableName=TEST_CASE; addDefaultValue columnName=REFERENCE, tableName=EXECUTION; modifyDataType columnName=REFERENCE, tableName=REQUIREMENT_V...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1638.01', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.118748', 178, 'EXECUTED', '9:66e4123fea0676a54e776521adf48683', 'addColumn tableName=CUSTOM_FIELD', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.0.feat-1638.02', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', '2025-04-03 16:51:11.122301', 179, 'EXECUTED', '9:b98d50c46ddf79c0761e1f219d03da01', 'addColumn tableName=CUSTOM_FIELD_OPTION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.1.00', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', '2025-04-03 16:51:11.124848', 180, 'EXECUTED', '9:f91c543b7d25860f5ec0550b2bf6d776', 'update tableName=CORE_CONFIG', 'Adds a TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.1.issue-1864-01', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', '2025-04-03 16:51:11.128132', 181, 'EXECUTED', '9:cfb68c78bd1430ef8d01d753613b9a6d', 'sql', 'fixed database integrity for execution importance', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.1.issue-1864-02', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', '2025-04-03 16:51:11.131295', 182, 'EXECUTED', '9:29ea6245e1a6ec7478cd3b821e42ee46', 'sql', 'fixed database integrity for execution tc_nature', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.1.issue-1864-03', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', '2025-04-03 16:51:11.134789', 183, 'EXECUTED', '9:2416c629af52a45a32210d554d408231', 'sql', 'fixed database integrity for execution tc_type', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.4.1.issue-1864-04', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', '2025-04-03 16:51:11.138288', 184, 'EXECUTED', '9:a132b10815700f3d6f44aeaa0bf4902a', 'sql', 'fixed database integrity for execution tc_status', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.141276', 185, 'EXECUTED', '9:be8b93543e9b7ed7544e5e35b3ea4e27', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.feat-1596.02', 'bsiri', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.15789', 186, 'EXECUTED', '9:89a1af11c077614614ac5bc43cd32c42', 'dropTable tableName=EXECUTION_TEST_CASE_DATA', 'dropping the temp table from changest tm-1.4.0.feat-1596.01', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-issue-1838.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.163512', 187, 'EXECUTED', '9:281e99d8c343ea959e4667d79d3e8f36', 'sql', 'Update table custom-field-value so that all mandatory cuf have a value', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1390.03', 'bsiri', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.167859', 188, 'EXECUTED', '9:66230b9bf131f27a55005e62cf985e9e', 'dropForeignKeyConstraint baseTableName=CUSTOM_FIELD_RENDERING_LOCATION, constraintName=fk_cfb_render_loc_cfb; addForeignKeyConstraint baseTableName=CUSTOM_FIELD_RENDERING_LOCATION, constraintName=fk_cfb_render_loc_cfb, referencedTableName=CUSTOM_F...', 'adding cascade delete on the rendering locations when custom field bindings are removed (prune the orphans)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1850.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.185276', 189, 'EXECUTED', '9:c5c7ca06e757bf9052f281796aaa3403', 'createTable tableName=DENORMALIZED_FIELD_VALUE; addForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_VALUE, constraintName=fk_dfv_cfv_binding, referencedTableName=CUSTOM_FIELD_VALUE', 'The table DENORMALIZED_FIELD_VALUE holds instances of a FIELD that are bound to instances of :
			executions, execution-steps	when they are created from test-cases or test-case-steps holding CUSTOM_FIELDS.
			A "denormalized field value" is destro...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1850.02', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.190891', 190, 'EXECUTED', '9:cc2620cd869c4c68e3518d3ae50a4aa9', 'createTable tableName=DENORMALIZED_FIELD_RENDERING_LOCATION; addForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_RENDERING_LOCATION, constraintName=fk_dfb_render_loc_dfb, referencedTableName=DENORMALIZED_FIELD_VALUE', 'Create table for denormalized field rendering location', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0-feat-821', 'gfouquet', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.196191', 191, 'EXECUTED', '9:c53d4fe5a484075afb6a3e95027b05fd', 'update tableName=ACL_CLASS; update tableName=ACL_CLASS; update tableName=ACL_CLASS; update tableName=ACL_CLASS; update tableName=ACL_CLASS', 'Change class names in ACL system', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1864.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.208508', 192, 'EXECUTED', '9:898510640f5153cb6d464f0cf4eecfa5', 'createTable tableName=CORE_PARTY; createTable tableName=CORE_TEAM', 'Create tables CORE_PARTY, CORE_TEAM', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1864.02', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.21651', 193, 'EXECUTED', '9:ecd341fdb72afebab90ec43ccf38c730', 'dropForeignKeyConstraint baseTableName=CAMPAIGN_TEST_PLAN_ITEM, constraintName=fk_camp_tp_user; dropForeignKeyConstraint baseTableName=ITERATION_TEST_PLAN_ITEM, constraintName=fk_itertestplan_user; dropForeignKeyConstraint baseTableName=ACL_RESPON...', 'change name of USER_ID into PARTY_ID in CORE_USER, ACL_RESPONSIBILITY_SCOPE_ENTRY and CORE_GROUP_MEMBER. We need to drop FKs on user first.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1864.04', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.220569', 194, 'EXECUTED', '9:78792a65e7ac020e848b01fc3fc20d41', 'sql', 'Create a PARTY for each CORE_USER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1864.postgresql', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.223359', 195, 'EXECUTED', '9:dbaab589de09b63955c1eab16942d68e', 'sql', 'Update party sequence after inserts', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1864.05', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.228341', 196, 'EXECUTED', '9:05be095b0a70df940283f4fb86edaf45', 'addForeignKeyConstraint baseTableName=ACL_RESPONSIBILITY_SCOPE_ENTRY, constraintName=fk_arse_party, referencedTableName=CORE_PARTY; addForeignKeyConstraint baseTableName=CORE_GROUP_MEMBER, constraintName=fk_group_member_party, referencedTableName=...', 'Replace reference on user with reference on party', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-12', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.536082', 244, 'EXECUTED', '9:76cbab82596b1fd6e88b118042f1a2d1', 'delete tableName=ISSUE_LIST', 'DELETE issue lists of executions and execution-steps to delete', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1864.06', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.253604', 197, 'EXECUTED', '9:363f3db66185e2814a8a03954c2cc686', 'dropPrimaryKey tableName=CORE_USER; addPrimaryKey constraintName=pk_core_user, tableName=CORE_USER; addForeignKeyConstraint baseTableName=CORE_USER, constraintName=fk_core_user_party, referencedTableName=CORE_PARTY; addForeignKeyConstraint baseTab...', 'Remove autoIncrement on core_user pk and add fk on Party table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1864.03', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.260143', 198, 'EXECUTED', '9:f547a677d6cd3f689d80ec6df13fcfb0', 'createTable tableName=CORE_TEAM_MEMBER; createIndex indexName=DX_TEAM_MEMBER, tableName=CORE_TEAM_MEMBER', 'create table team member', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1984.01', 'flaurens', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.26422', 199, 'EXECUTED', '9:7db8c305092506cb08964f5de07c4c0a', 'createTable tableName=TEST_SUITE_TEST_PLAN_ITEM', 'create table item_test_plan_test_suite', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1984.02', 'flaurens', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.269158', 200, 'EXECUTED', '9:3c9cd8d02547c06fffe062f23145921c', 'sql; dropForeignKeyConstraint baseTableName=ITERATION_TEST_PLAN_ITEM, constraintName=fk_itpi_testsuite; dropColumn columnName=TEST_SUITE, tableName=ITERATION_TEST_PLAN_ITEM', 'migrate data to table test_suite_test_plan_item', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1902.01', 'bsiri', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.276267', 201, 'EXECUTED', '9:1e5de48532d6982b05da836edecbe965', 'createTable tableName=TEST_CASE_LIBRARY_PLUGINS; createTable tableName=REQUIREMENT_LIBRARY_PLUGINS; createTable tableName=CAMPAIGN_LIBRARY_PLUGINS', 'creating the tables and references for the workspace plugins', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-1984.03', 'flaurens', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.278766', 202, 'EXECUTED', '9:bffe253a51dfb94104df7527051252db', 'addColumn tableName=TEST_SUITE_TEST_PLAN_ITEM', 'add column for ordering to table TEST_SUITE_TEST_PLAN_ITEM', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-2003.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.29429', 203, 'EXECUTED', '9:e7e325d8ba9670b3576acec6230aa82f', 'dropForeignKeyConstraint baseTableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION, constraintName=fk_verified_req_version; dropForeignKeyConstraint baseTableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION, constraintName=fk_verifying_test_case; dropUnique...', 'Action Steps now cover Requirements versions. We need to create a new table that will be an enhancement of the TEST_CASE_VERIFIED_REQUIREMENT_VERSION one.
We drop the constraint of the old TEST_CASE_VERIFIED_REQUIREMENT_VERSION so that we can crea...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-2003.02', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.297351', 204, 'EXECUTED', '9:ac16d9c77ddf50b87542269b1561d679', 'sql', 'We migrate datas from TEST_CASE_VERIFIED_REQUIREMENT_VERSION to REQUIREMENT_VERSION_COVERAGE.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-2003.03', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.300342', 205, 'EXECUTED', '9:4640d4c558a80458af36184974c878b2', 'dropTable tableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION', 'We drop the old TEST_CASE_VERIFIED_REQUIREMENT_VERSION table.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-feat-2003.04', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.305875', 206, 'EXECUTED', '9:56eac578e8df383bd798de1a91671e2c', 'createTable tableName=VERIFYING_STEPS', 'Let''s add a table VERIFYING_STEPS to hold the steps that are concerned by the requirement coverage', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-issue-2061.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.311844', 207, 'EXECUTED', '9:5188a85f5596a31fb5132645eb9c7b29', 'sql', 'Because imported test-cases did not have custom-field-values we need to fix the database.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.00-issue-2146.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', '2025-04-03 16:51:11.333573', 208, 'EXECUTED', '9:2585ad9ddd26caef220f35fffc3fbcdb', 'sql; addNotNullConstraint columnName=PROPERTY_NAME, tableName=REQUIREMENT_PROPERTY_CHANGE; sql; addNotNullConstraint columnName=PROPERTY_NAME, tableName=REQUIREMENT_LARGE_PROPERTY_CHANGE; sql; addNotNullConstraint columnName=REFERENCE, tableName=E...', 'This issue is due to null values in database when @NotNull constraint is present in the bean.
		This changeSet we will make all java @NotNull be present in database
--------------------REQUIREMENT_PROPERTY_CHANGE----------------------------
------...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.1', 'mpagnon', 'tm/tm.changelog-1.5.1.xml', '2025-04-03 16:51:11.337345', 209, 'EXECUTED', '9:70df5ac76cca4dab3859bb0b1265fb16', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.5.0.issue-2261-02-postgresql', 'mpagnon,bsiri', 'tm/tm.changelog-1.5.1.xml', '2025-04-03 16:51:11.351046', 210, 'EXECUTED', '9:84abf616ddb1421a9667f4b629f066cd', 'sql; createProcedure; sql; dropTable tableName=TEMP_DISCONTINUOUS_SUITE_ITEM; dropTable tableName=TEMP_CONTINUOUS_SUITE_ITEM; addNotNullConstraint columnName=TEST_PLAN_ORDER, tableName=TEST_SUITE_TEST_PLAN_ITEM', 'This issue is due to null values in test_suite_test_plan_item.test_plan_order after migration to 1.5.0
First we create help table that will help us match the iteration test plan orders with the test-suite''s test plan items.
drop the temp tables
en...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0', 'mpagnon', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.355458', 211, 'EXECUTED', '9:5cf631a4c198ed0b48382e99ad3ed92b', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.issue-2334-01', 'flaurens', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.369068', 212, 'EXECUTED', '9:4ea7024e40f8791ec4f30c7a4e15aec2', 'createTable tableName=CORE_TEAM_TEMP; sql; dropColumn columnName=DESCRIPTION, tableName=CORE_TEAM; addColumn tableName=CORE_TEAM; sql; dropTable tableName=CORE_TEAM_TEMP', 'Change type of column description in table core_team', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.feat-1101-01', 'mpagnon', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.382631', 213, 'EXECUTED', '9:09e8903a91933e273c52929ccfbc709e', 'createTable tableName=PARAMETER; addUniqueConstraint tableName=PARAMETER', 'Add table to handle test cases PARAMETERS', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.feat-1101-02', 'mpagnon', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.401881', 214, 'EXECUTED', '9:139394d9eb8346a90f3ac4546cee18f3', 'createTable tableName=DATASET; addUniqueConstraint tableName=DATASET; createTable tableName=DATASET_PARAM_VALUE; addUniqueConstraint tableName=DATASET_PARAM_VALUE', 'Add tables to handle test cases DATASETS', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.feat-1128-01', 'mpagnon', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.407284', 215, 'EXECUTED', '9:ae5b77852836a8f31b412235024e1b5a', 'addColumn tableName=ITERATION_TEST_PLAN_ITEM', 'Add column to bind a test plan item to a DATASET', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.issue-2203-01', 'flaurens', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.411076', 216, 'EXECUTED', '9:ae10f201bdb87f251aa4160955ff8076', 'sql', 'remove inactive users from all teams', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.issue-2203-02', 'flaurens', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.414061', 217, 'EXECUTED', '9:5706dcd526e0897353c5bc14d1266406', 'sql', 'remove core rights of inactive users', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.issue-2203-03', 'flaurens', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.417184', 218, 'EXECUTED', '9:07b14e0a03a65a1a36a63b5c2cea7305', 'sql', 'remove acl rights of inactive users', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0-issue-3236-01', 'flaurens', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.686964', 271, 'EXECUTED', '9:541c8e0a6b064be6658982dbf1a8043d', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.issue-2454-02-postgresql', 'mpagnon', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.427691', 219, 'EXECUTED', '9:752e0fcd1959fabc291f440ea27eb705', 'sql; createProcedure; sql', 'cleaning test suite test plan ordering : some collections have non-contiguous elements. This
		is due to issue #2454, because of shortcomings in the code in charge of deleting test cases and dependent
		entities.
			It looks pretty much like tm-1....', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.issue-2474-01', 'bsiri', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.43371', 220, 'EXECUTED', '9:fcd43320b04bef2e3a659d1bdbc3fe6f', 'sql', 'fixes the action test steps having no custom fields when copied from one project to another. Works for both mysql and h2.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.issue-2485-01', 'flaurens', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.437842', 221, 'EXECUTED', '9:3fe098f859e64a01b6a77fb9e9011bcb', 'dropForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_VALUE, constraintName=fk_dfv_cfv_binding; addForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_VALUE, constraintName=fk_dfv_cfv_binding, referencedTableName=CUSTOM_FIELD_VALUE', 'replaces fk-constraint which wrongly cascades the deletion of denormalized field values', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.6.0.issue-2536-01', 'flaurens', 'tm/tm.changelog-1.6.0.xml', '2025-04-03 16:51:11.440905', 222, 'EXECUTED', '9:e3b8042dd4d7937af5359a50c4187a15', 'insert tableName=ACL_GROUP_PERMISSION', 'giving testrunners reading rights on projects', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.0', 'bsiri', 'tm/tm.changelog-1.7.0.xml', '2025-04-03 16:51:11.443513', 223, 'EXECUTED', '9:7fefbeff7ae2617dc563631e02960ff4', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.0.feat-1107-01', 'bsiri', 'tm/tm.changelog-1.7.0.xml', '2025-04-03 16:51:11.449346', 224, 'EXECUTED', '9:a69acd739f30d0298e4834cc217885a0', 'dropForeignKeyConstraint baseTableName=RLN_RELATIONSHIP, constraintName=fk_rln_relationship_ancestor; dropForeignKeyConstraint baseTableName=RLN_RELATIONSHIP, constraintName=fk_rln_relationship_descendant; addForeignKeyConstraint baseTableName=RLN...', 'Modifying RLN_RELATIONSHIP and RLN_RELATIONSHIP_CLOSURE : requirements can now accept more requirements 
		(but no folders). Cautious : there is no way to express that a a requirement can only accept requirements as children.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.0.feat-1090-01', 'flaurens', 'tm/tm.changelog-1.7.0.xml', '2025-04-03 16:51:11.452684', 225, 'EXECUTED', '9:39c0521446be0ba8faa7f30b2e589732', 'insert tableName=CORE_CONFIG', 'adding entries for indexing dates in table core_config', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.0.feat-1090-02', 'flaurens', 'tm/tm.changelog-1.7.0.xml', '2025-04-03 16:51:11.455574', 226, 'EXECUTED', '9:20150619d97fcba78fa21aacf9b2d7a9', 'insert tableName=CORE_CONFIG', 'adding entries for indexing dates in table core_config', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.0.feat-1090-03', 'flaurens', 'tm/tm.changelog-1.7.0.xml', '2025-04-03 16:51:11.458435', 227, 'EXECUTED', '9:16fbe499ad1a0025e43552cce4cc4345', 'insert tableName=CORE_CONFIG', 'adding entries for indexing dates in table core_config', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.0.feat-1090-04', 'flaurens', 'tm/tm.changelog-1.7.0.xml', '2025-04-03 16:51:11.46137', 228, 'EXECUTED', '9:62f09046a3fa3b79d47a6a24113b9471', 'insert tableName=CORE_CONFIG', 'adding entries for indexing versions in table core_config', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.0.feat-1090-05', 'flaurens', 'tm/tm.changelog-1.7.0.xml', '2025-04-03 16:51:11.464566', 229, 'EXECUTED', '9:01e05b2a690181b08fe81e273402ac54', 'insert tableName=CORE_CONFIG', 'adding entries for indexing versions in table core_config', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.0.feat-1090-06', 'flaurens', 'tm/tm.changelog-1.7.0.xml', '2025-04-03 16:51:11.468184', 230, 'EXECUTED', '9:9d2ce9f71ddcfdd9e68c2dd54c7850ca', 'insert tableName=CORE_CONFIG', 'adding entries for indexing versions in table core_config', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.0.feat-2648', 'mpagnon', 'tm/tm.changelog-1.7.0.xml', '2025-04-03 16:51:11.485284', 231, 'EXECUTED', '9:26bb8888d917807904963d306acdec9d', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; delete tableName=ACL_GROUP_PERMISSION; delete tableName=ACL_GROUP_PERMISSION; delete tableName=ACL_GROUP_PERMISSION; delete tableN...', 'add permission EXTENDED_DELETE to Project Manager on Campaign library
add permission EXPORT to Test Runner on Requirement library
add permission EXPORT to Test Runner on Test-case library
remove permission WRITE to Advance tester on Campaign libra...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.488773', 232, 'EXECUTED', '9:6f69333f145aa5e2766a811280d85b21', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-01', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.492593', 233, 'EXECUTED', '9:d3d37bdf8b6a1c9e1ff638f27f1d914a', 'createTable tableName=ENTITIES_TO_DELETE', 'Delete ghost executions
create table to store the id of entities to delete', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-02', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.496594', 234, 'EXECUTED', '9:dbf86237d031ea5a31f1655475325859', 'sql', 'Store the ids of the ghost executions', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-03', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.500933', 235, 'EXECUTED', '9:5d4de6b6bf57102c52b5688c908e9db2', 'sql', 'Store the ids of the execution steps', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-04', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.508652', 236, 'EXECUTED', '9:4cc407d9015117d06ce9cccc772d3ace', 'sql; sql', 'Store the ids of the issue lists to delete', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-05', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.512547', 237, 'EXECUTED', '9:0b77d097d6d471011edd9ba2dcaee435', 'sql; sql', 'Store the ids of the issue lists to delete', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-06', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.515219', 238, 'EXECUTED', '9:3c8589f60823bf902b3a2d3a315114a5', 'delete tableName=ISSUE', 'DELETE Issues of execution and execution steps to delete', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-07', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.518524', 239, 'EXECUTED', '9:93387d5f85222eb1ba1ad0cad73942eb', 'delete tableName=AUTOMATED_EXECUTION_EXTENDER', 'DELETE Automated execution extender of executions to delete', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-08', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.521784', 240, 'EXECUTED', '9:f8cbb7b9a5d5f5334981aebf96245524', 'delete tableName=AUTOMATED_SUITE', 'DELETE automated suites that are not linked to any automated execution extender', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-09', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.525812', 241, 'EXECUTED', '9:c90ef6c46f123f8764245f376e05e92e', 'delete tableName=EXECUTION_EXECUTION_STEPS; delete tableName=EXECUTION_STEP', 'Delete execution steps of ghost executions', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-10', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.528272', 242, 'EXECUTED', '9:f0497a34f79ca13630820c3f7210d57b', 'delete tableName=EXECUTION', 'Delete ghost executions', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-11', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.533502', 243, 'EXECUTED', '9:aebc8cf7c61e2cfdb77ef2ea3b88ab8f', 'delete tableName=ATTACHMENT; delete tableName=ATTACHMENT_CONTENT; delete tableName=ATTACHMENT_LIST', 'DELETE Attachments of execution and execution steps to delete', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-4068-9', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.109727', 319, 'EXECUTED', '9:e86f40f6161a610eec4f91622eb604de', 'sql', 'update the sequences afterward', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.7.1.issue-2873-13', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', '2025-04-03 16:51:11.539155', 245, 'EXECUTED', '9:d8bfe4017ff9ee98397764cab50d1c6c', 'dropTable tableName=ENTITIES_TO_DELETE', 'Drop table used to store the ids of the entities to delete', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.0', 'mpagnon', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.543905', 246, 'EXECUTED', '9:07c4ac53e51fb901f9f2246b9137e1ce', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.0.feat-2688', 'mpagnon', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.547866', 247, 'EXECUTED', '9:19a4ee1132150dfbec1030f03983acda', 'sql', 'add permission READ_UNASSIGNED on Campaign library for all users but TestRunners', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.0.issue-1846-02', 'mpagnon', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.55244', 248, 'EXECUTED', '9:c8512e9719e1290d2a4bd5dd33750019', 'dropColumn columnName=DELETED_ON, tableName=CAMPAIGN_LIBRARY_NODE; dropColumn columnName=DELETED_ON, tableName=TEST_CASE_LIBRARY_NODE; dropColumn columnName=DELETED_ON, tableName=REQUIREMENT_LIBRARY_NODE; dropColumn columnName=DELETED_ON, tableNam...', 'Remove the DELETED_ON columns', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.0.issue-3009-01', 'bsiri', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.555294', 249, 'EXECUTED', '9:8515a0d8e0c99ebe05cd1d28c65a69c7', 'sql', 'As of 1.8.0 anyone that executes a test becomes de facto its assignee. This changeset will update the iteration
			test plan items and assign it to the last executor (if any) if it hasn''t an assignee already', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('core-1.8.0-feat-2699-00', 'bsiri', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.563399', 250, 'EXECUTED', '9:e912fb8f8bc31e3c6ce625aa47358ca5', 'sql', 'actually remove user accounts that were deactivated', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('core-1.8.0-feat-2699-01', 'bsiri', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.566663', 251, 'EXECUTED', '9:b01adbb848090c001d4adc0c8b75e557', 'update tableName=CORE_GROUP', 'the CORE_GROUP squashtest.tm.group.User is now renamed to the normalized squashtest.authz.group.tm.User', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('core-1.8.0-feat-2699-02', 'bsiri', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.570239', 252, 'EXECUTED', '9:2e9536907645ca32f4d873e37081df94', 'update tableName=CORE_GROUP_MEMBER; delete tableName=CORE_GROUP_AUTHORITY; delete tableName=CORE_GROUP', 'the CORE_GROUP squashtest.authz.tm.group.ProjectManager is deleted and the users belonging to that group are now
		demoted to squashtest.authz.group.tm.User', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('core-1.8.0-feat-2699-03', 'bsiri', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.575062', 253, 'EXECUTED', '9:83b28d5c487970f92d4548a082ba65c6', 'createTable tableName=CORE_PARTY_AUTHORITY', 'The table CORE_PARY_AUTHORITY stores personal authorities. As for TM 1.8.0 the users and teams now have blanket permissions
			(aka authorities) for themselves, not only via core_group membership. However, a user will still belong to one of the CO...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('core-1.8.0-feat-2699-04', 'bsiri', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.583372', 254, 'EXECUTED', '9:b3eb962c78e3c1df4e1e23213ca27bf2', 'sql', 'we have now to set the role ROLE_TM_PROJECT_MANAGER to the corresponding users', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.0.issue-2899-2-postgresql', 'mpagnon', 'tm/tm.changelog-1.8.0.xml', '2025-04-03 16:51:11.597963', 255, 'EXECUTED', '9:ae66eea1ab8b7b2235263ac7fb4b198c', 'sql', 'Clean up the database from dead entities that slipped through the deletion routines (postgresql).', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.2', 'flaurens', 'tm/tm.changelog-1.8.2.xml', '2025-04-03 16:51:11.600554', 256, 'EXECUTED', '9:c43d03a8b802d9fc0896e3eede0d20f9', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.2.feature-3120-01', 'flaurens', 'tm/tm.changelog-1.8.2.xml', '2025-04-03 16:51:11.604802', 257, 'EXECUTED', '9:491b875bac7f0df1f5924e0e9d12f633', 'createTable tableName=DENORMALIZED_FIELD_OPTION', 'Adding denormalized field option table for editable denormalized list valued cufs', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.2.feature-3120-02', 'flaurens', 'tm/tm.changelog-1.8.2.xml', '2025-04-03 16:51:11.607523', 258, 'EXECUTED', '9:0d2f1257cc2aad0e8cdc17cf58ba7ad2', 'update tableName=DENORMALIZED_FIELD_VALUE', 'Old list valued cufs are editable as simple text cufs', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.2.feature-3120-03', 'flaurens', 'tm/tm.changelog-1.8.2.xml', '2025-04-03 16:51:11.610486', 259, 'EXECUTED', '9:68f387706cd9e2bb64d2beff3af9138b', 'addColumn tableName=DENORMALIZED_FIELD_VALUE', 'Adding a field type column to denormalized field value table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.2-feat-3127-01', 'bsiri', 'tm/tm.changelog-1.8.2.xml', '2025-04-03 16:51:11.620918', 260, 'EXECUTED', '9:650e114769dea1118d96c93368325823', 'createTable tableName=LIBRARY_PLUGIN_BINDING; addUniqueConstraint constraintName=uniq_plugin_binding, tableName=LIBRARY_PLUGIN_BINDING', 'As of now X_LIBRARY_PLUGINS are merged in the single table LIBRARY_PLUGIN_BINDING', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.2-feat-3127-02', 'bsiri', 'tm/tm.changelog-1.8.2.xml', '2025-04-03 16:51:11.626021', 261, 'EXECUTED', '9:4c28c73f7a05cac9704242a6265a9eec', 'createTable tableName=LIBRARY_PLUGIN_BINDING_PROPERTY', 'create the table LIBRARY_PLUGIN_PROPERTY', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.8.2-feat-3127-03', 'bsiri', 'tm/tm.changelog-1.8.2.xml', '2025-04-03 16:51:11.630864', 262, 'EXECUTED', '9:972871afc807d510cef08372a2aebe12', 'dropTable tableName=TEST_CASE_LIBRARY_PLUGINS; dropTable tableName=REQUIREMENT_LIBRARY_PLUGINS; dropTable tableName=CAMPAIGN_LIBRARY_PLUGINS', 'drop the old tables', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0', 'flaurens', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.633897', 263, 'EXECUTED', '9:e0e2b361cca204600d245ee8483bff19', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3138-1', 'flaurens', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.639363', 264, 'EXECUTED', '9:fd1f35768832b0496a4aa53af2a857b6', 'addColumn tableName=CLN_RELATIONSHIP; addColumn tableName=RLN_RELATIONSHIP; addColumn tableName=TCLN_RELATIONSHIP; addColumn tableName=REQUIREMENT_LIBRARY_CONTENT; addColumn tableName=TEST_CASE_LIBRARY_CONTENT; addColumn tableName=CAMPAIGN_LIBRARY...', 'Adding columns to order descendants in node relationship tables', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3138-2', 'jsimon', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.648956', 265, 'EXECUTED', '9:5d6256482c5fdec962e4bdcbea26999a', 'sql; createProcedure; sql', 'Creating default order which is identical with the alphabetical order', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3138-4', 'jsimon', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.662936', 266, 'EXECUTED', '9:bd5db6a5624c52b02f3129004b8b55ed', 'sql; createProcedure; sql', 'Creating default order which is identical with the alphabetical order', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3138-6', 'jsimon', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.673642', 267, 'EXECUTED', '9:a55837f0f111282bf2cd8b9a0cf538c2', 'sql; createProcedure; sql', 'Creating default order which is identical with the alphabetical order', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3138-8', 'flaurens', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.677327', 268, 'EXECUTED', '9:c1742504ec21501c7c795030ccd2895b', 'dropNotNullConstraint columnName=VERIFIED_REQ_VERSION_ID, tableName=REQUIREMENT_VERSION_COVERAGE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3211-1', 'flaurens', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.680575', 269, 'EXECUTED', '9:6f3ba84271e5964c6ec954753ba0a9a7', 'createTable tableName=DISABLED_EXECUTION_STATUS', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3211-2', 'flaurens', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.684523', 270, 'EXECUTED', '9:09e2dc3da7377ca65b74d96e5e050ffb', 'sql', 'Inserting default disabled execution statuses for existing libraries', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0-issue--01', 'flaurens', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.694561', 272, 'EXECUTED', '9:5b3eb02fdaaf5c8c8ae0ca44b5c4325c', 'dropNotNullConstraint columnName=ACTION, tableName=ACTION_TEST_STEP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0-issue-3140-01', 'mpagnon', 'tm/tm.changelog-1.9.0.xml', '2025-04-03 16:51:11.700565', 273, 'EXECUTED', '9:2d5a10ef5f4f2426537a1be23abc0d39', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0', 'bsiri', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.70317', 274, 'EXECUTED', '9:72dd411ed068d8f851b58027f6420223', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0.feature-3481-1', 'bsiri', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.705318', 275, 'EXECUTED', '9:dd75b08c7bb07f5bbc7728704e124930', 'dropNotNullConstraint columnName=TEST_ID, tableName=AUTOMATED_EXECUTION_EXTENDER', 'before the cleanup, we need to relax some constraints', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0.feature-3481-2', 'bsiri', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.718908', 276, 'EXECUTED', '9:24630b8303cc3ee9f86b24462ca78432', 'sql; sql; sql; sql; sql; sql; sql', 'cleaning up unused entities', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0.feature-3481-3', 'bsiri', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.734441', 277, 'EXECUTED', '9:364c8f566a3bc100569ca5e625ab9ea9', 'addColumn tableName=TEST_AUTOMATION_SERVER; sql; sql; addNotNullConstraint columnName=NAME, tableName=TEST_AUTOMATION_SERVER; addUniqueConstraint tableName=TEST_AUTOMATION_SERVER; addNotNullConstraint columnName=CREATED_ON, tableName=TEST_AUTOMATI...', 'The test automation servers are now ''auditable'' (dates and authors of creation/modification are recorded) and has
		several other attributes', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0.feature-3481-4', 'bsiri', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.765222', 278, 'EXECUTED', '9:f883e208d10c7e2e02da96b8e5c82d2c', 'createTable tableName=PROTO_TEST_AUTOMATION_PROJECT; sql; dropTable tableName=TM_TA_PROJECTS; dropForeignKeyConstraint baseTableName=AUTOMATED_TEST, constraintName=fk_automated_test_project; dropTable tableName=TEST_AUTOMATION_PROJECT; renameTable...', 'The associative table TM_TA_PROJECTS is totally re-purposed as TEST_AUTOMATION_PROJECT
			(and the former table is ditched).', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0.feature-3481-5', 'bsiri', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.771517', 279, 'EXECUTED', '9:4ee800b9e12a7cda2eda529b0f2e456b', 'addColumn tableName=PROJECT; dropColumn columnName=TEST_AUTOMATION_ENABLED, tableName=PROJECT', 'A TM project is now hard-bound to a TA server', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0.feature-3481-6', 'bsiri', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.776444', 280, 'EXECUTED', '9:9b50672945fe8871232342968a77e120', 'sql', 'migrating existing data to the new schema', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0.feature-3481-6', 'gfouquet', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.779531', 281, 'EXECUTED', '9:6a7a59034ad80dcd05362f22d9b99bc0', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0.feature-3481-7', 'flaurens', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.782784', 282, 'EXECUTED', '9:0f90473d6ad10f237d542c2361c6f273', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0.feature-3481-postgresql', 'mpagnon', 'tm/tm.changelog-1.10.0.xml', '2025-04-03 16:51:11.793236', 283, 'EXECUTED', '9:d0158ac2d01684a024348f210c9faf50', 'sql; createProcedure; sql', 'Creating default order which is identical with the alphabetical order', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.0', 'bsiri', 'tm/tm.changelog-1.10.3.xml', '2025-04-03 16:51:11.795816', 284, 'EXECUTED', '9:49662bec8f80e38cdc171a2da79cd3b1', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.3-issue-3807-3808-1', 'bsiri', 'tm/tm.changelog-1.10.3.xml', '2025-04-03 16:51:11.807011', 285, 'EXECUTED', '9:8f8ae8fdfab7d1ac2f5bf9dec54e6474', 'createIndex indexName=idx_cfv_entity_id, tableName=CUSTOM_FIELD_VALUE; createIndex indexName=idx_cfv_entity_type, tableName=CUSTOM_FIELD_VALUE; createIndex indexName=idx_dfv_entity_id, tableName=DENORMALIZED_FIELD_VALUE; createIndex indexName=idx_...', 'Adding much needed indexes', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.5', 'mpagnon', 'tm/tm.changelog-1.10.5.xml', '2025-04-03 16:51:11.809564', 286, 'EXECUTED', '9:732cd4b19ed2aa905655702ad170fd3a', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.5-issue-3860-1', 'mpagnon', 'tm/tm.changelog-1.10.5.xml', '2025-04-03 16:51:11.820681', 287, 'EXECUTED', '9:9f54b915dafc7728e8a1f164a45af12c', 'createTable tableName=CUF_VALUES_TO_SAVE; createIndex indexName=idx_cuf_values_to_save, tableName=CUF_VALUES_TO_SAVE; sql; sql; dropIndex indexName=idx_cuf_values_to_save, tableName=CUF_VALUES_TO_SAVE; dropTable tableName=CUF_VALUES_TO_SAVE', 'Removing duplicate values', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.10.5-issue-3860-3', 'mpagnon', 'tm/tm.changelog-1.10.5.xml', '2025-04-03 16:51:11.830849', 288, 'EXECUTED', '9:cbe19f76af2f310f3c5a21504c28eceb', 'createTable tableName=STEPS_SHOULD_HAVE_CUF_VALUES; sql; sql; sql; dropTable tableName=STEPS_SHOULD_HAVE_CUF_VALUES', 'add missing custom field values', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0', 'flaurens', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.833294', 289, 'EXECUTED', '9:4fabd33f70ed22dcc78c8dc410c13983', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3576-1', 'bsiri', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.836036', 290, 'EXECUTED', '9:0b7eb38b79ac85a87aa4ec59b5008731', 'addColumn tableName=CUSTOM_FIELD', 'Prepares the table CUSTOM_FIELD for possible default_values of type TEXT.
  		Also accepts now a new value for the column FIELD_TYPE : RTF (for rich text fields) - no structural changes for that though.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3576-2', 'bsiri', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.84222', 291, 'EXECUTED', '9:62aebc13574ad3d98f452f12e7241b7b', 'addColumn tableName=CUSTOM_FIELD_VALUE', 'prepares the table CUSTOM_FIELD_VALUE for values of type CLOB, and adds support for inheritance to that end.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3576-3', 'bsiri', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.845013', 292, 'EXECUTED', '9:dd739bff86b178f1259e37ac4a7f0f11', 'addColumn tableName=DENORMALIZED_FIELD_VALUE', 'Prepares the table DENORMALIZED_FIELD_VALUE for values of type CLOB, and adds support for inheritance to that end.
  		Also accepts now a new value for the column FIELD_TYPE : RTF (for rich text fields) - no structural changes for that though.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3556-4', 'kdrifi', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.84766', 293, 'EXECUTED', '9:80b1819df7aeefef6c93e0f03acfcd25', 'delete tableName=CORE_GROUP_AUTHORITY; delete tableName=CORE_GROUP_AUTHORITY', 'Cleaning duplicates of column ROLE_USER in table core_group _authority', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3577-1', 'mpagnon', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.882393', 294, 'EXECUTED', '9:e9744a2ba546ee87f2fe5edf91832a31', 'modifyDataType columnName=INPUT_TYPE, tableName=CUSTOM_FIELD; modifyDataType columnName=FIELD_TYPE, tableName=CUSTOM_FIELD; modifyDataType columnName=FIELD_TYPE, tableName=DENORMALIZED_FIELD_VALUE; modifyDataType columnName=INPUT_TYPE, tableName=D...', 'Fix columns with CHAR(X) types to VARCHAR(X) type to avoid blank space filling by Postgresql', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3577-2', 'jsimon', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.886106', 295, 'EXECUTED', '9:fb5b2745690795c113c0f147b3a8af09', 'createProcedure', 'create function to emulate group concat with separator', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3138-2', 'jsimon', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.889017', 296, 'EXECUTED', '9:ff037747c8bcc2358008b09c51ab3007', 'addNotNullConstraint columnName=CONTENT_ORDER, tableName=CAMPAIGN_LIBRARY_CONTENT; addNotNullConstraint columnName=CONTENT_ORDER, tableName=CLN_RELATIONSHIP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3138-4', 'jsimon', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.891914', 297, 'EXECUTED', '9:c19c302228b58194580701e3cd468690', 'addNotNullConstraint columnName=CONTENT_ORDER, tableName=RLN_RELATIONSHIP; addNotNullConstraint columnName=CONTENT_ORDER, tableName=REQUIREMENT_LIBRARY_CONTENT', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.9.0.feature-3138-6', 'jsimon', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.895947', 298, 'EXECUTED', '9:51f71238d7ddbe7de436f45885565154', 'addNotNullConstraint columnName=CONTENT_ORDER, tableName=TCLN_RELATIONSHIP; addNotNullConstraint columnName=CONTENT_ORDER, tableName=TEST_CASE_LIBRARY_CONTENT', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3693-1', 'bsiri', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.902072', 299, 'EXECUTED', '9:41fbdacfd0bc9f5a52f5bbefca46cdcc', 'addColumn tableName=CALL_TEST_STEP; addForeignKeyConstraint baseTableName=CALL_TEST_STEP, constraintName=fk_call_step_dataset, referencedTableName=DATASET', 'Adding support for call-step level management of datasets', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3693-2', 'bsiri', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.904546', 300, 'EXECUTED', '9:e92bcd6832e2a65bcf646e71c851408c', 'update tableName=CALL_TEST_STEP', 'For back compatibility, the call steps migrating from an existing DB will now be set to delegate the parameters', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3700-1', 'bsiri', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.908341', 301, 'EXECUTED', '9:ac7faa4fa3d747fa7ba9dbb5e2a62555', 'addColumn tableName=CAMPAIGN_TEST_PLAN_ITEM', 'Items of a campaign test plan can now reference Datasets', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.feature-3701-1', 'bsiri', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.911113', 302, 'EXECUTED', '9:c9bbf88a2285d598839b7d6e6d70ac0c', 'addColumn tableName=EXECUTION', 'An execution now remembers which dataset was used (or not). That new column encodes three states :
				"" -> no dataset used,
				somelabel -> the label of the dataset used,
				null -> the test case had no parameters anyway', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.11.0.issue-3914', 'mpagnon', 'tm/tm.changelog-1.11.0.xml', '2025-04-03 16:51:11.920662', 303, 'EXECUTED', '9:d41d8cd98f00b204e9800998ecf8427e', 'empty', 'for some reason in postgresql generated scripts the column "VERSION" is in uppercase instead of lowercase like all other columns', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0', 'jsimon', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:11.923164', 304, 'EXECUTED', '9:429493269560edbfd1933ed82624c8bc', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feature-3607-1', 'jsimon', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:11.943309', 305, 'EXECUTED', '9:695b8c08b6c77eff3631801ef3d4361c', 'createTable tableName=MILESTONE; createIndex indexName=idx_milestone, tableName=MILESTONE', 'Table for Milestones', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feature-3608-1', 'jsimon', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:11.951113', 306, 'EXECUTED', '9:489e875ee38d848700d181d8e1247aa5', 'createTable tableName=MILESTONE_BINDING', 'Table for MilestoneBinding', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feature-3609-1', 'jsimon', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:11.958069', 307, 'EXECUTED', '9:2ed11b539c67acd0e3db3d0b52a2b013', 'createTable tableName=MILESTONE_BINDING_PERIMETER', 'Table for MilestoneBindingPerimeter', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feature-3823-1', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:11.962279', 308, 'EXECUTED', '9:582343b6f52bf45e71174c1f1106dcd4', 'createTable tableName=CUSTOM_FIELD_VALUE_OPTION', 'Creating the values table for multi-valued custom fields, much like CUSTOM_FIELD_OPTION is. 
  	Note : the DELETE CASCADE on the foreign key is necessary because Hibernate won''t do it (as specified, see HHH-5529)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feature-3823-2', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:11.966404', 309, 'EXECUTED', '9:afd83d596b5aad54034f4214cc607f44', 'createTable tableName=DENORMALIZED_FIELD_VALUE_OPTION', 'Same table for the denormalized field values', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feature-3823-3', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:11.969254', 310, 'EXECUTED', '9:59946ce9a3cbd2506a54936e13076320', 'dropNotNullConstraint columnName=POSITION, tableName=CUSTOM_FIELD_OPTION; dropNotNullConstraint columnName=POSITION, tableName=DENORMALIZED_FIELD_OPTION', 'tables CUSTOM_FIELD_OPTION and DENORMALIZED_FIELD_OPTION no longer enforce the option position.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.issue-4017-1', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:11.974185', 311, 'EXECUTED', '9:10ce02dad139ff3788a65f8e43faa4d1', 'modifyDataType columnName=OLD_VALUE, tableName=REQUIREMENT_PROPERTY_CHANGE; modifyDataType columnName=NEW_VALUE, tableName=REQUIREMENT_PROPERTY_CHANGE', 'Some columns in REQUIREMENT_PROPERTY_CHANGE are too short compared to what 
  	they are supposed to store. This changeset makes them bigger.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-4068-1', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.005058', 312, 'EXECUTED', '9:5598c4e45e6b7b20b4823cc804ea1bdf', 'createTable tableName=INFO_LIST; createIndex indexName=idx_info_list_code, tableName=INFO_LIST; createTable tableName=INFO_LIST_ITEM; createIndex indexName=idx_info_list_item_code, tableName=INFO_LIST_ITEM; createIndex indexName=idx_info_list_labe...', 'creating the table structure for parameterized list', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-4068-2', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.012617', 313, 'EXECUTED', '9:d114f8e367663913eb6d86a62d9f6608', 'addColumn tableName=EXECUTION', 'Updating the definition of an execution', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-4068-3', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.051917', 314, 'EXECUTED', '9:7750bf882350055deb61911b03e95154', 'insert tableName=INFO_LIST; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO...', 'inserting the default lists in the database', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-4068-4', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.061586', 315, 'EXECUTED', '9:653ecc8e541e7cbc0cfb5845c3497537', 'addColumn tableName=PROJECT', 'other structural modifications', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-4068-6', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.079486', 316, 'EXECUTED', '9:c32add07e209cf473783ad3ab69fb186', 'renameColumn newColumnName=TC_NATURE_OLD, oldColumnName=TC_NATURE, tableName=TEST_CASE; addColumn tableName=TEST_CASE; sql; dropColumn columnName=TC_NATURE_OLD, tableName=TEST_CASE; renameColumn newColumnName=TC_TYPE_OLD, oldColumnName=TC_TYPE, ta...', 'migrate the test cases', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-4068-7', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.089854', 317, 'EXECUTED', '9:192418472ddb76a3acf31286c62a0729', 'renameColumn newColumnName=CATEGORY_OLD, oldColumnName=CATEGORY, tableName=REQUIREMENT_VERSION; addColumn tableName=REQUIREMENT_VERSION; sql; dropColumn columnName=CATEGORY_OLD, tableName=REQUIREMENT_VERSION', 'migrate the requirements', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-4068-8', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.104989', 318, 'EXECUTED', '9:8a84c825ddbb702ba1f61aa1f56450d2', 'sql; dropColumn columnName=TC_NATURE, tableName=EXECUTION; dropColumn columnName=TC_TYPE, tableName=EXECUTION', 'migrating the columns from EXECUTION', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-3764-1', 'flaurens', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.152536', 320, 'EXECUTED', '9:d71eaa4260e74f09e4164558064ee879', 'createTable tableName=oauth_client_details; createTable tableName=oauth_client_token; createTable tableName=oauth_access_token; createTable tableName=oauth_refresh_token; createTable tableName=oauth_code; createTable tableName=oauth_approvals; add...', 'Tables for OAuth2 Support', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-4171-1', 'jsimon', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.156886', 321, 'EXECUTED', '9:75df193f617f44a92a014e2b8d7ba21c', 'insert tableName=CORE_CONFIG; insert tableName=CORE_CONFIG; insert tableName=CORE_CONFIG', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.0.feat-3611-1', 'bsiri', 'tm/tm.changelog-1.12.0.xml', '2025-04-03 16:51:12.180046', 322, 'EXECUTED', '9:7c703e6f91c8d9155f819dc32ef7204b', 'createTable tableName=MILESTONE_TEST_CASE; createTable tableName=MILESTONE_REQ_VERSION; createTable tableName=MILESTONE_CAMPAIGN', 'Creating the tables modeling the relationships between milestones and test cases, requirement versions 
    		and campaigns', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.3', 'bsiri', 'tm/tm.changelog-1.12.3.xml', '2025-04-03 16:51:12.187129', 323, 'EXECUTED', '9:27ad51ddd6e2d187067f57058376cdd2', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.3-issue-5965-1-1-postgresql', 'bsiri', 'tm/tm.changelog-1.12.3.xml', '2025-04-03 16:51:12.200883', 324, 'EXECUTED', '9:e6b3c7a05c3cbae2c0b4f2fd668a82df', 'sql', 'Fixing data in TCLN_RELATIONSHIP_CLOSURE that need to be', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.3-issue-5965-1-2-postgresql', 'bsiri', 'tm/tm.changelog-1.12.3.xml', '2025-04-03 16:51:12.209466', 325, 'EXECUTED', '9:47ccdf92dfdda0d436bcf75e1459a660', 'sql', 'Fixing data in RLN_RELATIONSHIP_CLOSURE that need to be', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.3-issue-5965-1-3-postgresql', 'bsiri', 'tm/tm.changelog-1.12.3.xml', '2025-04-03 16:51:12.216489', 326, 'EXECUTED', '9:a555d3cf230195390181a24111931eaf', 'sql', 'Fixing data in CLN_RELATIONSHIP_CLOSURE that need to be', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.12.3-issue-5965-2-1', 'bsiri', 'tm/tm.changelog-1.12.3.xml', '2025-04-03 16:51:12.225985', 327, 'EXECUTED', '9:f4abdbce1a28b0ab9becf9bc6fcbda5d', 'addUniqueConstraint constraintName=uniq_tcln_clos, tableName=TCLN_RELATIONSHIP_CLOSURE; addUniqueConstraint constraintName=uniq_rln_clos, tableName=RLN_RELATIONSHIP_CLOSURE; addUniqueConstraint constraintName=uniq_cln_clos, tableName=CLN_RELATIONS...', 'now we can add the unique constraints on the closure tables', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0', 'bsiri', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.22882', 328, 'EXECUTED', '9:8713391d2b6738d9f514d582039d2062', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5155-1', 'jsimon', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.243438', 329, 'EXECUTED', '9:dc1a897940bc0023d3b768ba839fb49f', 'createTable tableName=BUGTRACKER_PROJECT; createIndex indexName=idx_bugtracker_project, tableName=BUGTRACKER_PROJECT; sql; dropColumn columnName=PROJECT_NAME, tableName=BUGTRACKER_BINDING', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5162-1', 'bsiri', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.250148', 330, 'EXECUTED', '9:aaecf26aa114572a410ce65e5a34c08f', 'addColumn tableName=CAMPAIGN; addColumn tableName=ITERATION; sql', 'Now campaigns and iterations have a reference too', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-4022-1', 'jsimon', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.253048', 331, 'EXECUTED', '9:b38e23cf632fc5bf00c0a571663c5203', 'addColumn tableName=PROJECT', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5292-issues', 'bsiri', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.26604', 332, 'EXECUTED', '9:f2509d05bba24aa5b1e085590e65cbe6', 'createView viewName=EXECUTION_ISSUES_CLOSURE', 'creating a view that helps querying on all the issues reported in an execution because
			querying EXECUTION and EXECUTION_STEP separately is just a pain in the ass.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5375-1', 'jsimon, bsiri', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.345147', 333, 'EXECUTED', '9:d7cfc7b0ffe5e31d5c0467bd6bd14766', 'createTable tableName=CHART_QUERY; createTable tableName=CHART_DEFINITION; createIndex indexName=idx_chart_definition, tableName=CHART_DEFINITION; createTable tableName=CHART_COLUMN_PROTOTYPE; createIndex indexName=idx_column_prototype, tableName=...', 'The table CHART_QUERY aggregates 1..* CHART_MEASURE_COLUMN, 1..* CHART_AXIS_COLUMN and 0..* CHART_FILTER
			(see these table for more informations). It may be referenced by either a CHART_DEFINITION (as a query),
			either a COLUMN_PROTOTYPE (as a...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5375-2', 'bsiri', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.45697', 334, 'EXECUTED', '9:9f25841201b71860586b08cc83a6d472', 'sql', 'populate the column prototype referential data (generated from src/main/script/MakeChartColumns.groovy)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5292-1', 'jthebault', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.538374', 335, 'EXECUTED', '9:6eff1852ae2676acec5dee07bd0b9187', 'createTable tableName=CUSTOM_REPORT_LIBRARY; createIndex indexName=IDX_CUSTOM_REPORT_LIBRARY, tableName=CUSTOM_REPORT_LIBRARY; createTable tableName=CUSTOM_REPORT_LIBRARY_NODE; createTable tableName=CRLN_RELATIONSHIP; createIndex indexName=idx_crl...', 'This table contains the relations between two custom reports nodes. If a node is root, parent id will be null and descendant id will be itself.
		a given node can be referenced as descendant only one time so we can map the join with hibernate
clos...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feat-5292-2-postgresql', 'jthebault', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.546755', 336, 'EXECUTED', '9:64fe9e066f5fd6bcd6b960a17fbf1b83', 'createProcedure; createProcedure; createProcedure; createProcedure', 'postgresql-triggers for CRLN_RELATIONSHIP_CLOSURE table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feat-5292-3', 'jthebault', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.558393', 337, 'EXECUTED', '9:f62dac68c224ae6606fcdaeb58cc1f9a', 'sql; sql; sql; sql; dropColumn columnName=TMP_CRL_ID, tableName=ATTACHMENT_LIST', 'Migration for custom report workspace evolution. Mainly create the Library entities and their nodes, attachement list...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5292-4', 'bsiri', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.563952', 338, 'EXECUTED', '9:38db6b69ea513581f7549b1700016fc1', 'addForeignKeyConstraint baseTableName=PROJECT, constraintName=fk_project_crl, referencedTableName=CUSTOM_REPORT_LIBRARY; addForeignKeyConstraint baseTableName=CUSTOM_REPORT_LIBRARY, constraintName=fk_crl_attachment_list, referencedTableName=ATTACH...', 'set the foreign key constraints from project to custom report library, and from custom report_library to attachment_list', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5292-5', 'jthebault', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.567813', 339, 'EXECUTED', '9:1075599ee3061c2846ed0a8bdc0d3d82', 'sql', 'update the sequences afterward', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5375-3', 'jsimon, bsiri', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.572634', 340, 'EXECUTED', '9:6869d56f0ea4713269a3644a64be295e', 'sql', 'update the sequences afterward', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5375-4', 'jsimon', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.580037', 341, 'EXECUTED', '9:7e7a9ddd8bc1f61c3049be72565407a9', 'createTable tableName=CHART_PROJECT_SCOPE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5265-1', 'bsiri', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.592524', 342, 'EXECUTED', '9:96a655faa7ad432d018c12910b733bcb', 'createTable tableName=REQUIREMENT_SYNC_EXTENDER', 'This table holds the optional extension for requirement, that flags them as synchronized requirement', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.0-feature-5265-2', 'bsiri', 'tm/tm.changelog-1.13.0.xml', '2025-04-03 16:51:12.596082', 343, 'EXECUTED', '9:122d987c9fefaa781e63cfe952500181', 'addColumn tableName=REQUIREMENT', 'adding a column recording how a requirement should be managed', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.1', 'jthebault', 'tm/tm.changelog-1.13.1.xml', '2025-04-03 16:51:12.599039', 344, 'EXECUTED', '9:d7949e161e9f7437b59fff7c37518751', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.1-ACL-Custom-Report-Library', 'jthebault', 'tm/tm.changelog-1.13.1.xml', '2025-04-03 16:51:12.609625', 345, 'EXECUTED', '9:1ed5e62e089f118c6ed505ab27498a2f', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.3', 'bsiri', 'tm/tm.changelog-1.13.3.xml', '2025-04-03 16:51:12.612273', 346, 'EXECUTED', '9:9977c644e5ca1267a0ffe2ac54ec1b4a', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.3-feature-5265-1', 'bsiri', 'tm/tm.changelog-1.13.3.xml', '2025-04-03 16:51:12.61734', 347, 'EXECUTED', '9:a23998a38f21e276d45f3af879be999b', 'modifyDataType columnName=PLUGIN_BINDING_VALUE, tableName=LIBRARY_PLUGIN_BINDING_PROPERTY', 'making the capacity of plugin configuration items larger', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.3-feature-5265-2', 'bsiri', 'tm/tm.changelog-1.13.3.xml', '2025-04-03 16:51:12.628704', 348, 'EXECUTED', '9:d65f371a9ca4d839504e2b5c7763faf0', 'addColumn tableName=REQUIREMENT_SYNC_EXTENDER; dropForeignKeyConstraint baseTableName=REQUIREMENT_SYNC_EXTENDER, constraintName=fk_sync_extender_bugtracker; renameColumn newColumnName=SERVER_ID, oldColumnName=BUGTRACKER_ID, tableName=REQUIREMENT_S...', 'reworking table REQUIREMENT_SYNC_EXTENDER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.3-feature-5265-3', 'bsiri', 'tm/tm.changelog-1.13.3.xml', '2025-04-03 16:51:12.636009', 349, 'EXECUTED', '9:908cc53488063fb68e86a65cda21f931', 'createIndex indexName=idx_sync_remote_req_id, tableName=REQUIREMENT_SYNC_EXTENDER; createIndex indexName=idx_sync_remote_projfilter, tableName=REQUIREMENT_SYNC_EXTENDER', 'adding useful indexes', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.3-feature-5265-4', 'bsiri', 'tm/tm.changelog-1.13.3.xml', '2025-04-03 16:51:12.640318', 350, 'EXECUTED', '9:c22ab9913269237141870c54245e174d', 'createView viewName=RLN_RESOURCE', 'This view maps a requirement library node to its main resource. Some would say 
			it is redundant with what can be found in tables REQUIREMENT or REQUIREMENT_FOLDER
			but seriously it makes simple things likes getting the name of a generic 
			R...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.3-feature-5265-5', 'bsiri', 'tm/tm.changelog-1.13.3.xml', '2025-04-03 16:51:12.650807', 351, 'EXECUTED', '9:5a67df40bf142f51b6b6915a8ddb427b', 'createTable tableName=SYNC_REQUIREMENT_CREATION; createTable tableName=SYNC_REQUIREMENT_UPDATE', 'new requirement audit trail tables for synchronization events', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.5', 'jthebault', 'tm/tm.changelog-1.13.5.xml', '2025-04-03 16:51:12.65325', 352, 'EXECUTED', '9:0cf43d062195bb32a7e5c9ef68e23077', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.13.5-issue-6291', 'jthebault', 'tm/tm.changelog-1.13.5.xml', '2025-04-03 16:51:12.656161', 353, 'EXECUTED', '9:24770e278e94c823f0c536591fbc87ed', 'sql', 'Delete orphan lines in cuf values. Only for cuf values bind to a removed execution.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.14.0', 'bsiri', 'tm/tm.changelog-1.14.0.xml', '2025-04-03 16:51:12.662374', 354, 'EXECUTED', '9:850550c42549905459f1af26a31ad290', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.14.0-feature-5416', 'jthebault', 'tm/tm.changelog-1.14.0.xml', '2025-04-03 16:51:12.671324', 355, 'EXECUTED', '9:8836064b5a9cb111a973ef2e996af038', 'createTable tableName=PARTY_PREFERENCE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.14.1', 'bsiri', 'tm/tm.changelog-1.14.1.xml', '2025-04-03 16:51:12.673858', 356, 'EXECUTED', '9:ac4792059af1781386194797802b625b', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.14.1-issue-6340-1', 'bsiri', 'tm/tm.changelog-1.14.1.xml', '2025-04-03 16:51:12.678837', 357, 'EXECUTED', '9:4b95ecdad7ffe16617eb3031c3a4d62d', 'dropForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_OPTION, constraintName=fk_df_option_dfv; addForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_OPTION, constraintName=fk_df_option_dfv, referencedTableName=DENORMALIZED_FIELD_VALUE', 'For the purpose of the cleanup to come, we must activate on delete cascade
            between DENORMALIZED_FIELD_OPTION and DENORMALIZED_FIELD_VALUE', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.14.1-issue-6340-2a', 'bsiri', 'tm/tm.changelog-1.14.1.xml', '2025-04-03 16:51:12.683955', 358, 'EXECUTED', '9:909d25d046e817813fa9b61148790ad4', 'sql', 'Fixing the extraneous custom field values (for test cases) and denormalized field values (for executions)
          for Postgresql.
          Note about the ordering (in the partition instruction) : I''ve empirically found that it must be ascending...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.14.1-issue-6340-3', 'bsiri', 'tm/tm.changelog-1.14.1.xml', '2025-04-03 16:51:12.690331', 359, 'EXECUTED', '9:58ec5074e63f4f7198fb4890c61194af', 'addUniqueConstraint constraintName=u_dfv_id_type_code, tableName=DENORMALIZED_FIELD_VALUE; addUniqueConstraint constraintName=u_cfv_id_type_binding, tableName=CUSTOM_FIELD_VALUE', 'enforcing uniticy on the custom field values and denormalized field values -
          if later on there are more double insert let it fail fast', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.15.0', 'jthebault', 'tm/tm.changelog-1.15.0.xml', '2025-04-03 16:51:12.692841', 360, 'EXECUTED', '9:dd722049d224212fb51f80869606f035', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.15.0-feature-6365', 'jthebault', 'tm/tm.changelog-1.15.0.xml', '2025-04-03 16:51:12.698479', 361, 'EXECUTED', '9:6543e231c93fce9ccac0531bfa9667d0', 'addColumn tableName=CUSTOM_FIELD; addColumn tableName=CUSTOM_FIELD_VALUE; addColumn tableName=DENORMALIZED_FIELD_VALUE', 'column for numeric cufs', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.15.0-cuf-custom-report-1', 'jthebault', 'tm/tm.changelog-1.15.0.xml', '2025-04-03 16:51:12.715017', 362, 'EXECUTED', '9:61a42ece8a2c3511e2475296e078a12a', 'createTable tableName=TEMP_CUF_ID; createIndex indexName=idx_tmp_cuf_cuf_id, tableName=TEMP_CUF_ID; createIndex indexName=idx_tmp_cuf_cfv_id, tableName=TEMP_CUF_ID; addColumn tableName=CUSTOM_FIELD_VALUE; createIndex indexName=idx_cfv_custom_field...', 'Denormalize the cuf ID inside the cuf values, so we don''t have to make two more joins in custom reports', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.15.0-cuf-custom-report-2', 'jthebault', 'tm/tm.changelog-1.15.0.xml', '2025-04-03 16:51:12.746663', 363, 'EXECUTED', '9:b1568c52e2b1f979b85deb536dd37c46', 'sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; addColumn tableName=CHART_MEASURE_COLUMN; addColumn tableName=CHART_AXIS_COLUMN; addColumn tableName=CHART_FILTER', 'columns prototypes for custom fields bound to requirement version.
columns prototypes for custom fields bound to test case.
columns prototypes for custom fields bound to campaign.
columns prototypes for custom fields bound to iteration.
columns pr...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.15.0-feat-5417', 'jthebault', 'tm/tm.changelog-1.15.0.xml', '2025-04-03 16:51:12.752835', 364, 'EXECUTED', '9:c545a6a016adc5c43c6a611d5e904788', 'addColumn tableName=CHART_DEFINITION; sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.15.0-feat-5417-2', 'jthebault', 'tm/tm.changelog-1.15.0.xml', '2025-04-03 16:51:12.756625', 365, 'EXECUTED', '9:d5fdcb70dab4e3db73de134ff5e72ee0', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.15.0-feat-5417-3', 'jthebault', 'tm/tm.changelog-1.15.0.xml', '2025-04-03 16:51:12.759253', 366, 'EXECUTED', '9:f4cf4dd34381905ffd5a0feee0ae56da', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.16.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.16.0.xml', '2025-04-03 16:51:12.76333', 367, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.16.0', 'jprioux', 'tm/tm.changelog-1.16.0.xml', '2025-04-03 16:51:12.766827', 368, 'EXECUTED', '9:337fe8616ee977c66078a4217e21010d', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.16.0-feature-6763', 'jprioux', 'tm/tm.changelog-1.16.0.xml', '2025-04-03 16:51:12.770024', 369, 'EXECUTED', '9:3ae25d903630d96e4645f0b047e9b1ae', 'addColumn tableName=CORE_USER', 'column for last connected on', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.16.0-feature-6799', 'jlor', 'tm/tm.changelog-1.16.0.xml', '2025-04-03 16:51:12.787649', 370, 'EXECUTED', '9:49c48042126942ed46ace3bcc4439ef1', 'createTable tableName=REQUIREMENT_VERSION_LINK_TYPE; createTable tableName=REQUIREMENT_VERSION_LINK; insert tableName=REQUIREMENT_VERSION_LINK_TYPE; insert tableName=REQUIREMENT_VERSION_LINK_TYPE; insert tableName=REQUIREMENT_VERSION_LINK_TYPE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.791792', 371, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0', 'jthebault', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.794376', 372, 'EXECUTED', '9:57285f4f957eb02d5142441d546fda90', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0-feature-6921', 'zyang', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.798421', 373, 'EXECUTED', '9:78f7e9ddb47a0ea217fa5643dee0490e', 'addColumn tableName=CAMPAIGN; addColumn tableName=ITERATION', 'Adds a status field to campaign and iteration', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0', 'zyang', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.811753', 374, 'EXECUTED', '9:cda227b3707fb0a3c1d93292fd1655bf', 'createTable tableName=REPORT_DEFINITION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0-feature-6921', 'cholc', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.815124', 375, 'EXECUTED', '9:16ba619e149b0ebd1f5a4e66b445fcfc', 'addColumn tableName=TEST_SUITE', 'Adds a execution status field to the test suites', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0-feature-sqtm-167', 'bsiri', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.826737', 376, 'EXECUTED', '9:18dc5e9c110b3befde9431b4352cea19', 'createTable tableName=STORED_CREDENTIALS; addColumn tableName=BUGTRACKER', 'Adding the ability to use application-level credentials that allows Squash interact with a bugtracker on its own
      (ie instead of requiring the current user to authenticate).', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0-jira-sync-01', 'jthebault', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.837888', 377, 'EXECUTED', '9:31d6dfea11625975512c852032ca167b', 'createTable tableName=REMOTE_SYNCHRONISATION', 'Add a remote synchronisation table in squash tm.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0-jira-sync-02', 'jthebault', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.848087', 378, 'EXECUTED', '9:7de4128221dba87940252cb083fe2ce9', 'createTable tableName=REQUIREMENT_FOLDER_SYNC_EXTENDER', 'Add a remote folder synchronisation table in squash tm.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0-jira-sync-03', 'jthebault', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.857711', 379, 'EXECUTED', '9:7a615974c5faa61841df5749c6ce00d9', 'dropNotNullConstraint columnName=REMOTE_FILTER_NAME, tableName=REQUIREMENT_SYNC_EXTENDER; addColumn tableName=REQUIREMENT_SYNC_EXTENDER; createIndex indexName=req_sync_extender_remote_parent_id_idx, tableName=REQUIREMENT_SYNC_EXTENDER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.17.0-Issue-6967', 'jthebault', 'tm/tm.changelog-1.17.0.xml', '2025-04-03 16:51:12.8614', 380, 'EXECUTED', '9:f13ff49c3e1fc8de7b13a9e4fb59408e', 'createIndex indexName=tcln_name_idx, tableName=TEST_CASE_LIBRARY_NODE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.865331', 381, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0', 'jthebault', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.867712', 382, 'EXECUTED', '9:c2855ffdf2b90b2223f94c0d92b94638', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-connection-log-table', 'aguilhem', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.875278', 383, 'EXECUTED', '9:0651aa90288d064d3e7508ea6a8a4e92', 'createTable tableName=CONNECTION_ATTEMPT_LOG', 'Create Connection Attempt Log Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-project-template-link', 'jlor', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.879005', 384, 'EXECUTED', '9:92710907129050b19ff66c5f1917caf1', 'addColumn tableName=PROJECT', 'Adding a column to keep the link between a Project and a Project Template', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-feature-7183.1-postgresql', 'jprioux', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.897437', 385, 'EXECUTED', '9:d12fc485e321d277f6e967e464711954', 'sql; addUniqueConstraint constraintName=uc_test_case_steps_order, tableName=TEST_CASE_STEPS', 'postgresql - add unique constraint for ordered list : test case steps', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-feature-7183.2-postgresql', 'jprioux', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.915448', 386, 'EXECUTED', '9:fa9c1c8e67d76efd14d19d01e5e5d9b0', 'sql; addUniqueConstraint constraintName=uc_item_test_plan_list_order, tableName=ITEM_TEST_PLAN_LIST', 'postgresql - add unique constraint for ordered list : tcs in iteration', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-feature-7183.3-postgresql', 'jprioux', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.929323', 387, 'EXECUTED', '9:0cd575c9f1f14154589b622681d64690', 'sql; addUniqueConstraint constraintName=uc_test_suite_test_plan_item_order, tableName=TEST_SUITE_TEST_PLAN_ITEM', 'postgresql - add unique constraint for ordered list : tcs in test suite', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-feature-7183.4-postgresql', 'jprioux', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.948281', 388, 'EXECUTED', '9:20f5249c9a6797e06827ba2324d5b6b4', 'sql; addUniqueConstraint constraintName=uc_campaign_test_plan_item_order, tableName=CAMPAIGN_TEST_PLAN_ITEM', 'postgresql - add unique constraint for ordered list : tcs in campaign', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-binding-report-to-dashboard', 'zyang', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.957064', 389, 'EXECUTED', '9:7d3d066148e8460b60443662a234739e', 'createTable tableName=CUSTOM_REPORT_REPORT_BINDING', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-scripted-test-case', 'jthebault', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.978733', 390, 'EXECUTED', '9:4430a0a3851e853afc85e757d73fbb7b', 'createTable tableName=SCRIPTED_TC_EXTENDER; createIndex indexName=scripted_tc_extender_test_case_id_idx, tableName=SCRIPTED_TC_EXTENDER; createTable tableName=SCRIPTED_EXECUTION_EXTENDER; createIndex indexName=scripted_execution_extender_execution...', 'Create the scripted test case table
Create the scripted execution table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-modification-report', 'zyang', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.981974', 391, 'EXECUTED', '9:9c614ded74cec275af362a7cf4a5e72f', 'addColumn tableName=REPORT_DEFINITION', 'Adds a summary field to report definition', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-Mantis-7833', 'jprioux', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.155751', 415, 'EXECUTED', '9:8f39425a32e3bc9f90232048ce6d67ad', 'modifyDataType columnName=REMOTE_PROJECT_ID, tableName=REQUIREMENT_SYNC_EXTENDER', 'Increase remote project id limit to 100 for redmine bt project keys', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-oauth1a-consumer-1', 'bsiri', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.990286', 392, 'EXECUTED', '9:3c2932090b24192dd18085a1e77567c2', 'addColumn tableName=STORED_CREDENTIALS; addUniqueConstraint constraintName=uniq_stored_credentials_server_user, tableName=STORED_CREDENTIALS', 'StoredCredentials can now store either credentials, either general configuration.
        A new column appear so we can hint what is the type of the payload.
        Also, users can now have stored credentials (even though they can''t manage them y...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-oauth1a-consumer-2', 'bsiri', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.993024', 393, 'EXECUTED', '9:a886ad2654c657f6cedb5eb5152ade39', 'addColumn tableName=BUGTRACKER', 'Bugtracker now declare which authentication protocol should be used upfront.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.18.0-email-column-resizing', 'aguilhem', 'tm/tm.changelog-1.18.0.xml', '2025-04-03 16:51:12.999079', 394, 'EXECUTED', '9:ca643d72d5016b2c9798bc9e2edaf76c', 'modifyDataType columnName=EMAIL, tableName=CORE_USER; addDefaultValue columnName=EMAIL, tableName=CORE_USER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.002762', 395, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0', 'cholc', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.004998', 396, 'EXECUTED', '9:eff1c971d8eec47bf604c8e1ed38b7bd', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-400-info-list-item', 'cholc', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.007272', 397, 'EXECUTED', '9:067671d8069835a0fd748c2d43c02e29', 'addColumn tableName=INFO_LIST_ITEM', 'Adds a colour field to info list items', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-400-custom-field-option', 'cholc', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.009744', 398, 'EXECUTED', '9:af725d932a6447d0e999703d0e680553', 'addColumn tableName=CUSTOM_FIELD_OPTION', 'Adds a colour field to custom field options', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-409-iteration-test-suite-remove-constraint', 'cholc', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.020932', 399, 'EXECUTED', '9:45ffc234903fa352b98d3510b8780da6', 'addColumn tableName=ITERATION_TEST_SUITE; dropForeignKeyConstraint baseTableName=ITERATION_TEST_SUITE, constraintName=fk_iteration_test_suite_suite; update tableName=ITERATION_TEST_SUITE; dropColumn columnName=TEST_SUITE_ID, tableName=ITERATION_TE...', 'To drop an unique constraint, you need the constraint''s name, which we don''t have, so here we copy the
      column and delete the original', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-409-iteration-test-suite-order', 'cholc', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.023554', 400, 'EXECUTED', '9:1b85c347f68070f1cdfd0fb865767acd', 'addColumn tableName=ITERATION_TEST_SUITE', 'add an order to iterations'' test suites', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-409-iteration-test-suite-order-generation', 'cholc', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.02993', 401, 'EXECUTED', '9:e438bc98a24a3bbd7273666b563f0f93', 'sql; addUniqueConstraint constraintName=uc_iteration_iteration_test_suite_order, tableName=ITERATION_TEST_SUITE; addNotNullConstraint columnName=ITERATION_TEST_SUITE_ORDER, tableName=ITERATION_TEST_SUITE', 'will compute the order of the test suites in the iterations, should work for all databases', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-up-sb2-1', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.040639', 402, 'EXECUTED', '9:36eb4f092787eecca0c7840f0ffdc284', 'modifyDataType columnName=PASSWORD, tableName=AUTH_USER', 'Passwords are now much longer since we also store the salt.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-399-infolist-items-default-colours', 'cholc', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.06132', 403, 'EXECUTED', '9:fc071ffb52c30da0d0e3d426e738bd1b', 'update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName...', 'Requirement categories colours
Test cases natures colours
Test cases types colours', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-453-execution-name-maxlength', 'jprioux', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.065665', 404, 'EXECUTED', '9:15ee16d69208ef06b4f75ff24d136015', 'modifyDataType columnName=NAME, tableName=EXECUTION; addNotNullConstraint columnName=NAME, tableName=EXECUTION', 'Increase max length for execution name', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-508-automation-request', 'aboittiaux', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.092973', 405, 'EXECUTED', '9:316e5c23c83e05d764907e9c780ec01e', 'createTable tableName=AUTOMATION_REQUEST; createIndex indexName=automation_request_assigned_to_idx, tableName=AUTOMATION_REQUEST; createIndex indexName=automation_request_created_by_idx, tableName=AUTOMATION_REQUEST; createIndex indexName=automati...', 'Create table AUTOMATION_REQUEST to Gherkin''s test cases', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-1', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.102301', 406, 'EXECUTED', '9:1437dcd9890f160465cfa6d4ce6b4b8c', 'createTable tableName=AUTOMATION_REQUEST_LIBRARY; createIndex indexName=idx_automation_request_library, tableName=AUTOMATION_REQUEST_LIBRARY', 'Creating the AutomationRequestLibrary', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-2', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.110113', 407, 'EXECUTED', '9:45d2534bf74533807abe95d91a6db9cf', 'sql', 'New entries in the ACL infrastructure.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-3', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.120519', 408, 'EXECUTED', '9:f3dc3901ec87f10cbdc4d46d0b847dca', 'createTable tableName=AUTOMATION_REQUEST_LIBRARY_CONTENT; createIndex indexName=idx_automation_request_lib_content_content, tableName=AUTOMATION_REQUEST_LIBRARY_CONTENT; createIndex indexName=idx_automation_request_lib_content_lib, tableName=AUTOM...', 'The automation request library content table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-4', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.12626', 409, 'EXECUTED', '9:3d27b60550e75d35493319166ce1dc6a', 'addColumn tableName=PROJECT', 'Add a Project fk to the AutomationRequestLibrary', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-5', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.137131', 410, 'EXECUTED', '9:2481ea91eac797061e9287a05cab6be0', 'sql', 'Create one such library for each existing projects', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-6', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.141584', 411, 'EXECUTED', '9:2ed9deb1adbaa0cb8d87bf6790da6de6', 'sql', 'reset postgresql sequences', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-510-add-roles-automation', 'aboittiaux', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.144928', 412, 'EXECUTED', '9:afd0d6403e5aa7c7ce4bf6374447b9ff', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-524-automation-workflow-by-project', 'jprioux', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.147711', 413, 'EXECUTED', '9:ef0d486e6dba703c5b4570088045e696', 'addColumn tableName=PROJECT', 'add a boolean in project table to activate or not the automation workflow', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-create-auth-users', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.152041', 414, 'EXECUTED', '9:f2938a30259232e2a568d9dc5f7e7f2f', 'sql', 'add the missing entries in AUTH_USER for users that only exist in CORE_USER (eg a user created by LDAP)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-536-autoexec-gherkin-1', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.158721', 416, 'EXECUTED', '9:17befe0509e2dedbeb0a654884329975', 'addColumn tableName=TEST_AUTOMATION_PROJECT', 'Add a flag to the test automation project that tells whether it is able to run Gherkin tests.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-543-third-party-server-1', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.170004', 417, 'EXECUTED', '9:7726d9e696ac3cc2261d345ba7ee9d52', 'createTable tableName=THIRD_PARTY_SERVER', 'Create the table THIRD_PARTY_SERVER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-543-third-party-server-2', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.178319', 418, 'EXECUTED', '9:7352e438a22fc01b05fbcbc679b56441', 'sql', 'migrate data from table BUGTRACKER to table THIRD_PARTY_SERVER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-543-third-party-server-3', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.184933', 419, 'EXECUTED', '9:f979d094803c4102bea6610cb054ad54', 'dropColumn columnName=NAME, tableName=BUGTRACKER; dropColumn columnName=URL, tableName=BUGTRACKER; dropColumn columnName=AUTH_POLICY, tableName=BUGTRACKER; dropColumn columnName=AUTH_PROTOCOL, tableName=BUGTRACKER; addForeignKeyConstraint baseTabl...', 'Drop the now unused columns from BUGTRACKER and create the FK from BUGTRACKER to THIRD_PARTY_SERVER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-543-third-party-server-4', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.191976', 420, 'EXECUTED', '9:9f638a35cd9a4789069b05c824f42bf8', 'dropForeignKeyConstraint baseTableName=STORED_CREDENTIALS, constraintName=fk_stored_credentials_authenticated_server; createIndex indexName=idx_fk_stored_credentials_authenticated_server, tableName=STORED_CREDENTIALS; addForeignKeyConstraint baseT...', 'change the foreign key stored_credentials -> bugtracker to stored_credentials -> third_party_server', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-543-third-party-server-5-postgres', 'bsiri', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.207429', 421, 'EXECUTED', '9:6247758607c569f5f09ca8b8e6338808', 'sql', 'For PostGre, remove the autoincrement on bugtracker_id and reset the sequence for third_party_server', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-512-scm-server-management', 'jlor', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.218628', 422, 'EXECUTED', '9:734d81bb3aaa2d9d9a6a4c8c1eaabd76', 'createTable tableName=SCM_SERVER; addForeignKeyConstraint baseTableName=SCM_SERVER, constraintName=fk_scm_server_third_party_server, referencedTableName=THIRD_PARTY_SERVER', 'Add new table for scm (source code management) server.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-512-scm-repository-management', 'jlor', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.233284', 423, 'EXECUTED', '9:914a3500cb14f270054044fbf2a18df6', 'createTable tableName=SCM_REPOSITORY; addUniqueConstraint tableName=SCM_REPOSITORY', 'Add new table for scm (source code management) repository.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-SQTM-512-project-scm-repository-binding', 'jlor', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.23798', 424, 'EXECUTED', '9:03a74788621875de175bc7d838571b04', 'addColumn tableName=PROJECT', 'Add foreign key in project table to reference a scm (source code management) repository.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-fixing-postgresql-index', 'jthebault', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.524801', 425, 'EXECUTED', '9:f90006e12da3c1b4bd555a47daff2206', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.19.0-Mantis-7547', 'jprioux', 'tm/tm.changelog-1.19.0.xml', '2025-04-03 16:51:13.52873', 426, 'EXECUTED', '9:1b6627142d31bc9e2e6af33965f80ab3', 'modifyDataType columnName=REMOTE_REQ_ID, tableName=REQUIREMENT_SYNC_EXTENDER', 'Increase remote req id limit to 50 for jira', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.532581', 427, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0', 'jprioux', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.534902', 428, 'EXECUTED', '9:5d765a6cd877358f66c4542c39752226', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-176-custom-report-custom-export', 'jlor', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.545531', 429, 'EXECUTED', '9:834abf766e929cbbca2f3826fffec560', 'createTable tableName=CUSTOM_REPORT_CUSTOM_EXPORT; createIndex indexName=idx_fk_custom_export_project_id, tableName=CUSTOM_REPORT_CUSTOM_EXPORT', 'Create new object CustomExport in Custom Report Workspace', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-125-use-tm-tree-structure-in-scm-repository', 'jlor', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.548844', 430, 'EXECUTED', '9:8084c474cef3ddd1705037d63048aaaf', 'addColumn tableName=PROJECT', 'Add an option in Project automation settings to use the tm tree structure when transmitting test cases to a scm repository', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-220-add-missing-role-automation', 'agu', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.552237', 431, 'EXECUTED', '9:cdbe7ac46bba5f0109b57ea6145b3275', 'sql', 'Add missing automation role following changeset tm-1.19.0-SQTM-510-add-roles-automation', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-91-custom-export-column', 'jlor', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.559762', 432, 'EXECUTED', '9:a4939095fc7a00c732526561c5c182b8', 'createTable tableName=CUSTOM_EXPORT_SCOPE; createTable tableName=CUSTOM_EXPORT_COLUMN', 'Create new tables to store the scope and the columns of a custom export', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-13-add-conflict-association-ismanual', 'amk', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.565612', 433, 'EXECUTED', '9:0dac9ddba2cd3648f3480e49ad76e1a5', 'addColumn tableName=AUTOMATION_REQUEST', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-13-update-is-manual', 'amk', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.572655', 434, 'EXECUTED', '9:8f4f8db7a039babb659392d8f8c315c4', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-13-association-auto-cdt-script-auto', 'amk', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.577935', 435, 'EXECUTED', '9:c917e88c45379700cb5e17dc9aee8983', 'addColumn tableName=TEST_CASE; addUniqueConstraint constraintName=uc_test_case_uuid, tableName=TEST_CASE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-13-create-uuid-module-postgresql', 'aguilhem', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.581059', 436, 'EXECUTED', '9:81c537de32df5800f4a00e09afcd6cc7', 'sql', 'create uuid extension if not exist (for postgresql > 9.1', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-13-update-uuid-postgresql', 'amk', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.588995', 437, 'EXECUTED', '9:fb78b5be9cfb957f1632a3e1b1c8a7ce', 'sql', 'generate uuid if it''s null', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-503-clean-campaign-test-plan-item-table', 'aguilhem', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.59429', 438, 'EXECUTED', '9:2cd4885764292bbdcafdfe9314f89cfd', 'sql', 'Clean CAMPAIGN_TEST_PLAN_ITEM table from line with null value in CAMPAIGN_ID', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-180', 'abo', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.598364', 439, 'EXECUTED', '9:e0031fcbd8ada373ab900b878242b48d', 'sql', 'Change dataType for RequirementStatus', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-00', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.606332', 440, 'EXECUTED', '9:428a7ecffedfe5f9453d789ca243b696', 'dropForeignKeyConstraint baseTableName=CHART_DEFINITION, constraintName=fk_chart_query; dropForeignKeyConstraint baseTableName=CHART_COLUMN_PROTOTYPE, constraintName=fk_column_query; dropForeignKeyConstraint baseTableName=CHART_AXIS_COLUMN, constr...', 'Preparatory step : dropping foreign keys pointing to CHART_QUERY and CHART_COLUMN_PROTOTYPE.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-01b-h2-pg', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.628471', 441, 'EXECUTED', '9:3dd2c941fb07dba88b73b2ec6f053d24', 'dropPrimaryKey tableName=CHART_QUERY; dropPrimaryKey tableName=CHART_COLUMN_PROTOTYPE; renameTable newTableName=QUERY_MODEL, oldTableName=CHART_QUERY; renameTable newTableName=QUERY_COLUMN_PROTOTYPE, oldTableName=CHART_COLUMN_PROTOTYPE; renameColu...', 'Rename CHART_QUERY and CHART_COLUMN_PROTOTYPE and their primary keys', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-01c', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.635559', 442, 'EXECUTED', '9:b13f0de49eb71a73ad7741470dbf5853', 'addNotNullConstraint columnName=LABEL, tableName=QUERY_COLUMN_PROTOTYPE; addUniqueConstraint tableName=QUERY_COLUMN_PROTOTYPE', 'Adding unique constraint on QUERY_COLUMN_PROTOTYPE.LABEL since its likely to act as
  		a surrogate primary key.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-02', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.665505', 443, 'EXECUTED', '9:9a231cfa6eac5749b54287f54fbdfd3e', 'createTable tableName=QUERY_PROJECTION_COLUMN; createTable tableName=QUERY_AGGREGATION_COLUMN; createTable tableName=QUERY_FILTER_COLUMN; createIndex indexName=idx_query_filter, tableName=QUERY_FILTER_COLUMN; createTable tableName=QUERY_FILTER_VAL...', 'Create the new tables that hosts the query components.
This table define which columns are part of tuple returned by a query.
This table indicates which projected columns are aggregated on for a given query.
This table defines the columns on which...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-03', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.68773', 444, 'EXECUTED', '9:bbf28ba48a635e5f0dc6f4aec3ac4b75', 'sql', 'Now the fun part : migrate the former content into the new content', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-04a', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.700126', 445, 'EXECUTED', '9:3924384b23cf3ca2295c617442cdbadb', 'addColumn tableName=CHART_AXIS_COLUMN; addColumn tableName=CHART_FILTER; addColumn tableName=CHART_MEASURE_COLUMN', 'Creating the new foreign keys from CHART_X_COLUMNS tables, to CHART_DEFINITION. Initially nullable.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-04b-postgresql', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.706308', 446, 'EXECUTED', '9:bd03f8667a84d73d1b174a8d63fd8479', 'sql', 'Populating the new foreign keys from the tables CHART_X_COLUMN  to CHART_DEFINITION', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-04c', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.711073', 447, 'EXECUTED', '9:9c75d637d08ad54b19596b7edad52e82', 'sql; sql', 'Deleting the former referential data (that now exist in the new QUERY_X tables)
also delete the former QUERY_MODELs that previously had user data,
      because now the CHART_X_COLUMNS now solely rely on their CHART_DEFINITION', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-04d', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.718164', 448, 'EXECUTED', '9:a6fb10c4add6d5539f536ae24dec91b3', 'dropColumn columnName=QUERY_ID, tableName=CHART_AXIS_COLUMN; dropColumn columnName=QUERY_ID, tableName=CHART_FILTER; dropColumn columnName=QUERY_ID, tableName=CHART_MEASURE_COLUMN; dropColumn columnName=QUERY_ID, tableName=CHART_DEFINITION', 'Now dropping the now useless columns that pointed to QUERY_MODEL', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-05', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.729655', 449, 'EXECUTED', '9:a599e4ec58730849bc0eb36872732cf8', 'addForeignKeyConstraint baseTableName=QUERY_COLUMN_PROTOTYPE, constraintName=fk_query_col_query_model, referencedTableName=QUERY_MODEL; addForeignKeyConstraint baseTableName=CHART_COLUMN_ROLE, constraintName=fk_column_role_chart_column, referenced...', 'Rewiring the remaining foreign keys.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-05b', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.768188', 450, 'EXECUTED', '9:ca1e3e6b66866e062ca8127abe7ca838', 'createIndex indexName=idx_fk_query_projection_query_column, tableName=QUERY_PROJECTION_COLUMN; createIndex indexName=idx_fk_query_projection_query_model, tableName=QUERY_PROJECTION_COLUMN; createIndex indexName=idx_fk_query_aggr_query_column, tabl...', 'For postgresql, we need to explicitly create the index on foreign key columns and ensure sequence order.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-06', 'bsiri', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.816902', 451, 'EXECUTED', '9:c6d4e5e0d3f699cb15f5f576c0d72ee8', 'sql', 'Inserting now the new columns and querymodels in the database
For the subqueries we have to use (w)hacky SQL. This is because we need to select-insert from no table,
    which is supported with specific syntax by each table but aren''t compatible t...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('create_index_fulltext_mysql', 'abo', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.825179', 452, 'EXECUTED', '9:a68b997bec340bf47df2f293fe2e5a01', 'sql', 'Create fulltext index on specific columns to search on it', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('update_datatype_to_fulltext_search', 'abo', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.828197', 453, 'EXECUTED', '9:04aaa08260c0a440b54066fe7b8752fd', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.20.0-TM-282-delete-lastindexing-properties', 'jprioux', 'tm/tm.changelog-1.20.0.xml', '2025-04-03 16:51:13.830949', 454, 'EXECUTED', '9:ec409af1829f751fa860e6f951d42b4b', 'sql', 'Delete all lastindexing properties from core config', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.834773', 455, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0', 'jprioux', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.837268', 456, 'EXECUTED', '9:cebefab2b617d8e8659a1ba08e63e46e', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-244-remote-automation-request-extender', 'jlor', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.85548', 457, 'EXECUTED', '9:4358f0f65b77ec64edf807dbf9d54a24', 'createTable tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER; createIndex indexName=idx_fk_remote_automation_request_extender_automation_request_id, tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER; createIndex indexName=idx_fk_remote_automation_request_e...', 'Create new table for RemoteAutomationRequestExtender', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-248-automation-workflow-type', 'jlor', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.865564', 458, 'EXECUTED', '9:cbba88186d9481d32a7ff39410d8a581', 'addColumn tableName=PROJECT; sql', 'Modify column ALLOW_AUTOMATION_WORKFLOW into AUTOMATION_WORKFLOW_TYPE', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-248-plugin-type', 'amk', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.868992', 459, 'EXECUTED', '9:8e16b0f72c65d93d86c9175a06c7c767', 'addColumn tableName=LIBRARY_PLUGIN_BINDING', 'add new column PLUGIN_TYPE into LIBRARY_PLUGIN_BINDING', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-211-active', 'amk', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.872455', 460, 'EXECUTED', '9:417922723de7e3d4a9286ca42e272265', 'addColumn tableName=LIBRARY_PLUGIN_BINDING', 'add new column ACTIVE into LIBRARY_PLUGIN_BINDING', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-649-sync-enable', 'api', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.875481', 461, 'EXECUTED', '9:0affe366e588e10e4ce03abbe006c39b', 'addColumn tableName=REMOTE_SYNCHRONISATION', 'add new column Sync_Enable into REMOTE_SYNCHONISATION', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-211-last-sync-date', 'amk', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.878531', 462, 'EXECUTED', '9:fdb306cdd6c72df8165f962753c5ad5e', 'addColumn tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER', 'add new column LAST-SYNC-DATE into REMOTE_AUTOMATION_REQUEST_EXTENDER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-725-add-committer-mail-in-scm-server', 'jlor', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.880927', 463, 'EXECUTED', '9:cbfec1f8af0ef48f3ce0efd9beb104b7', 'addColumn tableName=SCM_SERVER', 'Add column COMMITTER_MAIL in SCM_SERVER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-713-add-axis_and_measure-to-execution_is_auto', 'abo', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.885143', 464, 'EXECUTED', '9:a7bddb4e73e9455a8ee04c2718debc6c', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-211-sent-value-for-sync', 'amk', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.88851', 465, 'EXECUTED', '9:c74c50880bc9860508681887f44bdcee', 'addColumn tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER', 'add new column SENT_VALUE_FOR_SYNC into REMOTE_AUTOMATION_REQUEST_EXTENDER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-916-918-synchronizable-issue-status', 'amk', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.891634', 466, 'EXECUTED', '9:6f167f845c26c37bd922073850b48fc7', 'addColumn tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER', 'add new column SYNCHRONIZABLE_ISSUE_STATUS into REMOTE_AUTOMATION_REQUEST_EXTENDER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-875-last-sync-date-squash', 'amk', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.894582', 467, 'EXECUTED', '9:bed495c1eaf840c95e3d49fb86865add', 'addColumn tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER', 'add new column LAST-SYNC-DATE into REMOTE_AUTOMATION_REQUEST_EXTENDER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-846.1-postgresql', 'jlor', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.913636', 468, 'EXECUTED', '9:8067b0e9d91c3a33d64177063c1dd725', 'sql; addUniqueConstraint tableName=CAMPAIGN_ITERATION', 'PostgreSQL - Add unique constraint on order column for iterations in campaign', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-846.2-postgresql', 'jlor', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.933036', 469, 'EXECUTED', '9:e83d0779a060932251b1dd75a2c3fa71', 'sql; addUniqueConstraint tableName=ITEM_TEST_PLAN_EXECUTION', 'PostgreSQL - Add unique constraint on order column for executions in itpi', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-846.3-postgresql', 'jlor', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.953454', 470, 'EXECUTED', '9:aeb8f70ca45b12f126dd895f7ac2eeec', 'sql; addUniqueConstraint tableName=EXECUTION_EXECUTION_STEPS', 'PostgreSQL - Add unique constraint on order column for steps in execution', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.21.0-TM-996-modify-entity-reference-id-type', 'jprioux', 'tm/tm.changelog-1.21.0.xml', '2025-04-03 16:51:13.959436', 471, 'EXECUTED', '9:9336c013200881f03983ed957dfe7657', 'modifyDataType columnName=ENTITY_REFERENCE_ID, tableName=CHART_SCOPE', 'Modify ENTITY_REFERENCE_ID data type in CHART_SCOPE', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:13.963369', 472, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0', 'jthebault', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:13.965928', 473, 'EXECUTED', '9:62759562f0d6afca99eed7d2ad44113b', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-squash-167-test-it-uuid-for-tf-side-trigger', 'edegenetais', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:13.970718', 474, 'EXECUTED', '9:b7215ba389d09c347bca022f46791f4b', 'addColumn tableName=ITERATION; addUniqueConstraint constraintName=uc_iteration_uuid, tableName=ITERATION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-squash-167-update-iteration-uuid-postgresql', 'edegenetais', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:13.975041', 475, 'EXECUTED', '9:7ccc441dadded438601140a37e9b30aa', 'sql', 'Created missing UUIDs on upgrade to add the not-null constraint.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-174-action-word-table', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.002053', 476, 'EXECUTED', '9:e6cdc96b53c8cf351e456169fb4e42a2', 'createTable tableName=ACTION_WORD; createIndex indexName=idx_fk_action_word_project, tableName=ACTION_WORD; addUniqueConstraint constraintName=uc_aw_token_project_id, tableName=ACTION_WORD', 'Add action word table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-174-keyword-test-step-table', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.025544', 477, 'EXECUTED', '9:8ced82bc52ab71112da0e77be8c8d633', 'createTable tableName=KEYWORD_TEST_STEP; createIndex indexName=idx_fk_keyword_test_step_action_word, tableName=KEYWORD_TEST_STEP', 'Add keyword test step table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-174-update-query-filter', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.03265', 478, 'EXECUTED', '9:5fe21caa0e8aa24b398e6ac74fd5a759', 'sql; sql', 'Changes in QueryBuilder related tables concerning TEST_CASE_CALLSTEPCOUNT prototype column: adding a new subclass of TestStep (KeywordTestStep) broke the QueryBuilder', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-drop-temp_execution_extender_order_table-postgresql', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.036526', 479, 'EXECUTED', '9:ae25fe1ff9cd5bd30dbd248d5f6337d8', 'dropTable tableName=TEMP_EXECUTION_EXTENDER_ORDER', 'Drop TEMP_EXECUTION_EXTENDER_ORDER table for PostgreSQL', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-TEST_CASE_HIERARCHY_MODIFICATION', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.052634', 480, 'EXECUTED', '9:c74f1ea4cb5782f3d541255150f38f0f', 'createTable tableName=KEYWORD_TEST_CASE; dropColumn columnName=SCRIPTED_TC_EXTENDER_ID, tableName=SCRIPTED_TC_EXTENDER; renameTable newTableName=SCRIPTED_TEST_CASE, oldTableName=SCRIPTED_TC_EXTENDER; dropForeignKeyConstraint baseTableName=SCRIPTED...', 'Create KEYWORD_TEST_CASE table. Update SCRIPTED_TC_EXTENDER table/column', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-325-update-tc-kind-column-prototype', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.055547', 481, 'EXECUTED', '9:0a61b4c479ece519eee7f65b118a2feb', 'sql', 'In QueryColumnPrototype table, at TestCaseKind line, change data_type column value from Level_enum to Entity', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-325-drop-tc-kind-column', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.058177', 482, 'EXECUTED', '9:60629453425541d620f70bb91a1b99e8', 'dropColumn columnName=TC_KIND, tableName=TEST_CASE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-325-drop-language-column-in-scripted-tc', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.060404', 483, 'EXECUTED', '9:d346ee208b4f61c931926dabf0d0396a', 'dropColumn columnName=LANGUAGE, tableName=SCRIPTED_TEST_CASE', 'LANGUAGE is no longer necessary for ScriptedTestCase, as it is always GHERKIN.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-squash-421-add-test-suite-uuid', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.065535', 484, 'EXECUTED', '9:e37baaf5af294fd04449392a9aff7dad', 'addColumn tableName=TEST_SUITE; addUniqueConstraint constraintName=uc_test_suite_uuid, tableName=TEST_SUITE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-squash-421-update-test-suite-uuid-postgresql', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.071035', 485, 'EXECUTED', '9:9a657d9b16e72fdf2cbedb6817cfaab8', 'sql', 'Created missing UUIDs on upgrade to add the not-null constraint.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-325-EXECUTION_HIERARCHY_MODIFICATION', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.082445', 486, 'EXECUTED', '9:b1ef0ce7302559a5cbbeba997ec82e4e', 'renameTable newTableName=SCRIPTED_EXECUTION, oldTableName=SCRIPTED_EXECUTION_EXTENDER; dropColumn columnName=SCRIPTED_EXECUTION_EXTENDER_ID, tableName=SCRIPTED_EXECUTION; addPrimaryKey tableName=SCRIPTED_EXECUTION; dropColumn columnName=LANGUAGE, ...', 'Create KEYWORD_EXECUTION table. Update SCRIPTED_EXECUTION_EXTENDER table/column.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-350-PARAMETER_IN_ACTION_WORD', 'qtran', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.122446', 487, 'EXECUTED', '9:4f8c5e980692b63d79c357bc710f80dc', 'createTable tableName=ACTION_WORD_FRAGMENT; createIndex indexName=idx_fk_action_word_fragment_action_word_id, tableName=ACTION_WORD_FRAGMENT; addUniqueConstraint constraintName=uc_action_word_fragment_order, tableName=ACTION_WORD_FRAGMENT; createT...', 'Create ACTION_WORD_FRAGMENT table
Create new table for Action word text elements
Create new table for Action word parameter elements
Create new table for Action word parameter value', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-302-action-word-workspace', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.158102', 488, 'EXECUTED', '9:b0ef866f18cd3f9ae90111b476d0a2eb', 'createTable tableName=ACTION_WORD_LIBRARY; createIndex indexName=idx_action_word_library, tableName=ACTION_WORD_LIBRARY; createIndex indexName=idx_fk_awl_attachment_list, tableName=ACTION_WORD_LIBRARY; sql; addColumn tableName=PROJECT; createIndex...', 'Create action word library table
Insert corresponding entries in ACL tables
Add foreign key to the library in a project
Create one action word library for each existing project', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-302-action-word-workspace-2', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.184257', 489, 'EXECUTED', '9:7b54cc30b5adc8b31ddd261641fd745b', 'createTable tableName=ACTION_WORD_LIBRARY_NODE; createIndex indexName=idx_action_word_library_node, tableName=ACTION_WORD_LIBRARY_NODE; createIndex indexName=idx_fk_awln_awl, tableName=ACTION_WORD_LIBRARY_NODE; sql; createTable tableName=AWLN_RELA...', 'Create action word library node table
Create one action word library node for each library created
Create action word library node relationship table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-302-action-word-workspace-3', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.188739', 490, 'EXECUTED', '9:c5c496b9ce9a1f9d7152245582452c40', 'sql', 'Reset postgresql sequences', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-794-auditable-automated-suite', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.194016', 491, 'EXECUTED', '9:23dab011667ac08bdb3e28e83ee0354a', 'addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE', 'Make Automated Suite auditable', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-794-automated-suite-migration-postgres', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.202277', 492, 'EXECUTED', '9:507e60bf088235686f4371b7ff700b6c', 'sql', 'Add audit data on automated suite for postgresql', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-795', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.20492', 493, 'EXECUTED', '9:e8637fb1882720c67d0cbeedf22a3d4d', 'addColumn tableName=AUTOMATED_SUITE', 'Adds a execution status field to the automated suites', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-795-migration-mysql', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.218576', 494, 'EXECUTED', '9:eb051c3484119f4c92485b41733c4678', 'sql', 'Compute preexisting automated suites status for postgres', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-896-add-indexes-for-search-sort-columns', 'jprioux', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.241237', 495, 'EXECUTED', '9:0a62011558dba9e39f86647cc88d72d7', 'createIndex indexName=idx_project_name, tableName=PROJECT; createIndex indexName=idx_tc_reference, tableName=TEST_CASE; createIndex indexName=idx_tc_importance, tableName=TEST_CASE; createIndex indexName=idx_req_reference, tableName=REQUIREMENT_VE...', 'add indexes on default search sort columns', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-891', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.249184', 496, 'EXECUTED', '9:e47b600027d3bad2d5e8e68aaee2b38b', 'addColumn tableName=AUTOMATED_SUITE', 'Automated Suite can be directly linked to an iteration or a test suite', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-291-bdd-impl-techno-and-language', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.25278', 497, 'EXECUTED', '9:9af863d1c2318872e6c8ca4642b5d0aa', 'addColumn tableName=PROJECT', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-306-create-closure-table', 'mqtran', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.266115', 498, 'EXECUTED', '9:c8a1f183bcab1b0930b08faf6dc6171e', 'createTable tableName=AWLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_awln_relationship_clos_desc, tableName=AWLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_awln_relationship_clos_anc, tableName=AWLN_RELATIONSHIP_CLOSURE; addUniqueConstr...', 'closure table for action word library nodes. Its content is set and modified by 4 triggers', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-306-closure-postgresql-trigger', 'mqtran', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.273106', 499, 'EXECUTED', '9:ec2a9d7aa0e07b42f72743c39cf05f6a', 'createProcedure; createProcedure; createProcedure; createProcedure', 'postgresql-triggers for AWLN_RELATIONSHIP_CLOSURE table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-1107-aw-last-impl-techno-and-date', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.276988', 500, 'EXECUTED', '9:d6596859ec8dbd5a07799c47358dbd1e', 'addColumn tableName=ACTION_WORD', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-1284-migration-postgresql', 'qtran', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.288344', 501, 'EXECUTED', '9:6c9c3b2f76460ff2fddbc0f128bb3088', 'sql; sql; sql', 'Remove all CUF values and CUF value options attaching to any deleted Test Case folder for postgresql
Remove all CUF values and CUF value options attaching to any deleted Campaign folder for postgresql
Remove all CUF values and CUF value options at...', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-1466-test-case-source-code-repository-url', 'akatz', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.293977', 502, 'EXECUTED', '9:c22999d8ab6fd07c51128cf90f880479', 'addColumn tableName=TEST_CASE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-1', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.30679', 503, 'EXECUTED', '9:b4b8614f8ac2b2f5721e1dee34e9c66d', 'createTable tableName=MIG_SQUASH_1975; dropForeignKeyConstraint baseTableName=TEST_AUTOMATION_PROJECT, constraintName=fk_ta_project_ta_server; dropForeignKeyConstraint baseTableName=PROJECT, constraintName=tm_project_ta_server; sql', 'Preparation for data migration', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-2-postgres', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.316316', 504, 'EXECUTED', '9:eda5cd64b5536aa600d3299bb2ab512f', 'sql', 'Transform Test Automation Server to Third Party Server', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-3', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.331451', 505, 'EXECUTED', '9:3b5f5a4908971f92e106ae687a5bfa63', 'dropUniqueConstraint constraintName=UNI_AUTOTEST_SERVER, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=NAME, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=BASE_URL, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=LOGIN,...', 'Finalisation of test automation server data migration', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-4-postgres', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.337691', 506, 'EXECUTED', '9:8d6d52ca7af673adec9d2974aada14fa', 'sql', 'For PostGre, remove the autoincrement on server_id and reset the sequence for third_party_server', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-808-automated-suites-lifetime', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.341577', 507, 'EXECUTED', '9:0c792660b2692e6ffb971acc8b3f027c', 'addColumn tableName=PROJECT', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-2032-fix-null-description-in-requirement', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.345549', 508, 'EXECUTED', '9:7f22d4b69a71e66d14f2ef65164c2e19', 'sql', 'Replace null descriptions by empty strings in requirements', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-2106-automated-suite-attachment', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.35009', 509, 'EXECUTED', '9:04cd31e9b2ee57a4c5385586090abecd', 'addColumn tableName=AUTOMATED_SUITE', 'Give possibility to AUTOMATED_SUITE to have ATTACHMENT', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-2106-automated-suite-attachment-2', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.359337', 510, 'EXECUTED', '9:5bd93cdfb5ffd894252d494c596ba469', 'sql', 'Create one attachment list for each automated suite', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-2106-automated-suite-attachment-3', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.36583', 511, 'EXECUTED', '9:5afd868b7b0e37d960152cc20c4dbab0', 'sql', 'reset postgresql sequence', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-2141-automated-test-technology', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.378337', 512, 'EXECUTED', '9:22ffb3b6f7fbadb09405d72bec44e566', 'createTable tableName=AUTOMATED_TEST_TECHNOLOGY; sql; addColumn tableName=TEST_CASE', 'create automated test technology table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0-SQUASH-1999-scm-repo-ids-sequence', 'jlor', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.383571', 513, 'EXECUTED', '9:b735753c2c88f732b32b0d9e483e65e9', 'sql', 'reset sequence for scm repositories', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.0.SQUASH-1596-autocnnect-on-connection-config', 'jprioux', 'tm/tm.changelog-1.22.0.xml', '2025-04-03 16:51:14.38688', 514, 'EXECUTED', '9:37718dded95a240c958e0544b44fc3d8', 'insert tableName=CORE_CONFIG', 'add system parameter for autoconnect on connection configuration', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.2-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.22.2.xml', '2025-04-03 16:51:14.391629', 515, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.2', 'jprioux', 'tm/tm.changelog-1.22.2.xml', '2025-04-03 16:51:14.394961', 516, 'EXECUTED', '9:e6c15c858f0293a04009b55a8b5b20e1', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.2-SQUASH-2701-1-add-tc-scm-repository-id-column', 'jprioux', 'tm/tm.changelog-1.22.2.xml', '2025-04-03 16:51:14.404855', 517, 'EXECUTED', '9:0afeda381bb6ad9b0b4a2d0a2f524a95', 'addColumn tableName=TEST_CASE; createIndex indexName=idx_fk_tc_scm_repository, tableName=TEST_CASE', 'Add a new column in test case for link to scm repository', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.2-SQUASH-2701-2-scm-repository-url-temporary-table', 'jprioux', 'tm/tm.changelog-1.22.2.xml', '2025-04-03 16:51:14.413167', 518, 'EXECUTED', '9:bdec26cc2f2cdb4a65d8c5bbe250d2ea', 'createTable tableName=SCM_REPOSITORY_URL_MIGRATION_TEMP', 'Create temporary table for migration', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.2-SQUASH-2701-3-psql-migration-for-scm-repo-url', 'jprioux', 'tm/tm.changelog-1.22.2.xml', '2025-04-03 16:51:14.437415', 519, 'EXECUTED', '9:d5d233484c7fdab95b40c30e0e406efb', 'sql; sql; sql; sql; sql', 'Migration part if scm repository url has been added in tc', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.2-SQUASH-2701-4-drop-old-column-and-temp-table', 'jprioux', 'tm/tm.changelog-1.22.2.xml', '2025-04-03 16:51:14.44326', 520, 'EXECUTED', '9:84071a8139ca861184b8d9179cd0aa96', 'dropColumn columnName=SOURCE_CODE_REPOSITORY_URL, tableName=TEST_CASE; dropTable tableName=SCM_REPOSITORY_URL_MIGRATION_TEMP', 'Drop unnecessary old column and the temporary table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.2-SQUASH-2834-modify-scm-repo-unique-constraint', 'jlor', 'tm/tm.changelog-1.22.2.xml', '2025-04-03 16:51:14.488436', 521, 'EXECUTED', '9:41df55e6b8d4336fd007d53ca33b7d7e', 'createTable tableName=SCM_REPOSITORY_DATA_TEMP; sql; dropForeignKeyConstraint baseTableName=PROJECT, constraintName=fk_project_scm_repository; dropForeignKeyConstraint baseTableName=TEST_CASE, constraintName=fk_tc_scm_repository; dropTable tableNa...', 'Modify SCM_REPOSITORY unique constraint (name, server_id) to (name, working_branch, server_id)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.2-add-auto-test-tech', 'aguilhem', 'tm/tm.changelog-1.22.2.xml', '2025-04-03 16:51:14.492468', 522, 'EXECUTED', '9:b5ca2cc6fa07fa9683e8c5b06fe0a21d', 'sql', 'Add new compatible auto. test tech.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.3-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.22.3.xml', '2025-04-03 16:51:14.496531', 523, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.3', 'abo', 'tm/tm.changelog-1.22.3.xml', '2025-04-03 16:51:14.499887', 524, 'EXECUTED', '9:00d7ca4093c20ac163d30c3cf59cda23', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.3-grant-waa-permission-on-tc-to-atw', 'abo', 'tm/tm.changelog-1.22.3.xml', '2025-04-03 16:51:14.502567', 525, 'EXECUTED', '9:ee8e70d7df4b5521adb5b68b27ab50e6', 'sql', 'Grant WRITE AS AUTOMATION permission on test case to automation test writer', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.5-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.22.5.xml', '2025-04-03 16:51:14.505885', 526, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.5', 'agu', 'tm/tm.changelog-1.22.5.xml', '2025-04-03 16:51:14.508351', 527, 'EXECUTED', '9:4077505ab4662c466a25efa24e1e8a5d', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-1.22.5-add-skf-auto-test-tech', 'aguilhem', 'tm/tm.changelog-1.22.5.xml', '2025-04-03 16:51:14.510632', 528, 'EXECUTED', '9:9207832c62b5ff4bea9bb7b4b5101d4b', 'sql', 'Add SKF to compatible auto. test tech.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:14.514517', 529, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0', 'jthebault', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:14.519092', 530, 'EXECUTED', '9:61e162fed2e24420d6e3c329444ae8b3', 'sql; update tableName=CORE_CONFIG', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-fix-missing-indexes', 'jthebault', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:14.531647', 531, 'EXECUTED', '9:eab3e68e7de66a9313581c5bb842a789', 'createIndex indexName=idx_rln_created_by, tableName=REQUIREMENT_LIBRARY_NODE; createIndex indexName=idx_rln_last_modified_by, tableName=REQUIREMENT_LIBRARY_NODE; createIndex indexName=idx_tcln_created_by, tableName=TEST_CASE_LIBRARY_NODE; createIn...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-update-default-test-case-nature-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:14.538802', 532, 'EXECUTED', '9:3b8a05d1657d01a9e3bd3a22829b9f68', 'sql', 'Change default tc nature icons', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-update-default-test-case-type-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:14.544103', 533, 'EXECUTED', '9:12f9b292caab6b3977d480086b8cc270', 'sql', 'Change default tc type icons', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-update-default-requirement-category-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:14.55308', 534, 'EXECUTED', '9:dc1435124ad2177a4dcd02da5ea5f46b', 'sql', 'Change default requirement category icons', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-update-custom-infolist-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:14.841402', 535, 'EXECUTED', '9:bb250a581f8dec45cd0640f4d3efbb3d', 'createIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM; sql; dropIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM', 'Change infolist item icons', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-update-execution-tc-nat-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:15.272972', 536, 'EXECUTED', '9:471c6a55ce7a6bf421a7c2878f5ea25d', 'createIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION; createIndex indexName=idx_exec_tc_nat_code_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION; dropIndex indexName=idx_...', 'Change execution tc nat icon name', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-update-execution-tc-typ-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:15.561857', 537, 'EXECUTED', '9:b72d1663401085936efe56791b658462', 'createIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION; createIndex indexName=idx_exec_tc_typ_code_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION; dropIndex indexName=idx_...', 'Change execution tc typ icon name', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-grant-attach-permission-on-projects-to-pms', 'pckerneis', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:15.565553', 538, 'EXECUTED', '9:125818760675ce4ffb8d7b049038e77d', 'sql', 'Grant ATTACH permission on projects to project managers', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-missing-entries-in-awln_relationship_closure', 'jlor', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:15.571845', 539, 'EXECUTED', '9:658c0bf5e908b86cfdb2dc4bb423afc4', 'sql', 'insert missing entries in awln_relationship_closure: former projects data were not inserted.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-grant-read-permission-on-projects-to-atw', 'abo', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:15.574189', 540, 'EXECUTED', '9:15856ddd669af4cee4c5f1d3491fa3ee', 'sql', 'Grant READ permission on projects to automation test writer', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-fix-resource-missing-indexes', 'jthebault', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:15.582629', 541, 'EXECUTED', '9:3c688d853dba1dcb939543e4cf53dda5', 'createIndex indexName=idx_resource_created_by, tableName=RESOURCE; createIndex indexName=idx_resource_last_modified_by, tableName=RESOURCE; createIndex indexName=idx_resource_name, tableName=RESOURCE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-change-item_test_plan_lastexecby-entity-type', 'jthebault', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:15.58544', 542, 'EXECUTED', '9:6407da02c92379595b4a7d252977f11d', 'sql', 'Fix sort on ITEM_TEST_PLAN_LASTEXECBY column - issue 3768', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.00.0-add-dataset-name-column-prototype', 'jthebault', 'tm/tm.changelog-2.00.0.xml', '2025-04-03 16:51:15.58786', 543, 'EXECUTED', '9:b24211971b6c22507875f60cca8bbc96', 'sql', 'Fix sort on ITEM_TEST_PLAN_DATASET_LABEL column - issue 3988', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.1.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-2.1.0.xml', '2025-04-03 16:51:15.591239', 544, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.1.0', 'dclaerhout', 'tm/tm.changelog-2.1.0.xml', '2025-04-03 16:51:15.594079', 545, 'EXECUTED', '9:583e259b782f2a4d600de1026e44f558', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.1.0-add-remote-req-perimeter-status', 'dclaerhout', 'tm/tm.changelog-2.1.0.xml', '2025-04-03 16:51:15.596945', 546, 'EXECUTED', '9:08e66d183c4e8f1919b8767eb493e0f4', 'addColumn tableName=REQUIREMENT_SYNC_EXTENDER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.1.0-SQUASH-4052-delete-owner-in-report-and-chart', 'jprioux', 'tm/tm.changelog-2.1.0.xml', '2025-04-03 16:51:15.60472', 547, 'EXECUTED', '9:197c7c9475487eaeaedfb0af937865fe', 'dropForeignKeyConstraint baseTableName=CHART_DEFINITION, constraintName=fk_chart_owner; dropColumn columnName=USER_ID, tableName=CHART_DEFINITION; dropForeignKeyConstraint baseTableName=REPORT_DEFINITION, constraintName=fk_report_owner; dropColumn...', 'Remove the USER_ID columns and associated foreign keys', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-2.1.0-add-template-configurable-plugin-binding', 'pckerneis', 'tm/tm.changelog-2.1.0.xml', '2025-04-03 16:51:15.612416', 548, 'EXECUTED', '9:68c27f8f54df06718634c032ab926065', 'createTable tableName=TEMPLATE_CONFIGURABLE_PLUGIN_BINDING', 'Add the template_configurable_plugin_binding table.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.616559', 549, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0', 'jprioux', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.61887', 550, 'EXECUTED', '9:1432664a1cf5c0c9f2dde5334eb7eccc', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-4293-update-execution-nat-and-typ-icon-name', 'jprioux', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.636835', 551, 'EXECUTED', '9:f80675767f7e7ff73160dded4b3b2cf1', 'createIndex indexName=idx_exec_tc_nat_code_temp, tableName=EXECUTION; createIndex indexName=idx_exec_tc_typ_code_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_nat_code_temp, tableName=EXECUTION; dropIndex indexName=idx_exec_tc_ty...', 'Update nature and type icon name for execution with native info list', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-increase-varchar-number-for-dataset-param-value', 'dclaerhout', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.644442', 552, 'EXECUTED', '9:945b2bb2e639983975e8f835208eac87', 'modifyDataType columnName=PARAM_VALUE, tableName=DATASET_PARAM_VALUE; addNotNullConstraint columnName=PARAM_VALUE, tableName=DATASET_PARAM_VALUE; addDefaultValue columnName=PARAM_VALUE, tableName=DATASET_PARAM_VALUE', 'Change varchar from 255 to 1024 for dataset param value', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-4299-update-def-icon-name-001', 'jprioux', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.660365', 553, 'EXECUTED', '9:d3cd3f57339feb2572f8b4bb15fee5ee', 'createIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM; sql; dropIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM', 'Update all def icon name when used in info list item', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-4299-update-def-icon-name-002', 'jprioux', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.674623', 554, 'EXECUTED', '9:e92ff959f05e4c02e2b1a65cf4078e3f', 'createIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION', 'Update all def icon name when used in tc nat execution', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-4299-update-def-icon-name-003', 'jprioux', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.687077', 555, 'EXECUTED', '9:ed6b5aa1182eee7569f9e1c8a822d88a', 'createIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION', 'Update all def icon name when used in tc type execution', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQMAP-636-add-new-attributes-to-custom-chart', 'dclaerhout', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.718439', 556, 'EXECUTED', '9:1639fff5d946cf08980fb25f9b9e495d', 'update tableName=QUERY_COLUMN_PROTOTYPE; update tableName=QUERY_COLUMN_PROTOTYPE; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql', 'Add new attributes concerning test cases to generate custom charts', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-4310-create-delete-working-table', 'jthebault', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.731158', 557, 'EXECUTED', '9:2873a9a32cc4a12fce5b529e9f734152', 'createTable tableName=WORK_DELETE_ENTITIES; createIndex indexName=work_delete_entities_entity_type_idx, tableName=WORK_DELETE_ENTITIES; createIndex indexName=work_delete_entities_entity_id_idx, tableName=WORK_DELETE_ENTITIES; createIndex indexName...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-add-bt-project-reference-in-issue', 'jthebault', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.738905', 558, 'EXECUTED', '9:673ccc1ab4164e91506156e7047266e6', 'addColumn tableName=ISSUE; createIndex indexName=issue_remote_issue_id_idx, tableName=ISSUE', 'Changing the type to allow storage of large jsonified object, without using jsonb for backward compat', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-TM-632-01-add-high-lvl-req-table', 'jthebault', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.744221', 559, 'EXECUTED', '9:39cc419818cf805b2fd45bb1c1128945', 'createTable tableName=HIGH_LEVEL_REQUIREMENT', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-TM-632-02-add-query-column-proto', 'jthebault', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.747118', 560, 'EXECUTED', '9:16f01f4ae7b9a7bc4a25069cb0520dd4', 'sql', 'Inserting column proto for high level requirements', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-TM-632-03-add-high-lvl-req-reference', 'jthebault', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.751596', 561, 'EXECUTED', '9:79d583cc9be73d976a20e758d279e56f', 'addColumn tableName=REQUIREMENT', 'add reference column to allow requirement to be linked to high level requirements', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-4196-add-new-attributes-to-requirement-search', 'dclaerhout', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.76026', 562, 'EXECUTED', '9:31ef963c9c781d7167233439f8ea92ff', 'sql; sql; sql; sql; sql', 'Add new attributes for high level requirement in search', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-4436-add-automated_test_technologies', 'pckerneis', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.770285', 563, 'EXECUTED', '9:3c1cf1c950b572b4bdca2f2f72b7152d', 'sql; sql', 'Add automated test technologies (Cucumber 5+ and Postman)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-4584-apply_InfoList_default_value', 'cduvigneau', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.787814', 564, 'EXECUTED', '9:9304914dd9f3e1613d54f9d64657e953', 'sql', 'Set InfoList default value for old Test Case and Requirement', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-3.0.0-SQUASH-4436-add-premium-column', 'pckerneis', 'tm/tm.changelog-3.0.0.xml', '2025-04-03 16:51:15.804432', 565, 'EXECUTED', '9:08e88d54dbd91962ae86aeef35195b79', 'addColumn tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY', 'Add ''premium'' column for test technologies', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.810597', 566, 'EXECUTED', '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0', 'jlor', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.813399', 567, 'EXECUTED', '9:f8b68dd1970b66d3b2f865f9c4f7dcb9', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-squash-4931-projects-data-migration', 'jlor', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.816011', 568, 'EXECUTED', '9:e17a6086b361dd3fa3293e75863bb919', 'update tableName=PROJECT', 'Migrate PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_4''', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-squash-4931-projects-default-value-modification', 'jlor', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.81874', 569, 'EXECUTED', '9:e36a3c11a1bfde73ed29f239dbb9382b', 'addDefaultValue columnName=BDD_IMPLEMENTATION_TECHNOLOGY, tableName=PROJECT', 'Modify default value of PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_5_PLUS''', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-squash-4931-action-words-data-migration', 'jlor', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.82249', 570, 'EXECUTED', '9:96e1d8eba8bdd88a64043979b80775fc', 'update tableName=ACTION_WORD', 'Migrate ACTION_WORD.LAST_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_4''', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-squash-5025-token-auth-migration-for-mantis', 'bms', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.82536', 571, 'EXECUTED', '9:c7676e97fbe8d9adbd36c01dbaee0697', 'sql', 'Migrate BASIC_AUTH TO TOKEN_AUTH in third_party_server table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-squash-5035-add-owner-column-to-remote-synchronisation', 'cduvigneau', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.835624', 572, 'EXECUTED', '9:f4f36b2514985fece0ece386985f3b09', 'addColumn tableName=REMOTE_SYNCHRONISATION; createIndex indexName=idx_fk_remote_sync_owner, tableName=REMOTE_SYNCHRONISATION', 'Add Owner Column to REMOTE_SYNCHRONISATION Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-delete-column-test-case-version', 'jlor', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.838062', 573, 'EXECUTED', '9:16fe1e7fbb013f4e30c70df6bb17513f', 'dropColumn columnName=VERSION, tableName=TEST_CASE', 'Delete TEST_CASE.VERSION which is not and was never used', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-sqmap-879-automation-environment-tag', 'jlor', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.844445', 574, 'EXECUTED', '9:8f894aa035dce5752e03d498817ce924', 'createTable tableName=AUTOMATION_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uniq_value_entity_type_entity_id, tableName=AUTOMATION_ENVIRONMENT_TAG', 'Create table AUTOMATION_ENVIRONMENT_TAG', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-sqmap-879-add-project-inherits-env-tag-column', 'pckerneis', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.847588', 575, 'EXECUTED', '9:33380b19b42f47a9d977bed3d3e455d1', 'addColumn tableName=PROJECT', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-sqmap-879-add-project-level-credentials', 'pckerneis', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.853195', 576, 'EXECUTED', '9:e76e77e7bd3521e2ea7406e05355c385', 'addColumn tableName=STORED_CREDENTIALS', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-SQUASH-4923-remove-orphan-project-filters', 'dclaerhout', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.859865', 577, 'EXECUTED', '9:766ed1873b5eaccc38bdb17a073713e4', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.0.0-squash-5384-taserver-observer-url-column', 'pckerneis', 'tm/tm.changelog-4.0.0.xml', '2025-04-03 16:51:15.863437', 578, 'EXECUTED', '9:20f43d1b12eff9da986c09bd8075d726', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add OBSERVER_URL column to TEST_AUTOMATION_SERVER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.1.0', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', '2025-04-03 16:51:15.866049', 579, 'EXECUTED', '9:5dc31337e0ff9faff511d912f5a5c7d7', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.1.0-sqmap-879-environment-variable', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', '2025-04-03 16:51:15.876511', 580, 'EXECUTED', '9:8b13124e04063999553ef536d11697db', 'createTable tableName=ENVIRONMENT_VARIABLE; createIndex indexName=idx_ev_name, tableName=ENVIRONMENT_VARIABLE; addUniqueConstraint constraintName=uc_ev_name, tableName=ENVIRONMENT_VARIABLE', 'Create table ENVIRONMENT_VARIABLE', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.1.0-sqmap-879-environment-variable_option', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', '2025-04-03 16:51:15.886822', 581, 'EXECUTED', '9:d6e85cf2fdd96b5e7c399e4e1ed50d53', 'createTable tableName=ENVIRONMENT_VARIABLE_OPTION; createIndex indexName=idx_fk_ev_option_ev, tableName=ENVIRONMENT_VARIABLE_OPTION; addUniqueConstraint constraintName=uc_ev_option_label, tableName=ENVIRONMENT_VARIABLE_OPTION', 'Creates a table for Environment Variable Options', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.1.0-sqmap-879-environment-variable_binding', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', '2025-04-03 16:51:15.902134', 582, 'EXECUTED', '9:21646b6c3929242a1da9755693a8f0a9', 'createTable tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_fk_ev_binding_ev, tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_fk_ev_binding_server, tableName=ENVIRONMENT_VARIABLE_BINDING; addUniqueConstraint con...', 'Creates a table for Environment Variable Binding', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.1.0-sqmap-879-environment-variable_value', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', '2025-04-03 16:51:15.920632', 583, 'EXECUTED', '9:840ddb124fa0d701aeda7ebefbd25a58', 'createTable tableName=ENVIRONMENT_VARIABLE_VALUE; createIndex indexName=idx_fk_ev_value_binding, tableName=ENVIRONMENT_VARIABLE_VALUE; createIndex indexName=idx_evv_entity_id, tableName=ENVIRONMENT_VARIABLE_VALUE; createIndex indexName=idx_evv_ent...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.1.0-sqmap-879-denormalized-environment-variable', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', '2025-04-03 16:51:15.941057', 584, 'EXECUTED', '9:55d9a196cb88ababeacc8d148e007e09', 'createTable tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; createIndex indexName=idx_fk_dev_environment_variable, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; createIndex indexName=idx_dev_holder_id, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; crea...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-4.1.0-sqmap-879-denormalized-environment-tag', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', '2025-04-03 16:51:15.954799', 585, 'EXECUTED', '9:117d3418d6704f394a77eeb8142fbb0c', 'createTable tableName=DENORMALIZED_ENVIRONMENT_TAG; createIndex indexName=idx_det_holder_id, tableName=DENORMALIZED_ENVIRONMENT_TAG; createIndex indexName=idx_det_holder_type, tableName=DENORMALIZED_ENVIRONMENT_TAG; addUniqueConstraint constraintN...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0', 'bmsaddek', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:15.95781', 586, 'EXECUTED', '9:0799604eb9eb2be7388f004c93851b31', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-SQUASH-5923-increase-max-size-for-databasechangelog', 'jprioux', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:15.961045', 587, 'EXECUTED', '9:5a715f325ee62e13bad31a7a80e5f834', 'modifyDataType columnName=ID, tableName=DATABASECHANGELOG; modifyDataType columnName=AUTHOR, tableName=DATABASECHANGELOG', 'Increase max size for ID and author columns in databasechangelog table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-SQUASH-5745-Add-environment-variables-to-project', 'bmsaddek', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:15.974078', 588, 'EXECUTED', '9:34b52c25de5de744ff0549269c4608d1', 'addColumn tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_evb_entity_id, tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_evb_entity_type, tableName=ENVIRONMENT_VARIABLE_BINDING; dropForeignKeyConstraint baseTabl...', 'Add VALUE, ENTITY_TYPE columns to ENVIRONMENT_VARIABLE_BINDING Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-SQUASH-5745-environment-variable-data-migration-server-value', 'lmurat', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:15.980886', 589, 'EXECUTED', '9:57bf95c62c3e20eca2c158416e42fdd9', 'sql', 'Migrate environment variable values in environment_variable_binding table when it''s a server value', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-SQUASH-5745-environment-variable-data-migration-default-value', 'lmurat', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:15.985556', 590, 'EXECUTED', '9:dba7448dee9efba52381240150b15cc2', 'sql', 'Migrate environment variable values in environment_variable_binding table when project value doesn''t exist in environment variable value table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-SQUASH-5745-environment-variable-data-migration-project-value', 'lmurat', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:15.989005', 591, 'EXECUTED', '9:567c608bffe98976e95bae8826acca6f', 'sql', 'Migrate environment variable values in environment_variable_binding table when project value exist in environment variable value table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-SQUASH-5745-Drop-environment-variable-value-table', 'lmurat', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:16.000136', 592, 'EXECUTED', '9:ea40aa1227bd9ee3e47a46a48e710dab', 'dropColumn columnName=bound_server_id, tableName=ENVIRONMENT_VARIABLE_BINDING; dropTable tableName=ENVIRONMENT_VARIABLE_VALUE; addUniqueConstraint constraintName=uc_evb_id_type_ev_id_binding, tableName=ENVIRONMENT_VARIABLE_BINDING', 'Drop old environment variable values', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-SQUASH-5745-Add-environment-variables-type-to-denormalized-environment-variable', 'bmsaddek', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:16.003112', 593, 'EXECUTED', '9:3c21775b2c564150270041d21a40eeeb', 'addColumn tableName=DENORMALIZED_ENVIRONMENT_VARIABLE', 'Add TYPE column to DENORMALIZED_ENVIRONMENT_VARIABLE Table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-SQUASH-5890-environment-variable-data-migration-variable-type', 'bmsaddek', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:16.009555', 594, 'EXECUTED', '9:a959fab70e52c265fb5201e136318756', 'sql', 'Copy environment variable type in denormalized_environment_variable table if the variable has not been deleted', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-add-user-custom-delete-permission', 'pckerneis', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:16.012529', 595, 'EXECUTED', '9:587c2e26b3f1851dfe373d913415b988', 'addColumn tableName=CORE_USER', 'Add a column for custom delete permissions on CORE_USER table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-squash-5665-update-welcome-and-login-message', 'lmurat', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:16.015782', 596, 'EXECUTED', '9:ca54baa64370c1b6ef6c5cc7eb9aa1f5', 'sql', 'Adapt default welcome and login message to new front', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-squash-5881-update-length-for-test-suite-name', 'lmurat', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:16.018384', 597, 'EXECUTED', '9:5b9948a68e9d4e755d0086d77fd5fde3', 'modifyDataType columnName=NAME, tableName=TEST_SUITE', 'Increase character limit for test suite name to 255', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-squash-5384-taserver-eventbus-url-column', 'pckerneis', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:16.021154', 598, 'EXECUTED', '9:af613a64edb306376a3413bd8e9f0799', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add EVENT_BUS_URL column to TEST_AUTOMATION_SERVER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-5.0.0-squash-5749-add-test-technology-tag-to-automated-execution-extender', 'lmurat', 'tm/tm.changelog-5.0.0.xml', '2025-04-03 16:51:16.023703', 599, 'EXECUTED', '9:1f07f54a1151d9fa8945667d5b538a7d', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', 'Add the automated test technology tag to the automated execution extender', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0', 'lmurat', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.026474', 600, 'EXECUTED', '9:1da4622fdd60568c4f980c199ec81cdc', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-SQUASH-6260-cleanup-core-party-authority-table', 'lmurat', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.029136', 601, 'EXECUTED', '9:a90e3537426c6ad8ccfe2cbe2b20016b', 'sql', 'Remove ROLE_TM_USER from CORE_PARTY_AUTHORITY', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-SQUASH-6284-login-up-to-100-characters', 'mbrugniere', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.103626', 602, 'EXECUTED', '9:4da72f9cd6af85d1618faaabd82056a9', 'modifyDataType columnName=CREATED_BY, tableName=ACTION_WORD; addNotNullConstraint columnName=CREATED_BY, tableName=ACTION_WORD; modifyDataType columnName=LAST_MODIFIED_BY, tableName=ACTION_WORD; modifyDataType columnName=LOGIN, tableName=AUTH_USER...', 'Update login maxlength for all tables concerned (from 50 to 100)', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-create-exploratory-test-case', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.115136', 603, 'EXECUTED', '9:b5c6f62ab4203dbe7033067a329f17a6', 'createTable tableName=EXPLORATORY_TEST_CASE', 'Create the exploratory test case table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-create-exploratory-execution', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.125322', 604, 'EXECUTED', '9:9f79c8d818b4b6e706a6535a3d569b6e', 'createTable tableName=EXPLORATORY_EXECUTION; createIndex indexName=idx_fk_exploratory_execution_assignee, tableName=EXPLORATORY_EXECUTION', 'Create the exploratory execution table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-create-session-note-for-exploratory-execution', 'mbrugniere', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.151579', 605, 'EXECUTED', '9:430bad4060599f6c2b1d586f9946cf5e', 'createTable tableName=SESSION_NOTE; createIndex indexName=idx_fk_session_note_execution, tableName=SESSION_NOTE; createIndex indexName=idx_fk_session_note_issue_list_id, tableName=SESSION_NOTE; createIndex indexName=idx_session_note_created_by, ta...', 'Create the session note table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-ISSUE-269-increase-max-size-for-test-reference', 'dclaerhout', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.154506', 606, 'EXECUTED', '9:0bd157b42a4f46da8a7356cf1193ea0b', 'modifyDataType columnName=AUTOMATED_TEST_REFERENCE, tableName=TEST_CASE', 'Increase max size for automated test reference in test case table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-issue-368-add-additional-configuration-to-test-automation-server', 'fahadi', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.156968', 607, 'EXECUTED', '9:358d02ec3170595bc7c24c2dbc276ba3', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add additional configuration to the test automation server', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-update-execution_issues_closure', 'mbrugniere', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.164113', 608, 'EXECUTED', '9:4386a6d83560f0de3ee87cb09071285e', 'dropView viewName=EXECUTION_ISSUES_CLOSURE; createView viewName=EXECUTION_ISSUES_CLOSURE', 'Consider session notes to get all known issues for an execution', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-add-grid-column-display-reference-table', 'jmarque', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.178235', 609, 'EXECUTED', '9:cc3e54db447d7e213e3739d5e29f9d82', 'createTable tableName=GRID_COLUMN_DISPLAY_REFERENCE; createIndex indexName=idx_fk_grid_column_display_reference_party_id, tableName=GRID_COLUMN_DISPLAY_REFERENCE; createIndex indexName=idx_fk_grid_column_display_reference_project_id, tableName=GRI...', 'Create the grid reference table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-add-grid-column-display-configuration-table', 'jmarque', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.188655', 610, 'EXECUTED', '9:55d28e6951c7a21c366de060c1c9c2cf', 'createTable tableName=GRID_COLUMN_DISPLAY_CONFIGURATION; createIndex indexName=idx_fk_grid_column_display_configuration_gcdr_id, tableName=GRID_COLUMN_DISPLAY_CONFIGURATION', 'Create the grid configuration table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-create-exploratory-execution-event-table', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.200026', 611, 'EXECUTED', '9:71be01a045aaef62c9c8f54a56402fa6', 'createTable tableName=EXPLORATORY_EXECUTION_EVENT; addUniqueConstraint constraintName=uc_exploratory_execution_event_execution_id_event_date, tableName=EXPLORATORY_EXECUTION_EVENT', 'Create the exploratory session event table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-add-dataset-parameter-order', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.202607', 612, 'EXECUTED', '9:639dadfddd2529e96a51722a5a0fa8d5', 'addColumn tableName=PARAMETER', 'add an order to parameters', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-add-dataset-parameter-order-generation', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.210268', 613, 'EXECUTED', '9:ce26bdca61165e40fdbbc754010577d6', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-add-exploratory-session-overview', 'mbrugniere', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.22633', 614, 'EXECUTED', '9:82e7bfed7a0aac520250fd073c73be7a', 'createTable tableName=EXPLORATORY_SESSION_OVERVIEW; createIndex indexName=idx_fk_exploratory_session_overview_itpi, tableName=EXPLORATORY_SESSION_OVERVIEW; createIndex indexName=idx_fk_exploratory_session_overview_attachment_list, tableName=EXPLOR...', 'Create the exploratory session overview table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-squash-remove-resultpublisher-plugin-binding', 'bms', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.231343', 615, 'EXECUTED', '9:534e9059223d07ff643a368807ac1d8c', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-6.0.0-667-rename-squashautom-ta-server-kind', 'jprioux', 'tm/tm.changelog-6.0.0.xml', '2025-04-03 16:51:16.234025', 616, 'EXECUTED', '9:dcca6dbc5f5d66e58fb4a015318ffc08', 'update tableName=TEST_AUTOMATION_SERVER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0', 'mbrugniere', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.236558', 617, 'EXECUTED', '9:92c0b4f8fe7acd7f37fe38b01f3faaaa', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-45-clean-database-of-nulls-in-action-steps', 'mbrugniere', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.243012', 618, 'EXECUTED', '9:6a4ebb7bc6693342635dab429be0ec85', 'update tableName=ACTION_TEST_STEP; update tableName=ACTION_TEST_STEP; update tableName=EXECUTION_STEP; update tableName=EXECUTION_STEP', 'Clean database of null values in test steps and execution steps', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-895-action-and-expected_result_should_not_be_nullable', 'mbrugniere', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.251177', 619, 'EXECUTED', '9:6d1896310b69247b9ef3de779db89e4e', 'addNotNullConstraint columnName=ACTION, tableName=ACTION_TEST_STEP; addDefaultValue columnName=ACTION, tableName=ACTION_TEST_STEP; addNotNullConstraint columnName=EXPECTED_RESULT, tableName=ACTION_TEST_STEP; addDefaultValue columnName=EXPECTED_RES...', 'Add not null constraint on columns action and expected_result', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-876-update-cufs-in-column-configuration', 'jma', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.256455', 620, 'EXECUTED', '9:70e70f2120676096be696b2597b1208f', 'sql', 'Delete active_column_id if it does not match any cuf code. Replace the cuf''s code with the cuf''s id.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-create-sprint-table', 'jprioux', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.269944', 621, 'EXECUTED', '9:157d873865c488f1edccfd21598ef4e5', 'createTable tableName=SPRINT; createIndex indexName=idx_fk_sprint_remote_synchronisation, tableName=SPRINT', 'Create the sprint table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-create-sprint-req-version-table', 'rfortoso', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.285836', 622, 'EXECUTED', '9:3b869128033d23cf8b9b3ba795389ade', 'createTable tableName=SPRINT_REQ_VERSION; createIndex indexName=idx_fk_sprint_req_version_req_version_id, tableName=SPRINT_REQ_VERSION; createIndex indexName=idx_fk_sprint_req_version_sprint_id, tableName=SPRINT_REQ_VERSION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-create-sprint-requirement-sync-extender-table', 'dclaerhout', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.300264', 623, 'EXECUTED', '9:8e731ad386e96a147d3b20bca1595e37', 'createTable tableName=SPRINT_REQUIREMENT_SYNC_EXTENDER; createIndex indexName=idx_fk_sprint_req_sync_ext_sprint_req_version_id, tableName=SPRINT_REQUIREMENT_SYNC_EXTENDER; createIndex indexName=idx_fk_sprint_req_sync_ext_remote_sync_id, tableName=...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-create-automated-suite-workflows-table', 'bmsaddek', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.309456', 624, 'EXECUTED', '9:235dafd0cc32fd25521133691132cb30', 'createTable tableName=AUTOMATED_SUITE_WORKFLOWS; createIndex indexName=idx_fk_automated_suite_workflows_project_id, tableName=AUTOMATED_SUITE_WORKFLOWS', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-create-ai-server-table', 'jmarque', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.321844', 625, 'EXECUTED', '9:03ad8a3d6219da9a41197d8af653f882', 'createTable tableName=AI_SERVER; addForeignKeyConstraint baseTableName=AI_SERVER, constraintName=fk_ai_server_third_party_server, referencedTableName=THIRD_PARTY_SERVER', 'Create the ai server table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-add-column-killswitch-url-in-test-automation-server', 'ngouriou', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.324476', 626, 'EXECUTED', '9:fa7bf56cd12296eaf6fcc5e9fc88cefc', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add killswitch_url column in test automation server table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-add-column-ai_server_id-in-project', 'mbrugniere', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.332899', 627, 'EXECUTED', '9:78f5388ceab0f94411ab26e8f2b4c6b3', 'addColumn tableName=PROJECT; createIndex indexName=idx_fk_project_ai_server, tableName=PROJECT', 'Add column ai_server_id in project table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-record-info-test-case-drafted-by-artificial-intelligence', 'mbrugniere', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.3369', 628, 'EXECUTED', '9:3d6edeb55a992a5a01cf2ca6eae859f1', 'addColumn tableName=TEST_CASE', 'Add column drafted_by_ai in test_case table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-filtering-on-drafted-by-ai-in-test-case-search-grid', 'mbrugniere', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.340188', 629, 'EXECUTED', '9:4b41e5ca2418c863e8ab34716beaeabe', 'sql', 'Add entry in QUERY_COLUMN_PROTOTYPE for filtering on TEST_CASE.drafted_by_ai', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-create-test_plan-tables', 'pckerneis', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.392216', 630, 'EXECUTED', '9:a3eafea31efc496324df52a798486d45', 'createTable tableName=TEST_PLAN; createIndex indexName=idx_fk_test_plan_campaign_library, tableName=TEST_PLAN; createTable tableName=TEST_PLAN_ITEM; createIndex indexName=idx_fk_test_plan_item_test_plan, tableName=TEST_PLAN_ITEM; createIndex index...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-fix-mapping-tc-add-automation-req-fk', 'bmsaddek', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.398225', 631, 'EXECUTED', '9:ca539cb6790f7783c1cfc1199730c1db', 'addColumn tableName=TEST_CASE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-fix-mapping-tc-import-ar-fk-postgres', 'bmsaddek', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.405886', 632, 'EXECUTED', '9:3e85b75bcbace6c916e1b959af9d0e11', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-fix-mapping-tc-add-columns-indexes', 'bmsaddek', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.410607', 633, 'EXECUTED', '9:53781476da8dd533667599282e0cd9fa', 'createIndex indexName=idx_test_case_automation_request_id, tableName=TEST_CASE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-fix-mapping-automation-request-drop-column', 'bmsaddek', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.416703', 634, 'EXECUTED', '9:646280828798ba689de3189b037b1264', 'dropForeignKeyConstraint baseTableName=AUTOMATION_REQUEST, constraintName=fk_automation_request_test_case; dropColumn columnName=TEST_CASE_ID, tableName=AUTOMATION_REQUEST', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-create-sprint-group-table', 'jprioux', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.423173', 635, 'EXECUTED', '9:374d532823f401c0a48670e947c5170f', 'createTable tableName=SPRINT_GROUP', 'Create the sprint group table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-expand_cln_relationship_ancestor_fk', 'jprioux', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.434285', 636, 'EXECUTED', '9:fd14d16c367d560136d412f9f9c40bd8', 'dropForeignKeyConstraint baseTableName=CLN_RELATIONSHIP, constraintName=fk_cln_relationship_ancestor; dropIndex indexName=dx_cln_relationship_ancestor, tableName=CLN_RELATIONSHIP; addForeignKeyConstraint baseTableName=CLN_RELATIONSHIP, constraintN...', 'Expand ANCESTOR_ID from cln_relationship to include campaign library node, not only folder', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-replace-invalid-br-tags', 'pckerneis', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.438469', 637, 'EXECUTED', '9:7c8e26e83eaebc40d469cfac8046ccf2', 'sql', 'Replace invalid br tags in test case description', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-fix-mapping-bugtracker-project-binding', 'bmsaddek', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.452908', 638, 'EXECUTED', '9:e8a1f7d1ecf87adba9e0bef770a8a000', 'addColumn tableName=BUGTRACKER_PROJECT; addColumn tableName=PROJECT; createIndex indexName=idx_fk_bugtracker_project_project_id, tableName=BUGTRACKER_PROJECT; createIndex indexName=idx_fk_project_bugtracker_id, tableName=PROJECT', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-fix-mapping-bugtracker-project-import-fk-postgresql', 'bmsaddek', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.458909', 639, 'EXECUTED', '9:6bcd3ebd4b80138ba7e8b0ba4191b472', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-fix-mapping-bugtracker-project-drop-table', 'bmsaddek', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.467815', 640, 'EXECUTED', '9:aab3e910c6e2cb44f7f44a377bd6b4d6', 'dropForeignKeyConstraint baseTableName=BUGTRACKER_PROJECT, constraintName=fk_bugtracker_project_bugtracker_binding; dropColumn columnName=BUGTRACKER_BINDING_ID, tableName=BUGTRACKER_PROJECT; dropTable tableName=BUGTRACKER_BINDING; addNotNullConstr...', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-1558-add-playwright-automated_test_technologies', 'xzhao-meinman', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.472', 641, 'EXECUTED', '9:866860367027c1ae00d010efa2b63013', 'sql', 'Add automated test technology Playwright', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.0.0-squash-1647-add-auditables-and-description-to-third-party-server-postgresql', 'jpmarque', 'tm/tm.changelog-7.0.0.xml', '2025-04-03 16:51:16.479831', 642, 'EXECUTED', '9:12ea7863fae98b7accbbbb16e2c03426', 'sql', 'Add auditables and description to THIRD_PARTY_SERVER, copy data from TEST_AUTOMATION_SERVER, remove columns from TEST_AUTOMATION_SERVER', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.1.0', 'mbrugniere', 'tm/tm.changelog-7.1.0.xml', '2025-04-03 16:51:16.482733', 643, 'EXECUTED', '9:9d10a2bc2b201964c73a7e7032b900dc', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.1.0-create-api-token-table', 'mbrugniere', 'tm/tm.changelog-7.1.0.xml', '2025-04-03 16:51:16.495204', 644, 'EXECUTED', '9:c4cab334b1277b733508ddbf4c4cad22', 'createTable tableName=API_TOKEN; createIndex indexName=idx_fk_api_token_user_id, tableName=API_TOKEN', 'Create table API_TOKEN', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.1.0-fix-description-default-value-in-third-party-server', 'jprioux', 'tm/tm.changelog-7.1.0.xml', '2025-04-03 16:51:16.499372', 645, 'EXECUTED', '9:d0526bba58ae7a065e3b71c8990eb3b3', 'addDefaultValue columnName=DESCRIPTION, tableName=THIRD_PARTY_SERVER; update tableName=THIRD_PARTY_SERVER', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.2.0', 'bmsaddek', 'tm/tm.changelog-7.2.0.xml', '2025-04-03 16:51:16.502004', 646, 'EXECUTED', '9:8aa3797b22f4be5daa5e99bfeaa7722a', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.2.0-remove-item-test-plan-execution-constraint-postgres', 'bmsaddek', 'tm/tm.changelog-7.2.0.xml', '2025-04-03 16:51:16.505585', 647, 'EXECUTED', '9:c429d5dfbbbd97bba41598bd11719b1f', 'dropUniqueConstraint constraintName=item_test_plan_execution_item_test_plan_id_execution_order_key, tableName=ITEM_TEST_PLAN_EXECUTION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.3.0', 'pckerneis', 'tm/tm.changelog-7.3.0.xml', '2025-04-03 16:51:16.508056', 648, 'EXECUTED', '9:5e14406efadbadd710e3d4a59e4d0a55', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-7.3.0-add-REPORTING_CACHE_CREDENTIALS-column-to-STORED_CREDENTIALS', 'pckerneis', 'tm/tm.changelog-7.3.0.xml', '2025-04-03 16:51:16.510892', 649, 'EXECUTED', '9:960cb33d43f5452166c3d22f7f909581', 'addColumn tableName=STORED_CREDENTIALS', 'Add REPORTING_CACHE_CREDENTIALS column to STORED_CREDENTIALS', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0', 'mbrugniere', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.513563', 650, 'EXECUTED', '9:da5a1a70628566273a68386bf3258f16', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-import-permission-to-project-manager-profile', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.656748', 676, 'EXECUTED', '9:54461965589da4cc39529ae42dc6a2b1', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-1658-add-column-duration-in-automated-execution-extender-table', 'xzhao', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.516409', 651, 'EXECUTED', '9:ec05fea5b5ddb5519d8b693c2ccbf03a', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', 'Add column duration in automated execution extender table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-custom-field-value-update-unique-constraint', 'rfortoso', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.52286', 652, 'EXECUTED', '9:7a35e83afc787162e080388deed7dddc', 'dropUniqueConstraint constraintName=u_cfv_id_type_binding, tableName=CUSTOM_FIELD_VALUE; addUniqueConstraint constraintName=u_cfv_type_id_binding, tableName=CUSTOM_FIELD_VALUE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-denormalized_field_value-update-unique-constraint', 'rfortoso', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.528652', 653, 'EXECUTED', '9:a2c120181a625204cbbc79c245e2150c', 'dropUniqueConstraint constraintName=u_dfv_id_type_code, tableName=DENORMALIZED_FIELD_VALUE; addUniqueConstraint constraintName=u_dfv_type_id_code, tableName=DENORMALIZED_FIELD_VALUE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-denormalized_environment_variable-update-unique-constraint', 'rfortoso', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.535039', 654, 'EXECUTED', '9:ce0df88a63d0e8592f8b85efe57793bc', 'dropUniqueConstraint constraintName=uc_dev_id_type_name, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; addUniqueConstraint constraintName=uc_dev_type_id_name, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-denormalized_environment_tag-update-unique-constraint', 'rfortoso', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.540624', 655, 'EXECUTED', '9:3f67ac813240f65a484fa66830769c98', 'dropUniqueConstraint constraintName=uc_det_id_type_value, tableName=DENORMALIZED_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uc_det_type_id_value, tableName=DENORMALIZED_ENVIRONMENT_TAG', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-environment_variable_binding-update-unique-constraint', 'rfortoso', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.546724', 656, 'EXECUTED', '9:2d792ed2bf3ce5632b537beeb4067f52', 'dropUniqueConstraint constraintName=uc_evb_id_type_ev_id_binding, tableName=ENVIRONMENT_VARIABLE_BINDING; addUniqueConstraint constraintName=uc_type_evb_id_ev_id_binding, tableName=ENVIRONMENT_VARIABLE_BINDING', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-automation_environment_tag-update-unique-constraint', 'rfortoso', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.553115', 657, 'EXECUTED', '9:6d1a3ea7a72fb3d7b1b38b79fe88d906', 'dropUniqueConstraint constraintName=uniq_value_entity_type_entity_id, tableName=AUTOMATION_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uniq_entity_type_entity_id_value, tableName=AUTOMATION_ENVIRONMENT_TAG', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-modify_restrain_to_active_sprint_json_keys', 'pguygot', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.556486', 658, 'EXECUTED', '9:76e1b4e0c4b157b2c7d30eb171738e12', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-remove-unnecessary-roles', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.558496', 659, 'EXECUTED', '9:4a8c30f71f1505794d2f57106f29b8c9', 'delete tableName=CORE_PARTY_AUTHORITY', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add_remote_sync_id_in_sprint_group_table', 'pguygot', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.565852', 660, 'EXECUTED', '9:c9bc54b9c3ecbad7e8b26c7c3ba8710d', 'addColumn tableName=SPRINT_GROUP; createIndex indexName=idx_fk_sprint_group_remote_synchronisation, tableName=SPRINT_GROUP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-manage-milestone-permission', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.569105', 661, 'EXECUTED', '9:438f790a864a5b1ca6f831e873b3d10d', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-manage-project-clearance-permission', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.571866', 662, 'EXECUTED', '9:321e8c064bd548664074d7e154546011', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-active-in-acl-group', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.574614', 663, 'EXECUTED', '9:e2e307038d99c9ae01d5493770489324', 'addColumn tableName=ACL_GROUP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-description-in-acl-group', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.579733', 664, 'EXECUTED', '9:648bc9595fe47806f6dc57d33b0b6e94', 'addColumn tableName=ACL_GROUP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-auditable-columns-in-sprint-req-version', 'pckerneis', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.58697', 665, 'EXECUTED', '9:7b9695a7fec85024827d529cdf54ec63', 'addColumn tableName=SPRINT_REQ_VERSION; update tableName=SPRINT_REQ_VERSION; addNotNullConstraint columnName=CREATED_BY, tableName=SPRINT_REQ_VERSION; addNotNullConstraint columnName=CREATED_ON, tableName=SPRINT_REQ_VERSION', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-update-acl-group-sequence', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.590258', 666, 'EXECUTED', '9:e5cc42590269ebee02682dfb218591e0', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-auditable-columns-in-acl-group', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.597977', 667, 'EXECUTED', '9:611344fe6e10611009b7c2920f75a233', 'addColumn tableName=ACL_GROUP; update tableName=ACL_GROUP; addNotNullConstraint columnName=CREATED_BY, tableName=ACL_GROUP; addNotNullConstraint columnName=CREATED_ON, tableName=ACL_GROUP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-limit-acl-group-name-to-50', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.611982', 668, 'EXECUTED', '9:7458d877d512b0602e4684d476e1b15b', 'modifyDataType columnName=QUALIFIED_NAME, tableName=ACL_GROUP', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-created-by-column-in-api-token', 'mbrugniere', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.618412', 669, 'EXECUTED', '9:b3090da737afdac4a5baaf293b66ce06', 'addColumn tableName=API_TOKEN; sql; addNotNullConstraint columnName=CREATED_BY, tableName=API_TOKEN', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-table-for-pivot-format-import', 'dclaerhout', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.632132', 670, 'EXECUTED', '9:cc3a4ab79f5b5a29f3e497e2185ab422', 'createTable tableName=PIVOT_FORMAT_IMPORT; createIndex indexName=idx_fk_pivot_format_import_created_by, tableName=PIVOT_FORMAT_IMPORT; createIndex indexName=idx_fk_pivot_format_import_project_id, tableName=PIVOT_FORMAT_IMPORT', 'Add a pivot format import table in squash tm.', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-harmonize-profile-permissions', 'jprioux', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.638625', 671, 'EXECUTED', '9:71f8dc427a500f8da2cedf8c97e33152', 'sql', '', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-credentials_not_shared-column-in-scm-server-table', 'xzhao', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.641523', 672, 'EXECUTED', '9:691b4872fb76c3c63c3b4d109684b924', 'addColumn tableName=SCM_SERVER', 'Add column credentials_not_shared in scm_server table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-remove-the-table-denormalized_field_option-from-the-squash-database', 'jmarque and rfortoso', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.648499', 673, 'EXECUTED', '9:77e068b720f9736562413ef2099f151d', 'sql', 'DENORMALIZED_FIELD_OPTION has been unused for some time', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-validation-status-column-in-sprint-requirement-version-table', 'mbrugniere', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.651083', 674, 'EXECUTED', '9:0d755ad52c58dec5ae67c9258ff87053', 'addColumn tableName=SPRINT_REQ_VERSION', 'Add column validation_status in sprint_req_version table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.0.0-add-last_modified_on-column-in-attachment-table', 'xzhao', 'tm/tm.changelog-8.0.0.xml', '2025-04-03 16:51:16.653695', 675, 'EXECUTED', '9:1e180d5f12864542089b7494a4ea7b46', 'addColumn tableName=ATTACHMENT', 'Add column last_modified_on in attachment table', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-8.1.0-replace-SSF-by-CF-in-denormalized-field-table', 'jmarque', 'tm/tm.changelog-8.1.0.xml', '2025-04-03 16:51:16.662509', 678, 'EXECUTED', '9:c29f82942d725d35b3daf89b57ab44a2', 'update tableName=DENORMALIZED_FIELD_VALUE', 'Remove SSF reference in DENORMALIZED_FIELD_VALUE', NULL, '4.27.0', NULL, 'legacy', '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-remove-oauth1a-cred-and-conf', 'jprioux', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.664978', 679, 'EXECUTED', '9:e5564512878f47076d46caa26b1894de', 'delete tableName=STORED_CREDENTIALS', 'Remove OAUTH_1A stored credentials and configuration', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-migrate-oauth1a-to-oauth2', 'jprioux', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.667301', 680, 'EXECUTED', '9:517426670e824e2bb8b64483158764fc', 'update tableName=THIRD_PARTY_SERVER', 'Migrate OAUTH_1A third party servers to OAUTH_2', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-remove-active-column-in-project-table', 'jmarque', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.66977', 681, 'EXECUTED', '9:878da21f351724b52376b7dcbb6666c4', 'dropColumn columnName=ACTIVE, tableName=PROJECT', 'Remove column active in project table', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-add-index-on-execution-last-executed-on-to-improve-performance', 'mbrugniere', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.67406', 682, 'EXECUTED', '9:371c76a95979c6912b07e2088d702abe', 'createIndex indexName=idx_execution_last_executed_on, tableName=EXECUTION', 'Add index on the last_executed_on column of the execution table', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-create-failure-detail-table', 'fahadi', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.684853', 683, 'EXECUTED', '9:0036b4bb74ec666d47923bac270cb15e', 'createTable tableName=FAILURE_DETAIL', 'Create the failure detail table', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-create-failure-detail-indexes', 'fahadi', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.695775', 684, 'EXECUTED', '9:38ae23a75910b0e4ad869e3fffb2dbdc', 'createIndex indexName=idx_failure_detail_item_test_plan_id, tableName=FAILURE_DETAIL; createIndex indexName=idx_failure_detail_created_by, tableName=FAILURE_DETAIL; createIndex indexName=idx_fk_failure_detail_issue_list_id, tableName=FAILURE_DETAIL', 'Create indexes for failure detail table', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-create-automated-execution-failure-detail-table', 'fahadi', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.699073', 685, 'EXECUTED', '9:61d3d5b12bd8a66a092f8b5383675f2d', 'createTable tableName=AUTOMATED_EXECUTION_FAILURE_DETAIL', 'Create the automated execution failure detail table', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-create-automated-execution-failure-detail-indexes', 'fahadi', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.704676', 686, 'EXECUTED', '9:b4787ada82d7bd9a892e7d1f5a653392', 'createIndex indexName=idx_automated_execution_failure_detail_execution_extender_id, tableName=AUTOMATED_EXECUTION_FAILURE_DETAIL; createIndex indexName=idx_automated_execution_failure_detail_failure_detail_id, tableName=AUTOMATED_EXECUTION_FAILURE...', 'Create indexes for automated execution failure detail table', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-add-automated-execution-failure-detail-foreign-keys', 'fahadi', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.711758', 687, 'EXECUTED', '9:b5de3bfafdf2b9808d24039f1d55263b', 'addForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_FAILURE_DETAIL, constraintName=fk_automated_execution_failure_detail_failure_detail_id, referencedTableName=FAILURE_DETAIL; addForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_FAILURE...', 'Add foreign key constraints for automated execution failure detail table', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-add-remote_req_state-column-in-sprint_requirement_sync_extender-table', 'mbrugniere', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.717149', 688, 'EXECUTED', '9:6deed4ac1dd631803d529b8270377ff9', 'addColumn tableName=SPRINT_REQUIREMENT_SYNC_EXTENDER', 'Add remote_req_state column in SPRINT_REQUIREMENT_SYNC_EXTENDER', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0-add-column-flag-in-automated-execution-extender-table', 'xzhao', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.720391', 689, 'EXECUTED', '9:2a1fd202beaa54f6b65f29dfddecd8a4', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', 'Add column flag in automated execution extender table to store test execution indicators', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-9.0.0', 'jprioux', 'tm/tm.changelog-9.0.0.xml', '2025-04-03 16:51:16.72319', 690, 'EXECUTED', '9:68af7a8fe46929e1344fe06a77d92845', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-export-right-in-custom-report-workspace', 'bmarejus', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.727607', 691, 'EXECUTED', '9:82e6480dadeb2840ba7b81a5b9ba15e5', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-delete-execution-permission', 'bmarejus', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.731355', 692, 'EXECUTED', '9:97a59d379e93ac4c96c767e7d3a0f4d1', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-automated_suite_workflows-foreign-key', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.734377', 693, 'EXECUTED', '9:afb4edaf144aeffd70beb90b462167cd', 'dropForeignKeyConstraint baseTableName=AUTOMATED_SUITE_WORKFLOWS, constraintName=fk_automated_suite_workflows_suite_id', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-automated_execution_extender-foreign-key', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.737212', 694, 'EXECUTED', '9:51cd90365b7ebad8c0859c376087c078', 'dropForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_EXTENDER, constraintName=fk_auto_exec_suite', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-create-uuid-column', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.739759', 695, 'EXECUTED', '9:415c6e5bfb1a4a8dc6fc2ff99de280a2', 'addColumn tableName=AUTOMATED_SUITE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-migrate-data-to-uuid-column', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.742127', 696, 'EXECUTED', '9:248a4df5b7a03816eb207ddfcfb34139', 'update tableName=AUTOMATED_SUITE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-replace-varchar-suite_id-column-by-bigint-suite_id-column-in-automated_suites', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.74657', 697, 'EXECUTED', '9:1d795624d2736c2aa1528cd0b1f7afe0', 'dropColumn columnName=SUITE_ID, tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-populate-suite-id-postgres-h2', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.754011', 698, 'EXECUTED', '9:d7b9b98e8d14c2843990aada8618718f', 'sql; sql; sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-suite-id-primary-key', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.759141', 699, 'EXECUTED', '9:5fc100e3d7ac7e379e5c12692a160c73', 'addNotNullConstraint columnName=SUITE_ID, tableName=AUTOMATED_SUITE; addPrimaryKey constraintName=pk_automated_suite, tableName=AUTOMATED_SUITE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-auto-increment-to-suite-id-postgres', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.763779', 700, 'EXECUTED', '9:cb55c03d56168f38852ad14a3f8314c4', 'sql; sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.767088', 701, 'EXECUTED', '9:ec3dc24946bb776d421bedf0ff860062', 'renameColumn newColumnName=UUID, oldColumnName=SUITE_ID, tableName=AUTOMATED_SUITE_WORKFLOWS; addColumn tableName=AUTOMATED_SUITE_WORKFLOWS', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.770625', 702, 'EXECUTED', '9:25c3b59a0b5e356dec93b59671cf618d', 'renameColumn newColumnName=UUID, oldColumnName=SUITE_ID, tableName=AUTOMATED_EXECUTION_EXTENDER; addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-update-automated_suite-constraints', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.774809', 703, 'EXECUTED', '9:a5597c31763134fc900117f0ce7622b8', 'addUniqueConstraint constraintName=uq_automated_suite_uuid, tableName=AUTOMATED_SUITE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-fill-out-suite_id-column-in-automated_suite_workflows-based-on-existing-references-posgres', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.778236', 704, 'EXECUTED', '9:81b7bb9cde82165cecac6a0073c04226', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-fill-out-suite_id-column-in-automated_execution_extender-based-on-existing-references-postgres', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.780855', 705, 'EXECUTED', '9:e67fd62138fc6afc9bb5859a3585ae04', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.784795', 706, 'EXECUTED', '9:43252ff1bdc9b52d8a91c8916764ee2c', 'createIndex indexName=idx_fk_automated_suite_workflows_suite_id, tableName=AUTOMATED_SUITE_WORKFLOWS', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.788505', 707, 'EXECUTED', '9:a9ff19ce080f815180e3485f3d33457b', 'createIndex indexName=idx_fk_automated_execution_extender_suite_id, tableName=AUTOMATED_EXECUTION_EXTENDER', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-to-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.79171', 708, 'EXECUTED', '9:bd0c9a55b1da9f652de6143b849d1e7d', 'addForeignKeyConstraint baseTableName=AUTOMATED_SUITE_WORKFLOWS, constraintName=fk_automated_suite_workflows_automated_suite, referencedTableName=AUTOMATED_SUITE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-to-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.795161', 709, 'EXECUTED', '9:4d321ab3c02545affd02205c2c565370', 'addForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_EXTENDER, constraintName=fk_automated_execution_extender_automated_suite, referencedTableName=AUTOMATED_SUITE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-uuid-column-in-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.797527', 710, 'EXECUTED', '9:7022bc31160990571dfc0a0408297ee7', 'dropColumn columnName=UUID, tableName=AUTOMATED_SUITE_WORKFLOWS', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-uuid-column-in-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.801444', 711, 'EXECUTED', '9:710cf945d3ab462aca7b6d2c4b979046', 'dropColumn columnName=UUID, tableName=AUTOMATED_EXECUTION_EXTENDER', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-create-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.84581', 712, 'EXECUTED', '9:83d158dd232e6fff162886c273857bd1', 'createTable tableName=TMP_EXECUTIONS_TO_DELETE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-truncate-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.850449', 713, 'EXECUTED', '9:0b871fa255e9370143292962bccd6cf8', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-fill-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.856636', 714, 'EXECUTED', '9:e54f4faa938cf319932860c02c7cffa5', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-delete-orphan-executions', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.876929', 715, 'EXECUTED', '9:b88b3341cb616f0d37bb03290f2690af', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.881216', 716, 'EXECUTED', '9:ebe89a0d616725c274b4099cbe3f4bf4', 'dropTable tableName=TMP_EXECUTIONS_TO_DELETE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-iteration-testplan', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.885755', 717, 'EXECUTED', '9:cc0756d81bf56192693c7bc1f30a77b2', 'addColumn tableName=ITERATION', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-index-on-iteration.test_plan_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.889728', 718, 'EXECUTED', '9:7e02cec576c7ba3e00362f7d4bcdd774', 'createIndex indexName=idx_iteration_test_plan_id, tableName=ITERATION', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-test_plan.tmp_iteration_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.892239', 719, 'EXECUTED', '9:958c4d63ce8bc5dcb7baed32dfd4e7af', 'addColumn tableName=TEST_PLAN', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-index-for-test_plan.tmp_iteration_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.898737', 720, 'EXECUTED', '9:9f102b53a6efdcd41348781d4d7792b8', 'createIndex indexName=idx_test_plan_tmp_iteration_id, tableName=TEST_PLAN', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-create-iteration-test-plans', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.906441', 721, 'EXECUTED', '9:d130fc9a5d9be9ae377e145dfcb1ce6d', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-test_plan.tmp_iteration_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.910453', 722, 'EXECUTED', '9:92f14b8bde955b1544accc5892636dd6', 'dropColumn columnName=TMP_ITERATION_ID, tableName=TEST_PLAN', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-non-nullable-constraint-to-iteration-test_plan_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.912983', 723, 'EXECUTED', '9:7fa828dab7adb3b81f097bb8e7d15514', 'addNotNullConstraint columnName=TEST_PLAN_ID, tableName=ITERATION', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-test_plan_item.tmp_itpi_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.919171', 724, 'EXECUTED', '9:4ad56115e6250cf6282e74c9927a5aa8', 'addColumn tableName=TEST_PLAN_ITEM', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-index-for-test_plan_item.tmp_itpi_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.924625', 725, 'EXECUTED', '9:c89cd93093a6822e4cd4489d807dfe40', 'createIndex indexName=idx_test_plan_item_tmp_itpi_id, tableName=TEST_PLAN_ITEM', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-migrate-iteration-test-plan-item', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.930111', 726, 'EXECUTED', '9:235da7541a83c7c816a240256043b5be', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-migrate-iteration-executions', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.934417', 727, 'EXECUTED', '9:850a27a201bf9d8446e10328124b3320', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-unique-constraint-on-execution_order', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.93837', 728, 'EXECUTED', '9:ef983d749257e95a585e42be3230b600', 'addUniqueConstraint constraintName=uq_execution_execution_order_test_plan_item_id, tableName=EXECUTION', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-non-nullable-constraint-to-execution-test_plan_item_id-and-execution_order', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.94124', 729, 'EXECUTED', '9:b096107ab1c19dad998a54c4a8faa922', 'addNotNullConstraint columnName=TEST_PLAN_ITEM_ID, tableName=EXECUTION; addNotNullConstraint columnName=EXECUTION_ORDER, tableName=EXECUTION', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-test_suite_test_plan_item-fk', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.943576', 730, 'EXECUTED', '9:90ca8cb64e72a7fd92a178d6cd3e7424', 'dropForeignKeyConstraint baseTableName=TEST_SUITE_TEST_PLAN_ITEM, constraintName=fk_test_suite_test_plan_item_test_plan_item', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-migrate-test-suite-data', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.947841', 731, 'EXECUTED', '9:fd99b2a4eb9c7e9fef750fc7f94cc737', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-migrate-test-suite-item-fk', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.950756', 732, 'EXECUTED', '9:08549324b419e68cf670433c42609a79', 'addForeignKeyConstraint baseTableName=TEST_SUITE_TEST_PLAN_ITEM, constraintName=fk_test_suite_test_plan_item_test_plan_item, referencedTableName=TEST_PLAN_ITEM', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-rename-failure_detail.item_test_plan_id-and-drop-fk', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.953882', 733, 'EXECUTED', '9:fec6c79158543e0987b769116d89ffb8', 'dropForeignKeyConstraint baseTableName=FAILURE_DETAIL, constraintName=fk_failure_detail_itpi_id; renameColumn newColumnName=TEST_PLAN_ITEM_ID, oldColumnName=ITEM_TEST_PLAN_ID, tableName=FAILURE_DETAIL', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-migrate-failure_detail-data', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.95684', 734, 'EXECUTED', '9:c36d859a5cb225ab794c39b634d7b500', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-fk-to-failure_detail.test_plan_item_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.959962', 735, 'EXECUTED', '9:20f178830835abe5f5de2e6c164444a7', 'addForeignKeyConstraint baseTableName=FAILURE_DETAIL, constraintName=fk_failure_detail_test_plan_item, referencedTableName=TEST_PLAN_ITEM', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-create-test_plan_item.overview_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.973344', 736, 'EXECUTED', '9:8f21e6422ab33af99a868b82361b89d2', 'addColumn tableName=TEST_PLAN_ITEM', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-index-on-test_plan_item.overview_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.978657', 737, 'EXECUTED', '9:5cff545e6fc4b35926debee5e9c0f804', 'createIndex indexName=idx_test_plan_item_overview_id, tableName=TEST_PLAN_ITEM', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-migrate-session-overview-data', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.982166', 738, 'EXECUTED', '9:c15a726de90d4c4d0013f163068667f0', 'sql', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-test_plan_item.tmp_itpi_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.986926', 739, 'EXECUTED', '9:4a79a13202717f31c6812b248c33e0f7', 'dropForeignKeyConstraint baseTableName=TEST_PLAN_ITEM, constraintName=fk_test_plan_item_iteration_test_plan_item; dropColumn columnName=TMP_ITPI_ID, tableName=TEST_PLAN_ITEM', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-exploratory_session_overview-test-plan-columns', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:16.993238', 740, 'EXECUTED', '9:7ac87751311f473f2d1fc39b50b90cf7', 'dropForeignKeyConstraint baseTableName=EXPLORATORY_SESSION_OVERVIEW, constraintName=fk_exploratory_session_test_plan_item; dropForeignKeyConstraint baseTableName=EXPLORATORY_SESSION_OVERVIEW, constraintName=fk_exploratory_session_overview; dropCol...', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-item_test_plan_execution-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.000228', 741, 'EXECUTED', '9:5f0f071058f46a87a2387e30e52acf6c', 'dropTable tableName=ITEM_TEST_PLAN_EXECUTION', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-item_test_plan_list-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.006884', 742, 'EXECUTED', '9:9d00a54dd2b8bc69123bc3c15d25ad43', 'dropTable tableName=ITEM_TEST_PLAN_LIST', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-drop-iteration_test_plan_item-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.017619', 743, 'EXECUTED', '9:2d204f5a75e9232c7dd63590a47d25d1', 'dropTable tableName=ITERATION_TEST_PLAN_ITEM', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-migrate-query_column_prototype-for-item_test_plan_tester', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.020158', 744, 'EXECUTED', '9:a097bef0e3b8d918bbd08387754ad46d', 'update tableName=QUERY_COLUMN_PROTOTYPE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-migrate-query_column_prototype-for-iteration_itemcount', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.022498', 745, 'EXECUTED', '9:99160695289a1d8e001ccacda21c7adf', 'update tableName=QUERY_COLUMN_PROTOTYPE', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-infrasturucture-admin-group', 'jprioux', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.02476', 746, 'EXECUTED', '9:03f884f749dcbb530204672ff5e601a1', 'insert tableName=CORE_GROUP', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-infrasturucture-admin-group-authority', 'jprioux', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.027257', 747, 'EXECUTED', '9:ab73a79080ca84c86e2208656039ca84', 'insert tableName=CORE_GROUP_AUTHORITY', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-not-null-constraint-on-automated-suite-workflows-suite-id', 'jprioux', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.030399', 748, 'EXECUTED', '9:3cbfa0e1614ccc5218665ce59bf11617', 'addNotNullConstraint columnName=SUITE_ID, tableName=AUTOMATED_SUITE_WORKFLOWS', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0-add-not-null-constraint-on-automated-execution-extender-suite-id', 'jprioux', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.032735', 749, 'EXECUTED', '9:fe3bc7bc3baffa37db48781795d0088c', 'addNotNullConstraint columnName=SUITE_ID, tableName=AUTOMATED_EXECUTION_EXTENDER', '', NULL, '4.27.0', NULL, NULL, '3691869110');
INSERT INTO public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) VALUES ('tm-10.0.0', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', '2025-04-03 16:51:17.03492', 750, 'EXECUTED', '9:170245afb47a5a4680a5515c84ca9a1e', 'update tableName=CORE_CONFIG', 'Update TM database version number', NULL, '4.27.0', NULL, NULL, '3691869110');


--
-- Data for Name: databasechangeloglock; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.databasechangeloglock (id, locked, lockgranted, lockedby) VALUES (1, false, NULL, NULL);


--
-- Data for Name: dataset; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: dataset_param_value; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: denormalized_environment_tag; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: denormalized_environment_variable; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: denormalized_field_rendering_location; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: denormalized_field_value; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: denormalized_field_value_option; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: disabled_execution_status; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: environment_variable; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: environment_variable_binding; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: environment_variable_option; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: execution; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: execution_execution_steps; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: execution_step; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: exploratory_execution; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: exploratory_execution_event; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: exploratory_session_overview; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: exploratory_test_case; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: failure_detail; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: grid_column_display_configuration; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: grid_column_display_reference; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: high_level_requirement; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: info_list; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.info_list (info_list_id, label, description, code, created_by, created_on, last_modified_by, last_modified_on) VALUES (1, 'infolist.category.default', '', 'DEF_REQ_CAT', 'system', '2010-01-01 00:00:00', 'system', '2010-01-01 00:00:00');
INSERT INTO public.info_list (info_list_id, label, description, code, created_by, created_on, last_modified_by, last_modified_on) VALUES (2, 'infolist.nature.default', '', 'DEF_TC_NAT', 'system', '2010-01-01 00:00:00', 'system', '2010-01-01 00:00:00');
INSERT INTO public.info_list (info_list_id, label, description, code, created_by, created_on, last_modified_by, last_modified_on) VALUES (3, 'infolist.type.default', '', 'DEF_TC_TYP', 'system', '2010-01-01 00:00:00', 'system', '2010-01-01 00:00:00');


--
-- Data for Name: info_list_item; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (22, 'SYS', 3, 2, 'test-case.type.TYP_CORRECTION_TESTING', 'TYP_CORRECTION_TESTING', false, 'bug', '#CD533B');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (17, 'SYS', 2, 5, 'test-case.nature.NAT_PERFORMANCE_TESTING', 'NAT_PERFORMANCE_TESTING', false, 'dashboard', '#FCCA46');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (8, 'SYS', 1, 7, 'requirement.category.CAT_PERFORMANCE', 'CAT_PERFORMANCE', false, 'dashboard', '#FCCA46');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (9, 'SYS', 1, 8, 'requirement.category.CAT_TECHNICAL', 'CAT_TECHNICAL', false, 'key', '#233D4D');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (13, 'SYS', 2, 1, 'test-case.nature.NAT_FUNCTIONAL_TESTING', 'NAT_FUNCTIONAL_TESTING', false, 'monitor', '#7594CD');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (1, 'SYS', 1, 0, 'requirement.category.CAT_FUNCTIONAL', 'CAT_FUNCTIONAL', false, 'monitor', '#7594CD');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (16, 'SYS', 2, 4, 'test-case.nature.NAT_NON_FUNCTIONAL_TESTING', 'NAT_NON_FUNCTIONAL_TESTING', false, 'server', '#BB5759');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (2, 'SYS', 1, 1, 'requirement.category.CAT_NON_FUNCTIONAL', 'CAT_NON_FUNCTIONAL', false, 'server', '#BB5759');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (15, 'SYS', 2, 3, 'test-case.nature.NAT_USER_TESTING', 'NAT_USER_TESTING', false, 'user', '#A1C181');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (18, 'SYS', 2, 6, 'test-case.nature.NAT_SECURITY_TESTING', 'NAT_SECURITY_TESTING', false, 'protect', '#FE7F2D');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (19, 'SYS', 2, 7, 'test-case.nature.NAT_ATDD', 'NAT_ATDD', false, 'circular_arrows', '#233D4D');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (12, 'SYS', 2, 0, 'test-case.nature.NAT_UNDEFINED', 'NAT_UNDEFINED', true, 'indeterminate_checkbox_empty', '#CDCDCD');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (20, 'SYS', 3, 0, 'test-case.type.TYP_UNDEFINED', 'TYP_UNDEFINED', true, 'indeterminate_checkbox_empty', '#CDCDCD');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (21, 'SYS', 3, 1, 'test-case.type.TYP_COMPLIANCE_TESTING', 'TYP_COMPLIANCE_TESTING', false, 'task_completed', '#5B9367');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (23, 'SYS', 3, 3, 'test-case.type.TYP_EVOLUTION_TESTING', 'TYP_EVOLUTION_TESTING', false, 'circled_up_right', '#D8A86E');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (24, 'SYS', 3, 4, 'test-case.type.TYP_REGRESSION_TESTING', 'TYP_REGRESSION_TESTING', false, 'circular_arrows', '#F2E77E');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (25, 'SYS', 3, 5, 'test-case.type.TYP_END_TO_END_TESTING', 'TYP_END_TO_END_TESTING', false, 'journey', '#2D5635');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (26, 'SYS', 3, 6, 'test-case.type.TYP_PARTNER_TESTING', 'TYP_PARTNER_TESTING', false, 'handshake', '#F2E2CE');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (3, 'SYS', 1, 2, 'requirement.category.CAT_USE_CASE', 'CAT_USE_CASE', false, 'read', '#A1C181');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (5, 'SYS', 1, 4, 'requirement.category.CAT_TEST_REQUIREMENT', 'CAT_TEST_REQUIREMENT', false, 'checked_checkbox', '#C3AB77');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (6, 'SYS', 1, 5, 'requirement.category.CAT_UNDEFINED', 'CAT_UNDEFINED', true, 'indeterminate_checkbox_empty', '#CDCDCD');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (7, 'SYS', 1, 6, 'requirement.category.CAT_ERGONOMIC', 'CAT_ERGONOMIC', false, 'puzzle', '#8F6057');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (11, 'SYS', 1, 10, 'requirement.category.CAT_SECURITY', 'CAT_SECURITY', false, 'protect', '#FE7F2D');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (10, 'SYS', 1, 9, 'requirement.category.CAT_USER_STORY', 'CAT_USER_STORY', false, 'bookmark', '#094C75');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (14, 'SYS', 2, 2, 'test-case.nature.NAT_BUSINESS_TESTING', 'NAT_BUSINESS_TESTING', false, 'briefcase', '#619B8A');
INSERT INTO public.info_list_item (item_id, item_type, list_id, item_index, label, code, is_default, icon_name, colour) VALUES (4, 'SYS', 1, 3, 'requirement.category.CAT_BUSINESS', 'CAT_BUSINESS', false, 'briefcase', '#619B8A');


--
-- Data for Name: issue; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: issue_list; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: iteration; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: iteration_test_suite; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: keyword_execution; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: keyword_test_case; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: keyword_test_step; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: library_plugin_binding; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: library_plugin_binding_property; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: milestone; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: milestone_binding; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: milestone_binding_perimeter; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: milestone_campaign; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: milestone_req_version; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: milestone_test_case; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: oauth_access_token; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: oauth_approvals; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: oauth_client_details; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: oauth_client_token; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: oauth_code; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: oauth_refresh_token; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: parameter; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: party_preference; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: pivot_format_import; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: project; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: project_filter; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: project_filter_entry; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: query_aggregation_column; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (1, 1, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (2, 7, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (3, 7, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (4, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (5, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (6, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (7, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (8, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (9, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (10, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (11, 37, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (12, 37, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (13, 46, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (14, 46, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (15, 54, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (16, 54, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (17, 54, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (18, 54, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (19, 54, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (20, 66, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (21, 66, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (22, 7, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (23, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (24, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (25, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (26, 54, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (27, 54, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (28, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (29, 19, NULL, 'NONE', 0, NULL);
INSERT INTO public.query_aggregation_column (query_model_id, query_column_id, label, aggregation_operation, aggregation_rank, cuf_id) VALUES (30, 1, NULL, 'NONE', 0, NULL);


--
-- Data for Name: query_column_prototype; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (1, 'ATTRIBUTE', NULL, 'REQUIREMENT_ID', 'REQUIREMENT', NULL, 'id', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (3, 'ATTRIBUTE', NULL, 'REQUIREMENT_PROJECT', 'REQUIREMENT', NULL, 'project.id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (4, 'ATTRIBUTE', NULL, 'REQUIREMENT_CRITICALITY', 'REQUIREMENT', NULL, 'resource.criticality', 'LEVEL_ENUM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (6, 'ATTRIBUTE', NULL, 'REQUIREMENT_CATEGORY', 'REQUIREMENT', NULL, 'resource.category.code', 'INFO_LIST_ITEM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (7, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_ID', 'REQUIREMENT_VERSION', NULL, 'id', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (8, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_REFERENCE', 'REQUIREMENT_VERSION', NULL, 'reference', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (9, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_CATEGORY', 'REQUIREMENT_VERSION', NULL, 'category.code', 'INFO_LIST_ITEM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (10, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_CRITICALITY', 'REQUIREMENT_VERSION', NULL, 'criticality', 'LEVEL_ENUM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (12, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_CREATED_BY', 'REQUIREMENT_VERSION', NULL, 'audit.createdBy', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (13, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_CREATED_ON', 'REQUIREMENT_VERSION', NULL, 'audit.createdOn', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (14, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_MODIFIED_BY', 'REQUIREMENT_VERSION', NULL, 'audit.lastModifiedBy', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (15, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_MODIFIED_ON', 'REQUIREMENT_VERSION', NULL, 'audit.lastModifiedOn', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (16, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_VERS_NUM', 'REQUIREMENT_VERSION', NULL, 'versionNumber', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (19, 'ATTRIBUTE', NULL, 'TEST_CASE_ID', 'TEST_CASE', NULL, 'id', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (20, 'ATTRIBUTE', NULL, 'TEST_CASE_REFERENCE', 'TEST_CASE', NULL, 'reference', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (21, 'ATTRIBUTE', NULL, 'TEST_CASE_IMPORTANCE', 'TEST_CASE', NULL, 'importance', 'LEVEL_ENUM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (22, 'ATTRIBUTE', NULL, 'TEST_CASE_NATURE', 'TEST_CASE', NULL, 'nature.code', 'INFO_LIST_ITEM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (23, 'ATTRIBUTE', NULL, 'TEST_CASE_TYPE', 'TEST_CASE', NULL, 'type.code', 'INFO_LIST_ITEM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (24, 'ATTRIBUTE', NULL, 'TEST_CASE_STATUS', 'TEST_CASE', NULL, 'status', 'LEVEL_ENUM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (25, 'ATTRIBUTE', NULL, 'TEST_CASE_CREATED_BY', 'TEST_CASE', NULL, 'audit.createdBy', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (26, 'ATTRIBUTE', NULL, 'TEST_CASE_CREATED_ON', 'TEST_CASE', NULL, 'audit.createdOn', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (27, 'ATTRIBUTE', NULL, 'TEST_CASE_MODIFIED_BY', 'TEST_CASE', NULL, 'audit.lastModifiedBy', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (28, 'ATTRIBUTE', NULL, 'TEST_CASE_MODIFIED_ON', 'TEST_CASE', NULL, 'audit.lastModifiedOn', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (29, 'ATTRIBUTE', NULL, 'TEST_CASE_PROJECT', 'TEST_CASE', NULL, 'project.id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (37, 'ATTRIBUTE', NULL, 'CAMPAIGN_ID', 'CAMPAIGN', NULL, 'id', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (38, 'ATTRIBUTE', NULL, 'CAMPAIGN_PROJECT', 'CAMPAIGN', NULL, 'project.id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (39, 'ATTRIBUTE', NULL, 'CAMPAIGN_REFERENCE', 'CAMPAIGN', NULL, 'reference', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (40, 'ATTRIBUTE', NULL, 'CAMPAIGN_SCHED_START', 'CAMPAIGN', NULL, 'scheduledPeriod.scheduledStartDate', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (41, 'ATTRIBUTE', NULL, 'CAMPAIGN_SCHED_END', 'CAMPAIGN', NULL, 'scheduledPeriod.scheduledEndDate', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (42, 'ATTRIBUTE', NULL, 'CAMPAIGN_ACTUAL_START', 'CAMPAIGN', NULL, 'actualPeriod.actualStartDate', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (43, 'ATTRIBUTE', NULL, 'CAMPAIGN_ACTUAL_END', 'CAMPAIGN', NULL, 'actualPeriod.actualEndDate', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (46, 'ATTRIBUTE', NULL, 'ITERATION_ID', 'ITERATION', NULL, 'id', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (47, 'ATTRIBUTE', NULL, 'ITERATION_REFERENCE', 'ITERATION', NULL, 'reference', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (48, 'ATTRIBUTE', NULL, 'ITERATION_SCHED_START', 'ITERATION', NULL, 'scheduledPeriod.scheduledStartDate', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (49, 'ATTRIBUTE', NULL, 'ITERATION_SCHED_END', 'ITERATION', NULL, 'scheduledPeriod.scheduledEndDate', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (50, 'ATTRIBUTE', NULL, 'ITERATION_ACTUAL_START', 'ITERATION', NULL, 'actualPeriod.actualStartDate', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (51, 'ATTRIBUTE', NULL, 'ITERATION_ACTUAL_END', 'ITERATION', NULL, 'actualPeriod.actualEndDate', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (54, 'ATTRIBUTE', NULL, 'ITEM_TEST_PLAN_ID', 'ITEM_TEST_PLAN', NULL, 'id', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (55, 'ATTRIBUTE', NULL, 'ITEM_TEST_PLAN_LABEL', 'ITEM_TEST_PLAN', NULL, 'label', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (56, 'ATTRIBUTE', NULL, 'ITEM_TEST_PLAN_STATUS', 'ITEM_TEST_PLAN', NULL, 'executionStatus', 'EXECUTION_STATUS', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (57, 'ATTRIBUTE', NULL, 'ITEM_TEST_PLAN_LASTEXECON', 'ITEM_TEST_PLAN', NULL, 'lastExecutedOn', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (58, 'ATTRIBUTE', NULL, 'ITEM_TEST_PLAN_DATASET_LABEL', 'ITEM_TEST_PLAN', NULL, 'referencedDataset.name', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (60, 'ATTRIBUTE', NULL, 'ITEM_TEST_PLAN_TC_ID', 'ITEM_TEST_PLAN', NULL, 'referencedTestCase.id', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (66, 'ATTRIBUTE', NULL, 'EXECUTION_ID', 'EXECUTION', NULL, 'id', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (67, 'ATTRIBUTE', NULL, 'EXECUTION_LABEL', 'EXECUTION', NULL, 'name', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (68, 'ATTRIBUTE', NULL, 'EXECUTION_DS_LABEL', 'EXECUTION', NULL, 'datasetLabel', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (69, 'ATTRIBUTE', NULL, 'EXECUTION_LASTEXEC', 'EXECUTION', NULL, 'lastExecutedOn', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (70, 'ATTRIBUTE', NULL, 'EXECUTION_TESTER_LOGIN', 'EXECUTION', NULL, 'lastExecutedBy', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (71, 'ATTRIBUTE', NULL, 'EXECUTION_STATUS', 'EXECUTION', NULL, 'executionStatus', 'EXECUTION_STATUS', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (74, 'ATTRIBUTE', NULL, 'ISSUE_ID', 'ISSUE', NULL, 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (75, 'ATTRIBUTE', NULL, 'ISSUE_REMOTE_ID', 'ISSUE', NULL, 'remoteIssueId', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (76, 'ATTRIBUTE', NULL, 'ISSUE_STATUS', 'ISSUE', NULL, 'status', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (77, 'ATTRIBUTE', NULL, 'ISSUE_SEVERITY', 'ISSUE', NULL, 'severity', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (78, 'ATTRIBUTE', NULL, 'ISSUE_BUGTRACKER', 'ISSUE', NULL, 'bugtracker', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (79, 'ATTRIBUTE', NULL, 'TEST_CASE_STEP_ID', 'TEST_CASE_STEP', NULL, 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (80, 'ATTRIBUTE', NULL, 'TEST_CASE_STEP_CLASS', 'TEST_CASE_STEP', NULL, 'class', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (81, 'ATTRIBUTE', NULL, 'TEST_CASE_NATURE_ID', 'INFO_LIST_ITEM', 'TEST_CASE_NATURE', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (82, 'ATTRIBUTE', NULL, 'TEST_CASE_NATURE_LABEL', 'INFO_LIST_ITEM', 'TEST_CASE_NATURE', 'label', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (83, 'ATTRIBUTE', NULL, 'TEST_CASE_TYPE_ID', 'INFO_LIST_ITEM', 'TEST_CASE_TYPE', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (84, 'ATTRIBUTE', NULL, 'TEST_CASE_TYPE_LABEL', 'INFO_LIST_ITEM', 'TEST_CASE_TYPE', 'label', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (85, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_CATEGORY_ID', 'INFO_LIST_ITEM', 'REQUIREMENT_VERSION_CATEGORY', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (86, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_CATEGORY_LABEL', 'INFO_LIST_ITEM', 'REQUIREMENT_VERSION_CATEGORY', 'label', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (87, 'ATTRIBUTE', NULL, 'TEST_CASE_MILESTONE_ID', 'MILESTONE', 'TEST_CASE_MILESTONE', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (88, 'ATTRIBUTE', NULL, 'TEST_CASE_MILESTONE_LABEL', 'MILESTONE', 'TEST_CASE_MILESTONE', 'label', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (89, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_MILESTONE_ID', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (90, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_MILESTONE_LABEL', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', 'label', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (5, 'ATTRIBUTE', NULL, 'REQUIREMENT_STATUS', 'REQUIREMENT', NULL, 'resource.status', 'REQUIREMENT_STATUS', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (59, 'ATTRIBUTE', NULL, 'ITEM_TEST_PLAN_TESTER', 'ITEM_TEST_PLAN', NULL, 'assignee.login', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (91, 'ATTRIBUTE', NULL, 'ITERATION_TEST_PLAN_ASSIGNED_USER_ID', 'USER', 'ITERATION_TEST_PLAN_ASSIGNED_USER', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (92, 'ATTRIBUTE', NULL, 'ITERATION_TEST_PLAN_ASSIGNED_USER_LOGIN', 'USER', 'ITERATION_TEST_PLAN_ASSIGNED_USER', 'login', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (93, 'ATTRIBUTE', NULL, 'AUTOMATED_TEST_ID', 'AUTOMATED_TEST', NULL, 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (94, 'ATTRIBUTE', NULL, 'AUTOMATED_EXECUTION_EXTENDER_ID', 'AUTOMATED_EXECUTION_EXTENDER', NULL, 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (2, 'CALCULATED', 1, 'REQUIREMENT_NB_VERSIONS', 'REQUIREMENT', NULL, 'count(requirementVersionCoverages)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (17, 'CALCULATED', 2, 'REQUIREMENT_VERSION_TCCOUNT', 'REQUIREMENT_VERSION', NULL, 'count(requirementVersionCoverages)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (18, 'CALCULATED', 3, 'REQUIREMENT_VERSION_MILCOUNT', 'REQUIREMENT_VERSION', NULL, 'count(milestones)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (30, 'CALCULATED', 4, 'TEST_CASE_VERSCOUNT', 'TEST_CASE', NULL, 'count(requirementVersionCoverages)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (31, 'CALCULATED', 5, 'TEST_CASE_CALLSTEPCOUNT', 'TEST_CASE', NULL, 'count(steps[class="CallTestStep"])', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (32, 'CALCULATED', 6, 'TEST_CASE_STEPCOUNT', 'TEST_CASE', NULL, 'count(steps)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (33, 'CALCULATED', 7, 'TEST_CASE_MILCOUNT', 'TEST_CASE', NULL, 'count(milestones)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (34, 'CALCULATED', 8, 'TEST_CASE_ITERCOUNT', 'TEST_CASE', NULL, 'count(iterations)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (35, 'CALCULATED', 9, 'TEST_CASE_EXECOUNT', 'TEST_CASE', NULL, 'count(executions)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (36, 'CALCULATED', 10, 'TEST_CASE_HASAUTOSCRIPT', 'TEST_CASE', NULL, 'notnull(automatedTest)', 'BOOLEAN', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (44, 'CALCULATED', 11, 'CAMPAIGN_ITERCOUNT', 'CAMPAIGN', NULL, 'count(iterations)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (45, 'CALCULATED', 12, 'CAMPAIGN_ISSUECOUNT', 'CAMPAIGN', NULL, 'count(issues)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (53, 'CALCULATED', 14, 'ITERATION_ISSUECOUNT', 'ITERATION', NULL, 'count(issues)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (61, 'CALCULATED', 15, 'ITEM_TEST_PLAN_TC_DELETED', 'ITEM_TEST_PLAN', NULL, 'isnull(referencedTestCase)', 'BOOLEAN', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (62, 'CALCULATED', 16, 'ITEM_TEST_PLAN_IS_EXECUTED', 'ITEM_TEST_PLAN', NULL, 'notnull(executions)', 'BOOLEAN', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (63, 'CALCULATED', 17, 'ITEM_TEST_PLAN_MANEXCOUNT', 'ITEM_TEST_PLAN', NULL, 'count(executions[auto="false"])', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (64, 'CALCULATED', 18, 'ITEM_TEST_PLAN_AUTOEXCOUNT', 'ITEM_TEST_PLAN', NULL, 'count(executions[auto="true"])', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (65, 'CALCULATED', 19, 'ITEM_TEST_PLAN_ISSUECOUNT', 'ITEM_TEST_PLAN', NULL, 'count(issues)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (72, 'CALCULATED', 20, 'EXECUTION_ISAUTO', 'EXECUTION', NULL, 'notnull(automatedExecutionExtender)', 'BOOLEAN', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (73, 'CALCULATED', 21, 'EXECUTION_ISSUECOUNT', 'EXECUTION', NULL, 'count(issues)', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (95, 'CUF', NULL, 'REQUIREMENT_VERSION_CUF_TEXT', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'value', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (96, 'CUF', NULL, 'REQUIREMENT_VERSION_CUF_CHECKBOX', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'value', 'BOOLEAN_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (97, 'CUF', NULL, 'REQUIREMENT_VERSION_CUF_LIST', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'value', 'LIST', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (98, 'CUF', NULL, 'REQUIREMENT_VERSION_CUF_DATE', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'value', 'DATE_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (99, 'CUF', NULL, 'REQUIREMENT_VERSION_CUF_TAG', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'value', 'TAG', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (100, 'CUF', NULL, 'REQUIREMENT_VERSION_CUF_NUMERIC', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'value', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (101, 'CUF', NULL, 'TEST_CASE_CUF_TEXT', 'TEST_CASE', 'CUSTOM_FIELD', 'value', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (102, 'CUF', NULL, 'TEST_CASE_CUF_CHECKBOX', 'TEST_CASE', 'CUSTOM_FIELD', 'value', 'BOOLEAN_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (103, 'CUF', NULL, 'TEST_CASE_CUF_LIST', 'TEST_CASE', 'CUSTOM_FIELD', 'value', 'LIST', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (104, 'CUF', NULL, 'TEST_CASE_CUF_DATE', 'TEST_CASE', 'CUSTOM_FIELD', 'value', 'DATE_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (105, 'CUF', NULL, 'TEST_CASE_CUF_TAG', 'TEST_CASE', 'CUSTOM_FIELD', 'value', 'TAG', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (106, 'CUF', NULL, 'TEST_CASE_CUF_NUMERIC', 'TEST_CASE', 'CUSTOM_FIELD', 'value', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (107, 'CUF', NULL, 'CAMPAIGN_CUF_TEXT', 'CAMPAIGN', 'CUSTOM_FIELD', 'value', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (108, 'CUF', NULL, 'CAMPAIGN_CUF_CHECKBOX', 'CAMPAIGN', 'CUSTOM_FIELD', 'value', 'BOOLEAN_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (109, 'CUF', NULL, 'CAMPAIGN_CUF_LIST', 'CAMPAIGN', 'CUSTOM_FIELD', 'value', 'LIST', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (110, 'CUF', NULL, 'CAMPAIGN_CUF_DATE', 'CAMPAIGN', 'CUSTOM_FIELD', 'value', 'DATE_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (111, 'CUF', NULL, 'CAMPAIGN_CUF_TAG', 'CAMPAIGN', 'CUSTOM_FIELD', 'value', 'TAG', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (112, 'CUF', NULL, 'CAMPAIGN_CUF_NUMERIC', 'CAMPAIGN', 'CUSTOM_FIELD', 'value', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (113, 'CUF', NULL, 'ITERATION_CUF_TEXT', 'ITERATION', 'CUSTOM_FIELD', 'value', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (114, 'CUF', NULL, 'ITERATION_CUF_CHECKBOX', 'ITERATION', 'CUSTOM_FIELD', 'value', 'BOOLEAN_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (115, 'CUF', NULL, 'ITERATION_CUF_LIST', 'ITERATION', 'CUSTOM_FIELD', 'value', 'LIST', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (116, 'CUF', NULL, 'ITERATION_CUF_DATE', 'ITERATION', 'CUSTOM_FIELD', 'value', 'DATE_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (117, 'CUF', NULL, 'ITERATION_CUF_TAG', 'ITERATION', 'CUSTOM_FIELD', 'value', 'TAG', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (118, 'CUF', NULL, 'ITERATION_CUF_NUMERIC', 'ITERATION', 'CUSTOM_FIELD', 'value', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (119, 'CUF', NULL, 'EXECUTION_CUF_TEXT', 'EXECUTION', 'CUSTOM_FIELD', 'value', 'STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (120, 'CUF', NULL, 'EXECUTION_CUF_CHECKBOX', 'EXECUTION', 'CUSTOM_FIELD', 'value', 'BOOLEAN_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (121, 'CUF', NULL, 'EXECUTION_CUF_LIST', 'EXECUTION', 'CUSTOM_FIELD', 'value', 'LIST', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (122, 'CUF', NULL, 'EXECUTION_CUF_DATE', 'EXECUTION', 'CUSTOM_FIELD', 'value', 'DATE_AS_STRING', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (123, 'CUF', NULL, 'EXECUTION_CUF_TAG', 'EXECUTION', 'CUSTOM_FIELD', 'value', 'TAG', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (124, 'CUF', NULL, 'EXECUTION_CUF_NUMERIC', 'EXECUTION', 'CUSTOM_FIELD', 'value', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (125, 'ATTRIBUTE', NULL, 'CAMPAIGN_MILESTONE_ID', 'MILESTONE', 'CAMPAIGN_MILESTONE', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (11, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_STATUS', 'REQUIREMENT_VERSION', NULL, 'status', 'REQUIREMENT_STATUS', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (126, 'ENTITY', NULL, 'REQUIREMENT_ENTITY', 'REQUIREMENT', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (127, 'ENTITY', NULL, 'REQUIREMENT_VERSION_ENTITY', 'REQUIREMENT_VERSION', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (128, 'ENTITY', NULL, 'TEST_CASE_ENTITY', 'TEST_CASE', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (129, 'ENTITY', NULL, 'CAMPAIGN_ENTITY', 'CAMPAIGN', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (130, 'ENTITY', NULL, 'ITERATION_ENTITY', 'ITERATION', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (131, 'ENTITY', NULL, 'ITEM_TEST_PLAN_ENTITY', 'ITEM_TEST_PLAN', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (132, 'ENTITY', NULL, 'EXECUTION_ENTITY', 'EXECUTION', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (133, 'ENTITY', NULL, 'ISSUE_ENTITY', 'ISSUE', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (134, 'ENTITY', NULL, 'TEST_CASE_STEP_ENTITY', 'TEST_CASE_STEP', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (135, 'ENTITY', NULL, 'TEST_CASE_NATURE_ENTITY', 'INFO_LIST_ITEM', 'TEST_CASE_NATURE', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (136, 'ENTITY', NULL, 'TEST_CASE_TYPE_ENTITY', 'INFO_LIST_ITEM', 'TEST_CASE_TYPE', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (137, 'ENTITY', NULL, 'REQUIREMENT_VERSION_CATEGORY_ENTITY', 'INFO_LIST_ITEM', 'REQUIREMENT_VERSION_CATEGORY', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (138, 'ENTITY', NULL, 'ITERATION_TEST_PLAN_ASSIGNED_USER_ENTITY', 'USER', 'ITERATION_TEST_PLAN_ASSIGNED_USER', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (139, 'ENTITY', NULL, 'TEST_CASE_MILESTONE_ENTITY', 'MILESTONE', 'TEST_CASE_MILESTONE', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (140, 'ENTITY', NULL, 'REQUIREMENT_VERSION_MILESTONE_ENTITY', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (141, 'ENTITY', NULL, 'CAMPAIGN_MILESTONE_ENTITY', 'MILESTONE', 'CAMPAIGN_MILESTONE', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (142, 'ENTITY', NULL, 'AUTOMATED_TEST_ENTITY', 'AUTOMATED_TEST', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (143, 'ENTITY', NULL, 'AUTOMATED_EXECUTION_EXTENDER_ENTITY', 'AUTOMATED_EXECUTION_EXTENDER', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (144, 'ENTITY', NULL, 'TEST_CASE_ATTLIST_ENTITY', 'ATTACHMENT_LIST', 'TEST_CASE_ATTLIST', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (145, 'ENTITY', NULL, 'REQUIREMENT_VERSION_ATTLIST_ENTITY', 'ATTACHMENT_LIST', 'REQUIREMENT_VERSION_ATTLIST', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (146, 'ENTITY', NULL, 'CAMPAIGN_ATTLIST_ENTITY', 'ATTACHMENT_LIST', 'CAMPAIGN_ATTLIST', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (147, 'ENTITY', NULL, 'TEST_CASE_ATTACHMENT_ENTITY', 'ATTACHMENT', 'TEST_CASE_ATTACHMENT', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (148, 'ENTITY', NULL, 'CAMPAIGN_ATTACHMENT_ENTITY', 'ATTACHMENT', 'CAMPAIGN_ATTACHMENT', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (149, 'ENTITY', NULL, 'REQUIREMENT_VERSION_ATTACHMENT_ENTITY', 'ATTACHMENT', 'REQUIREMENT_VERSION_ATTACHMENT', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (150, 'ENTITY', NULL, 'DATASET_ENTITY', 'DATASET', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (151, 'ENTITY', NULL, 'PARAMETER_ENTITY', 'PARAMETER', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (152, 'ENTITY', NULL, 'TEST_CASE_PROJECT_ENTITY', 'PROJECT', 'TEST_CASE_PROJECT', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (153, 'ENTITY', NULL, 'REQUIREMENT_PROJECT_ENTITY', 'PROJECT', 'REQUIREMENT_PROJECT', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (154, 'ENTITY', NULL, 'CAMPAIGN_PROJECT_ENTITY', 'PROJECT', 'CAMPAIGN_PROJECT', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (155, 'ENTITY', NULL, 'ITEM_SUITE_ENTITY', 'TEST_SUITE', 'ITEM_SUITE', NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (156, 'ENTITY', NULL, 'AUTOMATION_REQUEST_ENTITY', 'AUTOMATION_REQUEST', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (157, 'ATTRIBUTE', NULL, 'CAMPAIGN_MILESTONE_LABEL', 'MILESTONE', 'CAMPAIGN_MILESTONE', 'label', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (158, 'ATTRIBUTE', NULL, 'TEST_CASE_PROJECT_ID', 'PROJECT', 'TEST_CASE_PROJECT', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (159, 'ATTRIBUTE', NULL, 'TEST_CASE_PROJECT_NAME', 'PROJECT', 'TEST_CASE_PROJECT', 'name', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (160, 'ATTRIBUTE', NULL, 'REQUIREMENT_PROJECT_ID', 'PROJECT', 'REQUIREMENT_PROJECT', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (161, 'ATTRIBUTE', NULL, 'REQUIREMENT_PROJECT_NAME', 'PROJECT', 'REQUIREMENT_PROJECT', 'name', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (162, 'ATTRIBUTE', NULL, 'CAMPAIGN_PROJECT_ID', 'PROJECT', 'CAMPAIGN_PROJECT', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (163, 'ATTRIBUTE', NULL, 'CAMPAIGN_PROJECT_NAME', 'PROJECT', 'CAMPAIGN_PROJECT', 'name', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (164, 'ATTRIBUTE', NULL, 'TEST_CASE_ATTLIST_ID', 'ATTACHMENT_LIST', 'TEST_CASE_ATTLIST', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (165, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_ATTLIST_ID', 'ATTACHMENT_LIST', 'REQUIREMENT_VERSION_ATTLIST', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (166, 'ATTRIBUTE', NULL, 'CAMPAIGN_ATTLIST_ID', 'ATTACHMENT_LIST', 'CAMPAIGN_ATTLIST', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (167, 'ATTRIBUTE', NULL, 'TEST_CASE_ATTACHMENT_ID', 'ATTACHMENT', 'TEST_CASE_ATTACHMENT', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (168, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_ATTACHMENT_ID', 'ATTACHMENT', 'REQUIREMENT_VERSION_ATTACHMENT', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (169, 'ATTRIBUTE', NULL, 'CAMPAIGN_ATTACHMENT_ID', 'ATTACHMENT', 'CAMPAIGN_ATTACHMENT', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (170, 'ATTRIBUTE', NULL, 'DATASET_ID', 'DATASET', NULL, 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (171, 'ATTRIBUTE', NULL, 'PARAMETER_ID', 'PARAMETER', NULL, 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (172, 'ATTRIBUTE', NULL, 'TEST_CASE_MILESTONE_STATUS', 'MILESTONE', 'TEST_CASE_MILESTONE', 'status', 'LEVEL_ENUM', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (173, 'ATTRIBUTE', NULL, 'TEST_CASE_MILESTONE_END_DATE', 'MILESTONE', 'TEST_CASE_MILESTONE', 'endDate', 'DATE', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (174, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_MILESTONE_STATUS', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', 'status', 'LEVEL_ENUM', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (175, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_MILESTONE_END_DATE', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', 'endDate', 'DATE', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (176, 'ATTRIBUTE', NULL, 'CAMPAIGN_MILESTONE_STATUS', 'MILESTONE', 'CAMPAIGN_MILESTONE', 'status', 'LEVEL_ENUM', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (177, 'ATTRIBUTE', NULL, 'CAMPAIGN_MILESTONE_END_DATE', 'MILESTONE', 'CAMPAIGN_MILESTONE', 'endDate', 'DATE', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (178, 'ATTRIBUTE', NULL, 'AUTOMATION_REQUEST_ID', 'AUTOMATION_REQUEST', NULL, 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (180, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_NAME', 'REQUIREMENT_VERSION', NULL, 'name', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (182, 'ATTRIBUTE', NULL, 'TEST_CASE_NAME', 'TEST_CASE', NULL, 'name', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (187, 'ATTRIBUTE', NULL, 'CAMPAIGN_NAME', 'CAMPAIGN', NULL, 'name', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (188, 'ATTRIBUTE', NULL, 'ITERATION_NAME', 'ITERATION', NULL, 'name', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (189, 'ATTRIBUTE', NULL, 'ITEM_SUITE_ID', 'TEST_SUITE', 'ITEM_SUITE', 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (190, 'ATTRIBUTE', NULL, 'EXECUTION_EXECUTION_MODE', 'EXECUTION', NULL, 'executionMode', 'LEVEL_ENUM', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (191, 'ATTRIBUTE', NULL, 'EXECUTION_LAST_EXECUTED_ON', 'EXECUTION', NULL, 'lastExecutedOn', 'DATE', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (193, 'CALCULATED', 22, 'REQUIREMENT_VERSION_ATTCOUNT', 'REQUIREMENT_VERSION', NULL, 'count(attachment)', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (194, 'CALCULATED', 23, 'TEST_CASE_ATTCOUNT', 'TEST_CASE', NULL, 'count(attachment)', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (195, 'CALCULATED', 24, 'TEST_CASE_PARAMCOUNT', 'TEST_CASE', NULL, 'count(parameter)', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (196, 'CALCULATED', 25, 'TEST_CASE_DATASETCOUNT', 'TEST_CASE', NULL, 'count(dataset)', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (197, 'CALCULATED', 26, 'ITEM_TEST_PLAN_SUITECOUNT', 'ITEM_TEST_PLAN', NULL, 'count(testSuites)', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (198, 'CALCULATED', 27, 'ITEM_TEST_PLAN_DSCOUNT', 'ITEM_TEST_PLAN', NULL, 'count(datasets)', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (181, 'ATTRIBUTE', NULL, 'REQUIREMENT_VERSION_DESCRIPTION', 'REQUIREMENT_VERSION', NULL, 'description', 'TEXT', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (183, 'ATTRIBUTE', NULL, 'TEST_CASE_DESCRIPTION', 'TEST_CASE', NULL, 'description', 'TEXT', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (185, 'ATTRIBUTE', NULL, 'TEST_CASE_PREQUISITE', 'TEST_CASE', NULL, 'prerequisite', 'TEXT', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (184, 'ENTITY', NULL, 'TEST_CASE_KIND', 'TEST_CASE', NULL, 'kind', 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (192, 'ATTRIBUTE', NULL, 'ITEM_TEST_PLAN_LASTEXECBY', 'ITEM_TEST_PLAN', NULL, 'lastExecutedBy', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (199, 'ATTRIBUTE', NULL, 'DATASET_NAME', 'DATASET', NULL, 'name', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (186, 'ATTRIBUTE', NULL, 'TEST_CASE_AUTOMATABLE', 'TEST_CASE', NULL, 'automatable', 'LEVEL_ENUM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (179, 'ATTRIBUTE', NULL, 'AUTOMATION_REQUEST_STATUS', 'AUTOMATION_REQUEST', NULL, 'requestStatus', 'LEVEL_ENUM', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (200, 'ENTITY', NULL, 'SCM_REPOSITORY_ENTITY', 'SCM_REPOSITORY', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (201, 'ATTRIBUTE', NULL, 'SCM_REPOSITORY_ID', 'SCM_REPOSITORY', NULL, 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (202, 'ATTRIBUTE', NULL, 'TEST_CASE_AUTOMATED_TEST_REFERENCE', 'TEST_CASE', NULL, 'automatedTestReference', 'STRING', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (203, 'CALCULATED', 28, 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY', 'TEST_CASE', NULL, 'notnull(scmRepository)', 'BOOLEAN', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (204, 'CALCULATED', 29, 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE', 'TEST_CASE', NULL, 'notnull(automatedTestReference)', 'BOOLEAN', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (205, 'ATTRIBUTE', NULL, 'TEST_CASE_AUTOMATED_TEST_TECHNOLOGY', 'TEST_CASE', NULL, 'automatedTestTechnology.name', 'AUTOMATED_TEST_TECHNOLOGY', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (206, 'ATTRIBUTE', NULL, 'AUTOMATION_REQUEST_TRANSMISSION_DATE', 'AUTOMATION_REQUEST', NULL, 'transmissionDate', 'DATE', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (207, 'ATTRIBUTE', NULL, 'AUTOMATION_REQUEST_AUTOMATION_PRIORITY', 'AUTOMATION_REQUEST', NULL, 'automationPriority', 'NUMERIC', true, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (208, 'ENTITY', NULL, 'REQUIREMENT_KIND', 'REQUIREMENT', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (209, 'CALCULATED', 30, 'REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT', 'REQUIREMENT', NULL, 'notnull(highLevelRequirement)', 'BOOLEAN', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (210, 'ENTITY', NULL, 'HIGH_LEVEL_REQUIREMENT_ENTITY', 'HIGH_LEVEL_REQUIREMENT', NULL, NULL, 'ENTITY', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (211, 'ATTRIBUTE', NULL, 'HIGH_LEVEL_REQUIREMENT_ID', 'HIGH_LEVEL_REQUIREMENT', NULL, 'id', 'NUMERIC', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (212, 'ATTRIBUTE', NULL, 'TEST_CASE_DRAFTED_BY_AI', 'TEST_CASE', NULL, 'draftedByAi', 'BOOLEAN', false, NULL);
INSERT INTO public.query_column_prototype (query_column_id, column_type, subquery_id, label, entity_type, entity_role, attribute_name, data_type, business, attribute_type) VALUES (52, 'CALCULATED', 13, 'ITERATION_ITEMCOUNT', 'ITERATION', NULL, 'count(testPlanItems)', 'NUMERIC', true, NULL);


--
-- Data for Name: query_filter_column; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.query_filter_column (query_filter_id, query_column_id, query_model_id, filter_operation, cuf_id) VALUES (2, 94, 17, 'NOT_NULL', NULL);
INSERT INTO public.query_filter_column (query_filter_id, query_column_id, query_model_id, filter_operation, cuf_id) VALUES (3, 94, 18, 'NOT_NULL', NULL);
INSERT INTO public.query_filter_column (query_filter_id, query_column_id, query_model_id, filter_operation, cuf_id) VALUES (1, 134, 5, 'IS_CLASS', NULL);


--
-- Data for Name: query_filter_values; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.query_filter_values (query_filter_id, filter_value) VALUES (2, 'FALSE');
INSERT INTO public.query_filter_values (query_filter_id, filter_value) VALUES (3, 'TRUE');
INSERT INTO public.query_filter_values (query_filter_id, filter_value) VALUES (1, 'org.squashtest.tm.domain.testcase.CallTestStep');


--
-- Data for Name: query_model; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (1, 'REQUIREMENT_NB_VERSIONS_SUBQUERY', 'SUBQUERY', 'INNER_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (2, 'REQUIREMENT_VERSION_TCCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (3, 'REQUIREMENT_VERSION_MILCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (4, 'TEST_CASE_VERSCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (5, 'TEST_CASE_CALLSTEPCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (6, 'TEST_CASE_STEPCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (7, 'TEST_CASE_VERSION_MILCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (8, 'TEST_CASE_ITERCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (9, 'TEST_CASE_EXECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (10, 'TEST_CASE_HASAUTOSCRIPT_SUBQUERY', 'INLINED', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (11, 'CAMPAIGN_ITERCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (12, 'CAMPAIGN_ISSUECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (13, 'ITERATION_ITEMCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (14, 'ITERATION_ISSUECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (15, 'ITEM_TEST_PLAN_TCDELETED_SUBQUERY', 'INLINED', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (16, 'ITEM_TEST_PLAN_ISEXECUTED_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (17, 'ITEM_TEST_PLAN_MANEXCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (18, 'ITEM_TEST_PLAN_AUTOEXCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (19, 'ITEM_TEST_PLAN_ISSUECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (20, 'EXECUTION_ISAUTO_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (21, 'EXECUTION_ISSUECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (22, 'REQUIREMENT_VERSION_ATTCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (23, 'TEST_CASE_ATTCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (24, 'TEST_CASE_PARAMCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (25, 'TEST_CASE_DATASETCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (26, 'ITEM_TEST_PLAN_SUITECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (27, 'ITEM_TEST_PLAN_DSCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (28, 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (29, 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');
INSERT INTO public.query_model (query_model_id, name, strategy, join_style) VALUES (30, 'REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');


--
-- Data for Name: query_ordering_column; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (1, 1, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (2, 7, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (3, 7, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (4, 19, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (5, 19, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (6, 19, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (7, 19, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (8, 19, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (9, 19, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (10, 19, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (11, 37, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (12, 37, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (13, 46, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (14, 46, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (15, 54, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (16, 54, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (17, 54, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (18, 54, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (19, 54, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (20, 66, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (21, 66, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (1, 7, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (2, 19, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (3, 89, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (4, 7, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (5, 79, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (6, 79, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (7, 87, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (8, 46, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (9, 66, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (10, 93, 'NOT_NULL', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (11, 46, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (12, 75, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (13, 54, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (14, 75, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (15, 19, 'IS_NULL', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (16, 66, 'NOT_NULL', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (17, 66, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (18, 66, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (19, 75, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (20, 94, 'NOT_NULL', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (21, 75, 'COUNT', 1, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (28, 19, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (29, 202, 'NONE', 0, 'ASC', NULL);
INSERT INTO public.query_ordering_column (query_model_id, query_column_id, order_operation, order_rank, order_dir, cuf_id) VALUES (30, 1, 'NONE', 0, 'ASC', NULL);


--
-- Data for Name: query_projection_column; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (7, 1, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (19, 2, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (89, 3, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (7, 4, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (79, 5, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (79, 6, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (87, 7, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (46, 8, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (66, 9, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (93, 10, NULL, 'NOT_NULL', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (46, 11, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (75, 12, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (54, 13, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (75, 14, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (19, 15, NULL, 'IS_NULL', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (66, 16, NULL, 'NOT_NULL', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (66, 17, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (66, 18, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (75, 19, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (94, 20, NULL, 'NOT_NULL', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (75, 21, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (168, 22, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (167, 23, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (171, 24, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (170, 25, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (189, 26, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (170, 27, NULL, 'COUNT', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (201, 28, NULL, 'NOT_NULL', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (202, 29, NULL, 'NOT_NULL', 0, NULL);
INSERT INTO public.query_projection_column (query_column_id, query_model_id, label, projection_operation, projection_rank, cuf_id) VALUES (211, 30, NULL, 'NOT_NULL', 0, NULL);


--
-- Data for Name: remote_automation_request_extender; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: remote_synchronisation; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: report_definition; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_audit_event; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_creation; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_folder; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_folder_sync_extender; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_large_property_change; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_library; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_library_content; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_library_node; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_property_change; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_sync_extender; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_version; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_version_coverage; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_version_link; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: requirement_version_link_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.requirement_version_link_type (type_id, role_1, role_1_code, role_2, role_2_code, is_default) VALUES (1, 'requirement-version.link.type.related', 'RELATED', 'requirement-version.link.type.related', 'RELATED', true);
INSERT INTO public.requirement_version_link_type (type_id, role_1, role_1_code, role_2, role_2_code, is_default) VALUES (2, 'requirement-version.link.type.parent', 'PARENT', 'requirement-version.link.type.child', 'CHILD', false);
INSERT INTO public.requirement_version_link_type (type_id, role_1, role_1_code, role_2, role_2_code, is_default) VALUES (3, 'requirement-version.link.type.duplicate', 'DUPLICATE', 'requirement-version.link.type.duplicate', 'DUPLICATE', false);


--
-- Data for Name: resource; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: rln_relationship; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: rln_relationship_closure; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: scm_repository; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: scm_server; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: scripted_execution; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: scripted_test_case; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: session_note; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: simple_resource; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: sprint; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: sprint_group; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: sprint_req_version; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: sprint_requirement_sync_extender; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: stored_credentials; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: sync_requirement_creation; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: sync_requirement_update; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: tcln_relationship; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: tcln_relationship_closure; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: template_configurable_plugin_binding; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_automation_project; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_automation_server; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_case; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_case_folder; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_case_library; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_case_library_content; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_case_library_node; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_case_steps; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_plan; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_plan_item; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_step; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_suite; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: test_suite_test_plan_item; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: third_party_server; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: verifying_steps; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: work_delete_entities; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: acl_class_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.acl_class_id_seq', 6, true);


--
-- Name: acl_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.acl_group_id_seq', 10, true);


--
-- Name: acl_object_identity_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.acl_object_identity_id_seq', 1, false);


--
-- Name: acl_responsibility_scope_entry_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.acl_responsibility_scope_entry_id_seq', 1, false);


--
-- Name: action_word_action_word_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.action_word_action_word_id_seq', 1, false);


--
-- Name: action_word_fragment_action_word_fragment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.action_word_fragment_action_word_fragment_id_seq', 1, false);


--
-- Name: action_word_library_awl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.action_word_library_awl_id_seq', 1, false);


--
-- Name: action_word_library_node_awln_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.action_word_library_node_awln_id_seq', 1, false);


--
-- Name: action_word_parameter_value_action_word_parameter_value_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.action_word_parameter_value_action_word_parameter_value_id_seq', 1, false);


--
-- Name: api_token_token_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.api_token_token_id_seq', 1, false);


--
-- Name: attachment_attachment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.attachment_attachment_id_seq', 1, false);


--
-- Name: attachment_content_attachment_content_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.attachment_content_attachment_content_id_seq', 1, false);


--
-- Name: attachment_list_attachment_list_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.attachment_list_attachment_list_id_seq', 1, false);


--
-- Name: automated_execution_extender_extender_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.automated_execution_extender_extender_id_seq', 1, false);


--
-- Name: automated_suite_suite_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.automated_suite_suite_id_seq', 1, false);


--
-- Name: automated_test_technology_at_technology_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.automated_test_technology_at_technology_id_seq', 13, true);


--
-- Name: automated_test_test_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.automated_test_test_id_seq', 1, false);


--
-- Name: automation_request_automation_request_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.automation_request_automation_request_id_seq', 1, false);


--
-- Name: automation_request_library_arl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.automation_request_library_arl_id_seq', 1, false);


--
-- Name: bugtracker_project_bugtracker_project_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.bugtracker_project_bugtracker_project_id_seq', 1, false);


--
-- Name: campaign_library_cl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.campaign_library_cl_id_seq', 1, false);


--
-- Name: campaign_library_node_cln_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.campaign_library_node_cln_id_seq', 1, false);


--
-- Name: campaign_test_plan_item_ctpi_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.campaign_test_plan_item_ctpi_id_seq', 1, false);


--
-- Name: chart_definition_chart_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.chart_definition_chart_id_seq', 1, false);


--
-- Name: chart_filter_filter_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.chart_filter_filter_id_seq', 3, true);


--
-- Name: chart_project_scope_chart_project_scope_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.chart_project_scope_chart_project_scope_id_seq', 1, false);


--
-- Name: connection_attempt_log_attempt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.connection_attempt_log_attempt_id_seq', 1, false);


--
-- Name: core_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.core_group_id_seq', 5, true);


--
-- Name: core_party_party_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.core_party_party_id_seq', 1, true);


--
-- Name: core_user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.core_user_id_seq', 1, true);


--
-- Name: custom_field_binding_cfb_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_field_binding_cfb_id_seq', 1, false);


--
-- Name: custom_field_cf_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_field_cf_id_seq', 1, false);


--
-- Name: custom_field_value_cfv_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_field_value_cfv_id_seq', 1, false);


--
-- Name: custom_report_chart_binding_crcb_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_report_chart_binding_crcb_id_seq', 1, false);


--
-- Name: custom_report_custom_export_crce_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_report_custom_export_crce_id_seq', 1, false);


--
-- Name: custom_report_dashboard_crd_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_report_dashboard_crd_id_seq', 1, false);


--
-- Name: custom_report_folder_crf_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_report_folder_crf_id_seq', 1, false);


--
-- Name: custom_report_library_crl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_report_library_crl_id_seq', 1, false);


--
-- Name: custom_report_library_node_crln_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_report_library_node_crln_id_seq', 1, false);


--
-- Name: custom_report_report_binding_crrb_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.custom_report_report_binding_crrb_id_seq', 1, false);


--
-- Name: dataset_dataset_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.dataset_dataset_id_seq', 1, false);


--
-- Name: dataset_param_value_dataset_param_value_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.dataset_param_value_dataset_param_value_id_seq', 1, false);


--
-- Name: denormalized_environment_tag_det_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.denormalized_environment_tag_det_id_seq', 1, false);


--
-- Name: denormalized_environment_variable_dev_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.denormalized_environment_variable_dev_id_seq', 1, false);


--
-- Name: denormalized_field_value_dfv_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.denormalized_field_value_dfv_id_seq', 1, false);


--
-- Name: environment_variable_binding_evb_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.environment_variable_binding_evb_id_seq', 1, false);


--
-- Name: environment_variable_ev_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.environment_variable_ev_id_seq', 1, false);


--
-- Name: execution_execution_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.execution_execution_id_seq', 1, false);


--
-- Name: execution_step_execution_step_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.execution_step_execution_step_id_seq', 1, false);


--
-- Name: exploratory_execution_event_event_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.exploratory_execution_event_event_id_seq', 1, false);


--
-- Name: exploratory_session_overview_overview_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.exploratory_session_overview_overview_id_seq', 1, false);


--
-- Name: failure_detail_failure_detail_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.failure_detail_failure_detail_id_seq', 1, false);


--
-- Name: grid_column_display_configuration_gcdc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.grid_column_display_configuration_gcdc_id_seq', 1, false);


--
-- Name: grid_column_display_reference_gcdr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.grid_column_display_reference_gcdr_id_seq', 1, false);


--
-- Name: info_list_info_list_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.info_list_info_list_id_seq', 3, true);


--
-- Name: info_list_item_item_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.info_list_item_item_id_seq', 26, true);


--
-- Name: issue_issue_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.issue_issue_id_seq', 1, false);


--
-- Name: issue_list_issue_list_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.issue_list_issue_list_id_seq', 1, false);


--
-- Name: iteration_iteration_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.iteration_iteration_id_seq', 1, false);


--
-- Name: library_plugin_binding_plugin_binding_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.library_plugin_binding_plugin_binding_id_seq', 1, false);


--
-- Name: milestone_binding_milestone_binding_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.milestone_binding_milestone_binding_id_seq', 1, false);


--
-- Name: milestone_binding_perimeter_milestone_binding_perimeter_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.milestone_binding_perimeter_milestone_binding_perimeter_id_seq', 1, false);


--
-- Name: milestone_milestone_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.milestone_milestone_id_seq', 1, false);


--
-- Name: parameter_param_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.parameter_param_id_seq', 1, false);


--
-- Name: party_preference_preference_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.party_preference_preference_id_seq', 1, false);


--
-- Name: pivot_format_import_pfi_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.pivot_format_import_pfi_id_seq', 1, false);


--
-- Name: project_filter_project_filter_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.project_filter_project_filter_id_seq', 1, false);


--
-- Name: project_project_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.project_project_id_seq', 1, false);


--
-- Name: proto_test_automation_project_ta_project_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.proto_test_automation_project_ta_project_id_seq', 1, false);


--
-- Name: query_column_prototype_query_column_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.query_column_prototype_query_column_id_seq', 212, true);


--
-- Name: query_filter_column_query_filter_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.query_filter_column_query_filter_id_seq', 3, true);


--
-- Name: query_model_query_model_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.query_model_query_model_id_seq', 30, true);


--
-- Name: remote_automation_request_ext_remote_automation_request_ext_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.remote_automation_request_ext_remote_automation_request_ext_seq', 1, false);


--
-- Name: remote_synchronisation_remote_synchronisation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.remote_synchronisation_remote_synchronisation_id_seq', 1, false);


--
-- Name: report_definition_report_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.report_definition_report_id_seq', 1, false);


--
-- Name: requirement_audit_event_event_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.requirement_audit_event_event_id_seq', 1, false);


--
-- Name: requirement_folder_sync_extender_rf_sync_extender_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.requirement_folder_sync_extender_rf_sync_extender_id_seq', 1, false);


--
-- Name: requirement_library_node_rln_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.requirement_library_node_rln_id_seq', 1, false);


--
-- Name: requirement_library_rl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.requirement_library_rl_id_seq', 1, false);


--
-- Name: requirement_sync_extender_req_sync_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.requirement_sync_extender_req_sync_id_seq', 1, false);


--
-- Name: requirement_version_coverage_requirement_version_coverage_i_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.requirement_version_coverage_requirement_version_coverage_i_seq', 1, false);


--
-- Name: requirement_version_link_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.requirement_version_link_link_id_seq', 1, false);


--
-- Name: requirement_version_link_type_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.requirement_version_link_type_type_id_seq', 3, true);


--
-- Name: resource_res_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.resource_res_id_seq', 1, false);


--
-- Name: scm_repository_scm_repository_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.scm_repository_scm_repository_id_seq', 1, false);


--
-- Name: session_note_note_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.session_note_note_id_seq', 1, false);


--
-- Name: sprint_req_version_sprint_req_version_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.sprint_req_version_sprint_req_version_id_seq', 1, false);


--
-- Name: sprint_requirement_sync_extender_sprint_req_sync_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.sprint_requirement_sync_extender_sprint_req_sync_id_seq', 1, false);


--
-- Name: stored_credentials_credential_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.stored_credentials_credential_id_seq', 1, false);


--
-- Name: template_configurable_plugin_binding_binding_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.template_configurable_plugin_binding_binding_id_seq', 1, false);


--
-- Name: test_case_library_node_tcln_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.test_case_library_node_tcln_id_seq', 1, false);


--
-- Name: test_case_library_tcl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.test_case_library_tcl_id_seq', 1, false);


--
-- Name: test_plan_item_test_plan_item_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.test_plan_item_test_plan_item_id_seq', 1, false);


--
-- Name: test_plan_test_plan_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.test_plan_test_plan_id_seq', 1, false);


--
-- Name: test_step_test_step_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.test_step_test_step_id_seq', 1, false);


--
-- Name: test_suite_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.test_suite_id_seq', 1, false);


--
-- Name: third_party_server_server_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.third_party_server_server_id_seq', 1, false);


--
-- Name: action_word ACTION_WORD_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word
    ADD CONSTRAINT "ACTION_WORD_pkey" PRIMARY KEY (action_word_id);


--
-- Name: ai_server AI_SERVER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ai_server
    ADD CONSTRAINT "AI_SERVER_pkey" PRIMARY KEY (server_id);


--
-- Name: attachment_content ATTACHMENT_CONTENT_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attachment_content
    ADD CONSTRAINT "ATTACHMENT_CONTENT_pkey" PRIMARY KEY (attachment_content_id);


--
-- Name: attachment_list ATTACHMENT_LIST_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attachment_list
    ADD CONSTRAINT "ATTACHMENT_LIST_pkey" PRIMARY KEY (attachment_list_id);


--
-- Name: attachment ATTACHMENT_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attachment
    ADD CONSTRAINT "ATTACHMENT_pkey" PRIMARY KEY (attachment_id);


--
-- Name: auth_user AUTH_USER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user
    ADD CONSTRAINT "AUTH_USER_pkey" PRIMARY KEY (login);


--
-- Name: automated_execution_extender AUTOMATED_EXECUTION_EXTENDER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_execution_extender
    ADD CONSTRAINT "AUTOMATED_EXECUTION_EXTENDER_pkey" PRIMARY KEY (extender_id);


--
-- Name: automated_test_technology AUTOMATED_TEST_TECHNOLOGY_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_test_technology
    ADD CONSTRAINT "AUTOMATED_TEST_TECHNOLOGY_pkey" PRIMARY KEY (at_technology_id);


--
-- Name: automated_test AUTOMATED_TEST_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_test
    ADD CONSTRAINT "AUTOMATED_TEST_pkey" PRIMARY KEY (test_id);


--
-- Name: automation_request AUTOMATION_REQUEST_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request
    ADD CONSTRAINT "AUTOMATION_REQUEST_pkey" PRIMARY KEY (automation_request_id);


--
-- Name: bugtracker_project BUGTRACKER_PROJECT_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bugtracker_project
    ADD CONSTRAINT "BUGTRACKER_PROJECT_pkey" PRIMARY KEY (bugtracker_project_id);


--
-- Name: bugtracker BUGTRACKER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bugtracker
    ADD CONSTRAINT "BUGTRACKER_pkey" PRIMARY KEY (bugtracker_id);


--
-- Name: campaign_library_node CAMPAIGN_LIBRARY_NODE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_library_node
    ADD CONSTRAINT "CAMPAIGN_LIBRARY_NODE_pkey" PRIMARY KEY (cln_id);


--
-- Name: chart_definition CHART_DEFINITION_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_definition
    ADD CONSTRAINT "CHART_DEFINITION_pkey" PRIMARY KEY (chart_id);


--
-- Name: chart_filter CHART_FILTER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_filter
    ADD CONSTRAINT "CHART_FILTER_pkey" PRIMARY KEY (filter_id);


--
-- Name: chart_project_scope CHART_PROJECT_SCOPE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_project_scope
    ADD CONSTRAINT "CHART_PROJECT_SCOPE_pkey" PRIMARY KEY (chart_project_scope_id);


--
-- Name: connection_attempt_log CONNECTION_ATTEMPT_LOG_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.connection_attempt_log
    ADD CONSTRAINT "CONNECTION_ATTEMPT_LOG_pkey" PRIMARY KEY (attempt_id);


--
-- Name: core_config CORE_CONFIG_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_config
    ADD CONSTRAINT "CORE_CONFIG_pkey" PRIMARY KEY (str_key);


--
-- Name: custom_report_custom_export CUSTOM_REPORT_CUSTOM_EXPORT_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_custom_export
    ADD CONSTRAINT "CUSTOM_REPORT_CUSTOM_EXPORT_pkey" PRIMARY KEY (crce_id);


--
-- Name: execution_step EXECUTION_STEP_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution_step
    ADD CONSTRAINT "EXECUTION_STEP_pkey" PRIMARY KEY (execution_step_id);


--
-- Name: info_list_item INFO_LIST_ITEM_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.info_list_item
    ADD CONSTRAINT "INFO_LIST_ITEM_pkey" PRIMARY KEY (item_id);


--
-- Name: info_list INFO_LIST_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.info_list
    ADD CONSTRAINT "INFO_LIST_pkey" PRIMARY KEY (info_list_id);


--
-- Name: issue_list ISSUE_LIST_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.issue_list
    ADD CONSTRAINT "ISSUE_LIST_pkey" PRIMARY KEY (issue_list_id);


--
-- Name: issue ISSUE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.issue
    ADD CONSTRAINT "ISSUE_pkey" PRIMARY KEY (issue_id);


--
-- Name: iteration ITERATION_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.iteration
    ADD CONSTRAINT "ITERATION_pkey" PRIMARY KEY (iteration_id);


--
-- Name: keyword_execution KEYWORD_EXECUTION_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.keyword_execution
    ADD CONSTRAINT "KEYWORD_EXECUTION_pkey" PRIMARY KEY (execution_id);


--
-- Name: keyword_test_case KEYWORD_TEST_CASE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.keyword_test_case
    ADD CONSTRAINT "KEYWORD_TEST_CASE_pkey" PRIMARY KEY (tcln_id);


--
-- Name: library_plugin_binding LIBRARY_PLUGIN_BINDING_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.library_plugin_binding
    ADD CONSTRAINT "LIBRARY_PLUGIN_BINDING_pkey" PRIMARY KEY (plugin_binding_id);


--
-- Name: milestone_binding_perimeter MILESTONE_BINDING_PERIMETER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.milestone_binding_perimeter
    ADD CONSTRAINT "MILESTONE_BINDING_PERIMETER_pkey" PRIMARY KEY (milestone_binding_perimeter_id);


--
-- Name: milestone_binding MILESTONE_BINDING_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.milestone_binding
    ADD CONSTRAINT "MILESTONE_BINDING_pkey" PRIMARY KEY (milestone_binding_id);


--
-- Name: milestone MILESTONE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.milestone
    ADD CONSTRAINT "MILESTONE_pkey" PRIMARY KEY (milestone_id);


--
-- Name: party_preference PARTY_PREFERENCE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.party_preference
    ADD CONSTRAINT "PARTY_PREFERENCE_pkey" PRIMARY KEY (preference_id);


--
-- Name: pivot_format_import PIVOT_FORMAT_IMPORT_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pivot_format_import
    ADD CONSTRAINT "PIVOT_FORMAT_IMPORT_pkey" PRIMARY KEY (pfi_id);


--
-- Name: project PROJECT_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.project
    ADD CONSTRAINT "PROJECT_pkey" PRIMARY KEY (project_id);


--
-- Name: test_automation_project PROTO_TEST_AUTOMATION_PROJECT_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_automation_project
    ADD CONSTRAINT "PROTO_TEST_AUTOMATION_PROJECT_pkey" PRIMARY KEY (ta_project_id);


--
-- Name: query_filter_column QUERY_FILTER_COLUMN_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.query_filter_column
    ADD CONSTRAINT "QUERY_FILTER_COLUMN_pkey" PRIMARY KEY (query_filter_id);


--
-- Name: remote_automation_request_extender REMOTE_AUTOMATION_REQUEST_EXTENDER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.remote_automation_request_extender
    ADD CONSTRAINT "REMOTE_AUTOMATION_REQUEST_EXTENDER_pkey" PRIMARY KEY (remote_automation_request_extender_id);


--
-- Name: remote_synchronisation REMOTE_SYNCHRONISATION_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.remote_synchronisation
    ADD CONSTRAINT "REMOTE_SYNCHRONISATION_pkey" PRIMARY KEY (remote_synchronisation_id);


--
-- Name: report_definition REPORT_DEFINITION_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.report_definition
    ADD CONSTRAINT "REPORT_DEFINITION_pkey" PRIMARY KEY (report_id);


--
-- Name: requirement_audit_event REQUIREMENT_AUDIT_EVENT_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_audit_event
    ADD CONSTRAINT "REQUIREMENT_AUDIT_EVENT_pkey" PRIMARY KEY (event_id);


--
-- Name: requirement_folder_sync_extender REQUIREMENT_FOLDER_SYNC_EXTENDER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_folder_sync_extender
    ADD CONSTRAINT "REQUIREMENT_FOLDER_SYNC_EXTENDER_pkey" PRIMARY KEY (rf_sync_extender_id);


--
-- Name: requirement_library_node REQUIREMENT_LIBRARY_NODE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_library_node
    ADD CONSTRAINT "REQUIREMENT_LIBRARY_NODE_pkey" PRIMARY KEY (rln_id);


--
-- Name: requirement_library REQUIREMENT_LIBRARY_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_library
    ADD CONSTRAINT "REQUIREMENT_LIBRARY_pkey" PRIMARY KEY (rl_id);


--
-- Name: requirement_sync_extender REQUIREMENT_SYNC_EXTENDER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_sync_extender
    ADD CONSTRAINT "REQUIREMENT_SYNC_EXTENDER_pkey" PRIMARY KEY (req_sync_id);


--
-- Name: requirement_version_link_type REQUIREMENT_VERSION_LINK_TYPE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_version_link_type
    ADD CONSTRAINT "REQUIREMENT_VERSION_LINK_TYPE_pkey" PRIMARY KEY (type_id);


--
-- Name: requirement_version_link REQUIREMENT_VERSION_LINK_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_version_link
    ADD CONSTRAINT "REQUIREMENT_VERSION_LINK_pkey" PRIMARY KEY (link_id);


--
-- Name: resource RESOURCE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resource
    ADD CONSTRAINT "RESOURCE_pkey" PRIMARY KEY (res_id);


--
-- Name: scm_repository SCM_REPOSITORY_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.scm_repository
    ADD CONSTRAINT "SCM_REPOSITORY_pkey" PRIMARY KEY (scm_repository_id);


--
-- Name: scm_server SCM_SERVER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.scm_server
    ADD CONSTRAINT "SCM_SERVER_pkey" PRIMARY KEY (server_id);


--
-- Name: stored_credentials STORED_CREDENTIALS_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stored_credentials
    ADD CONSTRAINT "STORED_CREDENTIALS_pkey" PRIMARY KEY (credential_id);


--
-- Name: template_configurable_plugin_binding TEMPLATE_CONFIGURABLE_PLUGIN_BINDING_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.template_configurable_plugin_binding
    ADD CONSTRAINT "TEMPLATE_CONFIGURABLE_PLUGIN_BINDING_pkey" PRIMARY KEY (binding_id);


--
-- Name: test_automation_server TEST_AUTOMATION_SERVER_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_automation_server
    ADD CONSTRAINT "TEST_AUTOMATION_SERVER_pkey" PRIMARY KEY (server_id);


--
-- Name: test_case_library_node TEST_CASE_LIBRARY_NODE_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_case_library_node
    ADD CONSTRAINT "TEST_CASE_LIBRARY_NODE_pkey" PRIMARY KEY (tcln_id);


--
-- Name: test_plan_item TEST_PLAN_ITEM_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_plan_item
    ADD CONSTRAINT "TEST_PLAN_ITEM_pkey" PRIMARY KEY (test_plan_item_id);


--
-- Name: test_plan TEST_PLAN_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_plan
    ADD CONSTRAINT "TEST_PLAN_pkey" PRIMARY KEY (test_plan_id);


--
-- Name: test_step TEST_STEP_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_step
    ADD CONSTRAINT "TEST_STEP_pkey" PRIMARY KEY (test_step_id);


--
-- Name: acl_object_identity acl_object_identity_identity_class_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_object_identity
    ADD CONSTRAINT acl_object_identity_identity_class_id_key UNIQUE (identity, class_id);


--
-- Name: api_token api_token_uuid_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.api_token
    ADD CONSTRAINT api_token_uuid_key UNIQUE (uuid);


--
-- Name: automation_request_library_content automation_request_library_content_content_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request_library_content
    ADD CONSTRAINT automation_request_library_content_content_id_key UNIQUE (content_id);


--
-- Name: awln_relationship_closure awln_relationship_closure_ancestor_id_descendant_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.awln_relationship_closure
    ADD CONSTRAINT awln_relationship_closure_ancestor_id_descendant_id_key UNIQUE (ancestor_id, descendant_id);


--
-- Name: campaign_iteration campaign_iteration_campaign_id_iteration_order_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_iteration
    ADD CONSTRAINT campaign_iteration_campaign_id_iteration_order_key UNIQUE (campaign_id, iteration_order);


--
-- Name: campaign_library_content campaign_library_content_content_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_library_content
    ADD CONSTRAINT campaign_library_content_content_id_key UNIQUE (content_id);


--
-- Name: cln_relationship cln_relationship_descendant_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cln_relationship
    ADD CONSTRAINT cln_relationship_descendant_id_key UNIQUE (descendant_id);


--
-- Name: crln_relationship_closure crln_relationship_closure_ancestor_id_descendant_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.crln_relationship_closure
    ADD CONSTRAINT crln_relationship_closure_ancestor_id_descendant_id_key UNIQUE (ancestor_id, descendant_id);


--
-- Name: acl_group ct_un_acl_grp_qual_name; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_group
    ADD CONSTRAINT ct_un_acl_grp_qual_name UNIQUE (qualified_name);


--
-- Name: acl_class ct_un_classname; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_class
    ADD CONSTRAINT ct_un_classname UNIQUE (classname);


--
-- Name: core_group ct_un_grp_qual_name; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_group
    ADD CONSTRAINT ct_un_grp_qual_name UNIQUE (qualified_name);


--
-- Name: core_user ct_unique_user_login; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_user
    ADD CONSTRAINT ct_unique_user_login UNIQUE (login);


--
-- Name: requirement_version cu_version_of_requirement; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_version
    ADD CONSTRAINT cu_version_of_requirement UNIQUE (requirement_id, version_number);


--
-- Name: databasechangeloglock databasechangeloglock_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.databasechangeloglock
    ADD CONSTRAINT databasechangeloglock_pkey PRIMARY KEY (id);


--
-- Name: dataset dataset_name_test_case_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dataset
    ADD CONSTRAINT dataset_name_test_case_id_key UNIQUE (name, test_case_id);


--
-- Name: dataset_param_value dataset_param_value_dataset_id_param_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dataset_param_value
    ADD CONSTRAINT dataset_param_value_dataset_id_param_id_key UNIQUE (dataset_id, param_id);


--
-- Name: execution_execution_steps execution_execution_steps_execution_id_execution_step_order_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution_execution_steps
    ADD CONSTRAINT execution_execution_steps_execution_id_execution_step_order_key UNIQUE (execution_id, execution_step_order);


--
-- Name: info_list info_list_code_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.info_list
    ADD CONSTRAINT info_list_code_key UNIQUE (code);


--
-- Name: info_list_item info_list_item_code_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.info_list_item
    ADD CONSTRAINT info_list_item_code_key UNIQUE (code);


--
-- Name: info_list info_list_label_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.info_list
    ADD CONSTRAINT info_list_label_key UNIQUE (label);


--
-- Name: milestone milestone_label_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.milestone
    ADD CONSTRAINT milestone_label_key UNIQUE (label);


--
-- Name: oauth_access_token oauth_access_token_authentication_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oauth_access_token
    ADD CONSTRAINT oauth_access_token_authentication_id_key UNIQUE (authentication_id);


--
-- Name: oauth_access_token oauth_access_token_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oauth_access_token
    ADD CONSTRAINT oauth_access_token_pkey PRIMARY KEY (token_id);


--
-- Name: oauth_client_details oauth_client_details_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oauth_client_details
    ADD CONSTRAINT oauth_client_details_pkey PRIMARY KEY (client_id);


--
-- Name: oauth_client_token oauth_client_token_authentication_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oauth_client_token
    ADD CONSTRAINT oauth_client_token_authentication_id_key UNIQUE (authentication_id);


--
-- Name: oauth_client_token oauth_client_token_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oauth_client_token
    ADD CONSTRAINT oauth_client_token_pkey PRIMARY KEY (token_id);


--
-- Name: oauth_code oauth_code_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oauth_code
    ADD CONSTRAINT oauth_code_pkey PRIMARY KEY (code);


--
-- Name: oauth_refresh_token oauth_refresh_token_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oauth_refresh_token
    ADD CONSTRAINT oauth_refresh_token_pkey PRIMARY KEY (token_id);


--
-- Name: parameter parameter_name_test_case_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.parameter
    ADD CONSTRAINT parameter_name_test_case_id_key UNIQUE (name, test_case_id);


--
-- Name: acl_class pk_acl_class; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_class
    ADD CONSTRAINT pk_acl_class PRIMARY KEY (id);


--
-- Name: acl_group pk_acl_grp; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_group
    ADD CONSTRAINT pk_acl_grp PRIMARY KEY (id);


--
-- Name: acl_group_permission pk_acl_grp_permission; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_group_permission
    ADD CONSTRAINT pk_acl_grp_permission PRIMARY KEY (acl_group_id, class_id, permission_mask);


--
-- Name: acl_object_identity pk_acl_object_id; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_object_identity
    ADD CONSTRAINT pk_acl_object_id PRIMARY KEY (id);


--
-- Name: action_test_step pk_action_step; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_test_step
    ADD CONSTRAINT pk_action_step PRIMARY KEY (test_step_id);


--
-- Name: action_word_fragment pk_action_word_fragment; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_fragment
    ADD CONSTRAINT pk_action_word_fragment PRIMARY KEY (action_word_fragment_id);


--
-- Name: action_word_library pk_action_word_library; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_library
    ADD CONSTRAINT pk_action_word_library PRIMARY KEY (awl_id);


--
-- Name: action_word_library_node pk_action_word_library_node; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_library_node
    ADD CONSTRAINT pk_action_word_library_node PRIMARY KEY (awln_id);


--
-- Name: action_word_parameter pk_action_word_parameter; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_parameter
    ADD CONSTRAINT pk_action_word_parameter PRIMARY KEY (action_word_fragment_id);


--
-- Name: action_word_parameter_value pk_action_word_parameter_value; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_parameter_value
    ADD CONSTRAINT pk_action_word_parameter_value PRIMARY KEY (action_word_parameter_value_id);


--
-- Name: action_word_text pk_action_word_text; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_text
    ADD CONSTRAINT pk_action_word_text PRIMARY KEY (action_word_fragment_id);


--
-- Name: api_token pk_api_token; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.api_token
    ADD CONSTRAINT pk_api_token PRIMARY KEY (token_id);


--
-- Name: automated_suite pk_automated_suite; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_suite
    ADD CONSTRAINT pk_automated_suite PRIMARY KEY (suite_id);


--
-- Name: automation_request_library pk_automation_request_library; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request_library
    ADD CONSTRAINT pk_automation_request_library PRIMARY KEY (arl_id);


--
-- Name: call_test_step pk_call_step; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.call_test_step
    ADD CONSTRAINT pk_call_step PRIMARY KEY (test_step_id);


--
-- Name: campaign pk_campaign; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign
    ADD CONSTRAINT pk_campaign PRIMARY KEY (cln_id);


--
-- Name: campaign_folder pk_campaign_folder; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_folder
    ADD CONSTRAINT pk_campaign_folder PRIMARY KEY (cln_id);


--
-- Name: campaign_library pk_campaign_library; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_library
    ADD CONSTRAINT pk_campaign_library PRIMARY KEY (cl_id);


--
-- Name: campaign_test_plan_item pk_campaign_test_plan_item; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_test_plan_item
    ADD CONSTRAINT pk_campaign_test_plan_item PRIMARY KEY (ctpi_id);


--
-- Name: custom_field_binding pk_cfb_option; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_binding
    ADD CONSTRAINT pk_cfb_option PRIMARY KEY (cfb_id);


--
-- Name: core_group pk_core_group; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_group
    ADD CONSTRAINT pk_core_group PRIMARY KEY (id);


--
-- Name: core_user pk_core_user; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_user
    ADD CONSTRAINT pk_core_user PRIMARY KEY (party_id);


--
-- Name: custom_report_chart_binding pk_crcb_id; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_chart_binding
    ADD CONSTRAINT pk_crcb_id PRIMARY KEY (crcb_id);


--
-- Name: custom_report_dashboard pk_crd_id; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_dashboard
    ADD CONSTRAINT pk_crd_id PRIMARY KEY (crd_id);


--
-- Name: requirement_creation pk_creation_event; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_creation
    ADD CONSTRAINT pk_creation_event PRIMARY KEY (event_id);


--
-- Name: custom_report_folder pk_crf_id; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_folder
    ADD CONSTRAINT pk_crf_id PRIMARY KEY (crf_id);


--
-- Name: custom_report_report_binding pk_crrb_id; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_report_binding
    ADD CONSTRAINT pk_crrb_id PRIMARY KEY (crrb_id);


--
-- Name: custom_field pk_custom_field; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field
    ADD CONSTRAINT pk_custom_field PRIMARY KEY (cf_id);


--
-- Name: custom_field_value pk_custom_field_value; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_value
    ADD CONSTRAINT pk_custom_field_value PRIMARY KEY (cfv_id);


--
-- Name: custom_report_library pk_custom_report_library; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_library
    ADD CONSTRAINT pk_custom_report_library PRIMARY KEY (crl_id);


--
-- Name: custom_report_library_node pk_custom_report_library_node; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_library_node
    ADD CONSTRAINT pk_custom_report_library_node PRIMARY KEY (crln_id);


--
-- Name: dataset pk_dataset; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dataset
    ADD CONSTRAINT pk_dataset PRIMARY KEY (dataset_id);


--
-- Name: dataset_param_value pk_dataset_param_value; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dataset_param_value
    ADD CONSTRAINT pk_dataset_param_value PRIMARY KEY (dataset_param_value_id);


--
-- Name: denormalized_environment_tag pk_denormalized_environment_tag; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_environment_tag
    ADD CONSTRAINT pk_denormalized_environment_tag PRIMARY KEY (det_id);


--
-- Name: denormalized_environment_variable pk_denormalized_environment_variable; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_environment_variable
    ADD CONSTRAINT pk_denormalized_environment_variable PRIMARY KEY (dev_id);


--
-- Name: denormalized_field_value pk_denormalized_field; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_field_value
    ADD CONSTRAINT pk_denormalized_field PRIMARY KEY (dfv_id);


--
-- Name: environment_variable pk_environment_variable; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.environment_variable
    ADD CONSTRAINT pk_environment_variable PRIMARY KEY (ev_id);


--
-- Name: environment_variable_binding pk_ev_binding; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.environment_variable_binding
    ADD CONSTRAINT pk_ev_binding PRIMARY KEY (evb_id);


--
-- Name: execution pk_execution; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution
    ADD CONSTRAINT pk_execution PRIMARY KEY (execution_id);


--
-- Name: exploratory_execution pk_exploratory_execution; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_execution
    ADD CONSTRAINT pk_exploratory_execution PRIMARY KEY (execution_id);


--
-- Name: exploratory_execution_event pk_exploratory_execution_event; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_execution_event
    ADD CONSTRAINT pk_exploratory_execution_event PRIMARY KEY (event_id);


--
-- Name: exploratory_session_overview pk_exploratory_session_overview; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_session_overview
    ADD CONSTRAINT pk_exploratory_session_overview PRIMARY KEY (overview_id);


--
-- Name: exploratory_test_case pk_exploratory_test_case; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_test_case
    ADD CONSTRAINT pk_exploratory_test_case PRIMARY KEY (tcln_id);


--
-- Name: failure_detail pk_failure_detail; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.failure_detail
    ADD CONSTRAINT pk_failure_detail PRIMARY KEY (failure_detail_id);


--
-- Name: grid_column_display_configuration pk_grid_column_display_configuration; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.grid_column_display_configuration
    ADD CONSTRAINT pk_grid_column_display_configuration PRIMARY KEY (gcdc_id);


--
-- Name: grid_column_display_reference pk_grid_column_display_reference; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.grid_column_display_reference
    ADD CONSTRAINT pk_grid_column_display_reference PRIMARY KEY (gcdr_id);


--
-- Name: high_level_requirement pk_high_lvl_requirement; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.high_level_requirement
    ADD CONSTRAINT pk_high_lvl_requirement PRIMARY KEY (rln_id);


--
-- Name: keyword_test_step pk_keyword_test_step; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.keyword_test_step
    ADD CONSTRAINT pk_keyword_test_step PRIMARY KEY (test_step_id);


--
-- Name: requirement_large_property_change pk_large_ppt_change; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_large_property_change
    ADD CONSTRAINT pk_large_ppt_change PRIMARY KEY (event_id);


--
-- Name: oauth_approvals pk_oauth_approvals; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oauth_approvals
    ADD CONSTRAINT pk_oauth_approvals PRIMARY KEY (userid, clientid);


--
-- Name: parameter pk_parameter; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.parameter
    ADD CONSTRAINT pk_parameter PRIMARY KEY (param_id);


--
-- Name: core_party pk_party; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_party
    ADD CONSTRAINT pk_party PRIMARY KEY (party_id);


--
-- Name: requirement_property_change pk_ppt_change; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_property_change
    ADD CONSTRAINT pk_ppt_change PRIMARY KEY (event_id);


--
-- Name: project_filter_entry pk_proj_filter_entry; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.project_filter_entry
    ADD CONSTRAINT pk_proj_filter_entry PRIMARY KEY (project_id, filter_id);


--
-- Name: project_filter pk_project_filter; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.project_filter
    ADD CONSTRAINT pk_project_filter PRIMARY KEY (project_filter_id);


--
-- Name: query_column_prototype pk_query_column_prototype; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.query_column_prototype
    ADD CONSTRAINT pk_query_column_prototype PRIMARY KEY (query_column_id);


--
-- Name: query_model pk_query_model; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.query_model
    ADD CONSTRAINT pk_query_model PRIMARY KEY (query_model_id);


--
-- Name: requirement pk_requirement; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement
    ADD CONSTRAINT pk_requirement PRIMARY KEY (rln_id);


--
-- Name: requirement_folder pk_requirement_folder; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_folder
    ADD CONSTRAINT pk_requirement_folder PRIMARY KEY (rln_id);


--
-- Name: requirement_version pk_requirement_version; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_version
    ADD CONSTRAINT pk_requirement_version PRIMARY KEY (res_id);


--
-- Name: requirement_version_coverage pk_requirement_version_coverage; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_version_coverage
    ADD CONSTRAINT pk_requirement_version_coverage PRIMARY KEY (requirement_version_coverage_id);


--
-- Name: acl_responsibility_scope_entry pk_resp_scope_entry; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_responsibility_scope_entry
    ADD CONSTRAINT pk_resp_scope_entry PRIMARY KEY (id);


--
-- Name: session_note pk_session_note; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.session_note
    ADD CONSTRAINT pk_session_note PRIMARY KEY (note_id);


--
-- Name: simple_resource pk_simple_resource; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.simple_resource
    ADD CONSTRAINT pk_simple_resource PRIMARY KEY (res_id);


--
-- Name: sprint pk_sprint; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sprint
    ADD CONSTRAINT pk_sprint PRIMARY KEY (cln_id);


--
-- Name: sprint_group pk_sprint_group; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sprint_group
    ADD CONSTRAINT pk_sprint_group PRIMARY KEY (cln_id);


--
-- Name: sprint_requirement_sync_extender pk_sprint_req_sync_extender; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sprint_requirement_sync_extender
    ADD CONSTRAINT pk_sprint_req_sync_extender PRIMARY KEY (sprint_req_sync_id);


--
-- Name: sprint_req_version pk_sprint_req_version; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sprint_req_version
    ADD CONSTRAINT pk_sprint_req_version PRIMARY KEY (sprint_req_version_id);


--
-- Name: sync_requirement_creation pk_sync_create; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sync_requirement_creation
    ADD CONSTRAINT pk_sync_create PRIMARY KEY (event_id);


--
-- Name: sync_requirement_update pk_sync_update; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sync_requirement_update
    ADD CONSTRAINT pk_sync_update PRIMARY KEY (event_id);


--
-- Name: core_team pk_team; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_team
    ADD CONSTRAINT pk_team PRIMARY KEY (party_id);


--
-- Name: test_case_folder pk_test_case_folder; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_case_folder
    ADD CONSTRAINT pk_test_case_folder PRIMARY KEY (tcln_id);


--
-- Name: test_case_library pk_test_case_library; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_case_library
    ADD CONSTRAINT pk_test_case_library PRIMARY KEY (tcl_id);


--
-- Name: test_case pk_test_casse; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_case
    ADD CONSTRAINT pk_test_casse PRIMARY KEY (tcln_id);


--
-- Name: test_suite pk_test_suite; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_suite
    ADD CONSTRAINT pk_test_suite PRIMARY KEY (id);


--
-- Name: third_party_server pk_third_party_server; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.third_party_server
    ADD CONSTRAINT pk_third_party_server PRIMARY KEY (server_id);


--
-- Name: query_column_prototype query_column_prototype_label_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.query_column_prototype
    ADD CONSTRAINT query_column_prototype_label_key UNIQUE (label);


--
-- Name: requirement_folder_sync_extender requirement_folder_sync_extender_requirement_folder_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_folder_sync_extender
    ADD CONSTRAINT requirement_folder_sync_extender_requirement_folder_id_key UNIQUE (requirement_folder_id);


--
-- Name: requirement_library_content requirement_library_content_content_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_library_content
    ADD CONSTRAINT requirement_library_content_content_id_key UNIQUE (content_id);


--
-- Name: rln_relationship rln_relationship_descendant_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.rln_relationship
    ADD CONSTRAINT rln_relationship_descendant_id_key UNIQUE (descendant_id);


--
-- Name: scripted_execution scripted_execution_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.scripted_execution
    ADD CONSTRAINT scripted_execution_pkey PRIMARY KEY (execution_id);


--
-- Name: scripted_test_case scripted_test_case_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.scripted_test_case
    ADD CONSTRAINT scripted_test_case_pkey PRIMARY KEY (tcln_id);


--
-- Name: tcln_relationship tcln_relationship_descendant_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tcln_relationship
    ADD CONSTRAINT tcln_relationship_descendant_id_key UNIQUE (descendant_id);


--
-- Name: test_case_library_content test_case_library_content_content_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_case_library_content
    ADD CONSTRAINT test_case_library_content_content_id_key UNIQUE (content_id);


--
-- Name: custom_field_value u_cfv_type_id_binding; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_value
    ADD CONSTRAINT u_cfv_type_id_binding UNIQUE (bound_entity_type, bound_entity_id, cfb_id);


--
-- Name: denormalized_field_value u_dfv_type_id_code; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_field_value
    ADD CONSTRAINT u_dfv_type_id_code UNIQUE (denormalized_field_holder_type, denormalized_field_holder_id, code);


--
-- Name: action_word_fragment uc_action_word_fragment_order; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_fragment
    ADD CONSTRAINT uc_action_word_fragment_order UNIQUE (action_word_id, fragment_order);


--
-- Name: action_word uc_aw_token_project_id; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word
    ADD CONSTRAINT uc_aw_token_project_id UNIQUE (token, project_id);


--
-- Name: campaign_test_plan_item uc_campaign_test_plan_item_order; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_test_plan_item
    ADD CONSTRAINT uc_campaign_test_plan_item_order UNIQUE (campaign_id, test_plan_order);


--
-- Name: custom_field_binding uc_cf_entity_proj_bnd; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_binding
    ADD CONSTRAINT uc_cf_entity_proj_bnd UNIQUE (bound_project_id, bound_entity, cf_id);


--
-- Name: denormalized_environment_tag uc_det_type_id_value; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_environment_tag
    ADD CONSTRAINT uc_det_type_id_value UNIQUE (holder_type, holder_id, value);


--
-- Name: denormalized_environment_variable uc_dev_type_id_name; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_environment_variable
    ADD CONSTRAINT uc_dev_type_id_name UNIQUE (holder_type, holder_id, name);


--
-- Name: environment_variable uc_ev_name; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.environment_variable
    ADD CONSTRAINT uc_ev_name UNIQUE (name);


--
-- Name: environment_variable_option uc_ev_option_label; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.environment_variable_option
    ADD CONSTRAINT uc_ev_option_label UNIQUE (ev_id, label);


--
-- Name: exploratory_execution_event uc_exploratory_execution_event_execution_id_event_date; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_execution_event
    ADD CONSTRAINT uc_exploratory_execution_event_execution_id_event_date UNIQUE (execution_id, event_date);


--
-- Name: iteration_test_suite uc_iteration_iteration_test_suite_order; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.iteration_test_suite
    ADD CONSTRAINT uc_iteration_iteration_test_suite_order UNIQUE (iteration_id, iteration_test_suite_order);


--
-- Name: iteration uc_iteration_uuid; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.iteration
    ADD CONSTRAINT uc_iteration_uuid UNIQUE (uuid);


--
-- Name: requirement_version_coverage uc_tc_verifies_req_version; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_version_coverage
    ADD CONSTRAINT uc_tc_verifies_req_version UNIQUE (verified_req_version_id, verifying_test_case_id);


--
-- Name: test_case_steps uc_test_case_steps_order; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_case_steps
    ADD CONSTRAINT uc_test_case_steps_order UNIQUE (test_case_id, step_order);


--
-- Name: test_case uc_test_case_uuid; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_case
    ADD CONSTRAINT uc_test_case_uuid UNIQUE (uuid);


--
-- Name: test_suite_test_plan_item uc_test_suite_test_plan_item_order; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_suite_test_plan_item
    ADD CONSTRAINT uc_test_suite_test_plan_item_order UNIQUE (suite_id, test_plan_order);


--
-- Name: test_suite uc_test_suite_uuid; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_suite
    ADD CONSTRAINT uc_test_suite_uuid UNIQUE (uuid);


--
-- Name: environment_variable_binding uc_type_evb_id_ev_id_binding; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.environment_variable_binding
    ADD CONSTRAINT uc_type_evb_id_ev_id_binding UNIQUE (entity_type, entity_id, ev_id);


--
-- Name: automated_test uni_auto_test; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_test
    ADD CONSTRAINT uni_auto_test UNIQUE (name, project_id);


--
-- Name: cln_relationship_closure uniq_cln_clos; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cln_relationship_closure
    ADD CONSTRAINT uniq_cln_clos UNIQUE (ancestor_id, descendant_id);


--
-- Name: automation_environment_tag uniq_entity_type_entity_id_value; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_environment_tag
    ADD CONSTRAINT uniq_entity_type_entity_id_value UNIQUE (entity_type, entity_id, value);


--
-- Name: library_plugin_binding uniq_plugin_binding; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.library_plugin_binding
    ADD CONSTRAINT uniq_plugin_binding UNIQUE (library_id, library_type, plugin_id);


--
-- Name: rln_relationship_closure uniq_rln_clos; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.rln_relationship_closure
    ADD CONSTRAINT uniq_rln_clos UNIQUE (ancestor_id, descendant_id);


--
-- Name: scm_repository uniq_scm_repo_name_branch_server_id; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.scm_repository
    ADD CONSTRAINT uniq_scm_repo_name_branch_server_id UNIQUE (name, working_branch, server_id);


--
-- Name: stored_credentials uniq_stored_credentials_server_user; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stored_credentials
    ADD CONSTRAINT uniq_stored_credentials_server_user UNIQUE (authenticated_server, authenticated_user, content_type);


--
-- Name: tcln_relationship_closure uniq_tcln_clos; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tcln_relationship_closure
    ADD CONSTRAINT uniq_tcln_clos UNIQUE (ancestor_id, descendant_id);


--
-- Name: test_automation_project uniq_tm_ta_project_job; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_automation_project
    ADD CONSTRAINT uniq_tm_ta_project_job UNIQUE (tm_project_id, remote_name, server_id);


--
-- Name: test_automation_project uniq_tm_ta_project_label; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_automation_project
    ADD CONSTRAINT uniq_tm_ta_project_label UNIQUE (tm_project_id, label);


--
-- Name: automated_suite uq_automated_suite_uuid; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_suite
    ADD CONSTRAINT uq_automated_suite_uuid UNIQUE (uuid);


--
-- Name: execution uq_execution_execution_order_test_plan_item_id; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution
    ADD CONSTRAINT uq_execution_execution_order_test_plan_item_id UNIQUE (execution_order, test_plan_item_id);


--
-- Name: automation_request_assigned_to_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX automation_request_assigned_to_idx ON public.automation_request USING btree (assigned_to);


--
-- Name: automation_request_created_by_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX automation_request_created_by_idx ON public.automation_request USING btree (created_by);


--
-- Name: automation_request_transmitted_by_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX automation_request_transmitted_by_idx ON public.automation_request USING btree (transmitted_by);


--
-- Name: dx_cl_content_campaign_lib; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dx_cl_content_campaign_lib ON public.campaign_library_content USING btree (library_id);


--
-- Name: dx_cl_content_cl_node; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX dx_cl_content_cl_node ON public.campaign_library_content USING btree (content_id);


--
-- Name: dx_class_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX dx_class_name ON public.acl_class USING btree (classname);


--
-- Name: dx_cln_relationship_descendant; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dx_cln_relationship_descendant ON public.cln_relationship USING btree (descendant_id);


--
-- Name: dx_grp_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dx_grp_id ON public.core_group_authority USING btree (group_id);


--
-- Name: dx_grp_member; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX dx_grp_member ON public.core_group_member USING btree (party_id, group_id);


--
-- Name: dx_iteration_test_suite_iteration; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dx_iteration_test_suite_iteration ON public.iteration_test_suite USING btree (iteration_id);


--
-- Name: dx_obj_id_identity; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dx_obj_id_identity ON public.acl_object_identity USING btree (identity);


--
-- Name: dx_pfp_filter; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dx_pfp_filter ON public.project_filter_entry USING btree (filter_id);


--
-- Name: dx_pfp_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dx_pfp_project ON public.project_filter_entry USING btree (project_id);


--
-- Name: dx_team_member; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX dx_team_member ON public.core_team_member USING btree (team_id, user_id);


--
-- Name: dx_un_project_filter_user; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dx_un_project_filter_user ON public.project_filter USING btree (user_login);


--
-- Name: dx_user_login; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX dx_user_login ON public.core_user USING btree (login);


--
-- Name: idx_action_word_library; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_action_word_library ON public.action_word_library USING btree (awl_id);


--
-- Name: idx_action_word_library_node; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_action_word_library_node ON public.action_word_library_node USING btree (awln_id);


--
-- Name: idx_attachment; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_attachment ON public.attachment USING btree (attachment_id);


--
-- Name: idx_authentication; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_authentication ON public.auth_user USING btree (login);


--
-- Name: idx_automated_execution_failure_detail_execution_extender_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_automated_execution_failure_detail_execution_extender_id ON public.automated_execution_failure_detail USING btree (execution_extender_id);


--
-- Name: idx_automated_execution_failure_detail_failure_detail_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_automated_execution_failure_detail_failure_detail_id ON public.automated_execution_failure_detail USING btree (failure_detail_id);


--
-- Name: idx_automation_request_lib_content_content; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_automation_request_lib_content_content ON public.automation_request_library_content USING btree (content_id);


--
-- Name: idx_automation_request_lib_content_lib; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_automation_request_lib_content_lib ON public.automation_request_library_content USING btree (library_id);


--
-- Name: idx_automation_request_library; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_automation_request_library ON public.automation_request_library USING btree (arl_id);


--
-- Name: idx_autotest_server; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_autotest_server ON public.test_automation_server USING btree (server_id);


--
-- Name: idx_awln_relationship_ancestor; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_awln_relationship_ancestor ON public.awln_relationship USING btree (ancestor_id);


--
-- Name: idx_awln_relationship_clos_anc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_awln_relationship_clos_anc ON public.awln_relationship_closure USING btree (ancestor_id);


--
-- Name: idx_awln_relationship_clos_desc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_awln_relationship_clos_desc ON public.awln_relationship_closure USING btree (descendant_id);


--
-- Name: idx_awln_relationship_descendant; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_awln_relationship_descendant ON public.awln_relationship USING btree (descendant_id);


--
-- Name: idx_bugtracker_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_bugtracker_project ON public.bugtracker_project USING btree (bugtracker_project_id);


--
-- Name: idx_campaign_library; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_campaign_library ON public.campaign_library USING btree (cl_id);


--
-- Name: idx_camptestplan; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_camptestplan ON public.campaign_test_plan_item USING btree (ctpi_id);


--
-- Name: idx_cfv_custom_field_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_cfv_custom_field_id ON public.custom_field_value USING btree (cf_id);


--
-- Name: idx_cfv_entity_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_cfv_entity_id ON public.custom_field_value USING btree (bound_entity_id);


--
-- Name: idx_cfv_entity_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_cfv_entity_type ON public.custom_field_value USING btree (bound_entity_type);


--
-- Name: idx_chart_definition; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_chart_definition ON public.chart_definition USING btree (chart_id);


--
-- Name: idx_chart_filter; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_chart_filter ON public.chart_filter USING btree (filter_id);


--
-- Name: idx_cln_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_cln_name ON public.campaign_library_node USING btree (name);


--
-- Name: idx_cln_relationship_clos_anc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_cln_relationship_clos_anc ON public.cln_relationship_closure USING btree (ancestor_id);


--
-- Name: idx_cln_relationship_clos_desc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_cln_relationship_clos_desc ON public.cln_relationship_closure USING btree (descendant_id);


--
-- Name: idx_column_prototype; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_column_prototype ON public.query_column_prototype USING btree (query_column_id);


--
-- Name: idx_crln_relationship_ancestor; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_crln_relationship_ancestor ON public.crln_relationship USING btree (ancestor_id);


--
-- Name: idx_crln_relationship_clos_anc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_crln_relationship_clos_anc ON public.crln_relationship_closure USING btree (ancestor_id);


--
-- Name: idx_crln_relationship_clos_desc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_crln_relationship_clos_desc ON public.crln_relationship_closure USING btree (descendant_id);


--
-- Name: idx_crln_relationship_descendant; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_crln_relationship_descendant ON public.crln_relationship USING btree (descendant_id);


--
-- Name: idx_custom_report_library; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_custom_report_library ON public.custom_report_library USING btree (crl_id);


--
-- Name: idx_det_holder_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_det_holder_id ON public.denormalized_environment_tag USING btree (holder_id);


--
-- Name: idx_det_holder_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_det_holder_type ON public.denormalized_environment_tag USING btree (holder_type);


--
-- Name: idx_dev_holder_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_dev_holder_id ON public.denormalized_environment_variable USING btree (holder_id);


--
-- Name: idx_dev_holder_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_dev_holder_type ON public.denormalized_environment_variable USING btree (holder_type);


--
-- Name: idx_dfv_entity_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_dfv_entity_id ON public.denormalized_field_value USING btree (denormalized_field_holder_id);


--
-- Name: idx_dfv_entity_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_dfv_entity_type ON public.denormalized_field_value USING btree (denormalized_field_holder_type);


--
-- Name: idx_ev_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_ev_name ON public.environment_variable USING btree (name);


--
-- Name: idx_evb_entity_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_evb_entity_id ON public.environment_variable_binding USING btree (entity_id);


--
-- Name: idx_evb_entity_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_evb_entity_type ON public.environment_variable_binding USING btree (entity_type);


--
-- Name: idx_exec_exec_step_exec; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_exec_exec_step_exec ON public.execution_execution_steps USING btree (execution_id);


--
-- Name: idx_exec_exec_step_exec_step; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_exec_exec_step_exec_step ON public.execution_execution_steps USING btree (execution_step_id);


--
-- Name: idx_execution; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_execution ON public.execution USING btree (execution_id);


--
-- Name: idx_execution_last_executed_on; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_execution_last_executed_on ON public.execution USING btree (last_executed_on);


--
-- Name: idx_executionstep; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_executionstep ON public.execution_step USING btree (execution_step_id);


--
-- Name: idx_failure_detail_created_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_failure_detail_created_by ON public.failure_detail USING btree (created_by);


--
-- Name: idx_failure_detail_item_test_plan_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_failure_detail_item_test_plan_id ON public.failure_detail USING btree (test_plan_item_id);


--
-- Name: idx_fk_acl_grp_permission_acl_grp; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_acl_grp_permission_acl_grp ON public.acl_group_permission USING btree (acl_group_id);


--
-- Name: idx_fk_acl_obj_id_acl_class; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_acl_obj_id_acl_class ON public.acl_object_identity USING btree (class_id);


--
-- Name: idx_fk_action_test_step_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_action_test_step_attachment_list ON public.action_test_step USING btree (attachment_list_id);


--
-- Name: idx_fk_action_word_fragment_action_word_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_action_word_fragment_action_word_id ON public.action_word_fragment USING btree (action_word_id);


--
-- Name: idx_fk_action_word_parameter_action_word_fragment; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_action_word_parameter_action_word_fragment ON public.action_word_parameter USING btree (action_word_fragment_id);


--
-- Name: idx_fk_action_word_parameter_value_action_word_fragment_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_action_word_parameter_value_action_word_fragment_id ON public.action_word_parameter_value USING btree (action_word_fragment_id);


--
-- Name: idx_fk_action_word_parameter_value_keyword_test_step_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_action_word_parameter_value_keyword_test_step_id ON public.action_word_parameter_value USING btree (keyword_test_step_id);


--
-- Name: idx_fk_action_word_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_action_word_project ON public.action_word USING btree (project_id);


--
-- Name: idx_fk_action_word_text_action_word_fragment; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_action_word_text_action_word_fragment ON public.action_word_text USING btree (action_word_fragment_id);


--
-- Name: idx_fk_api_token_user_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_api_token_user_id ON public.api_token USING btree (user_id);


--
-- Name: idx_fk_arse_party; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_arse_party ON public.acl_responsibility_scope_entry USING btree (party_id);


--
-- Name: idx_fk_attachment_att_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_attachment_att_list ON public.attachment USING btree (attachment_list_id);


--
-- Name: idx_fk_attachment_content; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_attachment_content ON public.attachment USING btree (content_id);


--
-- Name: idx_fk_audit_event_requirement_version; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_audit_event_requirement_version ON public.requirement_audit_event USING btree (req_version_id);


--
-- Name: idx_fk_auto_exec_auto_test; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_auto_exec_auto_test ON public.automated_execution_extender USING btree (test_id);


--
-- Name: idx_fk_auto_exec_exec; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_auto_exec_exec ON public.automated_execution_extender USING btree (master_execution_id);


--
-- Name: idx_fk_automated_execution_extender_suite_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_automated_execution_extender_suite_id ON public.automated_execution_extender USING btree (suite_id);


--
-- Name: idx_fk_automated_suite_workflows_project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_automated_suite_workflows_project_id ON public.automated_suite_workflows USING btree (project_id);


--
-- Name: idx_fk_automated_suite_workflows_suite_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_automated_suite_workflows_suite_id ON public.automated_suite_workflows USING btree (suite_id);


--
-- Name: idx_fk_automated_test_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_automated_test_project ON public.automated_test USING btree (project_id);


--
-- Name: idx_fk_automation_request_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_automation_request_project ON public.automation_request USING btree (project_id);


--
-- Name: idx_fk_autorequestlib_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_autorequestlib_attachment_list ON public.automation_request_library USING btree (attachment_list_id);


--
-- Name: idx_fk_awl_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_awl_attachment_list ON public.action_word_library USING btree (attachment_list_id);


--
-- Name: idx_fk_awln_awl; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_awln_awl ON public.action_word_library_node USING btree (awl_id);


--
-- Name: idx_fk_axis_column_chart_column; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_axis_column_chart_column ON public.chart_axis_column USING btree (chart_column_id);


--
-- Name: idx_fk_bugtracker_project_project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_bugtracker_project_project_id ON public.bugtracker_project USING btree (project_id);


--
-- Name: idx_fk_call_step_called_test_case; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_call_step_called_test_case ON public.call_test_step USING btree (called_test_case_id);


--
-- Name: idx_fk_call_step_dataset; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_call_step_dataset ON public.call_test_step USING btree (called_dataset);


--
-- Name: idx_fk_camp_iter_campaign; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_camp_iter_campaign ON public.campaign_iteration USING btree (campaign_id);


--
-- Name: idx_fk_camp_iter_iteration; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_camp_iter_iteration ON public.campaign_iteration USING btree (iteration_id);


--
-- Name: idx_fk_camp_test_plan_item_dataset; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_camp_test_plan_item_dataset ON public.campaign_test_plan_item USING btree (dataset_id);


--
-- Name: idx_fk_camp_tp_campaign; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_camp_tp_campaign ON public.campaign_test_plan_item USING btree (campaign_id);


--
-- Name: idx_fk_camp_tp_testcase; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_camp_tp_testcase ON public.campaign_test_plan_item USING btree (test_case_id);


--
-- Name: idx_fk_camp_tp_user; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_camp_tp_user ON public.campaign_test_plan_item USING btree (user_id);


--
-- Name: idx_fk_camplib_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_camplib_attachment_list ON public.campaign_library USING btree (attachment_list_id);


--
-- Name: idx_fk_campnode_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_campnode_attachment_list ON public.campaign_library_node USING btree (attachment_list_id);


--
-- Name: idx_fk_cf_option_cf; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_cf_option_cf ON public.custom_field_option USING btree (cf_id);


--
-- Name: idx_fk_cfb_bound_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_cfb_bound_project ON public.custom_field_binding USING btree (bound_project_id);


--
-- Name: idx_fk_cfb_cf; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_cfb_cf ON public.custom_field_binding USING btree (cf_id);


--
-- Name: idx_fk_cfb_render_loc_cfb; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_cfb_render_loc_cfb ON public.custom_field_rendering_location USING btree (cfb_id);


--
-- Name: idx_fk_cfv_cf_binding; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_cfv_cf_binding ON public.custom_field_value USING btree (cfb_id);


--
-- Name: idx_fk_cfv_option_cfv; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_cfv_option_cfv ON public.custom_field_value_option USING btree (cfv_id);


--
-- Name: idx_fk_chart_axis_chart_def; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_axis_chart_def ON public.chart_axis_column USING btree (chart_definition_id);


--
-- Name: idx_fk_chart_bindind_chart_definition_chart_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_bindind_chart_definition_chart_id ON public.custom_report_chart_binding USING btree (chart_id);


--
-- Name: idx_fk_chart_bindind_custom_report_dashboard_crd_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_bindind_custom_report_dashboard_crd_id ON public.custom_report_chart_binding USING btree (crd_id);


--
-- Name: idx_fk_chart_bindind_report_definition_report_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_bindind_report_definition_report_id ON public.custom_report_report_binding USING btree (report_id);


--
-- Name: idx_fk_chart_filter_chart_column; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_filter_chart_column ON public.chart_filter USING btree (chart_column_id);


--
-- Name: idx_fk_chart_filter_chart_def; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_filter_chart_def ON public.chart_filter USING btree (chart_definition_id);


--
-- Name: idx_fk_chart_filter_value_chart_column; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_filter_value_chart_column ON public.chart_filter_values USING btree (filter_id);


--
-- Name: idx_fk_chart_meas_chart_def; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_meas_chart_def ON public.chart_measure_column USING btree (chart_definition_id);


--
-- Name: idx_fk_chart_measure_chart_column; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_measure_chart_column ON public.chart_measure_column USING btree (chart_column_id);


--
-- Name: idx_fk_chart_project_scope_chart_definition; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_project_scope_chart_definition ON public.chart_project_scope USING btree (chart_id);


--
-- Name: idx_fk_chart_scope_chart_definition; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_chart_scope_chart_definition ON public.chart_scope USING btree (chart_id);


--
-- Name: idx_fk_cln_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_cln_project ON public.campaign_library_node USING btree (project_id);


--
-- Name: idx_fk_cln_relationship_ancestor; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_cln_relationship_ancestor ON public.cln_relationship USING btree (ancestor_id);


--
-- Name: idx_fk_column_query; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_column_query ON public.query_column_prototype USING btree (subquery_id);


--
-- Name: idx_fk_column_role_chart_column; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_column_role_chart_column ON public.chart_column_role USING btree (chart_column_id);


--
-- Name: idx_fk_crl_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_crl_attachment_list ON public.custom_report_library USING btree (attachment_list_id);


--
-- Name: idx_fk_crln_custom_report_library_crl_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_crln_custom_report_library_crl_id ON public.custom_report_library_node USING btree (crl_id);


--
-- Name: idx_fk_custom_export_project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_custom_export_project_id ON public.custom_report_custom_export USING btree (project_id);


--
-- Name: idx_fk_dataset_param_value_dataset; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_dataset_param_value_dataset ON public.dataset_param_value USING btree (dataset_id);


--
-- Name: idx_fk_dataset_param_value_param; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_dataset_param_value_param ON public.dataset_param_value USING btree (param_id);


--
-- Name: idx_fk_dataset_test_case; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_dataset_test_case ON public.dataset USING btree (test_case_id);


--
-- Name: idx_fk_dev_environment_variable; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_dev_environment_variable ON public.denormalized_environment_variable USING btree (ev_id);


--
-- Name: idx_fk_dfb_render_loc_dfb; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_dfb_render_loc_dfb ON public.denormalized_field_rendering_location USING btree (dfv_id);


--
-- Name: idx_fk_dfv_cfv_binding; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_dfv_cfv_binding ON public.denormalized_field_value USING btree (cfv_id);


--
-- Name: idx_fk_dfv_option_dfv; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_dfv_option_dfv ON public.denormalized_field_value_option USING btree (dfv_id);


--
-- Name: idx_fk_disabled_exec_status_cl_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_disabled_exec_status_cl_id ON public.disabled_execution_status USING btree (cl_id);


--
-- Name: idx_fk_ev_binding_ev; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_ev_binding_ev ON public.environment_variable_binding USING btree (ev_id);


--
-- Name: idx_fk_ev_option_ev; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_ev_option_ev ON public.environment_variable_option USING btree (ev_id);


--
-- Name: idx_fk_execution_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_execution_attachment_list ON public.execution USING btree (attachment_list_id);


--
-- Name: idx_fk_execution_issue_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_execution_issue_list ON public.execution USING btree (issue_list_id);


--
-- Name: idx_fk_execution_step__attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_execution_step__attachment_list ON public.execution_step USING btree (attachment_list_id);


--
-- Name: idx_fk_execution_step_issue_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_execution_step_issue_list ON public.execution_step USING btree (issue_list_id);


--
-- Name: idx_fk_execution_test_case; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_execution_test_case ON public.execution USING btree (tcln_id);


--
-- Name: idx_fk_execution_test_plan_item; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_execution_test_plan_item ON public.execution USING btree (test_plan_item_id);


--
-- Name: idx_fk_executionstep_teststep; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_executionstep_teststep ON public.execution_step USING btree (test_step_id);


--
-- Name: idx_fk_exploratory_execution_assignee; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_exploratory_execution_assignee ON public.exploratory_execution USING btree (assignee_id);


--
-- Name: idx_fk_exploratory_session_overview_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_exploratory_session_overview_attachment_list ON public.exploratory_session_overview USING btree (attachment_list_id);


--
-- Name: idx_fk_failure_detail_issue_list_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_failure_detail_issue_list_id ON public.failure_detail USING btree (issue_list_id);


--
-- Name: idx_fk_grid_column_display_configuration_gcdr_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_grid_column_display_configuration_gcdr_id ON public.grid_column_display_configuration USING btree (gcdr_id);


--
-- Name: idx_fk_grid_column_display_reference_party_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_grid_column_display_reference_party_id ON public.grid_column_display_reference USING btree (party_id);


--
-- Name: idx_fk_grid_column_display_reference_project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_grid_column_display_reference_project_id ON public.grid_column_display_reference USING btree (project_id);


--
-- Name: idx_fk_group_member_party; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_group_member_party ON public.core_group_member USING btree (party_id);


--
-- Name: idx_fk_grp_member_grp; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_grp_member_grp ON public.core_group_member USING btree (group_id);


--
-- Name: idx_fk_info_item_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_info_item_list ON public.info_list_item USING btree (list_id);


--
-- Name: idx_fk_issue_bugtracker; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_issue_bugtracker ON public.issue USING btree (bugtracker_id);


--
-- Name: idx_fk_issue_issue_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_issue_issue_list ON public.issue USING btree (issue_list_id);


--
-- Name: idx_fk_iteration__attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_iteration__attachment_list ON public.iteration USING btree (attachment_list_id);


--
-- Name: idx_fk_iteration_test_suite_suite; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_iteration_test_suite_suite ON public.iteration_test_suite USING btree (test_suite_id);


--
-- Name: idx_fk_keyword_test_step_action_word; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_keyword_test_step_action_word ON public.keyword_test_step USING btree (action_word_id);


--
-- Name: idx_fk_libplugin_property_libplugin; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_libplugin_property_libplugin ON public.library_plugin_binding_property USING btree (plugin_binding_id);


--
-- Name: idx_fk_milestone_binding_milestone; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_milestone_binding_milestone ON public.milestone_binding USING btree (milestone_id);


--
-- Name: idx_fk_milestone_binding_perimeter_milestone; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_milestone_binding_perimeter_milestone ON public.milestone_binding_perimeter USING btree (milestone_id);


--
-- Name: idx_fk_milestone_binding_perimeter_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_milestone_binding_perimeter_project ON public.milestone_binding_perimeter USING btree (project_id);


--
-- Name: idx_fk_milestone_binding_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_milestone_binding_project ON public.milestone_binding USING btree (project_id);


--
-- Name: idx_fk_milestone_owner; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_milestone_owner ON public.milestone USING btree (user_id);


--
-- Name: idx_fk_parameter_test_case; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_parameter_test_case ON public.parameter USING btree (test_case_id);


--
-- Name: idx_fk_party_authority_party; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_party_authority_party ON public.core_party_authority USING btree (party_id);


--
-- Name: idx_fk_party_preference_core_party_party_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_party_preference_core_party_party_id ON public.party_preference USING btree (party_id);


--
-- Name: idx_fk_pivot_format_import_created_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_pivot_format_import_created_by ON public.pivot_format_import USING btree (created_by);


--
-- Name: idx_fk_pivot_format_import_project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_pivot_format_import_project_id ON public.pivot_format_import USING btree (project_id);


--
-- Name: idx_fk_project_ai_server; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_ai_server ON public.project USING btree (ai_server_id);


--
-- Name: idx_fk_project_arl; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_arl ON public.project USING btree (arl_id);


--
-- Name: idx_fk_project_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_attachment_list ON public.project USING btree (attachment_list_id);


--
-- Name: idx_fk_project_awl; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_awl ON public.project USING btree (awl_id);


--
-- Name: idx_fk_project_bugtracker_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_bugtracker_id ON public.project USING btree (bugtracker_id);


--
-- Name: idx_fk_project_chart_definition_project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_chart_definition_project_id ON public.chart_definition USING btree (project_id);


--
-- Name: idx_fk_project_cl; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_cl ON public.project USING btree (cl_id);


--
-- Name: idx_fk_project_crl; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_crl ON public.project USING btree (crl_id);


--
-- Name: idx_fk_project_custom_report_dashboard_project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_custom_report_dashboard_project_id ON public.custom_report_dashboard USING btree (project_id);


--
-- Name: idx_fk_project_custom_report_folder_project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_custom_report_folder_project_id ON public.custom_report_folder USING btree (project_id);


--
-- Name: idx_fk_project_report_definition_project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_report_definition_project_id ON public.report_definition USING btree (project_id);


--
-- Name: idx_fk_project_rl; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_rl ON public.project USING btree (rl_id);


--
-- Name: idx_fk_project_scm_repository; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_scm_repository ON public.project USING btree (scm_repository_id);


--
-- Name: idx_fk_project_tcl; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_tcl ON public.project USING btree (tcl_id);


--
-- Name: idx_fk_project_template_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_project_template_id ON public.project USING btree (template_id);


--
-- Name: idx_fk_query_aggr_query_column; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_query_aggr_query_column ON public.query_aggregation_column USING btree (query_column_id);


--
-- Name: idx_fk_query_aggr_query_model; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_query_aggr_query_model ON public.query_aggregation_column USING btree (query_model_id);


--
-- Name: idx_fk_query_filter_query_column; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_query_filter_query_column ON public.query_filter_column USING btree (query_column_id);


--
-- Name: idx_fk_query_filter_query_model; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_query_filter_query_model ON public.query_filter_column USING btree (query_model_id);


--
-- Name: idx_fk_query_order_query_column; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_query_order_query_column ON public.query_ordering_column USING btree (query_column_id);


--
-- Name: idx_fk_query_order_query_model; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_query_order_query_model ON public.query_ordering_column USING btree (query_model_id);


--
-- Name: idx_fk_query_projection_query_column; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_query_projection_query_column ON public.query_projection_column USING btree (query_column_id);


--
-- Name: idx_fk_query_projection_query_model; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_query_projection_query_model ON public.query_projection_column USING btree (query_model_id);


--
-- Name: idx_fk_remote_automation_request_extender_automation_request_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_remote_automation_request_extender_automation_request_id ON public.remote_automation_request_extender USING btree (automation_request_id);


--
-- Name: idx_fk_remote_automation_request_extender_server_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_remote_automation_request_extender_server_id ON public.remote_automation_request_extender USING btree (server_id);


--
-- Name: idx_fk_remote_sync__bugtracker__bugtracker_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_remote_sync__bugtracker__bugtracker_id ON public.remote_synchronisation USING btree (server_id);


--
-- Name: idx_fk_remote_sync__project__project_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_remote_sync__project__project_id ON public.remote_synchronisation USING btree (project_id);


--
-- Name: idx_fk_remote_sync_owner; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_remote_sync_owner ON public.remote_synchronisation USING btree (owner_id);


--
-- Name: idx_fk_report_bindind_custom_report_dashboard_crd_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_report_bindind_custom_report_dashboard_crd_id ON public.custom_report_report_binding USING btree (crd_id);


--
-- Name: idx_fk_req_folder_simple_resource; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_req_folder_simple_resource ON public.requirement_folder USING btree (res_id);


--
-- Name: idx_fk_req_folder_sync_extender__remote_sync_remote_sync_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_req_folder_sync_extender__remote_sync_remote_sync_id ON public.requirement_folder_sync_extender USING btree (remote_synchronisation_id);


--
-- Name: idx_fk_req_nature; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_req_nature ON public.requirement_version USING btree (category);


--
-- Name: idx_fk_req_sync_extender__remote_sync_remote_sync_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_req_sync_extender__remote_sync_remote_sync_id ON public.requirement_sync_extender USING btree (remote_synchronisation_id);


--
-- Name: idx_fk_req_version_link_req_version_link_type_link_type_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_req_version_link_req_version_link_type_link_type_id ON public.requirement_version_link USING btree (link_type_id);


--
-- Name: idx_fk_reqlib_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_reqlib_attachment_list ON public.requirement_library USING btree (attachment_list_id);


--
-- Name: idx_fk_requirement_current_version; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_requirement_current_version ON public.requirement USING btree (current_version_id);


--
-- Name: idx_fk_requirement_version_link_related_requirement_version_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_requirement_version_link_related_requirement_version_id ON public.requirement_version_link USING btree (related_requirement_version_id);


--
-- Name: idx_fk_requirement_version_link_requirement_version_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_requirement_version_link_requirement_version_id ON public.requirement_version_link USING btree (requirement_version_id);


--
-- Name: idx_fk_requirement_version_requirement; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_requirement_version_requirement ON public.requirement_version USING btree (requirement_id);


--
-- Name: idx_fk_resource_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_resource_attachment_list ON public.resource USING btree (attachment_list_id);


--
-- Name: idx_fk_resp_scope_acl_grp; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_resp_scope_acl_grp ON public.acl_responsibility_scope_entry USING btree (acl_group_id);


--
-- Name: idx_fk_resp_scope_obj_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_resp_scope_obj_id ON public.acl_responsibility_scope_entry USING btree (object_identity_id);


--
-- Name: idx_fk_rln_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_rln_project ON public.requirement_library_node USING btree (project_id);


--
-- Name: idx_fk_sc_auth_acl_class; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sc_auth_acl_class ON public.acl_group_permission USING btree (class_id);


--
-- Name: idx_fk_scm_repository_scm_server; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_scm_repository_scm_server ON public.scm_repository USING btree (server_id);


--
-- Name: idx_fk_session_note_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_session_note_attachment_list ON public.session_note USING btree (attachment_list_id);


--
-- Name: idx_fk_session_note_execution; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_session_note_execution ON public.session_note USING btree (execution_id);


--
-- Name: idx_fk_session_note_issue_list_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_session_note_issue_list_id ON public.session_note USING btree (issue_list_id);


--
-- Name: idx_fk_sprint_group_remote_synchronisation; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sprint_group_remote_synchronisation ON public.sprint_group USING btree (remote_synchronisation_id);


--
-- Name: idx_fk_sprint_remote_synchronisation; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sprint_remote_synchronisation ON public.sprint USING btree (remote_synchronisation_id);


--
-- Name: idx_fk_sprint_req_sync_ext_remote_sync_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sprint_req_sync_ext_remote_sync_id ON public.sprint_requirement_sync_extender USING btree (remote_synchronisation_id);


--
-- Name: idx_fk_sprint_req_sync_ext_sprint_req_version_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sprint_req_sync_ext_sprint_req_version_id ON public.sprint_requirement_sync_extender USING btree (sprint_req_version_id);


--
-- Name: idx_fk_sprint_req_version_req_version_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sprint_req_version_req_version_id ON public.sprint_req_version USING btree (req_version_id);


--
-- Name: idx_fk_sprint_req_version_sprint_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sprint_req_version_sprint_id ON public.sprint_req_version USING btree (sprint_id);


--
-- Name: idx_fk_sprint_req_version_test_plan; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sprint_req_version_test_plan ON public.sprint_req_version USING btree (test_plan_id);


--
-- Name: idx_fk_stored_credentials_authenticated_server; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_stored_credentials_authenticated_server ON public.stored_credentials USING btree (authenticated_server);


--
-- Name: idx_fk_stored_credentials_user; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_stored_credentials_user ON public.stored_credentials USING btree (authenticated_user);


--
-- Name: idx_fk_sync_extender_requirement; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sync_extender_requirement ON public.requirement_sync_extender USING btree (requirement_id);


--
-- Name: idx_fk_sync_extender_server; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_sync_extender_server ON public.requirement_sync_extender USING btree (server_id);


--
-- Name: idx_fk_ta_project_ta_server; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_ta_project_ta_server ON public.test_automation_project USING btree (server_id);


--
-- Name: idx_fk_ta_project_tm_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_ta_project_tm_project ON public.test_automation_project USING btree (tm_project_id);


--
-- Name: idx_fk_tc_nature; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_tc_nature ON public.test_case USING btree (tc_nature);


--
-- Name: idx_fk_tc_scm_repository; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_tc_scm_repository ON public.test_case USING btree (scm_repository_id);


--
-- Name: idx_fk_tc_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_tc_type ON public.test_case USING btree (tc_type);


--
-- Name: idx_fk_tclib_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_tclib_attachment_list ON public.test_case_library USING btree (attachment_list_id);


--
-- Name: idx_fk_tcln_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_tcln_project ON public.test_case_library_node USING btree (project_id);


--
-- Name: idx_fk_tcnode_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_tcnode_attachment_list ON public.test_case_library_node USING btree (attachment_list_id);


--
-- Name: idx_fk_team_member_team; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_team_member_team ON public.core_team_member USING btree (team_id);


--
-- Name: idx_fk_team_member_user; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_team_member_user ON public.core_team_member USING btree (user_id);


--
-- Name: idx_fk_test_case_ta_test; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_test_case_ta_test ON public.test_case USING btree (ta_test);


--
-- Name: idx_fk_test_plan_campaign_library; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_test_plan_campaign_library ON public.test_plan USING btree (cl_id);


--
-- Name: idx_fk_test_plan_item_dataset; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_test_plan_item_dataset ON public.test_plan_item USING btree (dataset_id);


--
-- Name: idx_fk_test_plan_item_test_case; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_test_plan_item_test_case ON public.test_plan_item USING btree (tcln_id);


--
-- Name: idx_fk_test_plan_item_test_plan; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_test_plan_item_test_plan ON public.test_plan_item USING btree (test_plan_id);


--
-- Name: idx_fk_test_plan_item_user; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_test_plan_item_user ON public.test_plan_item USING btree (assignee_id);


--
-- Name: idx_fk_test_suite_attachment_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_test_suite_attachment_list ON public.test_suite USING btree (attachment_list_id);


--
-- Name: idx_fk_test_suite_test_plan_item_test_plan_item; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_test_suite_test_plan_item_test_plan_item ON public.test_suite_test_plan_item USING btree (tpi_id);


--
-- Name: idx_fk_test_suite_test_plan_item_test_suite; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_test_suite_test_plan_item_test_suite ON public.test_suite_test_plan_item USING btree (suite_id);


--
-- Name: idx_fk_verified_req_version; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_verified_req_version ON public.requirement_version_coverage USING btree (verified_req_version_id);


--
-- Name: idx_fk_verifying_step_action_test_step; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_verifying_step_action_test_step ON public.verifying_steps USING btree (test_step_id);


--
-- Name: idx_fk_verifying_step_requirement_version_coverage; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_verifying_step_requirement_version_coverage ON public.verifying_steps USING btree (requirement_version_coverage_id);


--
-- Name: idx_fk_verifying_test_case; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fk_verifying_test_case ON public.requirement_version_coverage USING btree (verifying_test_case_id);


--
-- Name: idx_info_list_code; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_info_list_code ON public.info_list USING btree (code);


--
-- Name: idx_info_list_item_code; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_info_list_item_code ON public.info_list_item USING btree (code);


--
-- Name: idx_info_list_label; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_info_list_label ON public.info_list USING btree (label);


--
-- Name: idx_issue; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_issue ON public.issue USING btree (issue_id);


--
-- Name: idx_issue_list; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_issue_list ON public.issue_list USING btree (issue_list_id);


--
-- Name: idx_iteration_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_iteration_name ON public.iteration USING btree (name);


--
-- Name: idx_iteration_test_plan_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_iteration_test_plan_id ON public.iteration USING btree (test_plan_id);


--
-- Name: idx_milestone; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_milestone ON public.milestone USING btree (milestone_id);


--
-- Name: idx_milestone_camp_camp; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_milestone_camp_camp ON public.milestone_campaign USING btree (campaign_id);


--
-- Name: idx_milestone_camp_milestone; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_milestone_camp_milestone ON public.milestone_campaign USING btree (milestone_id);


--
-- Name: idx_milestone_rqv_milestone; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_milestone_rqv_milestone ON public.milestone_req_version USING btree (milestone_id);


--
-- Name: idx_milestone_rqv_rqv; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_milestone_rqv_rqv ON public.milestone_req_version USING btree (req_version_id);


--
-- Name: idx_milestone_tc_milestone; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_milestone_tc_milestone ON public.milestone_test_case USING btree (milestone_id);


--
-- Name: idx_milestone_tc_tc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_milestone_tc_tc ON public.milestone_test_case USING btree (test_case_id);


--
-- Name: idx_proj_req_categories; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_proj_req_categories ON public.project USING btree (req_categories_list);


--
-- Name: idx_proj_tc_natures; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_proj_tc_natures ON public.project USING btree (tc_natures_list);


--
-- Name: idx_proj_tc_types; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_proj_tc_types ON public.project USING btree (tc_types_list);


--
-- Name: idx_project; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_project ON public.project USING btree (project_id);


--
-- Name: idx_project_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_project_name ON public.project USING btree (name);


--
-- Name: idx_query_filter; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_query_filter ON public.query_filter_column USING btree (query_filter_id);


--
-- Name: idx_req_criticality; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_req_criticality ON public.requirement_version USING btree (criticality);


--
-- Name: idx_req_folder; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_req_folder ON public.requirement_folder USING btree (rln_id);


--
-- Name: idx_req_reference; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_req_reference ON public.requirement_version USING btree (reference);


--
-- Name: idx_req_status; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_req_status ON public.requirement_version USING btree (requirement_status);


--
-- Name: idx_requirement; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_requirement ON public.requirement USING btree (rln_id);


--
-- Name: idx_requirement_lib_content_content; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_requirement_lib_content_content ON public.requirement_library_content USING btree (content_id);


--
-- Name: idx_requirement_lib_content_lib; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_requirement_lib_content_lib ON public.requirement_library_content USING btree (library_id);


--
-- Name: idx_requirement_library; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_requirement_library ON public.requirement_library USING btree (rl_id);


--
-- Name: idx_resource_created_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_resource_created_by ON public.resource USING btree (created_by);


--
-- Name: idx_resource_last_modified_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_resource_last_modified_by ON public.resource USING btree (last_modified_by);


--
-- Name: idx_resource_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_resource_name ON public.resource USING btree (name);


--
-- Name: idx_rln_created_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_rln_created_by ON public.requirement_library_node USING btree (created_by);


--
-- Name: idx_rln_last_modified_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_rln_last_modified_by ON public.requirement_library_node USING btree (last_modified_by);


--
-- Name: idx_rln_relationship_ancestor; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_rln_relationship_ancestor ON public.rln_relationship USING btree (ancestor_id);


--
-- Name: idx_rln_relationship_clos_anc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_rln_relationship_clos_anc ON public.rln_relationship_closure USING btree (ancestor_id);


--
-- Name: idx_rln_relationship_clos_desc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_rln_relationship_clos_desc ON public.rln_relationship_closure USING btree (descendant_id);


--
-- Name: idx_rln_relationship_descendant; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_rln_relationship_descendant ON public.rln_relationship USING btree (descendant_id);


--
-- Name: idx_session_note_created_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_session_note_created_by ON public.session_note USING btree (created_by);


--
-- Name: idx_session_note_last_modified_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_session_note_last_modified_by ON public.session_note USING btree (last_modified_by);


--
-- Name: idx_sync_remote_projfilter; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_sync_remote_projfilter ON public.requirement_sync_extender USING btree (remote_project_id, remote_filter_name);


--
-- Name: idx_sync_remote_req_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_sync_remote_req_id ON public.requirement_sync_extender USING btree (remote_req_id);


--
-- Name: idx_tc_folder; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tc_folder ON public.test_case_folder USING btree (tcln_id);


--
-- Name: idx_tc_importance; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tc_importance ON public.test_case USING btree (importance);


--
-- Name: idx_tc_reference; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tc_reference ON public.test_case USING btree (reference);


--
-- Name: idx_tc_steps_step; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tc_steps_step ON public.test_case_steps USING btree (step_id);


--
-- Name: idx_tc_steps_tc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tc_steps_tc ON public.test_case_steps USING btree (test_case_id);


--
-- Name: idx_tcln_created_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tcln_created_by ON public.test_case_library_node USING btree (created_by);


--
-- Name: idx_tcln_last_modified_by; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tcln_last_modified_by ON public.test_case_library_node USING btree (last_modified_by);


--
-- Name: idx_tcln_relationship_ancestor; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tcln_relationship_ancestor ON public.tcln_relationship USING btree (ancestor_id);


--
-- Name: idx_tcln_relationship_clos_anc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tcln_relationship_clos_anc ON public.tcln_relationship_closure USING btree (ancestor_id);


--
-- Name: idx_tcln_relationship_clos_desc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tcln_relationship_clos_desc ON public.tcln_relationship_closure USING btree (descendant_id);


--
-- Name: idx_tcln_relationship_descendant; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tcln_relationship_descendant ON public.tcln_relationship USING btree (descendant_id);


--
-- Name: idx_test_case; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_test_case ON public.test_case USING btree (tcln_id);


--
-- Name: idx_test_case_automation_request_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_test_case_automation_request_id ON public.test_case USING btree (automation_request_id);


--
-- Name: idx_test_case_lib_content_content; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_test_case_lib_content_content ON public.test_case_library_content USING btree (content_id);


--
-- Name: idx_test_case_lib_content_lib; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_test_case_lib_content_lib ON public.test_case_library_content USING btree (library_id);


--
-- Name: idx_test_case_library; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_test_case_library ON public.test_case_library USING btree (tcl_id);


--
-- Name: idx_test_plan_item_overview_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_test_plan_item_overview_id ON public.test_plan_item USING btree (overview_id);


--
-- Name: idx_tm_project_ta_server; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_tm_project_ta_server ON public.project USING btree (ta_server_id);


--
-- Name: issue_remote_issue_id_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX issue_remote_issue_id_idx ON public.issue USING btree (remote_issue_id);


--
-- Name: req_sync_extender_remote_parent_id_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX req_sync_extender_remote_parent_id_idx ON public.requirement_sync_extender USING btree (remote_parent_id);


--
-- Name: resource_description_fulltext_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX resource_description_fulltext_idx ON public.resource USING gin (to_tsvector('simple'::regconfig, description));


--
-- Name: scripted_execution_extender_execution_id_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX scripted_execution_extender_execution_id_idx ON public.scripted_execution USING btree (execution_id);


--
-- Name: scripted_tc_extender_test_case_id_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX scripted_tc_extender_test_case_id_idx ON public.scripted_test_case USING btree (tcln_id);


--
-- Name: tc_prerequisite_fulltext_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX tc_prerequisite_fulltext_idx ON public.test_case USING gin (to_tsvector('simple'::regconfig, prerequisite));


--
-- Name: tcln_description_fulltext_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX tcln_description_fulltext_idx ON public.test_case_library_node USING gin (to_tsvector('simple'::regconfig, description));


--
-- Name: tcln_name_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX tcln_name_idx ON public.test_case_library_node USING btree (name);


--
-- Name: work_delete_entities_entity_id_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX work_delete_entities_entity_id_idx ON public.work_delete_entities USING btree (entity_id);


--
-- Name: work_delete_entities_entity_type_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX work_delete_entities_entity_type_idx ON public.work_delete_entities USING btree (entity_type);


--
-- Name: work_delete_entities_operation_id_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX work_delete_entities_operation_id_idx ON public.work_delete_entities USING btree (operation_id);


--
-- Name: awln_relationship attach_awln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER attach_awln_after AFTER INSERT ON public.awln_relationship FOR EACH ROW EXECUTE FUNCTION public.attach_awln_after();


--
-- Name: cln_relationship attach_cln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER attach_cln_after AFTER INSERT ON public.cln_relationship FOR EACH ROW EXECUTE FUNCTION public.attach_cln_after();


--
-- Name: crln_relationship attach_crln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER attach_crln_after AFTER INSERT ON public.crln_relationship FOR EACH ROW EXECUTE FUNCTION public.attach_crln_after();


--
-- Name: rln_relationship attach_rln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER attach_rln_after AFTER INSERT ON public.rln_relationship FOR EACH ROW EXECUTE FUNCTION public.attach_rln_after();


--
-- Name: tcln_relationship attach_tcln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER attach_tcln_after AFTER INSERT ON public.tcln_relationship FOR EACH ROW EXECUTE FUNCTION public.attach_tcln_after();


--
-- Name: action_word_library_node del_awln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER del_awln_before BEFORE DELETE ON public.action_word_library_node FOR EACH ROW EXECUTE FUNCTION public.del_awln_before();


--
-- Name: campaign_library_node del_cln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER del_cln_before BEFORE DELETE ON public.campaign_library_node FOR EACH ROW EXECUTE FUNCTION public.del_cln_before();


--
-- Name: custom_report_library_node del_crln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER del_crln_before BEFORE DELETE ON public.custom_report_library_node FOR EACH ROW EXECUTE FUNCTION public.del_crln_before();


--
-- Name: requirement_library_node del_rln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER del_rln_before BEFORE DELETE ON public.requirement_library_node FOR EACH ROW EXECUTE FUNCTION public.del_rln_before();


--
-- Name: test_case_library_node del_tcln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER del_tcln_before BEFORE DELETE ON public.test_case_library_node FOR EACH ROW EXECUTE FUNCTION public.del_tcln_before();


--
-- Name: awln_relationship detach_awln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER detach_awln_before BEFORE DELETE ON public.awln_relationship FOR EACH ROW EXECUTE FUNCTION public.detach_awln_before();


--
-- Name: cln_relationship detach_cln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER detach_cln_before BEFORE DELETE ON public.cln_relationship FOR EACH ROW EXECUTE FUNCTION public.detach_cln_before();


--
-- Name: crln_relationship detach_crln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER detach_crln_before BEFORE DELETE ON public.crln_relationship FOR EACH ROW EXECUTE FUNCTION public.detach_crln_before();


--
-- Name: rln_relationship detach_rln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER detach_rln_before BEFORE DELETE ON public.rln_relationship FOR EACH ROW EXECUTE FUNCTION public.detach_rln_before();


--
-- Name: tcln_relationship detach_tcln_before; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER detach_tcln_before BEFORE DELETE ON public.tcln_relationship FOR EACH ROW EXECUTE FUNCTION public.detach_tcln_before();


--
-- Name: action_word_library_node ins_awln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER ins_awln_after AFTER INSERT ON public.action_word_library_node FOR EACH ROW EXECUTE FUNCTION public.ins_awln_after();


--
-- Name: campaign_library_node ins_cln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER ins_cln_after AFTER INSERT ON public.campaign_library_node FOR EACH ROW EXECUTE FUNCTION public.ins_cln_after();


--
-- Name: custom_report_library_node ins_crln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER ins_crln_after AFTER INSERT ON public.custom_report_library_node FOR EACH ROW EXECUTE FUNCTION public.ins_crln_after();


--
-- Name: requirement_library_node ins_rln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER ins_rln_after AFTER INSERT ON public.requirement_library_node FOR EACH ROW EXECUTE FUNCTION public.ins_rln_after();


--
-- Name: test_case_library_node ins_tcln_after; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER ins_tcln_after AFTER INSERT ON public.test_case_library_node FOR EACH ROW EXECUTE FUNCTION public.ins_tcln_after();


--
-- Name: requirement_property_change fk_PPT_change_audit; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_property_change
    ADD CONSTRAINT "fk_PPT_change_audit" FOREIGN KEY (event_id) REFERENCES public.requirement_audit_event(event_id);


--
-- Name: acl_group_permission fk_acl_grp_permission_acl_grp; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_group_permission
    ADD CONSTRAINT fk_acl_grp_permission_acl_grp FOREIGN KEY (acl_group_id) REFERENCES public.acl_group(id);


--
-- Name: acl_object_identity fk_acl_obj_id_acl_class; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_object_identity
    ADD CONSTRAINT fk_acl_obj_id_acl_class FOREIGN KEY (class_id) REFERENCES public.acl_class(id);


--
-- Name: action_test_step fk_action_step_test_step; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_test_step
    ADD CONSTRAINT fk_action_step_test_step FOREIGN KEY (test_step_id) REFERENCES public.test_step(test_step_id);


--
-- Name: action_test_step fk_action_test_step_attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_test_step
    ADD CONSTRAINT fk_action_test_step_attachment_list FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: action_word_fragment fk_action_word_fragment_action_word_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_fragment
    ADD CONSTRAINT fk_action_word_fragment_action_word_id FOREIGN KEY (action_word_id) REFERENCES public.action_word(action_word_id);


--
-- Name: action_word_parameter fk_action_word_parameter_action_word_fragment; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_parameter
    ADD CONSTRAINT fk_action_word_parameter_action_word_fragment FOREIGN KEY (action_word_fragment_id) REFERENCES public.action_word_fragment(action_word_fragment_id);


--
-- Name: action_word_parameter_value fk_action_word_parameter_value_action_word_fragment_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_parameter_value
    ADD CONSTRAINT fk_action_word_parameter_value_action_word_fragment_id FOREIGN KEY (action_word_fragment_id) REFERENCES public.action_word_parameter(action_word_fragment_id);


--
-- Name: action_word_parameter_value fk_action_word_parameter_value_keyword_test_step_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_parameter_value
    ADD CONSTRAINT fk_action_word_parameter_value_keyword_test_step_id FOREIGN KEY (keyword_test_step_id) REFERENCES public.keyword_test_step(test_step_id);


--
-- Name: action_word fk_action_word_project; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word
    ADD CONSTRAINT fk_action_word_project FOREIGN KEY (project_id) REFERENCES public.project(project_id);


--
-- Name: action_word_text fk_action_word_text_action_word_fragment; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_text
    ADD CONSTRAINT fk_action_word_text_action_word_fragment FOREIGN KEY (action_word_fragment_id) REFERENCES public.action_word_fragment(action_word_fragment_id);


--
-- Name: ai_server fk_ai_server_third_party_server; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ai_server
    ADD CONSTRAINT fk_ai_server_third_party_server FOREIGN KEY (server_id) REFERENCES public.third_party_server(server_id) ON DELETE CASCADE;


--
-- Name: acl_responsibility_scope_entry fk_arse_party; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acl_responsibility_scope_entry
    ADD CONSTRAINT fk_arse_party FOREIGN KEY (party_id) REFERENCES public.core_party(party_id);


--
-- Name: attachment fk_attachment_att_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attachment
    ADD CONSTRAINT fk_attachment_att_list FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: attachment fk_attachment_content; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attachment
    ADD CONSTRAINT fk_attachment_content FOREIGN KEY (content_id) REFERENCES public.attachment_content(attachment_content_id);


--
-- Name: requirement_audit_event fk_audit_event_requirement_version; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_audit_event
    ADD CONSTRAINT fk_audit_event_requirement_version FOREIGN KEY (req_version_id) REFERENCES public.requirement_version(res_id);


--
-- Name: automated_execution_extender fk_auto_exec_auto_test; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_execution_extender
    ADD CONSTRAINT fk_auto_exec_auto_test FOREIGN KEY (test_id) REFERENCES public.automated_test(test_id);


--
-- Name: automated_execution_extender fk_auto_exec_exec; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_execution_extender
    ADD CONSTRAINT fk_auto_exec_exec FOREIGN KEY (master_execution_id) REFERENCES public.execution(execution_id);


--
-- Name: automated_execution_extender fk_automated_execution_extender_automated_suite; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_execution_extender
    ADD CONSTRAINT fk_automated_execution_extender_automated_suite FOREIGN KEY (suite_id) REFERENCES public.automated_suite(suite_id);


--
-- Name: automated_execution_failure_detail fk_automated_execution_failure_detail_execution_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_execution_failure_detail
    ADD CONSTRAINT fk_automated_execution_failure_detail_execution_id FOREIGN KEY (execution_extender_id) REFERENCES public.automated_execution_extender(extender_id);


--
-- Name: automated_execution_failure_detail fk_automated_execution_failure_detail_failure_detail_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_execution_failure_detail
    ADD CONSTRAINT fk_automated_execution_failure_detail_failure_detail_id FOREIGN KEY (failure_detail_id) REFERENCES public.failure_detail(failure_detail_id);


--
-- Name: automated_suite fk_automated_suite_attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_suite
    ADD CONSTRAINT fk_automated_suite_attachment_list FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: automated_suite fk_automated_suite_iteration; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_suite
    ADD CONSTRAINT fk_automated_suite_iteration FOREIGN KEY (iteration_id) REFERENCES public.iteration(iteration_id);


--
-- Name: automated_suite fk_automated_suite_test_suite; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_suite
    ADD CONSTRAINT fk_automated_suite_test_suite FOREIGN KEY (test_suite_id) REFERENCES public.test_suite(id);


--
-- Name: automated_suite_workflows fk_automated_suite_workflows_automated_suite; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_suite_workflows
    ADD CONSTRAINT fk_automated_suite_workflows_automated_suite FOREIGN KEY (suite_id) REFERENCES public.automated_suite(suite_id);


--
-- Name: automated_suite_workflows fk_automated_suite_workflows_project; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_suite_workflows
    ADD CONSTRAINT fk_automated_suite_workflows_project FOREIGN KEY (project_id) REFERENCES public.project(project_id);


--
-- Name: automated_test fk_automated_test_project; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automated_test
    ADD CONSTRAINT fk_automated_test_project FOREIGN KEY (project_id) REFERENCES public.test_automation_project(ta_project_id);


--
-- Name: automation_request fk_automation_request_automation_assigned_to; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request
    ADD CONSTRAINT fk_automation_request_automation_assigned_to FOREIGN KEY (assigned_to) REFERENCES public.core_user(party_id) ON DELETE SET NULL;


--
-- Name: automation_request fk_automation_request_created_by; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request
    ADD CONSTRAINT fk_automation_request_created_by FOREIGN KEY (created_by) REFERENCES public.core_user(party_id) ON DELETE SET NULL;


--
-- Name: automation_request_library_content fk_automation_request_lib_content_content; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request_library_content
    ADD CONSTRAINT fk_automation_request_lib_content_content FOREIGN KEY (content_id) REFERENCES public.automation_request(automation_request_id);


--
-- Name: automation_request fk_automation_request_project; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request
    ADD CONSTRAINT fk_automation_request_project FOREIGN KEY (project_id) REFERENCES public.project(project_id);


--
-- Name: automation_request fk_automation_request_transmitted_by; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request
    ADD CONSTRAINT fk_automation_request_transmitted_by FOREIGN KEY (transmitted_by) REFERENCES public.core_user(party_id) ON DELETE SET NULL;


--
-- Name: automation_request_library_content fk_automation_rquest_lib_content_lib; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request_library_content
    ADD CONSTRAINT fk_automation_rquest_lib_content_lib FOREIGN KEY (library_id) REFERENCES public.automation_request_library(arl_id);


--
-- Name: automation_request_library fk_autorequestLib_attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.automation_request_library
    ADD CONSTRAINT "fk_autorequestLib_attachment_list" FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: action_word_library fk_awLib_attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_library
    ADD CONSTRAINT "fk_awLib_attachment_list" FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: action_word_library_node fk_awln_awl; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_word_library_node
    ADD CONSTRAINT fk_awln_awl FOREIGN KEY (awl_id) REFERENCES public.action_word_library(awl_id);


--
-- Name: awln_relationship fk_awln_relationship_ancestor; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.awln_relationship
    ADD CONSTRAINT fk_awln_relationship_ancestor FOREIGN KEY (ancestor_id) REFERENCES public.action_word_library_node(awln_id);


--
-- Name: awln_relationship_closure fk_awln_relationship_clos_anc; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.awln_relationship_closure
    ADD CONSTRAINT fk_awln_relationship_clos_anc FOREIGN KEY (ancestor_id) REFERENCES public.action_word_library_node(awln_id);


--
-- Name: awln_relationship_closure fk_awln_relationship_clos_desc; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.awln_relationship_closure
    ADD CONSTRAINT fk_awln_relationship_clos_desc FOREIGN KEY (descendant_id) REFERENCES public.action_word_library_node(awln_id);


--
-- Name: awln_relationship fk_awln_relationship_descendant; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.awln_relationship
    ADD CONSTRAINT fk_awln_relationship_descendant FOREIGN KEY (descendant_id) REFERENCES public.action_word_library_node(awln_id);


--
-- Name: chart_axis_column fk_axis_column_chart_column; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_axis_column
    ADD CONSTRAINT fk_axis_column_chart_column FOREIGN KEY (chart_column_id) REFERENCES public.query_column_prototype(query_column_id);


--
-- Name: bugtracker_project fk_bugtracker_project_project_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bugtracker_project
    ADD CONSTRAINT fk_bugtracker_project_project_id FOREIGN KEY (project_id) REFERENCES public.project(project_id);


--
-- Name: bugtracker fk_bugtracker_third_party_server; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bugtracker
    ADD CONSTRAINT fk_bugtracker_third_party_server FOREIGN KEY (bugtracker_id) REFERENCES public.third_party_server(server_id) ON DELETE CASCADE;


--
-- Name: call_test_step fk_call_step_called_test_case; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.call_test_step
    ADD CONSTRAINT fk_call_step_called_test_case FOREIGN KEY (called_test_case_id) REFERENCES public.test_case(tcln_id);


--
-- Name: call_test_step fk_call_step_dataset; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.call_test_step
    ADD CONSTRAINT fk_call_step_dataset FOREIGN KEY (called_dataset) REFERENCES public.dataset(dataset_id) ON DELETE SET NULL;


--
-- Name: call_test_step fk_call_step_test_step; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.call_test_step
    ADD CONSTRAINT fk_call_step_test_step FOREIGN KEY (test_step_id) REFERENCES public.test_step(test_step_id);


--
-- Name: campaign_library fk_campLib_attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_library
    ADD CONSTRAINT "fk_campLib_attachment_list" FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: campaign_library_node fk_campNode_attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_library_node
    ADD CONSTRAINT "fk_campNode_attachment_list" FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: campaign_iteration fk_camp_iter_campaign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_iteration
    ADD CONSTRAINT fk_camp_iter_campaign FOREIGN KEY (campaign_id) REFERENCES public.campaign(cln_id);


--
-- Name: campaign_iteration fk_camp_iter_iteration; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_iteration
    ADD CONSTRAINT fk_camp_iter_iteration FOREIGN KEY (iteration_id) REFERENCES public.iteration(iteration_id);


--
-- Name: campaign_test_plan_item fk_camp_test_plan_item_dataset; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_test_plan_item
    ADD CONSTRAINT fk_camp_test_plan_item_dataset FOREIGN KEY (dataset_id) REFERENCES public.dataset(dataset_id);


--
-- Name: campaign_test_plan_item fk_camp_tp_campaign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_test_plan_item
    ADD CONSTRAINT fk_camp_tp_campaign FOREIGN KEY (campaign_id) REFERENCES public.campaign(cln_id);


--
-- Name: campaign_test_plan_item fk_camp_tp_testcase; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_test_plan_item
    ADD CONSTRAINT fk_camp_tp_testcase FOREIGN KEY (test_case_id) REFERENCES public.test_case(tcln_id);


--
-- Name: campaign_test_plan_item fk_camp_tp_user; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_test_plan_item
    ADD CONSTRAINT fk_camp_tp_user FOREIGN KEY (user_id) REFERENCES public.core_user(party_id);


--
-- Name: campaign fk_campaign_cl_node; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign
    ADD CONSTRAINT fk_campaign_cl_node FOREIGN KEY (cln_id) REFERENCES public.campaign_library_node(cln_id);


--
-- Name: campaign_folder fk_campaign_folder_cl_node; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_folder
    ADD CONSTRAINT fk_campaign_folder_cl_node FOREIGN KEY (cln_id) REFERENCES public.campaign_library_node(cln_id);


--
-- Name: custom_field_option fk_cf_option_cf; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_option
    ADD CONSTRAINT fk_cf_option_cf FOREIGN KEY (cf_id) REFERENCES public.custom_field(cf_id);


--
-- Name: custom_field_binding fk_cfb_bound_project; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_binding
    ADD CONSTRAINT fk_cfb_bound_project FOREIGN KEY (bound_project_id) REFERENCES public.project(project_id);


--
-- Name: custom_field_binding fk_cfb_cf; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_binding
    ADD CONSTRAINT fk_cfb_cf FOREIGN KEY (cf_id) REFERENCES public.custom_field(cf_id);


--
-- Name: custom_field_rendering_location fk_cfb_render_loc_cfb; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_rendering_location
    ADD CONSTRAINT fk_cfb_render_loc_cfb FOREIGN KEY (cfb_id) REFERENCES public.custom_field_binding(cfb_id) ON DELETE CASCADE;


--
-- Name: custom_field_value fk_cfv_cf_binding; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_value
    ADD CONSTRAINT fk_cfv_cf_binding FOREIGN KEY (cfb_id) REFERENCES public.custom_field_binding(cfb_id);


--
-- Name: custom_field_value_option fk_cfv_option_cfv; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_field_value_option
    ADD CONSTRAINT fk_cfv_option_cfv FOREIGN KEY (cfv_id) REFERENCES public.custom_field_value(cfv_id) ON DELETE CASCADE;


--
-- Name: chart_axis_column fk_chart_axis_chart_def; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_axis_column
    ADD CONSTRAINT fk_chart_axis_chart_def FOREIGN KEY (chart_definition_id) REFERENCES public.chart_definition(chart_id);


--
-- Name: custom_report_chart_binding fk_chart_bindind_chart_definition_chart_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_chart_binding
    ADD CONSTRAINT fk_chart_bindind_chart_definition_chart_id FOREIGN KEY (chart_id) REFERENCES public.chart_definition(chart_id);


--
-- Name: custom_report_chart_binding fk_chart_bindind_custom_report_dashboard_crd_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_chart_binding
    ADD CONSTRAINT fk_chart_bindind_custom_report_dashboard_crd_id FOREIGN KEY (crd_id) REFERENCES public.custom_report_dashboard(crd_id);


--
-- Name: custom_report_report_binding fk_chart_bindind_report_definition_report_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_report_binding
    ADD CONSTRAINT fk_chart_bindind_report_definition_report_id FOREIGN KEY (report_id) REFERENCES public.report_definition(report_id);


--
-- Name: chart_filter fk_chart_filter_chart_column; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_filter
    ADD CONSTRAINT fk_chart_filter_chart_column FOREIGN KEY (chart_column_id) REFERENCES public.query_column_prototype(query_column_id);


--
-- Name: chart_filter fk_chart_filter_chart_def; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_filter
    ADD CONSTRAINT fk_chart_filter_chart_def FOREIGN KEY (chart_definition_id) REFERENCES public.chart_definition(chart_id);


--
-- Name: chart_filter_values fk_chart_filter_value_chart_column; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_filter_values
    ADD CONSTRAINT fk_chart_filter_value_chart_column FOREIGN KEY (filter_id) REFERENCES public.chart_filter(filter_id);


--
-- Name: chart_measure_column fk_chart_meas_chart_def; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_measure_column
    ADD CONSTRAINT fk_chart_meas_chart_def FOREIGN KEY (chart_definition_id) REFERENCES public.chart_definition(chart_id);


--
-- Name: chart_measure_column fk_chart_measure_chart_column; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_measure_column
    ADD CONSTRAINT fk_chart_measure_chart_column FOREIGN KEY (chart_column_id) REFERENCES public.query_column_prototype(query_column_id);


--
-- Name: chart_project_scope fk_chart_project_scope_chart_definition; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_project_scope
    ADD CONSTRAINT fk_chart_project_scope_chart_definition FOREIGN KEY (chart_id) REFERENCES public.chart_definition(chart_id);


--
-- Name: chart_scope fk_chart_scope_chart_definition; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_scope
    ADD CONSTRAINT fk_chart_scope_chart_definition FOREIGN KEY (chart_id) REFERENCES public.chart_definition(chart_id);


--
-- Name: campaign_library_content fk_cl_content_content; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_library_content
    ADD CONSTRAINT fk_cl_content_content FOREIGN KEY (content_id) REFERENCES public.campaign_library_node(cln_id);


--
-- Name: campaign_library_content fk_cl_content_lib; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_library_content
    ADD CONSTRAINT fk_cl_content_lib FOREIGN KEY (library_id) REFERENCES public.campaign_library(cl_id);


--
-- Name: campaign_library_node fk_cln_project; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaign_library_node
    ADD CONSTRAINT fk_cln_project FOREIGN KEY (project_id) REFERENCES public.project(project_id);


--
-- Name: cln_relationship fk_cln_relationship_ancestor; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cln_relationship
    ADD CONSTRAINT fk_cln_relationship_ancestor FOREIGN KEY (ancestor_id) REFERENCES public.campaign_library_node(cln_id);


--
-- Name: cln_relationship_closure fk_cln_relationship_clos_anc; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cln_relationship_closure
    ADD CONSTRAINT fk_cln_relationship_clos_anc FOREIGN KEY (ancestor_id) REFERENCES public.campaign_library_node(cln_id);


--
-- Name: cln_relationship_closure fk_cln_relationship_clos_desc; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cln_relationship_closure
    ADD CONSTRAINT fk_cln_relationship_clos_desc FOREIGN KEY (descendant_id) REFERENCES public.campaign_library_node(cln_id);


--
-- Name: chart_column_role fk_column_role_chart_column; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chart_column_role
    ADD CONSTRAINT fk_column_role_chart_column FOREIGN KEY (chart_column_id) REFERENCES public.query_column_prototype(query_column_id);


--
-- Name: core_user fk_core_user_party; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_user
    ADD CONSTRAINT fk_core_user_party FOREIGN KEY (party_id) REFERENCES public.core_party(party_id);


--
-- Name: requirement_creation fk_create_audit; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_creation
    ADD CONSTRAINT fk_create_audit FOREIGN KEY (event_id) REFERENCES public.requirement_audit_event(event_id);


--
-- Name: custom_report_library fk_crl_attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_library
    ADD CONSTRAINT fk_crl_attachment_list FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: custom_report_library_node fk_crln_custom_report_library_crl_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_library_node
    ADD CONSTRAINT fk_crln_custom_report_library_crl_id FOREIGN KEY (crl_id) REFERENCES public.custom_report_library(crl_id);


--
-- Name: crln_relationship fk_crln_relationship_ancestor; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.crln_relationship
    ADD CONSTRAINT fk_crln_relationship_ancestor FOREIGN KEY (ancestor_id) REFERENCES public.custom_report_library_node(crln_id);


--
-- Name: crln_relationship_closure fk_crln_relationship_clos_anc; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.crln_relationship_closure
    ADD CONSTRAINT fk_crln_relationship_clos_anc FOREIGN KEY (ancestor_id) REFERENCES public.custom_report_library_node(crln_id);


--
-- Name: crln_relationship_closure fk_crln_relationship_clos_desc; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.crln_relationship_closure
    ADD CONSTRAINT fk_crln_relationship_clos_desc FOREIGN KEY (descendant_id) REFERENCES public.custom_report_library_node(crln_id);


--
-- Name: crln_relationship fk_crln_relationship_descendant; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.crln_relationship
    ADD CONSTRAINT fk_crln_relationship_descendant FOREIGN KEY (descendant_id) REFERENCES public.custom_report_library_node(crln_id);


--
-- Name: custom_export_column fk_custom_export_column_custom_export_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_export_column
    ADD CONSTRAINT fk_custom_export_column_custom_export_id FOREIGN KEY (custom_export_id) REFERENCES public.custom_report_custom_export(crce_id);


--
-- Name: custom_report_custom_export fk_custom_export_project_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_report_custom_export
    ADD CONSTRAINT fk_custom_export_project_id FOREIGN KEY (project_id) REFERENCES public.project(project_id);


--
-- Name: custom_export_scope fk_custom_export_scope_custom_export_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_export_scope
    ADD CONSTRAINT fk_custom_export_scope_custom_export_id FOREIGN KEY (custom_export_id) REFERENCES public.custom_report_custom_export(crce_id);


--
-- Name: dataset_param_value fk_dataset_param_value_dataset; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dataset_param_value
    ADD CONSTRAINT fk_dataset_param_value_dataset FOREIGN KEY (dataset_id) REFERENCES public.dataset(dataset_id);


--
-- Name: dataset_param_value fk_dataset_param_value_param; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dataset_param_value
    ADD CONSTRAINT fk_dataset_param_value_param FOREIGN KEY (param_id) REFERENCES public.parameter(param_id);


--
-- Name: dataset fk_dataset_test_case; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dataset
    ADD CONSTRAINT fk_dataset_test_case FOREIGN KEY (test_case_id) REFERENCES public.test_case(tcln_id);


--
-- Name: denormalized_environment_variable fk_dev_environment_variable; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_environment_variable
    ADD CONSTRAINT fk_dev_environment_variable FOREIGN KEY (ev_id) REFERENCES public.environment_variable(ev_id);


--
-- Name: denormalized_field_rendering_location fk_dfb_render_loc_dfb; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_field_rendering_location
    ADD CONSTRAINT fk_dfb_render_loc_dfb FOREIGN KEY (dfv_id) REFERENCES public.denormalized_field_value(dfv_id) ON DELETE CASCADE;


--
-- Name: denormalized_field_value fk_dfv_cfv_binding; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_field_value
    ADD CONSTRAINT fk_dfv_cfv_binding FOREIGN KEY (cfv_id) REFERENCES public.custom_field_value(cfv_id) ON DELETE SET NULL;


--
-- Name: denormalized_field_value_option fk_dfv_option_dfv; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.denormalized_field_value_option
    ADD CONSTRAINT fk_dfv_option_dfv FOREIGN KEY (dfv_id) REFERENCES public.denormalized_field_value(dfv_id) ON DELETE CASCADE;


--
-- Name: disabled_execution_status fk_disabled_exec_status_cl_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.disabled_execution_status
    ADD CONSTRAINT fk_disabled_exec_status_cl_id FOREIGN KEY (cl_id) REFERENCES public.campaign_library(cl_id);


--
-- Name: environment_variable_binding fk_ev_binding_ev; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.environment_variable_binding
    ADD CONSTRAINT fk_ev_binding_ev FOREIGN KEY (ev_id) REFERENCES public.environment_variable(ev_id);


--
-- Name: environment_variable_option fk_ev_option_ev; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.environment_variable_option
    ADD CONSTRAINT fk_ev_option_ev FOREIGN KEY (ev_id) REFERENCES public.environment_variable(ev_id);


--
-- Name: execution_execution_steps fk_exec_exec_step_exec; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution_execution_steps
    ADD CONSTRAINT fk_exec_exec_step_exec FOREIGN KEY (execution_id) REFERENCES public.execution(execution_id);


--
-- Name: execution_execution_steps fk_exec_exec_step_exec_step; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution_execution_steps
    ADD CONSTRAINT fk_exec_exec_step_exec_step FOREIGN KEY (execution_step_id) REFERENCES public.execution_step(execution_step_id);


--
-- Name: execution fk_execution_attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution
    ADD CONSTRAINT fk_execution_attachment_list FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: execution fk_execution_issue_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution
    ADD CONSTRAINT fk_execution_issue_list FOREIGN KEY (issue_list_id) REFERENCES public.issue_list(issue_list_id);


--
-- Name: execution_step fk_execution_step__attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution_step
    ADD CONSTRAINT fk_execution_step__attachment_list FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: execution_step fk_execution_step_issue_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution_step
    ADD CONSTRAINT fk_execution_step_issue_list FOREIGN KEY (issue_list_id) REFERENCES public.issue_list(issue_list_id);


--
-- Name: execution fk_execution_test_case; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution
    ADD CONSTRAINT fk_execution_test_case FOREIGN KEY (tcln_id) REFERENCES public.test_case(tcln_id);


--
-- Name: execution fk_execution_test_plan_item; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution
    ADD CONSTRAINT fk_execution_test_plan_item FOREIGN KEY (test_plan_item_id) REFERENCES public.test_plan_item(test_plan_item_id);


--
-- Name: execution_step fk_executionstep_teststep; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execution_step
    ADD CONSTRAINT fk_executionstep_teststep FOREIGN KEY (test_step_id) REFERENCES public.test_step(test_step_id);


--
-- Name: exploratory_execution fk_exploratory_execution_core_user; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_execution
    ADD CONSTRAINT fk_exploratory_execution_core_user FOREIGN KEY (assignee_id) REFERENCES public.core_user(party_id);


--
-- Name: exploratory_execution_event fk_exploratory_execution_event_execution; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_execution_event
    ADD CONSTRAINT fk_exploratory_execution_event_execution FOREIGN KEY (execution_id) REFERENCES public.execution(execution_id);


--
-- Name: exploratory_execution fk_exploratory_execution_execution; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_execution
    ADD CONSTRAINT fk_exploratory_execution_execution FOREIGN KEY (execution_id) REFERENCES public.execution(execution_id);


--
-- Name: exploratory_session_overview fk_exploratory_session_overview_attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_session_overview
    ADD CONSTRAINT fk_exploratory_session_overview_attachment_list FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: exploratory_test_case fk_exploratory_test_case; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exploratory_test_case
    ADD CONSTRAINT fk_exploratory_test_case FOREIGN KEY (tcln_id) REFERENCES public.test_case(tcln_id);


--
-- Name: failure_detail fk_failure_detail_issue_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.failure_detail
    ADD CONSTRAINT fk_failure_detail_issue_list FOREIGN KEY (issue_list_id) REFERENCES public.issue_list(issue_list_id);


--
-- Name: failure_detail fk_failure_detail_test_plan_item; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.failure_detail
    ADD CONSTRAINT fk_failure_detail_test_plan_item FOREIGN KEY (test_plan_item_id) REFERENCES public.test_plan_item(test_plan_item_id);


--
-- Name: requirement_folder fk_folder_requirement_node; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_folder
    ADD CONSTRAINT fk_folder_requirement_node FOREIGN KEY (rln_id) REFERENCES public.requirement_library_node(rln_id);


--
-- Name: test_case_folder fk_folder_test_case_node; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_case_folder
    ADD CONSTRAINT fk_folder_test_case_node FOREIGN KEY (tcln_id) REFERENCES public.test_case_library_node(tcln_id);


--
-- Name: grid_column_display_configuration fk_grid_col_display_config_grid_col_display_ref; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.grid_column_display_configuration
    ADD CONSTRAINT fk_grid_col_display_config_grid_col_display_ref FOREIGN KEY (gcdr_id) REFERENCES public.grid_column_display_reference(gcdr_id);


--
-- Name: grid_column_display_reference fk_grid_column_display_reference_core_user; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.grid_column_display_reference
    ADD CONSTRAINT fk_grid_column_display_reference_core_user FOREIGN KEY (party_id) REFERENCES public.core_user(party_id);


--
-- Name: grid_column_display_reference fk_grid_column_display_reference_project; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.grid_column_display_reference
    ADD CONSTRAINT fk_grid_column_display_reference_project FOREIGN KEY (project_id) REFERENCES public.project(project_id);


--
-- Name: core_group_member fk_group_member_party; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_group_member
    ADD CONSTRAINT fk_group_member_party FOREIGN KEY (party_id) REFERENCES public.core_party(party_id);


--
-- Name: core_group_authority fk_grp_auth_grp; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_group_authority
    ADD CONSTRAINT fk_grp_auth_grp FOREIGN KEY (group_id) REFERENCES public.core_group(id);


--
-- Name: core_group_member fk_grp_member_grp; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.core_group_member
    ADD CONSTRAINT fk_grp_member_grp FOREIGN KEY (group_id) REFERENCES public.core_group(id);


--
-- Name: high_level_requirement fk_high_lvl_requirement_requirement; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.high_level_requirement
    ADD CONSTRAINT fk_high_lvl_requirement_requirement FOREIGN KEY (rln_id) REFERENCES public.requirement(rln_id);


--
-- Name: info_list_item fk_info_item_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.info_list_item
    ADD CONSTRAINT fk_info_item_list FOREIGN KEY (list_id) REFERENCES public.info_list(info_list_id);


--
-- Name: issue fk_issue_bugtracker; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.issue
    ADD CONSTRAINT fk_issue_bugtracker FOREIGN KEY (bugtracker_id) REFERENCES public.bugtracker(bugtracker_id);


--
-- Name: issue fk_issue_issue_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.issue
    ADD CONSTRAINT fk_issue_issue_list FOREIGN KEY (issue_list_id) REFERENCES public.issue_list(issue_list_id);


--
-- Name: iteration fk_iteration__attachment_list; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.iteration
    ADD CONSTRAINT fk_iteration__attachment_list FOREIGN KEY (attachment_list_id) REFERENCES public.attachment_list(attachment_list_id);


--
-- Name: iteration fk_iteration_test_plan; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.iteration
    ADD CONSTRAINT fk_iteration_test_plan FOREIGN KEY (test_plan_id) REFERENCES public.test_plan(test_plan_id);


--
-- Name: iteration_test_suite fk_iteration_test_suite_iteration; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.iteration_test_suite
    ADD CONSTRAINT fk_iteration_test_suite_iteration FOREIGN KEY (iteration_id) REFERENCES public.iteration(iteration_id);


--
-- Name: iteration_test_suite fk_iteration_test_suite_suite; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.iteration_test_suite
    ADD CONSTRAINT fk_iteration_test_suite_suite FOREIGN KEY (test_suite_id) REFERENCES public.test_suite(id);


--
-- Name: keyword_execution fk_keyword_exec_exec; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.keyword_execution
    ADD CONSTRAINT fk_keyword_exec_exec FOREIGN KEY (execution_id) REFERENCES public.execution(execution_id);


--
-- Name: keyword_test_case fk_keyword_tc_tc; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.keyword_test_case
    ADD CONSTRAINT fk_keyword_tc_tc FOREIGN KEY (tcln_id) REFERENCES public.test_case(tcln_id);


--
-- Name: keyword_test_step fk_keyword_test_step_action_word_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.keyword_test_step
    ADD CONSTRAINT fk_keyword_test_step_action_word_id FOREIGN KEY (action_word_id) REFERENCES public.action_word(action_word_id);


--
-- Name: keyword_test_step fk_keyword_test_step_test_step; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.keyword_test_step
    ADD CONSTRAINT fk_keyword_test_step_test_step FOREIGN KEY (test_step_id) REFERENCES public.test_step(test_step_id);


--
-- Name: requirement_large_property_change fk_lPPT_change_audit; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.requirement_large_property_change
    ADD CONSTRAINT "fk_lPPT_change_audit" FOREIGN KEY (event_id) REFERENCES public.requirement_audit_event(event_id);


--
-- Name: library_plugin_binding_property fk_libplugin_property_libplugin; Type: FK CONSTRAINT; Sch