/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.postgresql.ds.PGSimpleDataSource;
import org.squashtest.it.datasetbuilder.DatabaseType;
import org.squashtest.it.datasetbuilder.DatasetBuilder;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.DatasetLoader;
import org.squashtest.it.datasetbuilder.api.model.SquashModel;
import org.squashtest.it.datasetbuilder.mappers.SquashMapper;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(Client.class);
    private static final String DUMP_FILE_NAME = "backup.sql";

    public static void main(String[] args) {
        try {
            Client.run(args);
        }
        catch (Exception e) {
            LOGGER.error("Error running the client: {}", new Object[]{e.getMessage(), e});
        }
    }

    private static void run(String[] args) throws ParseException, IOException, SQLException {
        ClientOptions options = Client.parseOptions(args);
        PGSimpleDataSource ds = Client.getDataSource(options);
        if (!options.clean && options.pathToDataset == null) {
            throw new IllegalArgumentException("Neither --clean nor --file option provided. Nothing to do.");
        }
        if (options.clean) {
            Client.cleanDatabase((DataSource)ds);
        }
        if (options.pathToDataset != null) {
            String[] datasetsXml = Client.getDatasetsXml(options.pathToDataset);
            Client.loadDataset((DataSource)ds, datasetsXml);
        }
    }

    private static ClientOptions parseOptions(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(Client.getOptions(), args);
        String pathToDataset = cmd.getOptionValue("file");
        String dbUrl = cmd.getOptionValue("url");
        String dbUser = cmd.getOptionValue("user");
        String dbPassword = cmd.getOptionValue("password");
        boolean clean = cmd.hasOption("clean");
        return new ClientOptions(pathToDataset, dbUser, dbPassword, dbUrl, clean);
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("f", "file", true, "Path to dataset file");
        options.addOption("u", "url", true, "Database URL");
        options.addOption("U", "user", true, "Database user");
        options.addOption("p", "password", true, "Database password");
        options.addOption("c", "clean", false, "Clean database before loading");
        return options;
    }

    private static String[] getDatasetsXml(String pathToDataset) throws IOException {
        File datasetFile = new File(pathToDataset);
        if (!datasetFile.exists()) {
            throw new IOException("Dataset file not found: " + pathToDataset);
        }
        String rawDataset = new String(Files.readAllBytes(datasetFile.toPath()));
        LOGGER.debug("Dataset:\n{}", new Object[]{rawDataset});
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        SquashModel model = (SquashModel)yamlMapper.readValue(rawDataset, SquashModel.class);
        DatasetData datasetData = SquashMapper.toDatasetData((SquashModel)model);
        return DatasetBuilder.build((DatasetData)datasetData);
    }

    private static PGSimpleDataSource getDataSource(ClientOptions options) {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setURL(options.url);
        ds.setUser(options.user);
        ds.setPassword(options.password);
        return ds;
    }

    private static void loadDataset(DataSource ds, String[] datasetsXml) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection dbConnection = ds.getConnection();){
            dbConnection.setAutoCommit(false);
            DatasetLoader.loadDataset((Connection)dbConnection, (String[])datasetsXml, (DatabaseType)DatabaseType.POSTGRESQL);
            dbConnection.commit();
            LOGGER.info("Dataset loaded successfully", new Object[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void cleanDatabase(DataSource ds) throws SQLException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection dbConnection = ds.getConnection();){
            dbConnection.setAutoCommit(false);
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (Connection conn = ds.getConnection();){
                Throwable throwable3 = null;
                Object var8_13 = null;
                try (Statement stmt = conn.createStatement();){
                    stmt.execute("DROP SCHEMA public CASCADE; CREATE SCHEMA public;");
                    stmt.execute(Client.getDumpContent());
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            dbConnection.commit();
            LOGGER.info("Database cleaned successfully", new Object[0]);
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private static String getDumpContent() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (InputStream inputStream = Client.class.getClassLoader().getResourceAsStream(DUMP_FILE_NAME);){
            if (inputStream == null) {
                throw new IOException("Dump file not found: backup.sql");
            }
            return new String(inputStream.readAllBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private record ClientOptions(String pathToDataset, String user, String password, String url, boolean clean) {
        public ClientOptions {
            if (user == null || user.isBlank()) {
                throw new IllegalArgumentException("Database user cannot be null or empty");
            }
            if (password == null || password.isBlank()) {
                throw new IllegalArgumentException("Database password cannot be null or empty");
            }
            if (url == null || url.isBlank()) {
                throw new IllegalArgumentException("Database URL cannot be null or empty");
            }
        }
    }
}

