/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.shell;

import java.io.File;
import org.opentestfactory.utils.shell.Platform;

public class WindowsPlatform
extends Platform {
    @Override
    public String getPlatformStatementSeparator() {
        return " && ";
    }

    @Override
    protected String changeIntoInSHellCommand(String localCommand) {
        String escapedInnerCommand = localCommand.replace("\"", "^\"");
        return "cmd /C \"" + escapedInnerCommand + "\"";
    }

    @Override
    protected String prepareStatement(String query) {
        if (query.trim().startsWith("REM ")) {
            return "";
        }
        return query.trim();
    }

    @Override
    protected boolean needsShellOnPlatform(String command) {
        String executable;
        String trimmedCommand = command.trim();
        if (trimmedCommand.trim().startsWith("\"")) {
            int closingDoubleQuote = trimmedCommand.indexOf(34, 1);
            while (closingDoubleQuote > 0 && trimmedCommand.charAt(closingDoubleQuote - 1) == '\\') {
                closingDoubleQuote = trimmedCommand.indexOf(34, closingDoubleQuote + 1);
            }
            executable = closingDoubleQuote > 0 ? trimmedCommand.substring(1, closingDoubleQuote) : trimmedCommand;
        } else {
            int firstSpace = trimmedCommand.indexOf(" ");
            executable = firstSpace > 0 ? trimmedCommand.substring(0, firstSpace) : trimmedCommand;
        }
        return !new File(executable).exists();
    }
}

