/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.shell;

import java.util.Iterator;
import org.apache.commons.lang3.SystemUtils;
import org.opentestfactory.utils.shell.PosixPlatform;
import org.opentestfactory.utils.shell.WindowsPlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Platform {
    private static final Logger LOGGER = LoggerFactory.getLogger(Platform.class);
    @Deprecated
    static Platform INSTANCE = SystemUtils.IS_OS_WINDOWS ? new WindowsPlatform() : new PosixPlatform();

    public static final Platform getLocalPlatform() {
        return INSTANCE;
    }

    public abstract String getPlatformStatementSeparator();

    public String addShellSpawnCommandIfNeeded(String localCommand) {
        if (this.isMultistatement(localCommand) | this.needsShellOnPlatform(localCommand)) {
            return this.changeIntoInSHellCommand(localCommand);
        }
        return localCommand;
    }

    protected boolean isMultistatement(String localCommand) {
        return localCommand.indexOf(this.getPlatformStatementSeparator()) > 0;
    }

    protected abstract boolean needsShellOnPlatform(String var1);

    protected abstract String prepareStatement(String var1);

    public void addStatementFromLine(Iterator<String> lineIterator, StringBuffer command) {
        String line = lineIterator.next();
        String preparedStatement = this.prepareStatement(line);
        if (!preparedStatement.isEmpty()) {
            LOGGER.debug("Command file line: {}", (Object)line);
            command.append(preparedStatement);
        }
    }

    protected abstract String changeIntoInSHellCommand(String var1);
}

