/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.opentestfactory.utils.AmnesicStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamMuncher
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamMuncher.class);
    private String streamName = "anonymous";
    private AmnesicStringBuffer buffer;
    private BufferedReader reader;
    private boolean shouldRun = true;

    public StreamMuncher(String streamName, InputStream stream, int bufferSize) {
        this.streamName = streamName;
        this.buffer = new AmnesicStringBuffer(bufferSize);
        this.reader = new BufferedReader(new InputStreamReader(stream));
    }

    public void requestStop() {
        this.shouldRun = false;
    }

    public void start() {
        Thread errMonitor = new Thread((Runnable)this, this.streamName + " tail.");
        errMonitor.setDaemon(true);
        errMonitor.start();
    }

    @Override
    public void run() {
        try {
            while (this.shouldRun) {
                String buf = this.reader.readLine();
                if (buf == null) continue;
                this.buffer.append(buf).append("\n");
            }
            if (this.reader.ready() && this.reader.read() >= 0) {
                this.buffer.append("<<stream truncated here!>>");
            }
            this.reader.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to access {} contents.", (Object)this.streamName, (Object)ex);
            try {
                this.buffer.append(this.streamName + " : could not access contents.");
            }
            catch (IOException e) {
                LOGGER.warn("Swallowing IOException, since we know our buffer is RAM based. If you see this message there is definitely something rotten in the realm of Denmark !", (Throwable)e);
            }
        }
    }

    public String getStreamContent() {
        return this.buffer.toString();
    }
}

