/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import org.opentestfactory.utils.shell.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessStreamListener
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessStreamListener.class);
    private InputStream stream;
    private WeakReference<Process> processRef;

    public ProcessStreamListener(Process process, OutputStream targetStream) {
        this.processRef = new WeakReference<Process>(process);
        switch (targetStream) {
            case out: {
                this.stream = process.getInputStream();
                break;
            }
            case err: {
                this.stream = process.getErrorStream();
                break;
            }
            default: {
                throw new IllegalArgumentException(targetStream.name() + " is no known stream!");
            }
        }
    }

    public void start() {
        Process process = (Process)this.processRef.get();
        if (process == null) {
            LOGGER.warn("No more process to monitor, nothing will start.");
        } else {
            Thread pollingThread = new Thread((Runnable)this, "stdoutPoller-" + process.toString());
            pollingThread.setDaemon(true);
            pollingThread.start();
        }
    }

    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int nb = this.stream.read(buffer);
            while (this.processAlive()) {
                this.getStdoutContentIfAvailable(buffer, os, nb);
                if (!this.processAlive()) continue;
                nb = this.stream.read(buffer);
            }
            LOGGER.debug("Process is dead");
        }
        catch (IOException e) {
            LOGGER.error("stdout reading failed.", (Throwable)e);
        }
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("stdout closing failed", (Throwable)e);
        }
    }

    private void getStdoutContentIfAvailable(byte[] buffer, ByteArrayOutputStream os, int nb) throws IOException {
        try {
            while (nb >= 0) {
                os.write(buffer, 0, nb);
                String osString = os.toString();
                int indexNewline = osString.indexOf(10);
                if (indexNewline > 0) {
                    while (indexNewline >= 0) {
                        this.commitOutputLine(osString.substring(0, indexNewline));
                        osString = osString.substring(indexNewline + 1);
                        indexNewline = osString.indexOf(10);
                    }
                    os.reset();
                    os.write(osString.getBytes());
                }
                if (!this.processAlive()) continue;
                nb = this.stream.read(buffer);
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("stdout reading failed.", (Throwable)ioe);
        }
    }

    protected abstract void commitOutputLine(String var1);

    private boolean processAlive() {
        Process process = (Process)this.processRef.get();
        boolean alive = false;
        if (process != null) {
            try {
                process.exitValue();
                alive = false;
            }
            catch (IllegalThreadStateException e) {
                LOGGER.debug("Process is still alive.", (Throwable)e);
                alive = true;
            }
        }
        return alive;
    }
}

