/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.process;

import org.opentestfactory.utils.process.ProcessStreamListener;
import org.opentestfactory.utils.shell.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessLogger
extends ProcessStreamListener
implements Runnable {
    private final Logger logger;
    private static int counter;

    public ProcessLogger(String processClass, Process process) {
        super(process, OutputStream.out);
        this.logger = LoggerFactory.getLogger((String)("stdout." + processClass + "." + counter++));
        if (this.logger.isDebugEnabled()) {
            this.logger.info("stdout logger daemon started");
        } else if (this.logger.isInfoEnabled()) {
            String name = this.logger.getName();
            this.logger.info("stdout logger daemon started (switch the '" + name.substring(0, name.lastIndexOf(46)) + "' logger category to level DEBUG to see more)");
        }
    }

    public ProcessLogger(String processClass, Process process, OutputStream targetStream) {
        super(process, targetStream);
        this.logger = LoggerFactory.getLogger((String)("std" + targetStream.name() + "." + processClass + "." + counter++));
        if (this.logger.isDebugEnabled()) {
            this.logger.info("std" + targetStream.name() + " logger daemon started");
        } else if (this.logger.isInfoEnabled()) {
            String name = this.logger.getName();
            this.logger.info("stdout logger daemon started (switch the '" + name.substring(0, name.lastIndexOf(46)) + "' logger category to level DEBUG to see more)");
        }
    }

    @Override
    protected void commitOutputLine(String osString) {
        this.logger.debug(osString);
    }
}

