/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.process;

import org.opentestfactory.utils.process.ProcessKiller;
import org.opentestfactory.utils.process.StreamMuncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHandle {
    private static final int DEFAULT_STDERR_LENGTH = 200;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessHandle.class);
    private String processName;
    private Process process;
    private Thread shutdownHook;
    private StreamMuncher errorStreamMonitor;
    private StreamMuncher stdoutStreamMonitor;

    public ProcessHandle(Process process) {
        this("Anonymous", process, false, false, 200);
    }

    public ProcessHandle(String processName, Process process, boolean registerShutdownHook, boolean monitorErrorStream) {
        this(processName, process, registerShutdownHook, monitorErrorStream, 200);
    }

    public ProcessHandle(String processName, Process process, boolean registerShutdownHook, boolean monitorErrorStream, int maxLength) {
        this(processName, process, registerShutdownHook, false, monitorErrorStream, maxLength);
    }

    public ProcessHandle(String processName, Process process, boolean registerShutdownHook, boolean monitorStdoutStream, boolean monitorErrorStream, int maxLength) {
        this.process = process;
        this.processName = processName;
        if (registerShutdownHook) {
            this.shutdownHook = new Thread(new ProcessKiller(process));
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        if (monitorErrorStream) {
            this.errorStreamMonitor = new StreamMuncher(processName + "error stream", process.getErrorStream(), maxLength);
            new Thread(this.errorStreamMonitor).start();
        }
        if (monitorStdoutStream) {
            this.stdoutStreamMonitor = new StreamMuncher(processName + "stdout stream", process.getInputStream(), maxLength);
            new Thread(this.stdoutStreamMonitor).start();
        }
    }

    public void killProcess() {
        if (this.shutdownHook != null) {
            LOGGER.debug("removing killing shutdown hook");
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            LOGGER.debug("killing shutdown hook removed");
            this.shutdownHook = null;
        }
        if (this.errorStreamMonitor != null) {
            LOGGER.debug("killing " + this.processName + " error stream monitor.");
            this.errorStreamMonitor.requestStop();
            LOGGER.debug(this.processName + " error stream monitor killed");
        }
        if (this.stdoutStreamMonitor != null) {
            LOGGER.debug("killing " + this.processName + " error stream monitor.");
            this.stdoutStreamMonitor.requestStop();
            LOGGER.debug(this.processName + " error stream monitor killed");
        }
        this.process.destroy();
    }

    public boolean isProcessAlive() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException ex) {
            LOGGER.debug("Process is still alive.", (Throwable)ex);
            return true;
        }
    }

    public Integer returnValue() {
        Integer value;
        try {
            value = this.process.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            LOGGER.debug("Process is still alive, no return value has been assigne yet.", (Throwable)itse);
            value = null;
        }
        return value;
    }

    public String getErrorStream() {
        if (this.errorStreamMonitor != null) {
            return this.errorStreamMonitor.getStreamContent();
        }
        return "stderr was not monitored";
    }

    public String getStdoutStream() {
        if (this.stdoutStreamMonitor != null) {
            return this.stdoutStreamMonitor.getStreamContent();
        }
        return "stdout was not monitored";
    }

    public String getProcessName() {
        return this.processName;
    }
}

