/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.process;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.opentestfactory.utils.process.CommandLine;
import org.opentestfactory.utils.process.ProcessHandle;
import org.opentestfactory.utils.process.Worker;
import org.opentestfactory.utils.shell.ShellResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProcessClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalProcessClient.class);
    private final Map<String, String> environment = new HashMap<String, String>(System.getenv());

    public boolean unsetEnvironementVariable(String name) {
        HashSet<String> uniset = new HashSet<String>(1);
        uniset.add(name);
        return !this.unsetEnvironmentVariables(uniset).isEmpty();
    }

    public Set<String> unsetEnvironmentVariables(Set<String> targetVariables) {
        HashSet<String> removed = new HashSet<String>(targetVariables.size());
        removed.addAll(targetVariables);
        removed.retainAll(this.environment.keySet());
        if (this.environment.keySet().removeAll(removed)) {
            LOGGER.debug("Removed all the following environment variables : {} according to removal query of the following vairables : {}.", removed, targetVariables);
        } else {
            LOGGER.warn("Failed to remove the following existing environment variable: {}", removed);
        }
        return removed;
    }

    public String setEnvironmentVariable(String name, String value) {
        HashMap<String, String> asMap = new HashMap<String, String>(1);
        asMap.put(name, value);
        Map<String, String> previousValue = this.setEnvironmentVariables(asMap);
        return previousValue.get(name);
    }

    public Map<String, String> setEnvironmentVariables(Map<String, String> variables) {
        HashMap<String, String> previouslyExisting = new HashMap<String, String>(this.environment);
        previouslyExisting.keySet().retainAll(variables.keySet());
        this.environment.putAll(variables);
        LOGGER.debug("Set the following variables {}, replacing the following pre-existing mappings: {}", variables, previouslyExisting);
        return previouslyExisting;
    }

    public ShellResult runLocalProcessCommand(String command, File workingDir, Integer timeout, Integer streamlength) throws IOException, InterruptedException, TimeoutException, ParseException {
        String[] parsedCommand = CommandLine.parse(command);
        ProcessBuilder processBuilder = new ProcessBuilder(parsedCommand);
        if (workingDir != null) {
            processBuilder.directory(workingDir);
        }
        if (timeout < 0) {
            timeout = new Integer(0);
        }
        if (streamlength < -1) {
            streamlength = new Integer(0);
        }
        LOGGER.debug("Beginning execution of the command '" + command + "'.");
        processBuilder.environment().clear();
        processBuilder.environment().putAll(this.environment);
        LOGGER.trace("Command environment : {}", processBuilder.environment());
        Process proc = processBuilder.start();
        ProcessHandle handle = new ProcessHandle("Local process", proc, true, true, true, streamlength);
        Worker worker = new Worker(proc);
        worker.start();
        try {
            worker.join(timeout.intValue());
            if (worker.getExitCode() != null) {
                ShellResult shellResult = new ShellResult(handle.returnValue(), handle.getStdoutStream(), handle.getErrorStream(), command);
                return shellResult;
            }
            try {
                StringBuilder builder = new StringBuilder("Command ").append(command).append(" timed out (").append(timeout).append(" ms)\n");
                if (handle.getStdoutStream() != null) {
                    builder.append("At timeout stdout was: ").append(handle.getStdoutStream()).append("\n");
                }
                if (handle.getErrorStream() != null) {
                    builder.append("At timeout stderr was: ").append(handle.getErrorStream()).append("\n");
                }
                throw new TimeoutException(builder.toString());
            }
            catch (InterruptedException ex) {
                worker.interrupt();
                Thread.currentThread().interrupt();
                throw ex;
            }
        }
        finally {
            handle.killProcess();
        }
    }
}

