/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.process;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CommandLine {
    public static String[] parse(String commandLine) throws ParseException {
        if (commandLine == null || commandLine.length() == 0) {
            return new String[0];
        }
        Status state = Status.OUTSIDE;
        StringTokenizer tokenized = new StringTokenizer(commandLine, "\"' ", true);
        ArrayList<String> parsedCommand = new ArrayList<String>();
        StringBuilder argument = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tokenized.hasMoreTokens()) {
            String nextToken = tokenized.nextToken();
            switch (state.ordinal()) {
                case 1: {
                    if ("'".equals(nextToken)) {
                        lastTokenHasBeenQuoted = true;
                        state = Status.OUTSIDE;
                        continue block4;
                    }
                    argument.append(nextToken);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextToken)) {
                        lastTokenHasBeenQuoted = true;
                        state = Status.OUTSIDE;
                        continue block4;
                    }
                    argument.append(nextToken);
                    continue block4;
                }
            }
            if ("'".equals(nextToken)) {
                state = Status.IN_QUOTE;
            } else if ("\"".equals(nextToken)) {
                state = Status.IN_DOUBLE_QUOTE;
            } else if (" ".equals(nextToken)) {
                if (lastTokenHasBeenQuoted || argument.length() != 0) {
                    parsedCommand.add(argument.toString());
                    argument.setLength(0);
                }
            } else {
                argument.append(nextToken);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || argument.length() != 0) {
            parsedCommand.add(argument.toString());
        }
        if (!state.equals((Object)Status.OUTSIDE)) {
            throw new ParseException("Unable to parse command \"" + commandLine + "\". Unbalanced \"" + state.token + "\"", commandLine.length());
        }
        return parsedCommand.toArray(new String[parsedCommand.size()]);
    }

    private static enum Status {
        OUTSIDE(""),
        IN_QUOTE("'"),
        IN_DOUBLE_QUOTE("\"");

        String token;

        private Status(String token) {
            this.token = token;
        }
    }
}

