/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.process;

import java.net.MalformedURLException;
import java.net.URL;
import org.opentestfactory.utils.process.ClasspathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathManager.class);

    public URL getClassCProotURL(Class<?> targetClass) throws ClasspathException {
        String name = targetClass.getSimpleName() + ".class";
        URL u = targetClass.getResource(name);
        if ("jar".equals(u.getProtocol())) {
            try {
                String classURL = u.getFile();
                String jarURL = classURL.split("!")[0];
                LOGGER.debug("Adding jar {} from the Junit plugin classpath to support default junit resource execution.", (Object)jarURL);
                return new URL(jarURL);
            }
            catch (MalformedURLException ex) {
                throw new ClasspathException("Failed to register plugin jar URL", ex);
            }
        }
        throw new ClasspathException("The plugin should be packaged as a JAR, other packagings are unsupported (found at " + u.toExternalForm() + ")");
    }
}

