/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.document;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.opentestfactory.utils.document.XmlTransformationException;

public class XmlReportTransformer {
    private final URL transformURL;

    public XmlReportTransformer(String transformURL) throws MalformedURLException {
        this.transformURL = new URL(transformURL);
    }

    public void transform(String source, String destinationDirectory, String destinationFile) throws XmlTransformationException {
        StreamSource xslt = new StreamSource(this.transformURL.toExternalForm());
        StreamSource xml = new StreamSource(source);
        Processor processor = new Processor(false);
        XsltCompiler compiler = processor.newXsltCompiler();
        try {
            XsltExecutable stylesheet = compiler.compile((Source)xslt);
            Files.createDirectories(Paths.get(destinationDirectory, new String[0]), new FileAttribute[0]);
            Serializer out = processor.newSerializer(new File(destinationDirectory + "/" + destinationFile));
            out.setOutputProperty(Serializer.Property.METHOD, "xml");
            out.setOutputProperty(Serializer.Property.INDENT, "yes");
            Xslt30Transformer transformer = stylesheet.load30();
            transformer.transform((Source)xml, (Destination)out);
        }
        catch (SaxonApiException e) {
            throw new XmlTransformationException("Unable to perform the transformation of the xml report into the target format", e);
        }
        catch (IOException e) {
            throw new XmlTransformationException("Couldn't create a destination directory for the transformation of the xml report into a Surefire type report", e);
        }
    }
}

