/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils.document;

import java.io.IOException;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opentestfactory.utils.document.DocumentBuildingException;
import org.opentestfactory.utils.document.MalformedDocumentBuildingException;
import org.opentestfactory.utils.document.SAXParseErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DocumentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentUtils.class);

    private DocumentUtils() {
    }

    public static Document getDocument(String fileName) throws DocumentBuildingException {
        Document document;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new SAXParseErrorHandler());
            document = builder.parse(fileName);
        }
        catch (ParserConfigurationException e) {
            throw new DocumentBuildingException("The DocumentBuilder could not be created which satisfies the configuration requested.", e);
        }
        catch (IOException e) {
            throw new DocumentBuildingException("The document is not located at the path provided.", e);
        }
        catch (SAXException e) {
            throw new MalformedDocumentBuildingException("The document is malformed. It is either not an XML document, or the test may have been aborted during its execution.", e);
        }
        return document;
    }

    public static List<String> evaluateXPath(Document document, String path) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            NodeList nodes = DocumentUtils.getNodes(document, path);
            for (int i = 0; i < nodes.getLength(); ++i) {
                values.add(nodes.item(i).getNodeValue());
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Unexpected XPath error.", (Throwable)e);
        }
        return values;
    }

    public static List<String> evaluateXPath(Document document, String query, String ... arguments) {
        return DocumentUtils.evaluateXPath(document, MessageFormat.format(query, arguments));
    }

    public static NodeList getNodes(Document document, String path) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression expr = xpath.compile(path);
        return (NodeList)expr.evaluate(document, XPathConstants.NODESET);
    }

    public static String getStringFromDocument(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }
}

