/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils;

import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static String requireNotBlank(String value, String name) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(String.format("%s cannot be blank", name));
        }
        return value;
    }

    public static <T> Collection<T> requireNotEmpty(Collection<T> candidate, String name) {
        Collection<T> collection = Objects.requireNonNull(candidate, String.format("%s cannot be null", name));
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s cannot be empty", name));
        }
        return collection;
    }

    public static <T> Collection<T> requireNotEmpty(Collection<T> candidate) {
        return ValidationUtils.requireNotEmpty(candidate, "Collection");
    }
}

