/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static URL appendPath(String baseUrl, String relativePath) {
        Objects.requireNonNull(baseUrl, "baseUrl should not be null.");
        Objects.requireNonNull(relativePath, "relativePath should not be null.");
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        URI uri = URI.create((String)baseUrl);
        try {
            return uri.resolve(relativePath).normalize().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            String errorMessage = String.format("Cannot build URL from base '%s' and relative path '%s'.", baseUrl, relativePath);
            throw new IllegalArgumentException(errorMessage, malformedURLException);
        }
    }
}

