/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListOf<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListOf.class);
    private final List<T> elements;

    public ListOf(Collection<T> elements) {
        this.elements = new ArrayList<T>(Objects.requireNonNull(elements));
    }

    public final <A> ListOf<T> attributeMatchValue(Function<T, A> getter, A matchingValue) {
        Objects.requireNonNull(matchingValue, "matchigValue may not be null. Use attributeMatchUndefined to select elements with an undefined optional attribute.");
        return this.attributeMatchAny(getter, Collections.singletonList(matchingValue));
    }

    public final <A> ListOf<T> attributeMatchUndefined(Function<T, A> getter) {
        return this.attributeMatchAny(getter, Collections.singleton(null));
    }

    public <A> ListOf<T> attributeMatchAny(Function<T, A> getter, Collection<A> matchingValues) {
        List attachments = this.elements.stream().filter(object -> {
            Object gottenValue = getter.apply(object);
            try {
                return matchingValues.contains(gottenValue);
            }
            catch (NullPointerException npe) {
                if (gottenValue == null) {
                    LOGGER.trace("Excluding value for {} because getter {} returned null and the matchingValues collection doesn't accept null values.", object, (Object)getter);
                    return false;
                }
                throw npe;
            }
        }).collect(Collectors.toList());
        return new ListOf(attachments);
    }

    public <A> List<A> pluck(Function<T, A> getter) {
        return this.elements.stream().map(getter).collect(Collectors.toList());
    }

    public List<T> toList() {
        return this.elements;
    }

    public boolean equals(Object obj) {
        return this.elements.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }
}

