/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.utils;

import java.io.IOException;

public class AmnesicStringBuffer
implements Appendable {
    private StringBuffer buffer = new StringBuffer();
    private int maxSize = 100;
    private static final int FULL_STREAMLENGTH = -1;

    public AmnesicStringBuffer() {
    }

    public AmnesicStringBuffer(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < -1) {
            throw new IllegalArgumentException("the max size must be positive or zero");
        }
        this.maxSize = maxSize;
        this.trimToMaxSize();
    }

    @Override
    public Appendable append(CharSequence arg0) throws IOException {
        this.buffer.append(arg0);
        this.trimToMaxSize();
        return this;
    }

    @Override
    public Appendable append(char arg0) throws IOException {
        this.buffer.append(arg0);
        this.trimToMaxSize();
        return this;
    }

    @Override
    public Appendable append(CharSequence arg0, int arg1, int arg2) {
        this.buffer.append(arg0, arg1, arg2);
        this.trimToMaxSize();
        return this;
    }

    private void trimToMaxSize() {
        int length;
        if (this.maxSize != -1 && (length = this.buffer.length()) > this.maxSize) {
            this.buffer.delete(0, length - this.maxSize);
        }
    }

    public String toString() {
        return this.buffer.toString();
    }
}

