/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.test.harness;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;
import org.opentestfactory.test.harness.AuthToken;
import org.slf4j.LoggerFactory;

public class TestConfiguration {
    public static final String CFG_FILE_SYSTEM_PROPERTY_NAME = "org.opentestfactory.test.cfg";
    private static final String DURATION_FACTOR_KEY = "sut.duration.factor.percent";
    @Deprecated
    public static final TestConfiguration VALUES = new TestConfiguration("org.opentestfactory.test.cfg");
    private final Properties cfgData;

    public static TestConfiguration values() {
        return new TestConfiguration(CFG_FILE_SYSTEM_PROPERTY_NAME);
    }

    TestConfiguration(String cfgFilePath) {
        String cfgFileParameter = System.getProperty(cfgFilePath);
        try {
            String cfgPath = Objects.requireNonNull(cfgFileParameter, "The org.opentestfactory.test.cfg system property should be defined");
            File canonicalCfgFile = new File(cfgPath).getCanonicalFile();
            this.cfgData = this.loadCfgData(canonicalCfgFile);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(TestConfiguration.class).error("Failed to load test configuration file " + cfgFileParameter, (Throwable)e);
            throw new IllegalArgumentException("Bad cfg file path", e);
        }
        catch (NullPointerException e) {
            LoggerFactory.getLogger(TestConfiguration.class).error("Missing mandatory org.opentestfactory.test.cfg java system property. The configuration file path should be specified.");
            throw e;
        }
    }

    private Properties loadCfgData(File canonicalCfgFile) throws IOException {
        Properties data = new Properties();
        try (FileInputStream dataStream = new FileInputStream(canonicalCfgFile);){
            data.load(dataStream);
        }
        return data;
    }

    public URL getServiceBaseURL(String hostURLKey) {
        try {
            if (this.cfgData.containsKey(hostURLKey)) {
                return new URL(this.cfgData.getProperty(hostURLKey));
            }
            throw new IllegalArgumentException("Missing configuration mapping fot key " + hostURLKey);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid base URL " + hostURLKey + " : " + e.getMessage(), e);
        }
    }

    public int getDurationFactorPercent() {
        int durationFactorPercent = Integer.parseInt(this.cfgData.getProperty(DURATION_FACTOR_KEY, "100"));
        LoggerFactory.getLogger(TestConfiguration.class).debug("Duration factor is set to {} %", (Object)durationFactorPercent);
        return durationFactorPercent;
    }

    public AuthToken getServiceAuthToken(String hostTokenKey) {
        return new AuthToken(this.cfgData.getProperty(Objects.requireNonNull(hostTokenKey, "hostTokenKey may not be null")));
    }

    public String getMockHost() {
        return Objects.requireNonNullElse(this.cfgData.get("mock.hostname"), "localhost").toString();
    }
}

