/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.test.harness;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Response;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SUTSender {
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private HttpResponse httpResponse;
    public static final Logger LOGGER = LoggerFactory.getLogger(SUTSender.class);

    public SUTSender(Response response) throws IOException {
        this.processResponse(response);
    }

    private void processResponse(Response response) throws IOException {
        this.httpResponse = response.returnResponse();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Got response: {}", (Object)this.getResponseBodyContent());
        }
    }

    public String getResponseBodyContent() throws IOException {
        return IOUtils.toString((InputStream)this.httpResponse.getEntity().getContent(), (String)DEFAULT_ENCODING);
    }

    public SUTSender thenExpectHttpCreateResponseCode() throws IOException {
        return this.thenExpectHttpResponseCode(201);
    }

    public SUTSender thenExpectHttpOkResponseCode() throws IOException {
        return this.thenExpectHttpResponseCode(200);
    }

    private SUTSender thenExpectHttpResponseCode(int reponseCode) throws IOException {
        Assertions.assertEquals((int)reponseCode, (int)this.httpResponse.getStatusLine().getStatusCode(), (String)("Expected " + reponseCode + " response code.\n Response body is :" + this.getResponseBodyContent()));
        return this;
    }
}

