/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.test.harness;

import java.time.Duration;
import org.mockserver.integration.ClientAndServer;

public class MockServerHelper {
    private long pollIntervalTimeMillis;
    private long timeOutMillis;

    public MockServerHelper(Duration pollIntervalTimeMillis, Duration timeOutMillis) {
        this.pollIntervalTimeMillis = pollIntervalTimeMillis.toMillis();
        this.timeOutMillis = timeOutMillis.toMillis();
    }

    public void waitForStart(ClientAndServer serverMock) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < this.timeOutMillis && !serverMock.isRunning()) {
            Thread.sleep(this.pollIntervalTimeMillis);
        }
        if (!serverMock.isRunning()) {
            throw new IllegalStateException("Mock server didn't start on time!");
        }
    }

    public void cleanStop(ClientAndServer mockServer) throws InterruptedException {
        if (mockServer != null) {
            mockServer.stop();
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < this.timeOutMillis && mockServer.isRunning()) {
                Thread.sleep(this.pollIntervalTimeMillis);
            }
            if (mockServer.isRunning()) {
                throw new IllegalStateException("Mock server didn't stop on time!");
            }
        }
    }
}

