/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.test.harness;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class JsonVariableMappings {
    private static final String UNIX_EOL_NEXT_PATTERN = ",\n";
    private static final String WINDOWS_EOL_NEXT_PATTERN = ",\r\n";
    private static final String UNIX_EOL_NEXT_REPLACEMENT = ",\n";
    private static final String WINDOWS_EOL_NEXT_REPLACEMENT = ",\r\n";
    private static final String UNIX_EOL_NONEXT_REPLACEMENT = "\n";
    private static final String WINDOWS_EOL_NONEXT_REPLACEMENT = "\r\n";
    private static final String UNIX_EOL_NONEXT_PATTERN = "\n";
    private static final String WINDOWS_EOL_NONEXT_PATTERN = "\r\n";
    private static final int BASE_DIX = 10;
    private static final Pattern STRAY_FIELD_VARIABLE = Pattern.compile(": *#\\{[^}]*\\},?\r?\n");
    private static final Pattern STRAY_FIRST_LIST_ELEMENT = Pattern.compile("\\[#\\{[^}]*\\}(?:,[^]]*)?\\]");
    private static final Pattern STRAY_MIDDLE_LIST_ELEMENT = Pattern.compile("\\[[^\\]]*,#\\{[^}]*\\},[^\\]]*]");
    private static final Pattern STRAY_LAST_LIST_ELEMENT = Pattern.compile("\\[(?:[^\\]]*,)#\\{[^,}]+\\}]");
    private final Map<String, String> mappings;

    public JsonVariableMappings(Map<String, String> mappings) {
        this.mappings = Objects.requireNonNull(mappings, "Mappings should not be null");
    }

    public static JsonVariableMappings noMappings() {
        return new JsonVariableMappings(Collections.emptyMap());
    }

    public static JsonVariableMappings withStringMapping(String key, String value) {
        return JsonVariableMappings.noMappings().withAdditionalStringMapping(key, value);
    }

    public static JsonVariableMappings withIntegerMapping(String key, Integer value) {
        return JsonVariableMappings.noMappings().withAdditionalIntegerMapping(key, value);
    }

    public static List<String> searchForStrayVariableConstructs(String expectedPayload) {
        Matcher variableMatcher = STRAY_FIELD_VARIABLE.matcher(expectedPayload);
        ArrayList<String> occurrences = new ArrayList<String>();
        while (variableMatcher.find()) {
            occurrences.add(variableMatcher.group().replace(",\r\n", "").replace("\r\n", "").replace(",\n", "").replace("\n", ""));
        }
        occurrences.addAll(JsonVariableMappings.findOccurences(expectedPayload, STRAY_FIRST_LIST_ELEMENT, STRAY_MIDDLE_LIST_ELEMENT, STRAY_LAST_LIST_ELEMENT));
        return occurrences;
    }

    private static List<String> findOccurences(String expectedPayload, Pattern ... pattern) {
        ArrayList<String> occurrences = new ArrayList<String>();
        for (Pattern p : pattern) {
            Matcher matcher = p.matcher(expectedPayload);
            while (matcher.find()) {
                occurrences.add(matcher.group());
            }
        }
        return occurrences;
    }

    public JsonVariableMappings withAdditionalStringMapping(String key, String value) {
        HashMap<String, String> newMappings = new HashMap<String, String>(this.mappings);
        newMappings.put(key, "\"" + value + "\"");
        return new JsonVariableMappings(newMappings);
    }

    public JsonVariableMappings withAdditionalIntegerMapping(String key, int value) {
        HashMap<String, String> newMappings = new HashMap<String, String>(this.mappings);
        newMappings.put(key, Integer.toString(value, 10));
        return new JsonVariableMappings(newMappings);
    }

    public String replaceMappings(InputStream bodyStream) throws IOException {
        String bodyString = IOUtils.toString((InputStream)bodyStream, (String)"UTF-8");
        return this.replaceMappings(bodyString);
    }

    public String replaceMappings(String bodyString) {
        for (Map.Entry<String, String> variableMapping : this.mappings.entrySet()) {
            String construct = ": *#\\{" + variableMapping.getKey() + "\\}";
            bodyString = ((String)bodyString).replaceAll(construct + ",\n", ": " + variableMapping.getValue() + ",\n");
            bodyString = ((String)bodyString).replaceAll(construct + ",\r\n", ": " + variableMapping.getValue() + ",\r\n");
            bodyString = ((String)bodyString).replaceAll(construct + "\n", ": " + variableMapping.getValue() + "\n");
            bodyString = ((String)bodyString).replaceAll(construct + "\r\n", ": " + variableMapping.getValue() + "\r\n");
            String listElementConstruct = ": *\\[(.*,)* *(?<construct>#\\{" + variableMapping.getKey() + "})(,[^\\[]+)*\\]";
            Pattern listElementPattern = Pattern.compile(listElementConstruct);
            Matcher m = listElementPattern.matcher((CharSequence)bodyString);
            while (m.find()) {
                bodyString = ((String)bodyString).substring(0, m.start("construct")) + variableMapping.getValue() + ((String)bodyString).substring(m.end("construct"));
                m = listElementPattern.matcher((CharSequence)bodyString);
            }
        }
        return bodyString;
    }
}

