/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.test.harness;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.javacrumbs.jsonunit.ConfigurableJsonMatcher;
import net.javacrumbs.jsonunit.JsonMatchers;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.commons.io.IOUtils;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.Body;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.NottableString;
import org.mockserver.model.RequestDefinition;
import org.mockserver.verify.VerificationTimes;
import org.opentestfactory.test.harness.JsonVariableMappings;
import org.opentestfactory.test.harness.TestConfiguration;
import org.opentestfactory.test.harness.UnknownTestResource;
import org.slf4j.LoggerFactory;

public class ExpectedOutputReceiver {
    private ClientAndServer mockServer;
    private List<HttpRequest> expectedRequests = Collections.emptyList();
    private List<HttpRequest> unwantedRequests = Collections.emptyList();
    private JsonVariableMappings variableMappings = JsonVariableMappings.noMappings();
    private boolean ignoreArrayOrder = false;
    private int speedFactor = TestConfiguration.values().getDurationFactorPercent();

    public ExpectedOutputReceiver(ClientAndServer mockServer) {
        this.mockServer = mockServer;
    }

    public ExpectedOutputReceiver(ClientAndServer mockServer, List<HttpRequest> expectedRequests, List<HttpRequest> unwantedRequests, JsonVariableMappings variableMappings, boolean ignoreArrayOrder) {
        this.mockServer = mockServer;
        this.expectedRequests = new ArrayList<HttpRequest>(expectedRequests);
        this.unwantedRequests = new ArrayList<HttpRequest>(unwantedRequests);
        this.variableMappings = variableMappings;
        this.ignoreArrayOrder = ignoreArrayOrder;
    }

    public static ExpectedOutputReceiver basedOnMock(ClientAndServer mockServer) {
        return new ExpectedOutputReceiver(mockServer);
    }

    public ExpectedOutputReceiver withVariableMapping(String key, String value) {
        if (this.expectedRequests.isEmpty() && this.unwantedRequests.isEmpty()) {
            JsonVariableMappings jsonVariableMappings = this.variableMappings.withAdditionalStringMapping(key, value);
            return new ExpectedOutputReceiver(this.mockServer, this.expectedRequests, this.unwantedRequests, jsonVariableMappings, this.ignoreArrayOrder);
        }
        throw new IllegalStateException("Adding variables after adding expected requetst is unsupported");
    }

    public ExpectedOutputReceiver withMockAttachment(String attachmentResourceName) throws IOException, URISyntaxException {
        try (InputStream attachmentStream = this.getClass().getResourceAsStream(attachmentResourceName);){
            if (attachmentStream == null) {
                throw new UnknownTestResource("Resource not found: " + attachmentResourceName);
            }
            URI mockAttachmentURI = new URI("http", null, TestConfiguration.values().getMockHost(), this.mockServer.getPort(), attachmentResourceName, null, null);
            this.mockServer.when((RequestDefinition)HttpRequest.request((String)attachmentResourceName)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(IOUtils.toByteArray((InputStream)attachmentStream)));
            ExpectedOutputReceiver expectedOutputReceiver = this.withVariableMapping(attachmentResourceName.replace('/', '_'), mockAttachmentURI.toString());
            return expectedOutputReceiver;
        }
    }

    public ExpectedOutputReceiver withExpectedRequestTemplate(String path, InputStream bodyStream) throws IOException {
        String bodyString = this.variableMappings.replaceMappings(bodyStream);
        ArrayList<HttpRequest> newExpectedRequestList = new ArrayList<HttpRequest>(this.expectedRequests);
        newExpectedRequestList.add(HttpRequest.request().withPath(path).withBody((Body)JsonBody.json((String)bodyString, (MatchType)MatchType.ONLY_MATCHING_FIELDS)));
        this.mockServer.when((RequestDefinition)HttpRequest.request().withPath(path)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        return new ExpectedOutputReceiver(this.mockServer, newExpectedRequestList, this.unwantedRequests, this.variableMappings, this.ignoreArrayOrder);
    }

    public ExpectedOutputReceiver withExpectedRequests(HttpRequest ... expectedRequests) {
        Arrays.asList(Objects.requireNonNull(expectedRequests, "expectedRequests cannot be null")).forEach(oneReq -> {
            this.warnOfStrayVariableConstructOccurences((HttpRequest)oneReq);
            this.mockServer.when((RequestDefinition)HttpRequest.request().withPath(oneReq.getPath())).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        });
        ArrayList<HttpRequest> newExpectedRequestList = new ArrayList<HttpRequest>(this.expectedRequests);
        newExpectedRequestList.addAll(Arrays.asList(expectedRequests));
        return new ExpectedOutputReceiver(this.mockServer, newExpectedRequestList, this.unwantedRequests, this.variableMappings, this.ignoreArrayOrder);
    }

    private void warnOfStrayVariableConstructOccurences(HttpRequest oneReq) {
        String expectedPayload = oneReq.getBodyAsString();
        List<String> occurences = JsonVariableMappings.searchForStrayVariableConstructs(expectedPayload);
        for (String occurence : occurences) {
            LoggerFactory.getLogger(ExpectedOutputReceiver.class).warn("Found unreplaced variable construct {} in {}", (Object)occurence, (Object)expectedPayload);
        }
    }

    public ExpectedOutputReceiver withUnwantedRequests(HttpRequest ... unwantedRequests) {
        ArrayList<HttpRequest> newUnwantedRequests = new ArrayList<HttpRequest>(this.unwantedRequests);
        newUnwantedRequests.addAll(Arrays.asList(unwantedRequests));
        return new ExpectedOutputReceiver(this.mockServer, this.expectedRequests, newUnwantedRequests, this.variableMappings, this.ignoreArrayOrder);
    }

    public ExpectedOutputReceiver waitAndVerifyExpectedCall(Duration delay) throws InterruptedException {
        long effectiveDelay = delay.multipliedBy(this.speedFactor).dividedBy(100L).toMillis();
        LoggerFactory.getLogger(ExpectedOutputReceiver.class).info("This test specifies a {} ms delay, with factor {}%, we'll wait {} ms.", new Object[]{delay.toMillis(), this.speedFactor, effectiveDelay});
        Thread.sleep(effectiveDelay);
        for (HttpRequest oneReq : this.expectedRequests) {
            this.checkIfExpectedRequestWasReceived(oneReq);
        }
        try {
            for (HttpRequest oneReq : this.unwantedRequests) {
                this.mockServer.verify((RequestDefinition)oneReq, VerificationTimes.exactly((int)0));
            }
        }
        catch (AssertionError e) {
            throw new AssertionError("Unwanted request received", (Throwable)((Object)e));
        }
        return this;
    }

    public ExpectedOutputReceiver withIgnoreArrayElementOrder() {
        return new ExpectedOutputReceiver(this.mockServer, this.expectedRequests, this.unwantedRequests, this.variableMappings, true);
    }

    public JsonVariableMappings mappings() {
        return this.variableMappings;
    }

    private void checkIfExpectedRequestWasReceived(HttpRequest oneReq) {
        boolean found = false;
        LoggerFactory.getLogger(ExpectedOutputReceiver.class).info("Checking for target request " + String.valueOf(oneReq));
        NottableString path = oneReq.getPath();
        String expectedPayload = oneReq.getBodyAsString();
        StringBuilder actualBuilder = new StringBuilder();
        for (HttpRequest req : this.mockServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(path))) {
            LoggerFactory.getLogger(ExpectedOutputReceiver.class).info("Went through request : " + String.valueOf(req));
            String actualPayload = req.getBodyAsString();
            ConfigurableJsonMatcher matcher = JsonMatchers.jsonEquals((Object)expectedPayload);
            if (this.ignoreArrayOrder) {
                matcher = matcher.when(Option.IGNORING_ARRAY_ORDER, new Option[0]);
            }
            if (found |= matcher.matches((Object)actualPayload)) continue;
            actualBuilder.append(actualPayload).append("\n");
        }
        if (!found) {
            throw new AssertionError((Object)("Expected request payload not found : expected<" + expectedPayload + "> but was <" + String.valueOf(actualBuilder) + ">"));
        }
    }
}

