/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.test.harness;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.opentestfactory.test.harness.AbstractMicroServiceTestBase;
import org.opentestfactory.test.harness.AuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMicroserviceIntegrationTest
extends AbstractMicroServiceTestBase {
    protected final List<String> busMockSubscriptionCfg;
    private final Map<String, String> subscriptionIds = new HashMap<String, String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMicroserviceIntegrationTest.class);

    public AbstractMicroserviceIntegrationTest(int receiverPort, String busMockSubscriptionCfg, URL sutBaseUrl, AuthToken serviceAuthConfig) {
        this(receiverPort, sutBaseUrl, serviceAuthConfig, busMockSubscriptionCfg);
    }

    public AbstractMicroserviceIntegrationTest(int mockPort, URL sutBaseUrl, AuthToken serviceAuthToken, String ... busMockSubscriptionCfg) {
        super(mockPort, sutBaseUrl, serviceAuthToken);
        this.busMockSubscriptionCfg = Arrays.asList(Objects.requireNonNull(busMockSubscriptionCfg, "Mock subscritpion list should be provided"));
    }

    @BeforeEach
    public void subscribeToBus() throws URISyntaxException, IOException {
        String busSubscribeEndpoint = String.valueOf(this.BUS_BASE_URL) + "/subscriptions";
        URI busSubscribeURI = new URI(busSubscribeEndpoint);
        for (String subscription : this.busMockSubscriptionCfg) {
            String subscriptionContent = this.jsonRESTPost(subscription, busSubscribeURI, this.subscriptionMappings(subscription), this.BUS_AUTH_TOKEN).thenExpectHttpCreateResponseCode().getResponseBodyContent();
            Matcher uuidMatcher = Pattern.compile("\\{\"uuid\":\"(?<uuid>[^}]+)\"\\}").matcher(subscriptionContent);
            if (uuidMatcher.find()) {
                this.subscriptionIds.put(uuidMatcher.group("uuid"), String.valueOf(busSubscribeURI) + ";" + this.BUS_AUTH_TOKEN.value);
                continue;
            }
            LOGGER.warn("Failed to extract SUT bus subscription UUID, won't be able to unsubscribe");
        }
    }

    @AfterEach
    public synchronized void unsubscribeToBus() {
        HashSet done = new HashSet();
        this.subscriptionIds.entrySet().forEach(subscriptionRecord -> {
            String subscriptionId = (String)subscriptionRecord.getKey();
            done.add(subscriptionId);
            String callData = (String)subscriptionRecord.getValue();
            String[] dataTable = callData.split(";");
            if (dataTable.length != 2) {
                LOGGER.warn("Invalid subscription data {} for subscription {}", (Object)callData, (Object)subscriptionId);
            } else {
                try {
                    String busUri = dataTable[0];
                    String busToken = dataTable[1];
                    Request request = Request.Delete((String)(busUri + "/" + subscriptionId)).addHeader(AbstractMicroServiceTestBase.ContentType.JSON.header);
                    Response execute = new AuthToken(busToken).apply(request).execute();
                    int code = execute.returnResponse().getStatusLine().getStatusCode();
                    if (code != 200) {
                        LOGGER.warn("Unsubscribe request came back with code {}", (Object)code);
                    }
                }
                catch (IOException ex) {
                    LOGGER.warn("Failed to unsubscribe for subscription {}", (Object)subscriptionId, (Object)ex);
                }
            }
        });
        this.subscriptionIds.keySet().removeAll(done);
    }
}

