/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.test.harness;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.message.BasicHeader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.Body;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.opentestfactory.test.harness.AuthToken;
import org.opentestfactory.test.harness.ExpectedOutputReceiver;
import org.opentestfactory.test.harness.JsonVariableMappings;
import org.opentestfactory.test.harness.MockServerHelper;
import org.opentestfactory.test.harness.SUTSender;
import org.opentestfactory.test.harness.TestConfiguration;
import org.opentestfactory.test.harness.UnknownTestResource;
import org.slf4j.LoggerFactory;

public abstract class AbstractMicroServiceTestBase {
    public static final Duration DELAY_BEFORE_ASYNC_REQUEST_VERIFY = Duration.ofMillis(1000L);
    public static final Duration DELAY_BEFORE_ASYNC_REQUEST_SEQUENCE_VERIFY = Duration.ofMillis(1000L);
    public static final Duration DELAY_FOR_SSH = Duration.ofSeconds(45L);
    protected static final String AUTH_TOKEN_KEY_SUFFIX = ".auth-token";
    protected static final String URL_KEY_SUFFIX = ".url";
    public static final String EVENTBUS_BASE_KEY = "eventbus.base";
    private static final String EVENTBUS_URL_KEY = "eventbus.base.url";
    private static final String EVENT_BUS_AUTH_TOKEN_KEY = "eventbus.base.auth-token";
    public static final String SUBSCRIPTIONS_PATH = "/subscriptions";
    private static final MockServerHelper MOCK_SERVER_HELPER = new MockServerHelper(Duration.ofMillis(100L), Duration.ofMinutes(1L));
    private static final String MOCK_HOST_NAME = TestConfiguration.values().getMockHost();
    private static final String RECEIVER_INBOX_MAPPING_KEY = "receiverInbox";
    public final URL BUS_BASE_URL;
    public final AuthToken BUS_AUTH_TOKEN;
    public final AuthToken serviceAuthToken;
    private final int receiverPort;
    private final URL sutBaseUrl;
    protected ClientAndServer mockServer;

    public AbstractMicroServiceTestBase(int receiverPort, URL sutBaseUrl, AuthToken serviceAuthToken) {
        this.receiverPort = receiverPort;
        this.sutBaseUrl = sutBaseUrl;
        TestConfiguration configuration = TestConfiguration.values();
        this.BUS_BASE_URL = configuration.getServiceBaseURL(EVENTBUS_URL_KEY);
        this.BUS_AUTH_TOKEN = configuration.getServiceAuthToken(EVENT_BUS_AUTH_TOKEN_KEY);
        this.serviceAuthToken = serviceAuthToken;
    }

    @BeforeAll
    public static void mockServerWarmUp() throws InterruptedException {
        MOCK_SERVER_HELPER.cleanStop(ClientAndServer.startClientAndServer((Integer[])new Integer[]{1088}));
    }

    @BeforeEach
    public void startClientAndServer() throws InterruptedException {
        this.mockServer = ClientAndServer.startClientAndServer((Integer[])new Integer[]{this.receiverPort});
        MOCK_SERVER_HELPER.waitForStart(this.mockServer);
    }

    @AfterEach
    public void stopClientAndServer() throws InterruptedException {
        MOCK_SERVER_HELPER.cleanStop(this.mockServer);
    }

    protected SUTSender sendTemplatedTestMessage(String testMessageResourceName, JsonVariableMappings variableMappings) throws URISyntaxException, IOException {
        return this.jsonRESTPost(testMessageResourceName, this.getSutURI(), variableMappings, this.serviceAuthToken);
    }

    protected SUTSender sendTestMessage(String testMessageResourceName) throws IOException, URISyntaxException {
        return this.jsonRESTPost(testMessageResourceName, this.getSutURI(), JsonVariableMappings.noMappings(), this.serviceAuthToken);
    }

    private URI getSutURI() throws URISyntaxException {
        return new URI(String.valueOf(this.BUS_BASE_URL) + "/publications");
    }

    protected SUTSender jsonRESTPost(String testMessageResourceName, URI sutURI, JsonVariableMappings variableMappings, AuthToken sutAuthToken) throws IOException {
        Request request = Request.Post((URI)sutURI).addHeader(ContentType.JSON.header).bodyStream(this.useTestResource(testMessageResourceName, variableMappings));
        Response execute = sutAuthToken.apply(request).execute();
        return new SUTSender(execute);
    }

    protected HttpRequest requestMatcher(String pathOfMock, String expectedPayloadName) throws IOException {
        String expected = IOUtils.toString((InputStream)this.useTestResource(expectedPayloadName));
        return HttpRequest.request().withPath(pathOfMock).withBody((Body)JsonBody.json((String)expected, (MatchType)MatchType.ONLY_MATCHING_FIELDS));
    }

    protected InputStream useTestResource(String resourceName) {
        try {
            return this.useTestResource(resourceName, JsonVariableMappings.noMappings());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read from resource. This should not happen.", e);
        }
    }

    private InputStream useTestResource(String testResourceName, JsonVariableMappings variableMappings) throws IOException {
        if (Objects.requireNonNullElse(testResourceName, "").isBlank()) {
            throw new UnknownTestResource("Cannot use a resource from a null or blank name.");
        }
        InputStream resourceAsStream = this.getClass().getResourceAsStream(testResourceName);
        if (resourceAsStream == null) {
            throw new UnknownTestResource("Test resource " + testResourceName + " not found.");
        }
        String resourceContent = IOUtils.toString((InputStream)resourceAsStream, (String)"UTF-8");
        String replacedContent = variableMappings.replaceMappings(resourceContent);
        this.warnForStrayVariableMappingPatterns(testResourceName, replacedContent);
        return new ByteArrayInputStream(replacedContent.getBytes("UTF-8"));
    }

    private void warnForStrayVariableMappingPatterns(String testResourceName, String replacedContent) {
        List<String> strayPatterns = JsonVariableMappings.searchForStrayVariableConstructs(replacedContent);
        strayPatterns.forEach(pattern -> LoggerFactory.getLogger(AbstractMicroServiceTestBase.class).warn("Found stray variable injection pattern {} in replaced payload {}.", pattern, (Object)testResourceName));
    }

    protected ExpectedOutputReceiver getExpectedOutputReceiver() {
        return ExpectedOutputReceiver.basedOnMock(this.mockServer);
    }

    protected SUTSender postJSONToSUTendPoint(String messageName, String sutEndpointPath, JsonVariableMappings variables) throws URISyntaxException, IOException {
        return this.postToSUTendPoint(messageName, sutEndpointPath, variables, ContentType.JSON);
    }

    protected SUTSender postYAMLToSUTendPoint(String messageName, String sutEndpointPath) throws URISyntaxException, IOException {
        return this.postToSUTendPoint(messageName, sutEndpointPath, JsonVariableMappings.noMappings(), ContentType.YAML);
    }

    private SUTSender postToSUTendPoint(String payloadMessageName, String sutEndpointPath, JsonVariableMappings variables, ContentType contentType) throws URISyntaxException, IOException {
        URI targetURI = new URI(this.sutBaseUrl.toExternalForm() + sutEndpointPath);
        String payloadStringContent = variables.replaceMappings(this.useTestResource(payloadMessageName));
        Request request = Request.Post((URI)targetURI).setHeader(contentType.header).bodyByteArray(payloadStringContent.getBytes("UTF-8"));
        Response sutResponse = this.serviceAuthToken.apply(request).execute();
        return new SUTSender(sutResponse);
    }

    protected JsonVariableMappings subscriptionMappings(String subscriptionName) throws IOException {
        String receiverInbox = new URL("http://" + MOCK_HOST_NAME + ":" + this.receiverPort + this.subscriptionPath(subscriptionName)).toExternalForm();
        return JsonVariableMappings.noMappings().withAdditionalStringMapping(RECEIVER_INBOX_MAPPING_KEY, receiverInbox);
    }

    protected String subscriptionPath(String subscriptionName) throws IOException {
        InputStream subscriptionPayloadStream = this.useTestResource(subscriptionName);
        String subscriptionPayload = JsonVariableMappings.noMappings().replaceMappings(subscriptionPayloadStream);
        if (JsonVariableMappings.searchForStrayVariableConstructs(subscriptionPayload).indexOf(":#{receiverInbox}") < 0) {
            Map subscription = (Map)new ObjectMapper().readValue(subscriptionPayload, Map.class);
            String endpointURL = (String)((Map)((Map)subscription.get("spec")).get("subscriber")).get("endpoint");
            return new URL(endpointURL).getPath();
        }
        return ("/" + subscriptionName).replace("//", "/");
    }

    protected static enum ContentType {
        JSON("application/json"),
        YAML("application/x-yaml");

        public final Header header;

        private ContentType(String headerValue) {
            this.header = new BasicHeader("Content-Type", headerValue);
        }
    }
}

