/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.worker;

import java.util.UUID;
import org.opentestfactory.dto.v1.WorkerJobComplete;
import org.opentestfactory.dto.v1.WorkerJobStarted;
import org.opentestfactory.messages.GenericNotification;
import org.opentestfactory.messages.OTFMessage;
import org.opentestfactory.messages.Status;
import org.opentestfactory.services.components.bus.BusApiClient;
import org.opentestfactory.services.components.bus.PublicationStatus;
import org.opentestfactory.services.components.worker.SynchronousTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerNotifier.class);
    private final BusApiClient busClient;
    private final String workflowId;
    private final String name;
    private final String notificationId;

    public WorkerNotifier(BusApiClient busClient, String workflowId, String name) {
        this.busClient = busClient;
        this.workflowId = workflowId;
        this.name = name;
        this.notificationId = UUID.randomUUID().toString();
    }

    public void doInWorker(SynchronousTask task) {
        this.notifyWorkerStarted();
        try {
            task.runSynchronously();
        }
        finally {
            this.notifyWorkerCompleted();
        }
    }

    public void notifyWorkerStarted() {
        WorkerJobStarted workerJobStarted = new WorkerJobStarted("opentestfactory.org/v1alpha1", this.name, this.workflowId, this.notificationId);
        this.publish((GenericNotification)workerJobStarted);
    }

    public void notifyWorkerCompleted() {
        WorkerJobComplete workerJobCompleted = new WorkerJobComplete("opentestfactory.org/v1alpha1", this.name, this.workflowId, this.notificationId);
        this.publish((GenericNotification)workerJobCompleted);
    }

    private void publish(GenericNotification message) {
        PublicationStatus publicationStatus = this.busClient.publishEvent((OTFMessage)message);
        if (publicationStatus.getStatus() == Status.StatusValue.Failure) {
            LOGGER.error("Failed to send {} for workflow with id={} : {}, {}", new Object[]{message.getKind(), this.workflowId, publicationStatus.getReason(), publicationStatus.getDetails()});
        } else {
            LOGGER.debug("Successfully sent {} for workflow with id={}", (Object)message, (Object)this.workflowId);
        }
    }
}

