/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.repository;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.opentestfactory.services.components.domain.AggregateRepository;
import org.opentestfactory.services.components.domain.Identified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InMemoryRepository<AGGREGATE extends Identified<String>>
implements AggregateRepository<String, AGGREGATE> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Map<String, AGGREGATE> map = new ConcurrentHashMap<String, AGGREGATE>();

    @Override
    public Optional<AGGREGATE> findById(String id) {
        return Optional.ofNullable((Identified)this.map.get(id));
    }

    @Override
    public void save(AGGREGATE aggregate) {
        this.LOGGER.trace("Try to save {} ", aggregate);
        this.validate(aggregate);
        this.map.put((String)aggregate.getId(), aggregate);
        this.LOGGER.trace("Saved {} ", aggregate);
    }

    private void validate(AGGREGATE aggregate) {
        Objects.requireNonNull(aggregate, "Aggregate cannot be null");
        if (StringUtils.isBlank((CharSequence)((CharSequence)aggregate.getId()))) {
            throw new IllegalArgumentException("Id must not be blank");
        }
    }

    @Override
    public void remove(AGGREGATE aggregate) {
        this.map.remove(aggregate.getId());
    }
}

