/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.logger;

import java.util.Collections;
import java.util.List;
import org.opentestfactory.messages.OTFMessage;

public class WorkflowEvent {
    public static final String STEP_ID_KEY = "step_id";
    public static final String STEP_ORIGIN_KEY = "step_origin";
    public static final String JOB_ID_KEY = "job_id";
    public static final String JOB_ORIGIN_KEY = "job_origin";
    private final OTFMessage otfMessage;

    public WorkflowEvent(OTFMessage otfMessage) {
        this.otfMessage = otfMessage;
    }

    public boolean hasStepId() {
        return this.otfMessage.getMetadata().containsKey(STEP_ID_KEY);
    }

    public String stepId() {
        return this.hasStepId() ? (String)this.otfMessage.getMetadata().get(STEP_ID_KEY) : null;
    }

    public boolean hasStepOrigin() {
        return this.otfMessage.getMetadata().containsKey(STEP_ORIGIN_KEY);
    }

    public List<String> stepOrigin() {
        return this.hasStepOrigin() ? (List)this.otfMessage.getMetadata().get(STEP_ORIGIN_KEY) : null;
    }

    public String getWorkflowId() {
        return (String)this.otfMessage.getMetadata().get("workflow_id");
    }

    public boolean hasJobID() {
        return this.otfMessage.getMetadata().containsKey(JOB_ID_KEY);
    }

    public String getJobId() {
        return this.hasJobID() ? (String)this.otfMessage.getMetadata().get(JOB_ID_KEY) : null;
    }

    public boolean hasJobOrigin() {
        return this.otfMessage.getMetadata().containsKey(JOB_ORIGIN_KEY);
    }

    public List<String> getJobOrigin() {
        return this.hasJobOrigin() ? (List)this.otfMessage.getMetadata().get(JOB_ORIGIN_KEY) : Collections.emptyList();
    }

    public OTFMessage getOtfMessage() {
        return this.otfMessage;
    }
}

