/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.logger;

import java.util.List;
import java.util.Objects;
import org.opentestfactory.messages.OTFMessage;
import org.opentestfactory.services.components.logger.WorkflowEvent;

public class WorkflowContext {
    private static final ThreadLocal<WorkflowContext> contextStore = new ThreadLocal();
    public final String workflowId;
    private final String jobId;
    private final String stepId;
    private final List<String> jobOrigin;
    private final List<String> stepOrigin;

    public WorkflowContext(WorkflowEvent event) {
        this.workflowId = Objects.requireNonNull(event.getWorkflowId(), "The event object needs a workflow id");
        this.jobId = event.getJobId();
        this.jobOrigin = this.jobId != null && !event.getJobOrigin().isEmpty() ? event.getJobOrigin() : null;
        this.stepId = event.stepId();
        this.stepOrigin = event.stepOrigin();
    }

    public static void registerContext(WorkflowContext context) {
        contextStore.set(context);
    }

    public static void registerWorkflowContext(OTFMessage otfMessage) {
        WorkflowContext.registerContext(new WorkflowContext(new WorkflowEvent(otfMessage)));
    }

    public static void cleanWorkflowContextUp() {
        contextStore.remove();
    }

    public static WorkflowContext get() {
        return contextStore.get();
    }

    public boolean hasJobId() {
        return this.jobId != null;
    }

    public String jobId() {
        return this.jobId;
    }

    public boolean hasStepId() {
        return this.stepId != null;
    }

    public String stepId() {
        return this.stepId;
    }

    public boolean hasJobOrigin() {
        return this.jobOrigin != null;
    }

    public List<String> jobOrigin() {
        return this.jobOrigin;
    }

    public boolean hasStepOrigin() {
        return this.stepOrigin != null;
    }

    public List<String> stepOrigin() {
        return this.stepOrigin;
    }
}

