/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.http;

import io.micronaut.http.HttpStatus;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.opentestfactory.services.components.http.exception.HttpClientResponseException;
import org.opentestfactory.services.components.http.exception.HttpForbiddenException;
import org.opentestfactory.services.components.http.exception.HttpMethodNotAllowedException;
import org.opentestfactory.services.components.http.exception.HttpNotFoundException;
import org.opentestfactory.services.components.http.exception.HttpNotImplementedException;
import org.opentestfactory.services.components.http.exception.HttpPreconditionFailedException;
import org.opentestfactory.services.components.http.exception.HttpRedirectionException;
import org.opentestfactory.services.components.http.exception.HttpServerException;
import org.opentestfactory.services.components.http.exception.HttpUnauthorizedException;

public class HttpResponseErrorHandler {
    private HttpResponseErrorHandler() {
    }

    public static void handleHttpErrors(ClassicHttpResponse response, String uri) {
        HttpStatus httpStatus = HttpStatus.valueOf((int)response.getCode());
        switch (httpStatus) {
            case UNAUTHORIZED: {
                throw new HttpUnauthorizedException(uri);
            }
            case FORBIDDEN: {
                throw new HttpForbiddenException(uri);
            }
            case NOT_FOUND: {
                throw new HttpNotFoundException(uri);
            }
            case METHOD_NOT_ALLOWED: {
                throw new HttpMethodNotAllowedException(uri);
            }
            case PRECONDITION_FAILED: {
                throw new HttpPreconditionFailedException(uri);
            }
            case NOT_IMPLEMENTED: {
                throw new HttpNotImplementedException(uri);
            }
        }
        if (response.getCode() >= 500) {
            throw new HttpServerException(response.getCode(), uri);
        }
        if (response.getCode() >= 400) {
            throw new HttpClientResponseException(response.getCode(), uri);
        }
        if (response.getCode() >= 300) {
            throw new HttpRedirectionException(response.getCode(), uri);
        }
    }
}

