/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.http;

import java.net.URI;
import java.util.Objects;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.opentestfactory.services.components.http.exception.HttpRequestBuilderException;

public class HttpRequestBuilder {
    private static final String ERROR_NO_ENDPOINT = "Cannot build a request without an endpoint";
    private static final String ERROR_NO_CONTENT = "Cannot build a POST request without a content";
    private static final String BEARER_TOKEN_FORMAT = "Bearer %s";
    private static final String BASIC_AUTH_FORMAT = "Basic %s";
    private static final String LOGIN_PASSWORD_ENCODING_FORMAT = "%s:%s";
    private String endpoint;
    private String authorizationHeader;
    private String userAgentHeader;
    private final String acceptHeader;
    private final String contentTypeHeader;
    private String content;

    public HttpRequestBuilder() {
        this.acceptHeader = "application/json";
        this.contentTypeHeader = "application/json";
    }

    public HttpRequestBuilder withUri(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpRequestBuilder withBearerToken(String token) {
        this.authorizationHeader = String.format(BEARER_TOKEN_FORMAT, token);
        return this;
    }

    public HttpRequestBuilder withEncodedAuthorizationHeader(String login, String password) {
        String concat = String.format(LOGIN_PASSWORD_ENCODING_FORMAT, login, password);
        this.authorizationHeader = String.format(BASIC_AUTH_FORMAT, Base64Utility.encode((byte[])concat.getBytes()));
        return this;
    }

    public HttpRequestBuilder withUserAgent(String userAgent) {
        this.userAgentHeader = userAgent;
        return this;
    }

    public HttpRequestBuilder withContent(String content) {
        this.content = content;
        return this;
    }

    public HttpPost buildPost() {
        this.validateEndpoint();
        this.validateContent();
        URI uri = URI.create(this.endpoint);
        HttpPost httpPost = new HttpPost(uri);
        this.buildCommonAttributes((HttpUriRequestBase)httpPost);
        return httpPost;
    }

    public HttpDelete buildDelete() {
        this.validateEndpoint();
        URI uri = URI.create(this.endpoint);
        HttpDelete httpDelete = new HttpDelete(uri);
        this.buildCommonAttributes((HttpUriRequestBase)httpDelete);
        return httpDelete;
    }

    public HttpPut buildPut() {
        this.validateEndpoint();
        URI uri = URI.create(this.endpoint);
        HttpPut httpPut = new HttpPut(uri);
        this.buildCommonAttributes((HttpUriRequestBase)httpPut);
        return httpPut;
    }

    private void validateContent() {
        if (Objects.isNull(this.content)) {
            throw new HttpRequestBuilderException(ERROR_NO_CONTENT);
        }
    }

    private void validateEndpoint() {
        if (Objects.isNull(this.endpoint)) {
            throw new HttpRequestBuilderException(ERROR_NO_ENDPOINT);
        }
    }

    private void buildCommonAttributes(HttpUriRequestBase request) {
        if (Objects.nonNull(this.authorizationHeader)) {
            request.addHeader("Authorization", (Object)this.authorizationHeader);
        }
        if (Objects.nonNull(this.userAgentHeader)) {
            request.addHeader("User-Agent", (Object)this.userAgentHeader);
        }
        request.addHeader("Accept", (Object)this.acceptHeader);
        request.addHeader("Content-Type", (Object)this.contentTypeHeader);
        if (Objects.nonNull(this.content)) {
            request.setEntity((HttpEntity)new StringEntity(this.content, ContentType.APPLICATION_JSON));
        }
    }
}

