/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.bus.subscription;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotBlank;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentestfactory.messages.Category;
import org.opentestfactory.messages.OTFMessage;
import org.opentestfactory.services.components.bus.subscription.Specification;

@Serdeable
public class Subscription
extends OTFMessage {
    private static final String NAME_KEY = "name";
    @Nonnull
    @NotBlank
    private Specification spec;

    public String name() {
        return (String)this.getMetadata().get(NAME_KEY);
    }

    @JsonCreator
    public Subscription(@JsonProperty Specification spec, @JsonProperty @Nullable String name) {
        super("opentestfactory.org/v1alpha1");
        this.spec = Objects.requireNonNull(spec, "Specification is mandatory.");
        this.addMetadata(NAME_KEY, name);
    }

    public static Subscription withEndpoint(@JsonProperty String name, @JsonProperty URL endpoint) {
        return new Subscription(new Specification(endpoint), name);
    }

    public Subscription withMatchKind(String kind) {
        return new Subscription(this.spec.withMatchKind(kind), this.name());
    }

    public Subscription withMatchLabel(String label, String value) {
        return new Subscription(this.spec.withMatchLabel(label, value), this.name());
    }

    public Subscription withMatchField(String field, String value) {
        return new Subscription(this.spec.withMatchField(field, value), this.name());
    }

    public Subscription withMatchFieldExpression(List<Map<String, String>> fieldExpressions) {
        return new Subscription(this.spec.withMatchFieldExpression(fieldExpressions), this.name());
    }

    public Subscription withCategory(Category c) {
        return new Subscription(this.spec.withCategory(c), this.name());
    }

    public Specification getSpec() {
        return this.spec;
    }

    public void setSpec(Specification spec) {
        this.spec = spec;
    }
}

