/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.bus.subscription;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.serde.annotation.Serdeable;
import java.net.URL;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Serdeable
public class Subscriber {
    private URL endpoint;
    @JsonProperty(value="insecure-skip-tls-verify")
    public final Boolean insecureSkipTlsVerify;

    public Subscriber(URL endpoint) {
        this(endpoint, null);
    }

    private Subscriber(URL endpoint, Boolean insecureSkipTlsVerify) {
        this.endpoint = Objects.requireNonNull(endpoint, "EndpointURL is mandatory");
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
    }

    public Subscriber withInsecureSkipTlsVerify() {
        return new Subscriber(this.endpoint, true);
    }

    public Subscriber withoutInsecureSkipTlsVerify() {
        return new Subscriber(this.endpoint, false);
    }

    public URL getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URL endpoint) {
        this.endpoint = endpoint;
    }

    public Boolean getInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }
}

