/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.bus.subscription;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotBlank;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.opentestfactory.messages.Category;
import org.opentestfactory.services.components.bus.subscription.Selector;
import org.opentestfactory.services.components.bus.subscription.Subscriber;

@Serdeable
public class Specification {
    @NotBlank
    @Nonnull
    private Subscriber subscriber;
    @NotBlank
    @Nonnull
    private Selector selector;

    public Specification(@Nullable URL endpoint) {
        this(new Subscriber(endpoint), null);
    }

    @JsonCreator
    public Specification(Subscriber subscriber, Selector selector) {
        this.subscriber = subscriber;
        this.selector = selector;
    }

    public Specification withMatchKind(String kind) {
        if (this.selector == null) {
            return new Specification(this.subscriber, Selector.fromBase(Selector.matchKindSelector((String)kind)));
        }
        return new Specification(this.subscriber, Selector.fromBase(this.selector.withMatchKind(kind)));
    }

    public Specification withMatchLabel(String label, String value) {
        if (this.selector == null) {
            return new Specification(this.subscriber, Selector.fromBase(Selector.matchLabelsSelector((String)label, (String)value)));
        }
        return new Specification(this.subscriber, Selector.fromBase(this.selector.withMatchLabel(label, value)));
    }

    public Specification withMatchField(String field, String value) {
        if (this.selector == null) {
            return new Specification(this.subscriber, Selector.fromBase(Selector.matchFieldSelector((String)field, (String)value)));
        }
        return new Specification(this.subscriber, Selector.fromBase(this.selector.withMatchField(field, value)));
    }

    public Specification withCategory(Category c) {
        if (this.selector == null) {
            return new Specification(this.subscriber, Selector.fromBase(Selector.withCategorySelector((Category)c)));
        }
        return new Specification(this.subscriber, Selector.fromBase(this.selector.withCategory(c)));
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public Specification withMatchFieldExpression(List<Map<String, String>> fieldExpressions) {
        if (this.selector == null) {
            return new Specification(this.subscriber, Selector.fromBase(Selector.matchFieldExpressionSelector(fieldExpressions)));
        }
        return new Specification(this.subscriber, Selector.fromBase(this.selector.withMatchFieldExpression(fieldExpressions)));
    }
}

