/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.bus;

import io.micronaut.context.annotation.Value;
import io.micronaut.serde.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.opentestfactory.messages.OTFMessage;
import org.opentestfactory.services.components.bus.BusApiClient;
import org.opentestfactory.services.components.bus.PublicationStatus;
import org.opentestfactory.services.components.bus.subscription.Subscription;
import org.opentestfactory.services.components.bus.subscription.SubscriptionResult;
import org.opentestfactory.services.components.http.HttpClient;
import org.opentestfactory.services.components.http.HttpRequestBuilder;
import org.opentestfactory.services.components.http.HttpResponseErrorHandler;
import org.opentestfactory.services.components.http.exception.HttpClientException;
import org.opentestfactory.services.components.http.exception.HttpNotFoundException;

@Singleton
public class BusApiClientImpl
implements BusApiClient {
    private static final String SUBSCRIPTIONS_PATH = "/subscriptions";
    private static final String PUBLICATIONS_PATH = "/publications";
    private static final String WRITE_JSON_ERROR_MESSAGE = "Could not write Json for OTFMessage";
    private static final String CONNECTION_ERROR_MESSAGE_FORMAT = "A connection error occurred when %s";
    private static final String ERROR_404_MESSAGE_FORMAT = "Received an error 404 when %s. Please verify the bus URL.";
    private static final String PUBLISHING_MESSAGE = "publishing message";
    private static final String SUBSCRIBING = "subscribing";
    private static final String UNSUBSCRIBING = "unsubscribing";
    private final ObjectMapper mapper;
    private final String baseUrl;
    private final String userAgent;
    private final String token;

    @Inject
    public BusApiClientImpl(ObjectMapper mapper, @Value(value="${org.opentestfactory.bus.base-url}") String baseUrl, @Value(value="${server.name}") String userAgent, @Value(value="${org.opentestfactory.bus.auth-token}") String token) {
        this.mapper = mapper;
        this.baseUrl = baseUrl;
        this.userAgent = userAgent;
        this.token = token;
    }

    @Override
    public PublicationStatus publishEvent(OTFMessage message) {
        String uri = this.baseUrl + PUBLICATIONS_PATH;
        String messageJson = this.writeMessageAsJson(message);
        HttpPost httpPost = new HttpRequestBuilder().withUri(uri).withUserAgent(this.userAgent).withBearerToken(this.token).withContent(messageJson).buildPost();
        return (PublicationStatus)((Object)this.executeBusClientHttpRequest((HttpUriRequestBase)httpPost, response -> {
            HttpResponseErrorHandler.handleHttpErrors(response, uri);
            return (PublicationStatus)((Object)((Object)this.mapper.readValue(response.getEntity().getContent(), PublicationStatus.class)));
        }, PUBLISHING_MESSAGE));
    }

    @Override
    public SubscriptionResult subscribe(Subscription subscription) {
        String uri = this.baseUrl + SUBSCRIPTIONS_PATH;
        String subscriptionJson = this.writeMessageAsJson(subscription);
        HttpPost httpPost = new HttpRequestBuilder().withUri(uri).withBearerToken(this.token).withUserAgent(this.userAgent).withContent(subscriptionJson).buildPost();
        return (SubscriptionResult)((Object)this.executeBusClientHttpRequest((HttpUriRequestBase)httpPost, response -> {
            HttpResponseErrorHandler.handleHttpErrors(response, uri);
            return (SubscriptionResult)((Object)((Object)this.mapper.readValue(response.getEntity().getContent(), SubscriptionResult.class)));
        }, SUBSCRIBING));
    }

    @Override
    public void unsubscribe(String uuid) {
        String uri = this.baseUrl + "/subscriptions/" + uuid;
        HttpDelete httpDelete = new HttpRequestBuilder().withUri(uri).withUserAgent(this.userAgent).withBearerToken(this.token).buildDelete();
        this.executeBusClientHttpRequest((HttpUriRequestBase)httpDelete, response -> {
            HttpResponseErrorHandler.handleHttpErrors(response, uri);
            return null;
        }, UNSUBSCRIBING);
    }

    private String writeMessageAsJson(OTFMessage message) {
        try {
            return this.mapper.writeValueAsString((Object)message);
        }
        catch (IOException ex) {
            throw new HttpClientException(WRITE_JSON_ERROR_MESSAGE, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends OTFMessage> T executeBusClientHttpRequest(HttpUriRequestBase httpRequest, HttpClientResponseHandler<T> responseHandler, String action) {
        try (CloseableHttpClient client = HttpClient.getHttpClient();){
            OTFMessage oTFMessage = (OTFMessage)client.execute((ClassicHttpRequest)httpRequest, responseHandler);
            return (T)oTFMessage;
        }
        catch (IOException ex) {
            throw new HttpClientException(String.format(CONNECTION_ERROR_MESSAGE_FORMAT, action), ex);
        }
        catch (HttpNotFoundException ex) {
            throw new HttpClientException(String.format(ERROR_404_MESSAGE_FORMAT, action), ex);
        }
    }
}

