/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.proc.JWSVerifierFactory;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.reactivex.rxjava3.core.Flowable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.text.ParseException;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.opentestfactory.services.components.auth.AuthConfiguration;
import org.opentestfactory.services.components.auth.UnauthorizedStatus;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Filter(value={"/**"})
public class JwtAuthFilter
implements HttpServerFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAuthFilter.class);
    private static final String AUTHORIZATION = "Authorization";
    private AuthConfiguration authConfiguration;

    public JwtAuthFilter(AuthConfiguration authConfiguration) {
        this.authConfiguration = authConfiguration;
        LOGGER.debug("JWTAuth filter created, {} mode.", (Object)(authConfiguration.anonymousAllowed() ? "test" : "secure"));
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        LOGGER.trace("Applying JWT auth filter");
        if (this.authConfiguration.anonymousAllowed() && (request.getServerAddress().getAddress().isLoopbackAddress() || request.getServerAddress().getAddress().isAnyLocalAddress())) {
            return chain.proceed(request);
        }
        String header = (String)request.getHeaders().get((CharSequence)AUTHORIZATION);
        if (header == null || header.trim().length() == 0) {
            return this.sendJsonErrorStatus("Unauthenticated", 401);
        }
        return this.checkAuthorizationHeader(header, chain, request);
    }

    private Publisher<MutableHttpResponse<?>> checkAuthorizationHeader(String header, ServerFilterChain chain, HttpRequest<?> request) {
        String[] headerParts = header.split(" ");
        if (headerParts.length == 2 && "bearer".equalsIgnoreCase(headerParts[0])) {
            if (this.isValidHeader(headerParts[1])) {
                return chain.proceed(request);
            }
            return this.sendInvalidTokenError();
        }
        return this.sendInvalidTokenError();
    }

    private boolean isValidHeader(String token) {
        try {
            SignedJWT jwt = SignedJWT.parse((String)token);
            DefaultJWSVerifierFactory f = new DefaultJWSVerifierFactory();
            for (File keyLocation : this.authConfiguration.trustedAutorities()) {
                if (!this.checkTokenAgainstPublicKey(keyLocation, (JWSVerifierFactory)f, jwt)) continue;
                return true;
            }
        }
        catch (ParseException ex) {
            LOGGER.debug("Token parsing error", (Throwable)ex);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkTokenAgainstPublicKey(File keyLocation, JWSVerifierFactory f, SignedJWT jwt) {
        try (FileReader fr = new FileReader(keyLocation);){
            PEMParser pemParser = new PEMParser((Reader)fr);
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)pemParser.readObject());
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            PublicKey key = converter.getPublicKey(info);
            JWSVerifier v = f.createJWSVerifier(jwt.getHeader(), (Key)key);
            if (!jwt.verify(v)) return false;
            boolean bl = true;
            return bl;
        }
        catch (PEMException e) {
            LOGGER.error("Token could not be verified by the provided public key : " + keyLocation.getPath(), (Throwable)e);
            return false;
        }
        catch (JOSEException ex) {
            LOGGER.debug("Token parsing error", (Throwable)ex);
            return false;
        }
        catch (IOException ioException) {
            LOGGER.error("Error while reading Public Key", (Throwable)ioException);
        }
        return false;
    }

    private Publisher<MutableHttpResponse<?>> sendInvalidTokenError() {
        return this.sendJsonErrorStatus("Invalid token", 403);
    }

    private Publisher<MutableHttpResponse<?>> sendJsonErrorStatus(String details, int httpCode) {
        String entityString;
        UnauthorizedStatus status = new UnauthorizedStatus(details);
        try {
            entityString = new ObjectMapper().writeValueAsString((Object)status);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error sending JSON error response: {}", (Object)e.getMessage());
            return Flowable.error((Throwable)e);
        }
        return Flowable.just((Object)HttpResponse.status((HttpStatus)HttpStatus.valueOf((int)httpCode)).body((Object)entityString).characterEncoding(StandardCharsets.UTF_8).contentType((CharSequence)"application/json"));
    }
}

