/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.services.components.auth;

import io.micronaut.context.annotation.Value;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.util.Collections;
import java.util.List;

@Singleton
public class AuthConfiguration {
    public static final String INSECURE_ALLOWED_KEY = "org.opentestfactory.insecure";
    private List<File> trustedAuthorities;

    @Inject
    public AuthConfiguration(@Value(value="${org.opentestfactory.auth.trustedAuthorities}") List<File> trustedAuthorities) {
        this.trustedAuthorities = trustedAuthorities;
    }

    public List<File> trustedAutorities() {
        return Collections.unmodifiableList(this.trustedAuthorities);
    }

    public boolean anonymousAllowed() {
        return System.getProperties().containsKey(INSECURE_ALLOWED_KEY) && Boolean.parseBoolean(System.getProperty(INSECURE_ALLOWED_KEY));
    }
}

