/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.tools.annotation.processor;

import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.lang3.StringUtils;

public abstract class DynamicComponentProcessor<ANNOTATION extends Annotation>
extends AbstractProcessor {
    private static final String FILE_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\">\n\n";
    private static final String FILE_FOOTER = "</beans>\n";
    protected static final String DYNAMIC_COMPONENT_TEMPLATE = "  <bean id=\"{0}\" {5} class=\"{1}\" depends-on=\"entityManagerFactory\">\n\t   <constructor-arg index=\"0\" type=\"java.lang.Class\" value=\"{2}\" />\t<!-- componentType -->\n    <constructor-arg index=\"1\" type=\"java.lang.Class\" value=\"{3}\" />\t<!-- entityType -->\n    <property name=\"lookupCustomImplementation\" value=\"{4}\" />\n  </bean>\n";
    private Filer filer;
    private Messager messager;
    private List<Element> dynamicComponents = new ArrayList<Element>();

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        this.enqueueComponents(roundEnvironment);
        if (roundEnvironment.processingOver()) {
            this.processComponents();
        }
        return true;
    }

    private void enqueueComponents(RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(this.annotationClass())) {
            if (!this.checkTarget(this.annotationClass(), element)) continue;
            this.dynamicComponents.add(element);
        }
    }

    private boolean checkTarget(Class<ANNOTATION> annotation, Element annotated) {
        if (!annotated.getKind().isInterface()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "ERROR Only interfaces can be annotated @" + annotation.getSimpleName(), annotated);
            return false;
        }
        return true;
    }

    private void processComponents() {
        Writer writer = null;
        try {
            try {
                writer = this.openWriter();
                this.outputSpringContextFile(writer);
            }
            catch (IOException e) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "WARNING Error during processing of @" + this.annotationClass().getSimpleName() + " annotations");
                e.printStackTrace();
                if (writer != null) {
                    this.noFailCloseFile(writer);
                }
            }
        }
        finally {
            if (writer != null) {
                this.noFailCloseFile(writer);
            }
        }
    }

    private void outputSpringContextFile(Writer writer) throws IOException {
        writer.append(FILE_HEADER);
        for (Element manager : this.dynamicComponents) {
            String beanDefinition = this.buildBeanDefinition(manager);
            writer.append(beanDefinition);
        }
        writer.append(FILE_FOOTER);
    }

    private Writer openWriter() throws IOException {
        FileObject file = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "spring", this.generatedFileName(), null);
        Writer writer = file.openWriter();
        return writer;
    }

    private void noFailCloseFile(Writer writer) {
        try {
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract Class<ANNOTATION> annotationClass();

    private String buildBeanDefinition(Element component) {
        ANNOTATION definition = component.getAnnotation(this.annotationClass());
        String beanName = StringUtils.isBlank((CharSequence)this.beanName(definition)) ? this.defaultBeanName(component) : this.beanName(definition);
        Name managerClass = ((TypeElement)component).getQualifiedName();
        TypeMirror entityClass = this.extractEntityClass(definition);
        boolean lookupCustomImplementation = this.lookupCustomImplementation(definition);
        String primary = this.primaryAttribute(definition);
        String beanDefinition = MessageFormat.format(DYNAMIC_COMPONENT_TEMPLATE, beanName, this.beanFactoryClass(), managerClass, entityClass, lookupCustomImplementation, primary);
        return beanDefinition;
    }

    protected abstract String primaryAttribute(ANNOTATION var1);

    private String defaultBeanName(Element manager) {
        return StringUtils.uncapitalize((String)manager.getSimpleName().toString());
    }

    private TypeMirror extractEntityClass(ANNOTATION definition) {
        TypeMirror entityClass = null;
        try {
            this.entityClass(definition);
        }
        catch (MirroredTypeException e) {
            entityClass = e.getTypeMirror();
        }
        return entityClass;
    }

    protected abstract Class<?> entityClass(ANNOTATION var1);

    protected abstract String beanName(ANNOTATION var1);

    protected abstract String beanFactoryClass();

    protected abstract String generatedFileName();

    protected abstract boolean lookupCustomImplementation(ANNOTATION var1);

    protected final Messager getMessager() {
        return this.messager;
    }
}

