/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.security.authentication;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
public class TraceSuccessfulAuthentication
implements ApplicationListener<AuthenticationSuccessEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceSuccessfulAuthentication.class);

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        Object details = event.getAuthentication().getDetails();
        if (details instanceof WebAuthenticationDetails) {
            String ipAddress = ((WebAuthenticationDetails)details).getRemoteAddress();
            LOGGER.info(String.format("Successful authentication from remote IP %s", ipAddress));
        }
    }
}

