/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.model.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

public class CleanedStringSerializer
extends StdSerializer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanedStringSerializer.class);

    public CleanedStringSerializer() {
        super(String.class);
    }

    public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CLEANING STRING {}", (Object)s);
        }
        String cleaned = HTMLCleanupUtils.cleanHtml((String)s);
        jsonGenerator.writeString(cleaned);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CLEANED STRING {}", (Object)cleaned);
        }
    }
}

