/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.manager.plugin;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.ConfigurablePlugin;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.GenericLibrary;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.service.internal.display.dto.ProjectPluginDto;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginBindingService;
import org.squashtest.tm.web.backend.manager.plugin.ConfigurablePluginBinding;
import org.squashtest.tm.web.backend.manager.plugin.ConfigurablePluginManager;

@Service
@Transactional
public class ConfigurablePluginManagerImpl
implements ConfigurablePluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurablePluginManagerImpl.class);
    private final GenericProjectFinder projectFinder;
    private final GenericProjectManagerService projectManager;
    private final TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService;
    @Autowired(required=false)
    private final Collection<ConfigurablePlugin> configurablePlugins = Collections.emptyList();
    @Autowired(required=false)
    private final Collection<TemplateConfigurablePlugin> templatePlugins = Collections.emptyList();
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType;

    public ConfigurablePluginManagerImpl(GenericProjectFinder projectFinder, GenericProjectManagerService projectManager, TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService) {
        this.projectFinder = projectFinder;
        this.projectManager = projectManager;
        this.templateConfigurablePluginBindingService = templateConfigurablePluginBindingService;
    }

    public boolean isPluginBindingValid(String pluginId, long projectId) {
        ConfigurablePlugin configurablePlugin = this.findByIdOrThrow(pluginId);
        EntityReference context = new EntityReference(EntityType.PROJECT, Long.valueOf(projectId));
        return this.isPluginValid(configurablePlugin, context);
    }

    public List<ProjectPluginDto> getAvailablePlugins(long projectId) {
        boolean isTemplate = this.projectManager.isProjectTemplate(projectId);
        return this.toPluginDtos(projectId, this.getBindings(projectId), isTemplate);
    }

    private List<ProjectPluginDto> toPluginDtos(long projectId, Collection<ConfigurablePluginBinding> pluginBindings, boolean isTemplate) {
        return IntStream.range(0, pluginBindings.size()).mapToObj(index -> this.toPluginDto(Long.valueOf(projectId), (ConfigurablePluginBinding)Iterables.get((Iterable)pluginBindings, (int)index), index + 1, isTemplate)).collect(Collectors.toList());
    }

    private ProjectPluginDto toPluginDto(Long projectId, ConfigurablePluginBinding pluginBinding, int pluginIndex, boolean isTemplate) {
        EntityReference context = new EntityReference(EntityType.PROJECT, projectId);
        ProjectPluginDto projectPluginDto = new ProjectPluginDto(pluginBinding.getPlugin());
        projectPluginDto.setIndex(pluginIndex);
        projectPluginDto.setEnabled(pluginBinding.isActive());
        boolean hasValidConfiguration = pluginBinding.isHasConfiguration() && this.isPluginValid(pluginBinding.getPlugin(), context);
        projectPluginDto.setHasValidConfiguration(hasValidConfiguration);
        this.updateConfigUrl(pluginBinding.getPlugin(), isTemplate, context, projectPluginDto);
        return projectPluginDto;
    }

    private void updateConfigUrl(ConfigurablePlugin plugin, boolean isTemplate, EntityReference context, ProjectPluginDto projectPluginDto) {
        if (isTemplate) {
            Optional templatePlugin = this.findTemplatePlugin(plugin.getId());
            templatePlugin.ifPresent(templateConfigurablePlugin -> projectPluginDto.setConfigUrl(templateConfigurablePlugin.getTemplateConfigurationPath(context)));
        } else {
            projectPluginDto.setConfigUrl(plugin.getConfigurationPath(context));
        }
    }

    private Optional<TemplateConfigurablePlugin> findTemplatePlugin(String pluginId) {
        return this.templatePlugins.stream().filter(tp -> tp.getId().equals(pluginId)).findFirst();
    }

    private boolean isPluginValid(ConfigurablePlugin plugin, EntityReference context) {
        try {
            plugin.validate(context);
            return true;
        }
        catch (PluginValidationException damnit) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Plugin validation failed for plugin '%s'", plugin.getName()), (Throwable)damnit);
            }
            return false;
        }
    }

    public Collection<ConfigurablePluginBinding> getBindings(long projectId) {
        return this.configurablePlugins.stream().map(plugin -> new ConfigurablePluginBinding(plugin, projectId, this.isActive(plugin, projectId), this.hasConfiguration(plugin, projectId))).collect(Collectors.toUnmodifiableList());
    }

    public Optional<ConfigurablePlugin> findById(String pluginId) {
        return this.configurablePlugins.stream().filter(plugin -> plugin.getId().equals(pluginId)).findFirst();
    }

    private ConfigurablePlugin findByIdOrThrow(String pluginId) {
        return (ConfigurablePlugin)this.findById(pluginId).orElseThrow(() -> new IllegalArgumentException("Could not find plugin with ID " + pluginId));
    }

    private boolean isActive(ConfigurablePlugin plugin, long projectId) {
        GenericLibrary library = this.findLibrary(projectId, plugin.getConfiguringWorkspace());
        LibraryPluginBinding binding = library.getPluginBinding(plugin.getId());
        return binding != null && binding.getActive() != false;
    }

    private boolean hasConfiguration(ConfigurablePlugin plugin, long projectId) {
        return this.projectManager.pluginHasConfigurationOrSynchronisations(plugin, projectId);
    }

    /*
     * Exception decompiling
     */
    private GenericLibrary<? extends LibraryNode> findLibrary(long projectId, WorkspaceType workspace) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void disableConfigurablePlugin(String pluginId, long projectId, Boolean saveConf) {
        ConfigurablePlugin plugin = this.findByIdOrThrow(pluginId);
        List workspaceTypes = plugin.getWorkspaces();
        if (Boolean.TRUE.equals(saveConf)) {
            this.projectManager.disablePluginAndKeepConfiguration(projectId, workspaceTypes, plugin.getId());
            this.projectManager.disableSynchronisations(projectId, pluginId);
        } else {
            if (pluginId.contains("workflow.automjira")) {
                this.projectManager.deleteAllRemoteAutomationRequestExtenders(projectId);
            }
            boolean isProjectBound = this.templateConfigurablePluginBindingService.isProjectConfigurationBoundToTemplate(projectId);
            boolean isProjectTemplate = this.projectManager.isProjectTemplate(projectId);
            if (isProjectTemplate) {
                this.projectManager.disablePluginAndRemoveConfiguration(projectId, workspaceTypes, pluginId);
                this.projectManager.synchronizeBoundPluginConfigurations(projectId, pluginId);
            } else if (isProjectBound) {
                this.projectManager.disablePluginAndKeepConfiguration(projectId, workspaceTypes, pluginId);
                this.projectManager.removeSynchronisations(projectId, pluginId);
            } else {
                this.projectManager.disablePluginAndRemoveConfiguration(projectId, workspaceTypes, pluginId);
                this.projectManager.removeSynchronisations(projectId, pluginId);
            }
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType() {
        if ($SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType != null) {
            return $SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType;
        }
        int[] nArray = new int[WorkspaceType.values().length];
        try {
            nArray[WorkspaceType.AUTOMATION_TESTER_WORKSPACE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.AUTOMATION_WORKSPACE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.CAMPAIGN_WORKSPACE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.CUSTOM_REPORT_WORKSPACE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.REQUIREMENT_WORKSPACE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.TEST_CASE_WORKSPACE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType = nArray;
        return nArray;
    }
}

