/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.web.backend.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.backend.exceptionresolver.HandlerMaxUploadSizeExceptionResolver;
import org.squashtest.tm.web.backend.exceptionresolver.MaxUploadSizeErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component
@Deprecated
public class HandlerMaxUploadSizeExceptionResolver
extends AbstractHandlerExceptionResolver {
    private static final int NB_BYTES_PER_MBYTES = 0x100000;
    private static final String ACTION_VALIDATION_ERROR = "actionValidationError";
    private static final Logger THIS_LOGGER = LoggerFactory.getLogger(HandlerMaxUploadSizeExceptionResolver.class);
    @Inject
    private InternationalizationHelper messageSource;

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        THIS_LOGGER.trace("received exception, testing whether it should be handled");
        if (this.exceptionIsHandled(ex)) {
            THIS_LOGGER.trace("exception is being handled");
            response.setStatus(413);
            MaxUploadSizeExceededException mex = (MaxUploadSizeExceededException)((Object)ex);
            if (ExceptionResolverUtils.clientAcceptsMIME((HttpServletRequest)request, (MimeType)MimeType.APPLICATION_JSON)) {
                THIS_LOGGER.trace("MIME type is application/json, returning response as json");
                return this.handleAsJson(mex);
            }
            if (ExceptionResolverUtils.clientAcceptsMIME((HttpServletRequest)request, (MimeType)MimeType.TEXT_PLAIN)) {
                THIS_LOGGER.trace("MIME type is text/plain, returning response as plain text");
                return this.handleAsText(mex);
            }
            if (ExceptionResolverUtils.clientAcceptsMIME((HttpServletRequest)request, (MimeType)MimeType.TEXT_HTML)) {
                THIS_LOGGER.trace("MIME type is text/html, returning response as html");
                return this.handleAsHtml(mex);
            }
            if (ExceptionResolverUtils.clientAcceptsMIME((HttpServletRequest)request, (MimeType)MimeType.ANYTHING)) {
                THIS_LOGGER.trace("MIME type is */*, returning response as plain text");
                return this.handleAsText(mex);
            }
        }
        THIS_LOGGER.trace("the exception was not processed because it was not a valid target");
        return null;
    }

    private ModelAndView handleAsJson(MaxUploadSizeExceededException mex) {
        MaxUploadSizeErrorModel error = new MaxUploadSizeErrorModel(mex);
        return new ModelAndView((View)new MappingJackson2JsonView(), "maxUploadError", (Object)error);
    }

    private ModelAndView handleAsText(MaxUploadSizeExceededException mex) {
        String error = "{ \"maxSize\" : " + mex.getMaxUploadSize() + "}";
        MaxSizeView view = new MaxSizeView();
        return new ModelAndView((View)view, ACTION_VALIDATION_ERROR, (Object)error);
    }

    private ModelAndView handleAsHtml(MaxUploadSizeExceededException mex) {
        Long size = mex.getMaxUploadSize() / 0x100000L;
        String msg = this.messageSource.getMessage("message.AttachmentUploadSizeExceeded", null, "message.AttachmentUploadSizeExceeded", LocaleContextHolder.getLocale()).replace("#size#", size.toString());
        String error = "<div>" + msg + "</div>";
        MaxSizeView view = new MaxSizeView();
        return new ModelAndView((View)view, ACTION_VALIDATION_ERROR, (Object)error);
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof MaxUploadSizeExceededException;
    }
}

