/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.web.backend.exceptionresolver.model.FieldValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.model.SquashFieldValidationErrorModel;

@Component
public class HandlerDomainExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            response.setStatus(412);
            DomainException dex = (DomainException)((Object)ex);
            List errors = this.buildFieldValidationErrors(dex);
            SquashFieldValidationErrorModel squashError = new SquashFieldValidationErrorModel(errors);
            return new ModelAndView((View)new MappingJackson2JsonView(), "squashTMError", (Object)squashError);
        }
        return null;
    }

    private List<FieldValidationErrorModel> buildFieldValidationErrors(DomainException dex) {
        ArrayList<FieldValidationErrorModel> ves = new ArrayList<FieldValidationErrorModel>();
        ves.add(new FieldValidationErrorModel(dex.getObjectName(), dex.getField(), dex.getI18nKey(), dex.getI18nParams(), (Object)dex.getFieldValue()));
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof DomainException;
    }
}

