/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.service.display.user.UserDisplayService;
import org.squashtest.tm.service.internal.display.dto.ProjectPermissionDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.user.UserAdministrationService;
import org.squashtest.tm.web.backend.controller.user.UserForm;
import org.squashtest.tm.web.backend.controller.user.UsersAdministrationController;

@RestController
@RequestMapping(value={"/backend/users"})
public class UsersAdministrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersAdministrationController.class);
    private final UserDisplayService userDisplayService;
    private final UserAdministrationService adminService;
    private final ProjectsPermissionManagementService permissionService;

    @Inject
    public UsersAdministrationController(UserDisplayService userDisplayService, UserAdministrationService adminService, ProjectsPermissionManagementService permissionService) {
        this.userDisplayService = userDisplayService;
        this.adminService = adminService;
        this.permissionService = permissionService;
    }

    @PostMapping
    public GridResponse getAllUsers(@RequestBody GridRequest request) {
        return this.userDisplayService.findAll(request);
    }

    @PostMapping(value={"/new"})
    public Map<String, Long> addUser(@RequestBody @Valid UserForm userForm) {
        if (userForm.getPassword() == null) {
            this.adminService.createUserWithoutCredentials(userForm.getUser(), userForm.getGroupId());
        } else {
            this.adminService.addUser(userForm.getUser(), userForm.getGroupId(), userForm.getPassword());
        }
        return Collections.singletonMap("id", userForm.getUser().getId());
    }

    @GetMapping(value={"/get-users-groups"})
    public Map<String, List<UsersGroup>> getUsersGroups() {
        HashMap<String, List<UsersGroup>> response = new HashMap<String, List<UsersGroup>>();
        response.put("usersGroups", this.adminService.findAllUsersGroupOrderedByQualifiedName());
        return response;
    }

    @RequestMapping(value={"/{userId}/login"}, method={RequestMethod.POST})
    public void modifyLogin(@PathVariable long userId, @RequestBody UserPatch patch) {
        this.adminService.modifyUserLogin(userId, patch.getLogin());
    }

    @RequestMapping(value={"/{userId}/first-name"}, method={RequestMethod.POST})
    public void modifyFirstName(@PathVariable long userId, @RequestBody UserPatch patch) {
        this.adminService.modifyUserFirstName(userId, patch.getFirstName());
    }

    @RequestMapping(value={"/{userId}/last-name"}, method={RequestMethod.POST})
    public void modifyLastName(@PathVariable long userId, @RequestBody UserPatch patch) {
        this.adminService.modifyUserLastName(userId, patch.getLastName());
    }

    @RequestMapping(value={"/{userId}/email"}, method={RequestMethod.POST})
    public void modifyEmail(@PathVariable long userId, @RequestBody UserPatch patch) {
        this.adminService.modifyUserEmail(userId, patch.getEmail());
    }

    @RequestMapping(value={"/{userIds}"}, method={RequestMethod.DELETE})
    public void deleteUsers(@PathVariable(value="userIds") List<Long> userIds) {
        this.adminService.deleteUsers(userIds);
    }

    @GetMapping(value={"/{userId}/synchronisations"})
    public List<RemoteSynchronisation> getSynchronisationsByUser(@PathVariable(value="userId") Long userId) {
        return this.adminService.getSynchronisationsByUser(userId);
    }

    @RequestMapping(value={"/{userIds}/deactivate"}, method={RequestMethod.POST})
    public void deactivateUsers(@PathVariable(value="userIds") List<Long> userIds) {
        this.adminService.deactivateUsers(userIds);
    }

    @RequestMapping(value={"/{userIds}/activate"}, method={RequestMethod.POST})
    public void activateUsers(@PathVariable(value="userIds") List<Long> userIds) {
        this.adminService.activateUsers(userIds);
    }

    @RequestMapping(value={"/{userId}/change-group/{groupId}"}, method={RequestMethod.POST})
    public void changeUserGroup(@PathVariable long userId, @PathVariable long groupId) {
        this.adminService.setUserGroupAuthority(userId, groupId);
    }

    @RequestMapping(value={"/{userId}/reset-password"}, method={RequestMethod.POST})
    public void resetPassword(@PathVariable long userId, @RequestBody UserPatch patch) {
        LOGGER.trace("Reset password for user #" + userId);
        this.adminService.resetUserPassword(userId, patch.getPassword());
    }

    @PostMapping(value={"/{userId}/projects/{projectIds}/permissions/{profileId}"})
    public Map<String, List<ProjectPermissionDto>> addNewPermissions(@PathVariable long userId, @PathVariable List<Long> projectIds, @PathVariable long profileId) {
        this.permissionService.addNewPermissionToProject(userId, projectIds, profileId);
        return Collections.singletonMap("projectPermissions", this.userDisplayService.getProjectPermissions(Long.valueOf(userId)));
    }

    @RequestMapping(value={"/{userId}/permissions/{projectIds}"}, method={RequestMethod.DELETE})
    public void removePermissions(@PathVariable long userId, @PathVariable List<Long> projectIds) {
        this.permissionService.removeProjectPermission(userId, projectIds);
    }

    @RequestMapping(value={"/{userId}/teams/{partyIds}"}, method={RequestMethod.POST})
    public AssociatedTeamReport associateTeams(@PathVariable long userId, @PathVariable List<Long> partyIds) {
        Set nonAssociatedTeamNames = this.adminService.associateToTeams(userId, partyIds);
        List teams = this.userDisplayService.getAssociatedTeams(Long.valueOf(userId));
        return new AssociatedTeamReport(teams, nonAssociatedTeamNames);
    }

    @RequestMapping(value={"/{userId}/teams/{partyIds}"}, method={RequestMethod.DELETE})
    public void disassociateTeams(@PathVariable long userId, @PathVariable List<Long> partyIds) {
        this.adminService.deassociateTeams(userId, partyIds);
    }

    @PostMapping(value={"/{userId}/can-delete-from-front"})
    public void changeCanDeleteFromFront(@PathVariable long userId, @RequestBody UserPatch patch) {
        this.adminService.changeCanDeleteFromFront(userId, patch.isCanDeleteFromFront());
    }

    @PostMapping(value={"/{userIds}/mass-update"})
    public void deactivateUsers(@PathVariable(value="userIds") List<Long> userIds, @RequestBody UserMassEditPatch massEditPatch) {
        if (massEditPatch.isChangeState()) {
            if (massEditPatch.isActivated()) {
                this.adminService.activateUsers(userIds);
            } else {
                this.adminService.deactivateUsers(userIds);
            }
        }
        if (massEditPatch.isChangeCanDelete()) {
            this.adminService.changeCanDeleteFromFront(userIds, massEditPatch.isCanDelete());
        }
    }
}

